#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qpmrep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire polymarker representation
 */
VOID
q_ws_pmr(wkid, index, as_set, errno, mtype, msize, color)
WKID wkid ;
int index ;
BOOL as_set ;
GKSERR *errno ;
int *mtype ;
REAL *msize ;
COLOR *color ;
{
	static char *fname = "q_ws_pmr" ;
	WSINFO ws ;
	struct msqpmr *msg ;
	struct msqpmr *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqpmr *)_allocmsg(sizeof(struct msqpmr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	pmrmsg(msg, WsGetpid(ws), index, as_set, TRUE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqpmr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;


		case 1:
			*errno = 64 ;
			_freemsg(reply) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*mtype = reply -> qpm_pmrep.pm_type ;
	*msize = reply -> qpm_pmrep.pm_size ;
	*color = reply -> qpm_pmrep.pm_col ;
	*errno = 0 ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %f, %d)\n", fname, wkid, index, as_set,
					*errno, *mtype, *msize, *color) ;
#endif
}

/*
 * inquire default color representation
 */
VOID
q_wd_pmr(wktype, index, errno, mtype, msize, color)
WSTYPE wktype ;
int index ;
GKSERR *errno ;
int *mtype ;
REAL *msize ;
COLOR *color ;
{
	static char *fname = "q_wd_pmr" ;
	WSINFO ws ;
	struct msqpmr *msg ;
	struct msqpmr *reply ;
	BOOL must_close = FALSE ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}
/**************************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/**************************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
**************************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}

	msg = (struct msqpmr *)_allocmsg(sizeof(struct msqpmr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	pmrmsg(msg, WsGetpid(ws), index, TRUE, FALSE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqpmr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 64 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*mtype = reply -> qpm_pmrep.pm_type ;
	*msize = reply -> qpm_pmrep.pm_size ;
	*color = reply -> qpm_pmrep.pm_col ;
	_freemsg(reply) ;
	if(must_close)
		close_ws(0xffff) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %f, %d)\n", fname, wktype, index,
					*errno, *mtype, *msize, *color) ;
#endif
}

static
pmrmsg(msg, pid, index, as_set, fromstate)
struct msqpmr *msg ;
PID pid ;
int index ;
BOOL as_set ;
BOOL fromstate ;
{
	msg -> mhdr.msg_id = MSQPMR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqpmr) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qpm_indx = index ;
	msg -> qpm_set = as_set ;
	msg -> qpm_state = fromstate ;
}

static char *SccsId = "@(#)q_pmrep.c	1.7\t2/21/85" ;
