#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qplrep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire polyline representation
 */
VOID
q_ws_plr(wkid, index, as_set, errno, ltype, lwdth, color)
WKID wkid ;
int index ;
BOOL as_set ;
GKSERR *errno ;
int *ltype ;
REAL *lwdth ;
COLOR *color ;
{
	static char *fname = "q_ws_plr" ;
	WSINFO ws ;
	struct msqplr *msg ;
	struct msqplr *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqplr *)_allocmsg(sizeof(struct msqplr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	plrmsg(msg, WsGetpid(ws), index, as_set, TRUE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqplr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 60 ;
			_freemsg(reply) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*ltype = reply -> qpl_plrep.pl_type ;
	*lwdth = reply -> qpl_plrep.pl_wdth ;
	*color = reply -> qpl_plrep.pl_col ;
	*errno = 0 ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %f, %d)\n", fname, wkid, index, as_set,
					*errno, *ltype, *lwdth, *color) ;
#endif
}

/*
 * inquire default polyline representation
 */
VOID
q_wd_plr(wktype, index, errno, ltype, lwdth, color)
WSTYPE wktype ;
int index ;
GKSERR *errno ;
int *ltype ;
REAL *lwdth ;
COLOR *color ;
{
	static char *fname = "q_wd_plr" ;
	WSINFO ws ;
	struct msqplr *msg ;
	struct msqplr *reply ;
	BOOL must_close = FALSE ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}
	
/**************************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/**************************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
**************************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}

	msg = (struct msqplr *)_allocmsg(sizeof(struct msqplr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	plrmsg(msg, WsGetpid(ws), index, TRUE, FALSE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqplr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 60 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*ltype = reply -> qpl_plrep.pl_type ;
	*lwdth = reply -> qpl_plrep.pl_wdth ;
	*color = reply -> qpl_plrep.pl_col ;
	_freemsg(reply) ;
	if(must_close)
		close_ws(0xffff) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %f, %d)\n", fname, wktype, index,
					*errno, *ltype, *lwdth, *color) ;
#endif
}

static
plrmsg(msg, pid, index, as_set, fromstate)
struct msqplr *msg ;
PID pid ;
int index ;
BOOL as_set ;
BOOL fromstate ;
{
	msg -> mhdr.msg_id = MSQPLR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqplr) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qpl_indx = index ;
	msg -> qpl_set = as_set ;
	msg -> qpl_state = fromstate ;
}

static char *SccsId = "@(#)q_plrep.c	1.8\t3/12/85" ;
