#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qfarep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire fill area representation
 */
VOID
q_ws_far(wkid, index, as_set, errno, istyle, style, color)
WKID wkid ;
int index ;
BOOL as_set ;
GKSERR *errno ;
int *istyle ;
int *style ;
COLOR *color ;
{
	static char *fname = "q_ws_far" ;
	WSINFO ws ;
	struct msqfar *msg ;
	struct msqfar *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqfar *)_allocmsg(sizeof(struct msqfar)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	farmsg(msg, WsGetpid(ws), index, as_set, TRUE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqfar *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;


		case 1:
			*errno = 75 ;
			_freemsg(reply) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*istyle = reply -> qfa_farep.fa_istyle ;
	*style = reply -> qfa_farep.fa_style ;
	*color = reply -> qfa_farep.fa_col ;
	*errno = 0 ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %d, %d)\n", fname, wkid, index, as_set,
					*errno, *istyle, *style, *color) ;
#endif
}

/*
 * inquire default fill area representation
 */
VOID
q_wd_far(wktype, index, errno, istyle, style, color)
WSTYPE wktype ;
int index ;
GKSERR *errno ;
int *istyle ;
int *style ;
COLOR *color ;
{
	static char *fname = "q_wd_far" ;
	WSINFO ws ;
	struct msqfar *msg ;
	struct msqfar *reply ;
	BOOL must_close = FALSE ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}
/*********************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/*********************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
********************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}

	msg = (struct msqfar *)_allocmsg(sizeof(struct msqfar)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	farmsg(msg, WsGetpid(ws), index, TRUE, FALSE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqfar *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 75 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*istyle = reply -> qfa_farep.fa_istyle ;
	*style = reply -> qfa_farep.fa_style ;
	*color = reply -> qfa_farep.fa_col ;
	_freemsg(reply) ;
	if(must_close)
		close_ws(0xffff) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %d)\n", fname, wktype, index,
					*errno, *istyle, *style, *color) ;
#endif
}

static
farmsg(msg, pid, index, as_set, fromstate)
struct msqfar *msg ;
PID pid ;
int index ;
BOOL as_set ;
BOOL fromstate ;
{
	msg -> mhdr.msg_id = MSQFAR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqfar) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qfa_indx = index ;
	msg -> qfa_set = as_set ;
	msg -> qfa_state = fromstate ;
}

static char *SccsId = "@(#)q_farep.c	1.8\t2/21/85" ;
