#include <gks/gks_types.h>
#include <gks/message.h>
#include <gks/gks_structs.h>
#include <gks/inputmsg.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern BOOL _GksAck;


/*
 * initialize stroke
 */

GKSERR
ini_stk(wkid, devno, npts, pts, norm, prompt, xmin, xmax, ymin, ymax, datarec)
WKID wkid ;
int  devno ;
int  npts ;
WCPT pts[] ;
int  norm ;
int  prompt ;
DC   xmin,
     xmax,
     ymin,
     ymax ;
struct i_stkdata *datarec ;
{
	int res  = 0 ;
	struct msinpinit *msg ;
	MSGHDR *reply ;
	WSINFO ws ;
	static char *fname = "ini_stk" ;
	int curnorm ;
	extern struct gksstate Gksstate ;
	struct i_stkdata *d;

#ifdef TRACE
	if(Gksdebug & DB_INPUT)
		Gksout("ini_stk(%d, %d, %d, %d, %d\n\t%8.3f, %8.3f, %8.3f, %8.3f)\n",
			wkid, devno, npts, norm, prompt, xmin, xmax, ymin, ymax) ;
#endif

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
		return(err_hand(7, fname)) ;

	if(wkid == 0)
		return(err_hand(20, fname)) ;

	if((xmin >= xmax) || (ymin >= ymax))
		return(err_hand(51, fname)) ;

/*
 * deliver "initialize stroke" message
 */

	ws = WsId2info(wkid) ;
	if(ws == NULL)
		return(err_hand(25, fname)) ;

	if((WsGetcat(ws) != WSC_INPUT) && (WsGetcat(ws) != WSC_OUTIN))
		return(err_hand(38, fname)) ;

	msg = (struct msinpinit *)_allocmsg(sizeof(struct msinpinit) + 
		sizeof(struct i_stkdata)) ;
	if(msg == NULL)
		return(err_hand(904, fname)) ;
/*
 * transform all pts by specified normtr.
 */
	curnorm = Gksstate.gs_norm ;
	Gksstate.gs_norm = norm ;
	inpinitmsg(msg, WsGetpid(ws), devno, npts, pts, prompt,
		xmin, xmax, ymin, ymax, datarec) ;
	Gksstate.gs_norm = curnorm ;
/*
 *	update data record based on attribute control flag
 */
	d = (struct i_stkdata *)(msg -> datarec);

	switch (prompt)
		{
	
	case 3:
		if (d->istk_un.istk_p3.stk3_curr)
			{
			d->istk_un.istk_p3.stk3_asf = Gksstate.gs_asf;
			d->istk_un.istk_p3.stk3_bnd = Gksstate.gs_pmbund;
			cpybuf(&(d->istk_un.istk_p3.stk3_pmr), &Gksstate.gs_pmrep,
				sizeof(struct pmrep));
			}
		break;
	
	case 4:
		if (d->istk_un.istk_p4.stk4_curr)
			{
			d->istk_un.istk_p4.stk4_asf = Gksstate.gs_asf;
			d->istk_un.istk_p4.stk4_bnd = Gksstate.gs_plbund;
			cpybuf(&(d->istk_un.istk_p4.stk4_plr), &Gksstate.gs_plrep,
				sizeof(struct plrep));
			}
		break;

	default:
		break;

		}
	

	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	if (_GksAck)
		{
		reply = (MSGHDR *)_recvmsg(WsGetpid(ws)) ;
		if(reply == NULL)
			return (err_hand(WsNomsg(), fname));
		switch(reply -> msg_reply)
			{
		case 0:		/* success */
			res = 0 ;
			break ;

		case 1:		/* device not present on workstation */
			res = 140 ;
			break ;

		case 2:		/* device not in request mode */
			res = 141 ;
			break ;

		case 3:		/* echo type not supported */
			res = 144 ;
			break ;

		case 4:		/* echo area outside display surface */
			res = 145 ;
			break ;

		case 5:		/* contents of data record invalid */
			res = 146 ;
			break ;

		case 6:		/* initial value is invalid */
			res = 152 ;
			break ;

		default:
			Gksout("gks internal error: bad reply to ini_stk.\n") ;
			Gksout("\twkid = %d, reply = %d\n", wkid, reply -> msg_reply) ;
			res = 0 ;
			}
		_freemsg(reply) ;
		}

	if(res != 0)
		return(err_hand(res, fname)) ;
	return(0) ;
}

static inpinitmsg(msg, pid, devno, npts, pts, prompt,
	xmin, xmax, ymin, ymax, datarec)
struct msinpinit *msg ;
PID pid ;
int devno ;
int npts ;
WCPT pts[] ;
int prompt ;
WC  xmin,
	xmax,
	ymin,
	ymax ;
struct i_stkdata *datarec ;
{
	int i ;

	msg -> mhdr.msg_id = MSINPINI ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msinpinit) + sizeof(struct i_stkdata)
			- sizeof(int) - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = _GksAck ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> inpcls = STROKE ;
	msg -> inpdevno = devno ;

	msg -> initun.inpt_stk.stk_npts = npts ;
	for(i=0; i<npts; i++)
		_wc2ndc(&pts[i], &msg->initun.inpt_stk.stk_pts[i]) ;

	msg -> inpprmpt = prompt ;
	msg -> echo_xmin = xmin ;
	msg -> echo_xmax = xmax ;
	msg -> echo_ymin = ymin ;
	msg -> echo_ymax = ymax ;
	cpybuf((struct i_stkdata *)(msg -> datarec), datarec,
			sizeof(struct i_stkdata));
}

static char *SccsId = "%W%\t%G%" ;
