/*
 *	Definitions of abstract types  used in GKS
 *  Changed REAL typedef for CX2000 compatibility
 */

/*** typedef double REAL; ****/
typedef float REAL;
typedef int BOOL;
typedef int VOID;
#define TRUE 1
#define FALSE 0
#define YES 1
#define NO 0

#ifndef NULL
#define NULL 0
#endif

#define EOMF 0						/* end of metafile */

typedef REAL NDC;					/* normalized display coordinates */

typedef struct
	{
	NDC ndc_x;
	NDC ndc_y;
	} NDCPT;						/* NDC point */

typedef REAL WC;					/* world coordinates */

typedef struct
	{
	WC wc_x;
	WC wc_y;
	} WCPT;							/* WC point */

typedef REAL DC;					/* device coordinates */

typedef struct
	{
	DC dc_x;
	DC dc_y;
	} DCPT;							/* DC point */

typedef unsigned long COLOR;

typedef unsigned short WKID;		/* workstation id */
typedef int GKSERR;					/* return value of all GKS functions */
typedef unsigned short GDP_ID;
typedef unsigned short ESCAPE_ID;

/*	typedef enum GKSSTATE - operating state */

typedef unsigned short GKSSTATE;

#define GS_GKCL 0x01
#define GS_GKOP 0x02
#define GS_WSOP 0x04
#define GS_WSAC 0x08
#define GS_SGOP 0x10

/*
 *	Allowable GKS levels
 */

#define GKS_LEVma 0
#define GKS_LEVmb 1
#define GKS_LEVmc 2
#define GKS_LEV0a 3
#define GKS_LEV0b 4
#define GKS_LEV0c 5
#define GKS_LEV1a 6
#define GKS_LEV1b 7
#define GKS_LEV1c 8
#define GKS_LEV2a 9
#define GKS_LEV2b 10
#define GKS_LEV2c 11

/*	typedef enum WSTYPE - workstation type */

typedef short WSTYPE;
#define WST_WISS 0
#define WST_MO 1
#define WST_MI 2
#define WST_CX1500 6
#define WST_CX15OV 7
#define WST_CX1500A WST_CX1500
#define WST_CX15OVA WST_CX15OV
#define WST_CX1500B 8
#define WST_CX15OVB 9

/* typedef enum WSCATEG - workstation category */

typedef unsigned short WSCATEG;
#define WSC_OUTPUT 1
#define WSC_INPUT 2
#define WSC_OUTIN 3
#define WSC_WISS 4
#define WSC_MO 5
#define WSC_MI 6

/* typedef enum WSDEVCOORD - device coordinate units */

typedef unsigned short WSDEVCOORD;
#define DC_METERS 1
#define DC_OTHER 2

/*
 * typedef enum COORDTYPE - NDC or WC coordinates
 */
typedef unsigned short COORDTYPE;
#define CRD_WC 1
#define CRD_NDC 2

/* typedef enum SCRTYPE - vector or raster */

typedef unsigned short SCRTYPE;
#define SCR_VECTOR 1
#define SCR_RASTER 2
#define SCR_OTHER 3

/*	typedef enum DEFMODE - deferral mode */

typedef unsigned short DEFMODE;
#define ASAP 0
#define BNIL 1
#define BNIG 2
#define ASTI 3

typedef unsigned short IRGMODE;			/* implicit regeneration mode */
#define SUPPRESSED FALSE
#define ALLOWED TRUE

typedef unsigned short DYNMOD; /* dynamic modification */
#define IRG 0
#define IMM 1

/* bundle table types */

typedef unsigned short PLTYPE; /* polyline type */
#define SOLID 1
#define DASHED 2
#define DOTTED 3
#define DASHED_DOT 4

typedef unsigned short PMTYPE; /* polymarker type */
#define DOT 1
#define PLUS 2
#define ASTERISK 3
#define CIRCLE 4
#define CROSS 5

typedef unsigned short TPREC;
#define STRING 0
#define CHAR 1
#define STROKE 2

/* typedef enum TXPATH - text path */

typedef unsigned short TXPATH;
#define RIGHT 0
#define LEFT 1
#define UP 2
#define DOWN 3

/* typedef enum text alignment */

typedef unsigned short ALINVAL;

typedef struct
	{
	ALINVAL txt_horiz;	/* should be enum's of components below */
	ALINVAL txt_vert;
	} TXALIN;

#define CENTER 2	/* horiz also uses RIGHT and LEFT from TXPATH (above) */
#define TOP 0					/* vertical components */
#define CAP 1
#define HALF 2
#define BASE 3
#define BOTTOM 4
#define NORMAL 5

/*
 * typedef enum FILINTER
 */
typedef unsigned short FILINTER;
#define HOLLOW 0
#define SOLID 1
#define PATTERN 2
#define HATCH 3

/*
 *	ASF's
 *
 *	This part defines the mask bits for
 *	the aspect source flags (ASF)
 */
typedef unsigned long ASF;

/*	polyline	*/

#define ASFPLCOL 0x1
#define ASFPLWD 0x2
#define ASFPLTYP 0x4

/*	polymarker	*/

#define ASFPMCOL 0x8
#define ASFPMSZ 0x10
#define ASFPMTYP 0x20

/*	text		*/

#define ASFTXCOL 0x40
#define ASFTXEX 0x80
#define ASFTXSP 0x100
#define ASFTXFP 0x200

/*	fill area	*/

#define ASFFILCOL 0x400
#define ASFFILIN 0x800
#define ASFFILSTL 0x1000

/* other useful bits in the asf field */

#define ASFWRAP 0x2000		/* used by string input to control scrolling */


typedef unsigned short GDP_ATTR;
#define ATR_POLYLINE 1
#define ATR_POLYMARKER 2
#define ATR_TEXT 4
#define ATR_FILLAREA 8

/* 
 * Segment and input definitions
 */

typedef REAL TWODTRANS[2][3];

/*
 * Return value from CHOICE device
 *
 *	note that CHOICESTAT uses OK and
 *	NONE from PICKSTAT
 */

typedef unsigned short CHOICESTAT;
#define NOCHOICE 1

typedef unsigned long CHOICEVAL;

/*
 * typedef enum PICKSTAT
 */

typedef unsigned short PICKSTAT;
#define OK 0
#define NOPICK 1
#define NONE 2

typedef unsigned int PICKID;

typedef unsigned int SEGNAME;

/*
 * typedef enum INPUTCLASS
 * n.b. subtle relation between names here and in TEXT PREC.
 */

typedef int INPUTCLASS;
#define NOEVENT	   -1
/* #define STRING	0 */
#define LOCATOR		1
/* #define STROKE	2 */
#define VALUATOR	3
#define PICK		4
#define CHOICE		5

/*
 * typedef enum INPUTMODE
 */
typedef unsigned short INPUTMODE;
#define REQUEST 0
#define SAMPLE 1
#define EVENT 2

/*
 * system parameters
 */

#define MAXSTROKE 64		/* max no. of stroke input pairs */
#define MAXTXFP   60		/* max no. of text font-precision pairs */
#define MAXINPSTR (128 + 1)	/* max size (in chars) of input string */
#define MAXGDP 20			/* max no. of gdp's */
#define MAXGDPDATA 512		/* max size of gdp data record */
#define MAXPRMPT 10			/* max no. of input prompts */
#define MAXTRANS 50			/* max no. norm. trans. */
#define MAXTXT (127 + 1)	/* max size (in chars) of text out. string */
#define PROMPTSZ (128 + 1)	/* max size (in chars) of prompt string */
#define MAXOPWORK 5			/* max no. of open workstations */
#define MAXACWORK 5			/* max no. of active workstations */
#define MAXSEGWORK 5		/* max no. of workstations assos. w/ seg.*/
#define MAXPATH (96 + 1)	/* max no. of characters in path name */
#define MAXCONN MAXPATH		/* max no. of characters in connection string */
#define MAXMSGBUF (132 + 1)	/* max no. of characters in message() */
