/*
 * CX2000 GKS C Library definitions and structures
 *
 * Copyright 1989 Chromatics. Inc. Release 1.3 SCCS 1.3 (89/05/04)
 *
 * CR0582 89/05/02 (lei) define Gtypemode & GLINETYPE,
 *                 GMARKERTYPE, GHATCHTYPE
 * CR0495 89/01/15 (rfc) Release 1.3, define Gbdrlim
 */

#ifndef FILE
#include <stdio.h>
#endif

/*
 *	Definitions of abstract types  used in GKS
 */

#define Gchar char
#define Gfile FILE 
#define Gfloat float
#define Gint int     
#define Gshort short     
#define Guint unsigned int     
#define Glong long
#define Gconn char
#define Gwstype char
#define GLN_SOLID 1
#define GLN_DASH 2
#define GLN_DOT 3
#define GLN_DOTDASH 4
#define GMK_POINT 1
#define GMK_PLUS 2
#define GMK_STAR 3
#define GMK_O 4
#define GMK_X 5

/*
 * Definitions of workstation connection id's
 */

#define GKSMO "GKSMO"
#define GKSMI "GKSMI"
#define GKSWISS "GKSWISS"
#define GCXHD1 "GCXHD1"
#define GCXHD2 "GCXHD2"
#define GCXHD3 "GCXHD3"
#define GCXHD4 "GCXHD4"
#define GCXOV1 "GCXOV1"
#define GCXOV2 "GCXOV2"
#define GCXOV3 "GCXOV3"
#define GCXOV4 "GCXOV4"


typedef enum{    /* attribute control flag */
    GCURRENT,
    GSPECIFIED
} Gacf;

typedef enum{    /* aspect source flag */
    GBUNDLED,
    GINDIVIDUAL
} Gasf;

typedef enum{    /* attributes used */
    GPOLYLINE,
    GPOLYMARKER,
    GTEXT,
    GFILLAREA
} Gattrs;

typedef enum{    /* clipping indicator */
    GCLIP,
    GNOCLIP
} Gclip;

typedef enum{    /* clear control flag */
    GCONDITIONALLY,
    GALWAYS
} Gclrflag;

typedef enum{    /* color availability */
    G_COLOUR,
    G_MONOCHROME
} Gcoavail;

typedef enum{    /* color values valid */
    GABSENT,
    GPRESENT
} Gcovalid;

typedef enum{    /* choice status */
    GC_NONE,
    GC_OK,
    GC_NOCHOICE
} Gcstat;

typedef enum{    /* coordinate switch */
    GWC,    /* world coordinates */
    GNDC    /* normalized device coordinates */
} Gcsw;

typedef enum{    /* deferral mode */
    GASAP,    /* as soon as possible */
    GBNIG,    /* before next interaction globally */
    GBNIL,    /* before next interaction locally */
    GASTI     /* at some time */
} Gdefmode;

typedef enum{    /* device coordinate units */
    GDC_METRES,
    GDC_OTHER
} Gdevunits;

typedef enum{    /* display surface */
    GEMPTY,
    GNOTEMPTY
} Gdspsurf;

typedef enum{    /* echo switch */
    GECHO,
    GNOECHO
} Gesw;

typedef enum{    /* fill area interior style */
    GHOLLOW,
    GSOLID,
    GPATTERN,
    GHATCH
} Gflinter;

typedef enum{    /* input class */
    GNCLASS,
    GLOCATOR,
    GSTROKE,
    GVALUATOR,
    GCHOICE,
    GPICK,
    GSTRING,
    GPAN
} Giclass;

typedef enum{    /* input mode */
    GREQUEST,
    GSAMPLE,
    GEVENT
} Gimode;

typedef enum{    /* inquiry type */
    GSET,
    GREALIZED
} Ginqtype;

typedef enum{    /* implicit regeneration mode */
    GSUPPRESSED,
    GALLOWED
} Girgmode;

typedef enum{    /* input status */
    GOK,
    GNONE
} Gistat;

typedef enum{    /* last event */
    GLAST,
    GNOTLAST
} Glastev;

typedef enum{    /* level of GKS */
    GLMA= -3,
    GLMB,
    GLMC,
    GL0A,
    GL0B,
    GL0C,
    GL1A,
    GL1B,
    GL1C,
    GL2A,
    GL2B,
    GL2C
} Glevel;

typedef enum{    /* dynamic modification type */
    GIRG,
    GIMM
} Gmodtype;

typedef enum{    /* new frame action at update */
    GNO,
    GYES
} Gnframe;

typedef enum{    /* GKS operating state */
    GGKCL,    /* GKS closed */
    GGKOP,    /* GKS open */
    GWSOP,    /* workstation open */
    GWSAC,    /* workstation active */
    GSGOP     /* segment open */
} Gopst;

typedef enum{    /* polyline fill area control flag */
    GPF_POLYLINE,
    GPF_FILLAREA
} Gpfcf;

typedef enum{    /* prompt flag */
    GPROFF,
    GPRON
} Gprflag;

typedef enum{    /* pick status */
    GP_NONE,
    GP_OK,
    GP_NOPICK
} Gpstat;

typedef enum{    /* pan status */
    GPN_NONE,
	GPN_OK
} Gpnstat;

typedef enum{    /* pan limit trigger */
    GPT_LIMIT,
    GPT_OK
} Gptrig;

typedef enum{    /* regeneration flag */
    GPERFORM,
    GPOSTPONE
} Gregen;
 
typedef enum{    /* segment detectability */
    GUNDETECTABLE,
    GDETECTABLE
} Gsegdet;
 
typedef enum{    /* segment highlighting */
    GNORMAL,
    GHIGHLIGHTED
} Gseghi;
 
typedef enum{    /* segment visibility */
    GVISIBLE,
    GINVISIBLE
} Gsegvis;
 
typedef enum{    /* simultaneous events */
    GNOMORE,
    GMORE
} Gsimultev;
 
typedef enum{    /* text alignment horizontal component */
    GAH_NORMAL,
    GAH_LEFT,
    GAH_CENTRE,
    GAH_RIGHT
} Gtxhor;
 
typedef enum{    /* text path */
    GTP_RIGHT,
    GTP_LEFT,
    GTP_UP,
    GTP_DOWN
} Gtxpath;
 
typedef enum{    /* text precision */
    GP_STRING,
    GP_CHAR,
    GP_STROKE
} Gtxprec;
 
typedef enum{    /* text alignment vertical component */
    GAV_NORMAL,
    GAV_TOP,
    GAV_CAP,
    GAV_HALF,
    GAV_BASE,
    GAV_BOTTOM
} Gtxver;
 
typedef enum{    /* viewport input priority */
    GHIGHER,
    GLOWER
} Gvpri;
 
typedef enum{    /* work station catagory */
    GOUTPUT,
    GINPUT,
    GOUTIN,
    GWISS,
    GMO,
    GMI
} Gwscat;
 
typedef enum{    /* workstation classification */
    GVECTOR,
    GRASTOR,
    GOTHER
} Gwsclass;
 
typedef enum{    /* workstation state */
    GINACTIVE,
    GACTIVE
} Gwsstate;
 
typedef enum{    /* workstation transformation update state */
    GNOTPENDING,
    GPENDING
} Gwstus;

typedef enum{	/* display view buffers */
	GCXVSAME = 1,
	GCXVBUF0,
	GCXVBUF1,
	GCXVFLIP
} Gvwbuf;

typedef enum{	/* display write buffers */
	GCXWBUF0 = 1,
	GCXWBUF1,
	GCXWBOTH,
	GCXWVIEW,
	GCXWHIDE
} Gwrtbuf;

/* 
 * Error codes
 */

#define NO_ERROR 0     /* No error */ 
#ifndef ENOTGKCL 

/* State error codes */

#define ENOTGKCL 1         /* GKS not in proper state: should be GKCL */
#define ENOTGKOP 2         /* GKS not in proper state: should be GKOP */
#define ENOTWSAC 3         /* GKS not in proper state: should be WSAC */
#define ENOTSGOP 4         /* GKS not in proper state: should be SGOP */
#define ENOTACOP 5         /* GKS not in proper state: should be WSAC,SGOP */
#define ENOTOPAC 6         /* GKS not in proper state: should be WSOP,WSAC */
#define ENOTWSOP 7         /* GKS not in proper state: should be WSOP,WSAC, */
                           /*  SGOP */
#define ENOTGWWS 8         /* GKS not in proper state: should be GKOP,WSOP, */
                           /*  WSAC,SGOP */

/* Workstation error codes */

#define EWSIDINV 20         /* Specified workstation ID is invalid */
#define ECNIDINV 21         /* Specified connection ID is invalid */
#define EWSTPINV 22         /* Specified workstation type is invalid */
#define ENOWSTYP 23         /* Specified workstation type does not exist */
#define EWSISOPN 24         /* Specified workstation is open */
#define EWSNOTOP 25         /* Specified workstation is not open */
#define EWSCNTOP 26         /* Specified workstation cannot be opened */
#define EWISSNOP 27         /* WISS is not open */
#define EWISSOPN 28         /* WISS is already open */
#define EWSISACT 29         /* Specified workstation is active */
#define EWSNTACT 30         /* Specified workstation is not active */
#define EWSCATMO 31         /* Specified workstation is of category MO */
#define EWSNOTMO 32         /* Specified workstation is not of category MO */
#define EWSCATMI 33         /* Specified workstation is of category MI */
#define EWSNOTMI 34         /* Specified workstation is not of category MI */
#define EWSCATIN 35         /* Specified workstation is of category INPUT */
#define EWSIWISS 36         /* Specified workstation is WISS */
#define EWSNOTOI 37         /* Specified workstation is not of category OUTIN */
#define EWSNOTIO 38         /* Specified workstation is neither INPUT nor */
                            /*  OUTIN */
#define EWSNOTOO 39         /* Specified workstation is neither OUTPUT nor */
                            /*  OUTIN */
#define EWSNOPXL 40         /* Specified workstation has no pixel store */
                            /*  readback capability */
#define EWSNOGDP 41         /* Specified workstation is not able to generate */
                            /*  GDP */
#define EWSMXOPN 42         /* Max number of simultaneously open workstations */
                            /*  would be exceeded */
#define EWSMXACT 43         /* Max number of simultaneously active */
                            /*  workstations would be exceeded */

/* Transformation error codes */

#define EBADXFRM 50         /* Transformation number is invalid */
#define EBADRCTD 51         /* Rectangle definition is invalid */
#define EBDVIEWP 52         /* Viewport is not within NDC unit square */
#define EBDWINDW 53         /* Workstation window is not within NDC unit */
                            /*  square */
#define EVIEWDSP 54         /* Workstation viewport is not within display */
                            /*  surface */

/* Output attribute error codes */

#define EBADLINX 60         /* Polyline index is invalid */
#define ENOLINEX 61         /* A representation for the specified polyline */
                            /*  index has not been defined on this */
                            /*  workstation */
#define ENOPLINX 62         /* A representation for the specified polyline */
                            /*  index has not been predefined on this */
                            /*  workstation */
#define ELINEEQZ 63         /* Linetype is equal to zero */
#define ENOLINTP 64         /* Specified linetype not supported */
#define ELNWDLTZ 65         /* Linewidth scale factor is less than zero */
#define EBADMRKX 66         /* Polymarker index is invalid */
#define ENOMARKX 67         /* A representation for the specified polymarker */
                            /*  index has not been defined on this */
                            /*  workstation */
#define ENOPMRKX 68         /* A representation for the specified polymarker */
                            /*  index has not been predefined on this */
                            /*  workstation */
#define EMARKEQZ 69         /* Marker type is equal to zero */
#define ENOMRKTP 70         /* Specified marker type not supported */
#define EMKSZLTZ 71         /* Marker size scale factor is less than zero */
#define EBADTXTX 72         /* Text index is invalid */
#define ENOTEXTX 73         /* A representation for the specified text */
                            /*  index has not been defined on this */
                            /*  workstation */
#define ENOPTXTX 74         /* A representation for the specified text */
                            /*  index has not been predefined on this */
                            /*  workstation */
#define ETXTFEQZ 75         /* Text font is equal to zero */
#define ENOTXTFP 76         /* Requested text font is not supported for the */
                            /*  specified precision */
#define ECEXFLEZ 77         /* Character expansion factor is less than or */
                            /*  equal to zero */
#define ECHHTLEZ 78         /* Character height is less than or equal to zero */
#define ECHRUPVZ 79         /* Length of character up vector is zero */
#define EBADFILX 80         /* Fill area index is invalid */
#define ENOFILLX 81         /* A representation for the specified fill area */
                            /*  index has not been defined on this */
                            /*  workstation */
#define ENOPFILX 82         /* A representation for the specified fill area */
                            /*  index has not been predefined on this */
                            /*  workstation */
#define ENOFSTYL 83         /* Specified fill area interior style is not */
                            /*  supported */
#define ESTYLEQZ 84         /* Style index is equal to zero */
#define EBADPATN 85         /* Specified pattern index is invalid */
#define ENOHATCH 86         /* Specified hatch style not supported */
#define EPATSZLZ 87         /* Pattern size is not positive */
#define ENOPATNX 88         /* A representation for the specified pattern */
                            /*  index has not been defined on this */
                            /*  workstation */
#define ENOPPTNX 89         /* A representation for the specified pattern */
                            /*  index has not been predefined on this */
                            /*  workstation */
#define ENOPSTYL 90         /* Interior style PATTERN not supported */
#define ECADIMEN 91         /* Dimensions of color array are invalid */
#define ECINDXLZ 92         /* Color index is less than zero */
#define EBADCOLX 93         /* Color index is invalid */
#define ENOCOLRX 94         /* A representation for the specified color */
                            /*  index has not been defined on this */
                            /*  workstation */
#define ENOPCLRX 95         /* A representation for the specified color */
                            /*  index has not been predefined on this */
                            /*  workstation */
#define ECOLRNGE 96         /* Color is outside range [0,1] */
#define EBADPICK 97         /* Pick identifier is invalid */

/* Output primitive error codes */

#define ENPOINTS 100     /* Number of points is invalid */
#define ECHRCODE 101     /* Invalid code in string */
#define EBDGDPID 102     /* GDP identifier is invalid */
#define EGDPDATA 103     /* Content of GDP data record is invalid */
#define ECANTGDP 104     /* At least one active workstation is not able */
                         /*  to generate the specified GDP */
#define ECNTGDPC 105     /* At least one actove workstation is not able */
                         /*  to generate the specified GDP undeer the */
                         /*  current transformations and clipping rect. */

/* Segment error codes */

#define EBADNAME 120     /* Specified segment name is invalid */
#define ENAMUSED 121     /* Specified segment name is in use */
#define EWHATSEG 122     /* Specified segment does not exist */
#define EWORKSEG 123     /* Specified segment does not exist on specified */
                         /*  workstation */
#define EWISSSEG 124     /* Specified segment dies not exist on WISS */
#define ESEGOPEN 125     /* Specified segment is open */
#define ESEGPRIR 126     /* Segment priority is outside the range [0,1] */

/* Input error codes */

#define ENOINDEV 140     /* Specified input device is not present on */
                         /*  workstation */
#define EREQUEST 141     /* Input device is not in REQUEST mode */
#define ENSAMPLE 142     /* Input device is not in SAMPLE mode */
#define ENOEVSMP 143     /* EVENT and SAMPLE input modes not available */
                         /*  at this level of GKS */
#define ENOPETWS 144     /* Specified prompt and echo type not supported */
#define EEBOUNDS 145     /* Contents of input data record are invalid */
#define EBADDATA 146     /* Echo area is output display space */
#define EINQOVFL 147     /* Input queue has overflowed */
#define ENOQOVFL 148     /* Input queue has not overflowed since GKS was */
                         /*  opened or the last invocation of INQUIRE */
                         /*  INPUT QUEUE OVERFLOW */
#define EASWSCLO 149     /* Input queue has overflowed, but associated */
                         /*  workstation has been closed */
#define ENOCURIV 150     /* No input value of the correct class is in the */
                         /*  current event report */
#define EINVTOUT 151     /* Timeout is invalid */
#define EBDINITV 152     /* Initial value is invalid */
#define ESTROKSZ 153     /* Number of points in the initial stroke is */
                         /*  greater than the buffer size */
#define ESTRINSZ 154     /* Length of the initial string is greater than */
                         /*  the buffer size */

/* Metafile error codes */

#define ERESERVE 160     /* Item type is not allowed for user items */
#define EBDLNGTH 161     /* Item length is invalid */
#define EMNOITEM 162     /* No item is left in GKS metafile input */
#define EMITMINV 163     /* Metafile item is invalid */
#define ENOTGKSI 164     /* Item type is not a valid GKS item */
#define EBADCNTS 165     /* Content of item data record is invalid for */
                         /*  the specified item type */
#define EEBDMXDR 166     /* Maximum item data record length is invalid */
#define EINTERPT 167     /* User item cannot be interpreted */
#define ENOFUNCT 168     /* Specified function not supported at this  */
                         /*  level of GKS */

/* Escape error codes */

#define ENOESCFN 180     /* Specified escape function not supported */
#define ESCIDINV 181     /* Specified escape funstion ID not supported */
#define EESCDATA 182     /* Contents of escape data record are invalid */

/* Miscellaneous error codes */

#define EBDERRFL 200     /* Specified error file is invalid */

/* System error codes */

#define EMEMSPAC 300     /* Storage overflow has occurred in GKS */
#define ESEGSPAC 301     /* Storage overflow has occurred in segment */
                         /*  storage */
#define EIOREAD  302     /* Input/Output error has occurred while reading */
#define EIOWRITE 303     /* Input/Output error has occurred while writing */
#define EIOSENDD 304     /* Input/Output error has occurred while sending */
                         /*  data to workstation */
#define EIORECDA 305     /* Input/Output error has occurred while */
                         /*  receiving data from workstation */
#define EIOLIBMG 306     /* Input/Output error has occurred during program */
                         /*  library management */
#define EIORDWDT 307     /* Input/Output error has occurred while reading */
                         /*  workstation description table */
#define EMATHERR 308     /* Arithmetic error has occurred */

/* Type 3 buffer messages */

#define EBUFSPAC 2200    /* Buffer overflow on input or inquiry functions */
#define ERRLOGMT 2201    /* Error log is empty */
#define EOUTRANG 2202    /* Out of range */

/* CX dependent error code */

#define ECXNODMA -1      /* Error occurred during a DMA transfer */
#define ECXMXSIZ -10     /* Message/buffer size error */
#define ECXBTINV -11     /* Invalid blink type */
#define ECXNOXFR -12     /* Message transfer failed */
#define ECXNOADD -13     /* Address not within DLM space */
#define ECXODADD -14     /* Odd address within DLM specified */
#define ECXODCNT -15     /* Odd DLM transfer count specified */
#define ECXMLINV -16     /* Invalid polymarker length specified */
#define ECXNOHEP -17     /* No room in heap for definition */
#define ECXIREDY -18     /* Infinite redraw already in progress */
#define ECXFPINV -19     /* Invalid frame grabber parameter */
#define ECXFNINV -20     /* Invalid font number */
#define ECXNOMEM -21     /* No memory in which to define font */
#define ECXFNREP -22     /* Font is not replacable */
#define ECXFLINV -23     /* Invalid font length */
#define ECXTLINV -24     /* Transmission length invalid */
#define ECXMPINV -25     /* Microcode load parameter invalid */
#define ECXNOVER -26     /* Microcode load failed to verify */
#define ECXBDSCT -27     /* Invalid segment/pick count */
#define ECXCNINV -28     /* Invalid connection name */
#define ECXBDCTP -29     /* Invalid connection type */
#define ECXSLINV -30     /* Segment length invalid */
#define ECXDTNCT -31     /* Non-contiguous data transfers */
#define ECXRMATD -32     /* Raster size does not match data size */
#define ECXFLOPN -33     /* Error opening Metafile */
#define ECXSDTOE -34     /* Value out of range */
#define ECXSYMST -35	 /* GKS not in proper state, already in SDEF */
#define ECXNSYMS -36	 /* GKS not in proper state, must be SDEF */
#define ECXSYMFL -37	 /* symbol definition buffer is full */
#define ECXINVSS -38	 /* invalid symbol buffer size */
#define ECXINVSI -39	 /* symbol index less than 0 */
#define ECXINVUT -40	 /* invalid update table */
#define ECXINVNS -41	 /* invalid number of symbols */
#define ECXINVTT -42	 /* invalid table type */
#define ECXINVUM -43	 /* invalid update mode */
#define ECXNAMEM -44	 /* no available memory on the CX2000 */
#define ECXINVWB -45	 /* display write buffer invalid */
#define ECXINVVB -46	 /* display view buffer invalid */
#endif

/*
 *	Definitions of structure types used in GKS
 */

typedef struct{  /* coordinate limits */
    Gfloat    xmin;    /* x minimum limit */
    Gfloat    xmax;    /* x maximum limit */
    Gfloat    ymin;    /* y minimum limit */
    Gfloat    ymax;    /* y maximum limit */
} Glimit;

typedef struct{  /* integer list */
    Gint    number;    /* number of integers in list */
    Gint    *integers; /* array of integers */
} Gintlist;

typedef struct{  /* coordinate point */
    Gfloat    x;    /* x coordinate */
    Gfloat    y;    /* y coordinate */
} Gpoint;

typedef struct{  /* intger point */
    Gint    x;    /* x coordinate */
    Gint    y;    /* y coordinate */
} Gipoint;

typedef struct{  /* aspect source flags */
    Gasf    ln_type;    /* line type */
    Gasf    ln_width;   /* line width */
    Gasf    ln_colour;  /* line colour */
    Gasf    mk_type;    /* marker type */
    Gasf    mk_size;    /* marker size */
    Gasf    mk_colour;  /* marker colour */
    Gasf    tx_pf;      /* text font and precision */
    Gasf    tx_exp;     /* text expansion */
    Gasf    tx_space;   /* text character spacing */
    Gasf    tx_colour;  /* text colour */
    Gasf    fl_inter;   /* fill area interior style */
    Gasf    fl_style;   /* fill area style index */
    Gasf    fl_colour;  /* fill area colour */
} Gasfs;

typedef struct{  /* choice data */
    Gcstat status;    /* choice status */
    Gint   choice;    /* choice number */
} Gchoice;

typedef struct{  /* dimensions in real values */
    Gfloat   x_dim;
    Gfloat   y_dim;
} Gdim;

typedef struct{  /* polyline bundle */
    Gint     type;    /* line type */
    Gfloat   width;   /* linewidth scale factor */
    Gint     colour;  /* polyline colour index */
} Glnbundl;

typedef struct{  /* fill area bundle */
    Gflinter   inter;    /* fill area interior style */
    Gint       style;    /* fill area style index */
    Gint       colour;   /* fill area colour index */
} Gflbundl;

typedef struct{  /* text font and presision */
    Gint       font;      /* text font */
    Gtxprec    prec;      /* text precision */
} Gtxfp;
 
typedef struct{  /* test bundle */
    Gtxfp     fp;        /* font and presision */
    Gfloat    exp;       /* character expansion */
    Gfloat    space;     /* character spacing */
    Gint      colour;    /* text colour */
} Gtxbundl;
 
typedef struct{  /* polyline attributes */
    Gasf     type;    /* linetype ASF */
    Gasf     width;   /* linewidth ASF */
    Gasf     colour;  /* linecolour ASF */
    Gint     line;    /* line index */
    Glnbundl bundl;   /* line bundle */
} Glnattr;

typedef struct{  /* fill area attributes */
    Gasf     inter;    /* fill area interior style ASF */
    Gasf     style;    /* fill area style index ASF */
    Gasf     colour;   /* fill area colour ASF */
    Gint     fill;     /* fill area index */
    Gflbundl bundl;    /* fill area bundle */
} Gflattr;

typedef struct{  /* text attributes */
    Gasf       fp;      /* test font and presision ASF */
    Gasf       exp;     /* text character expansion ASF */
    Gasf       space;   /* text character spacing ASF */
    Gasf       colour;  /* test colour ASF */
    Gint       text;    /* text index */
    Gtxbundl   bundl;   /* text bundle */
} Gtxattr;
 
typedef struct{  /* polymarker bundle */
    Gint     type;    /* marker type */
    Gfloat   size;    /* marker size scale factor */
    Gint     colour;  /* marker line colour index */
} Gmkbundl;

typedef struct{  /* polymarker attributes */
    Gasf     type;    /* marker type ASF */
    Gasf     size;    /* marker size ASF */
    Gasf     colour;  /* marker colour ASF */
    Gint     mark;    /* marker index */
    Gmkbundl bundl;   /* marker bundle */
} Gmkattr;

typedef struct{  /* text alignment */
    Gtxhor     hor;    /* horizontal component */
    Gtxver     ver;    /* vertical component */
} Gtxalign;
 
typedef struct{  /* pattern bundle */
    Gipoint    size;    /* pattern array size */
    Gint       *array;  /* pattern array */
} Gptbundl;
 
typedef struct{  /* stroke data */
    Gint      transform;    /* normalization transformation number */
    Gint      n_points;     /* number of points in stroke */
    Gpoint    *points;      /* array of points in stroke */
} Gstroke;
 
typedef struct{
    Gchar    *data;    /* device/implementation dependent data */
} Gchoicepet0001;

typedef struct{
    Gint     number;   /* number of alternatives */
    Gprflag  *enable;  /* array of prompts */
    Gchar    *data;    /* device/implementation dependent data */
} Gchoicepet0002;

typedef struct{
    Gint     number;   /* number of choice strings */
    Gchar    **strings;/* array of strings */
    Gchar    *data;    /* device/implementation dependent data */
} Gchoicepet0003;

typedef struct{
    Gint     number;   /* number of choice strings */
    Gchar    **strings;/* array of strings */
    Gchar    *data;    /* device/implementation dependent data */
} Gchoicepet0004;

typedef struct{
    Gint     seg;      /* segment name */
    Gint     number;   /* number of alternatives */
    Gchar    *pickids; /* array of pick identifiers */
    Gchar    *data;    /* device/implementation dependent data */
} Gchoicepet0005;

typedef union{   /* choice data record */
    Gchoicepet0001    choicepet1_datarec;
    Gchoicepet0002    choicepet2_datarec;
    Gchoicepet0003    choicepet3_datarec;
    Gchoicepet0004    choicepet4_datarec;
    Gchoicepet0005    choicepet5_datarec;
} Gchoicerec;

typedef struct{
    Gacf    acf;      /* attribute control flag */
    Glnattr ln;       /* polyline attributes */
} Glocpet0004;

typedef Glocpet0004 Glocpet0001;
typedef Glocpet0004 Glocpet0002;
typedef Glocpet0004 Glocpet0003;

typedef struct{
    Gpfcf   pfcf;     /* polyline/fill area control flag */
    Gacf    acf;      /* attribute control flag */
    union{ 
        Glnattr ln;   /* polyline attributes */
        Gflattr fl;   /* fill area attributes */
    } attr;
} Glocpet0005;

typedef union{   /* choice data record */
    Glocpet0001    locpet1_datarec;
    Glocpet0002    locpet2_datarec;
    Glocpet0003    locpet3_datarec;
    Glocpet0004    locpet4_datarec;
    Glocpet0005    locpet5_datarec;
} Glocrec;

typedef struct{
    Gint      curnum;      /* cursor number */
    Gpoint    curpos;      /* initial cursor position */
    Gacf      acf;         /* attribute control flag */
    Glnattr   ln;          /* attributes */
    Gipoint   window;      /* pick window */
    Gfloat    time;        /* number of seconds to highlight */
} Gpickpet0001;

typedef Gpickpet0001 Gpickpet0002;
typedef Gpickpet0001 Gpickpet0003;

typedef union{   /* pick data record */
    Gpickpet0001    pickpet1_datarec;
    Gpickpet0002    pickpet2_datarec;
    Gpickpet0003    pickpet3_datarec;
} Gpickrec;

typedef struct{
    Gint    bufsiz;    /* buffer size */
    Gint    position;  /* initial cursor position */
    Gint    tx_wrap;   /* text wraping */
    Gint    tx_font;   /* text font */
    Gtxprec tx_prec;   /* text precision */
    Gfloat  tx_chexp;  /* character expansion */
    Gfloat  tx_space;  /* character spacing */
    Gint    tx_ci;     /* text color index */
    Gfloat  tx_ht;     /* text height */
    Gfloat  tx_ils;    /* inter-line spacing */
    Gint    tx_bgci;   /* text background color index */
    Gint    fgci;      /* prompt foreground color index */
    Gint    tx_curci;  /* cursor color index */
} Gstringpet0001;

typedef union{   /* string data record */
    Gstringpet0001    stringpet1_datarec;
} Gstringrec;
 
typedef struct{
    Gint      bufsiz;      /* input buffer size */
    Gint      editpos;     /* editing position */
    Gpoint    interval;    /* x,y interval */
    Gfloat    time;        /* time interval */
    Gacf      acf;         /* attribute control flag */
    Gmkattr   mk;          /* marker attributes */
    Gint      curnum;      /* cursor number */
    Gpoint    curpos;      /* initial cursor position */
    Glnattr   cursor;      /* cursor attribute bundle */
    Glnattr   ln;          /* line attributes */
} Gstrokepet0001;

typedef struct{
    Gint      bufsiz;      /* input buffer size */
    Gint      editpos;     /* editing position */
    Gpoint    interval;    /* x,y interval */
    Gfloat    time;        /* time interval */
    Gacf      acf;         /* attribute control flag */
    Gmkattr   mk;          /* marker attributes */
    Gint      curnum;      /* cursor number */
    Gpoint    curpos;      /* initial cursor position */
    Glnattr   cursor;      /* cursor attribute bundle */
} Gstrokepet0003;
 
typedef Gstrokepet0003 Gstrokepet0002;
 
typedef struct{
    Gint      bufsiz;      /* input buffer size */
    Gint      editpos;     /* editing position */
    Gpoint    interval;    /* x,y interval */
    Gfloat    time;        /* time interval */
    Gacf      acf;         /* attribute control flag */
    Glnattr   ln;          /* line attributes */
    Gint      curnum;      /* cursor number */
    Gpoint    curpos;      /* initial cursor position */
    Glnattr   cursor;      /* cursor attribute bundle */
} Gstrokepet0004;
 
typedef union{   /* stroke data record */
    Gstrokepet0001    strokepet1_datarec;
    Gstrokepet0002    strokepet2_datarec;
    Gstrokepet0003    strokepet3_datarec;
    Gstrokepet0004    strokepet4_datarec;
} Gstrokerec;
 
typedef struct{
	Gint      bg;		/* bg color index */
	Gint      uidx;		/* val unit index */
    Gfloat    low;      /* low range limit */
    Gfloat    high;     /* high range limit */
    Gint      step;     /* number of steps */
    Gint      path;     /* direction */
    Gacf      acf;      /* attribute control flag */
    Gflattr   fl;       /* interior style */
} Gvalpet0001;
 
typedef Gvalpet0001 Gvalpet0002;
 
typedef struct{
	Gint      bg;		/* bg color index */
	Gint      uidx;		/* val unit index */
    Gfloat    low;      /* low range limit */
    Gfloat    high;     /* high range limit */
    Gint      step;     /* number of steps */
    Gint      path;     /* direction */
    Gacf      acf;      /* attribute control flag */
    Gtxattr   tx;       /* text style */
} Gvalpet0003;
 
typedef union{   /* valuator data record */
    Gvalpet0001    valpet1_datarec;
    Gvalpet0002    valpet2_datarec;
    Gvalpet0003    valpet3_datarec;
} Gvalrec;
 

typedef struct{  /* choice state */ 
    Gimode      mode;    /* mode */
    Gesw        esw;     /* echo switch */
    Gchoice     choice;  /* choice data */
    Gint        pet;     /* prompt and echo type */
    Glimit      e_area;  /* echo area */
    Gchoicerec  record;  /* choice data record */
} Gchoicest;

typedef struct{  /* cliping rectangle */
    Gclip    ind;    /* cliping indicator */
    Glimit   rec;    /* cliping rectangle */
} Gcliprect;

typedef struct{  /* color bundle */
    Gfloat    red;    /* red intensity */
    Gfloat    green;  /* green intensity */
    Gfloat    blue;   /* blue intensity */
} Gcobundl;

typedef struct{  /* color facilities */
    Gint      colours;    /* number of colours */
    Gcoavail  coavail;    /* colour availability */
    Gint      predefined; /* number of predefined bundles */
} Gcofac;

typedef struct{  /* default choice data */
    Gint       choices;    /* maximum number of choices */
    Gintlist   *pets;      /* list of prompt and echo types */
    Glimit     e_area;     /* default echo area */
    Gchoicerec record;     /* default choice data record */
} Gdefchoice;

typedef struct{  /* deferral state */
    Gdefmode    defmode;    /* deferral mode */
    Girgmode    irgmode;    /* implicit regeneration mode */
} Gdefer;

typedef struct{  /* default locator data */
    Gpoint    position;    /* inital position */
    Gintlist  *pets;       /* list of prompt and echo types */
    Glimit    e_area;      /* default echo area */
    Glocrec   record;      /* default locator data record */
} Gdefloc;

typedef struct{  /* default pick data */
    Gintlist    *pets;   /* list of prompt and echo types */
    Glimit      e_area;  /* default echo area */
    Gpickrec    record;  /* default pick data record */
} Gdefpick;

typedef struct{  /* default string data */
    Gint       bufsiz;    /* inital buffer size */
    Gintlist   *pets;     /* list of prompt and echo types */
    Glimit     e_area;    /* default echo area */
    Gstringrec record;    /* default string data record */
} Gdefstring;

typedef struct{  /* default stroke data */
    Gint       bufsiz;    /* buffer size */
    Gintlist   *pets;     /* list of prompt and echo types */
    Glimit     e_area;    /* default echo area */
    Gstrokerec record;    /* default stroke data record */
} Gdefstroke;

typedef struct{  /* default valuator data */
    Gfloat    value;    /* initial value */
    Gintlist  *pets;    /* list of prompt and echo types */
    Glimit    e_area;   /* default echo area */
    Gvalrec   record;   /* default valuator data record */
} Gdefval;

typedef struct{  /* display size */
    Gdevunits  units;    /* device coordinate units */
    Gpoint     device;   /* device coordinate unit size */
    Gipoint    raster;   /* raster uinit size */
} Gdspsize;

typedef struct{  /* event */
    Gint    ws;    /* workstation */
    Gint    dev;   /* device number */
    Giclass class; /* event class */
} Gevent;

typedef struct{  /* text extent */
    Gpoint    concat;
    Gpoint    corner_1;
    Gpoint    corner_2;
    Gpoint    corner_3;
    Gpoint    corner_4;
} Gextent;

typedef struct{  /* fill area facilities */
    Gint        n_interiors;  /* list of available interior styles */
    Gflinter    *interiors;   /* list of available interior styles */
    Gintlist    *hatches;     /* list of available hatch styles */
    Gint        predefined;   /* number of predefined bundles */
} Gflfac;

typedef struct{  /* GDP facilities */
    Gint    n_attrs;  /* number of GDPs */ 
    Gattrs  *attrs;   /* list of attributes used */
} Ggdpfac;

typedef struct{  /* GKS metafile data record */
    Gchar data[206*80];
} Ggksmrec;

typedef struct{  /* GKS metafile item */
    Gint    type;    /* item type */
    Gint    length;  /* item length */
} Ggksmit;

typedef struct{  /* dimensions in integer values */
    Guint    x_dim;
    Guint    y_dim;
} Gidim;

typedef struct{  /* individual attributes */
    Gint      ln_type;     /* current line type */
    Gfloat    ln_width;    /* current linewidth scale factor */
    Gint      ln_colour;   /* current polyline colour index */
    Gint      mk_type;     /* current marker type */
    Gfloat    mk_size;     /* current marker size scale factor */
    Gint      mk_colour;   /* current polymarker colour index */
    Gtxfp     tx_fontprec; /* current text font and precision structure */
    Gfloat    ch_exp;      /* current character expansion factor */
    Gfloat    ch_space;    /* current character spaceing factor */
    Gint      tx_colour;   /* current text colour index */
    Gflinter  fl_interior; /* current fill area interior style */
    Gint      fl_style;
    Gint      fl_colour;   /* current fill area colour index */
    Gasfs     asfs;        /* aspect source flags */
} Gindivattr;

typedef struct{  /* polyline facilities */
    Gintlist    *types;     /* list of available line types */
    Gint        widths;     /* number of line widths */
    Gfloat      nom_width;  /* nominal width */
    Gfloat      min_width;  /* minimum width */
    Gfloat      max_width;  /* maximum width */
    Gint        predefined; /* number of predefined bundles */
} Glnfac;

typedef struct{  /* locator data */
    Gint    transform;    /* normalization transformation number */
    Gpoint  position;     /* locator position */
} Gloc;

typedef struct{  /* locator state */
    Gimode    mode;    /* mode */
    Gesw      esw;     /* echo switch */
    Gloc      loc;     /* locator data */
    Gint      pet;     /* prompt and echo type */
    Glimit    e_area;  /* echo area */
    Glocrec   record;  /* locator data record */
} Glocst;

typedef struct{  /* polymarker line facilities */
    Gintlist    *types;     /* list of available marker types */
    Gint        sizes;      /* number of marker sizes */
    Gfloat      nom_size;   /* nominal size */
    Gfloat      min_size;   /* minimum size */
    Gfloat      max_size;   /* maximum size */
    Gint        predefined; /* number of predefined bundles */
} Gmkfac;

typedef struct{  /* dynamic modification of segment attributes */
    Gmodtype    transform;    /* transformation */
    Gmodtype    appear;       /* appearing (turning visible) */
    Gmodtype    disappear;    /* disappearing (turning invisible) */
    Gmodtype    highlight;    /* highlighting */
    Gmodtype    priority;     /* priority */
    Gmodtype    addition;     /* addition of primitives to segment */
    Gmodtype    deletion;     /* deletion of segment */
} Gmodseg;

typedef struct{  /* dynamic modification of workstation attributes */
    Gmodtype    line;    /* polyline */
    Gmodtype    mark;    /* polymarker */
    Gmodtype    text;    /* text */
    Gmodtype    fill;    /* fill area */
    Gmodtype    pat;     /* pattern */
    Gmodtype    colour;  /* colour */
    Gmodtype    wstran;  /* workstation transformation */
} Gmodws;

typedef struct{  /* number of input devices */
    Gint    locator;    /* locators */
    Gint    stroke;     /* strokes */
    Gint    valuator;   /* valuators */
    Gint    choice;     /* choices */
    Gint    pick;       /* picks */
    Gint    string;     /* strings */
} Gnumdev;

typedef struct{  /* pick data */
    Gpstat    status;    /* pick status */
    Gint      seg;       /* pick segment */
    Gint      pickid;    /* pick identifer */
} Gpick;

typedef struct{  /* pickstate */
    Gimode    mode;    /* mode */
    Gesw      esw;     /* echo switch */
    Gpick     pick;    /* pick data */
    Gint      pet;     /* prompt and echo type */
    Glimit    e_area;  /* echo area */
    Gpickrec  record;  /* pick data record */
} Gpickst;

typedef struct{  /* primary attributes */
    Gint     ln_index;    /* current polyline index */
    Gint     mk_index;    /* current polymarker index */
    Gint     tx_index;    /* current text index */
    Gfloat   ch_heigth;   /* current character heigth */
    Gpoint   ch_up;       /* current character up vector */
    Gfloat   ch_width;    /* current character width */
    Gpoint   ch_base;     /* current character base vector */
    Gtxpath  tx_path;     /* current text path */
    Gtxalign tx_align;    /* current text alignment */
    Gint     fl_index;    /* current fill area index */
    Gpoint   pa_width;    /* current pattern width vector */
    Gpoint   pa_height;   /* current pattern height vector */
    Gpoint   pa_refpt;    /* current pattern reference point */
} Gprimattr;

typedef struct{  /* pixel array */
    Gcovalid    covalid;    /* colour values valid */
    Gint        *array;     /* pixel array */
} Gpxarray;
 
typedef struct{  /* choice data */
    Gcstat status;    /* choice status */
    Gint   choice;    /* choice number */
} Gqchoice;

typedef struct{  /* request locator */
    Gistat    status;    /* input status */
    Gloc      loc;       /* locator data */
} Gqloc;
 
typedef struct{  /* request string */
    Gistat    status;    /* input status */
    Gchar     *string;   /* string data */
} Gqstring;
 
typedef struct{  /* request stroke */
    Gistat    status;    /* input status */
    Gstroke   *stroke;   /* stroke data */
} Gqstroke;
 
typedef struct{  /* queue information */
    Gint        ws;       /* workstation identifier */
    Giclass     class;    /* event class */
    Gint        devno;    /* logical input device */
} Gqueue;
 
typedef struct{  /* request valuator */
    Gistat    status;    /* input status */
    Gfloat    val;       /* valuator data */
} Gqval;
 
typedef struct{  /* coordinate rectangle */
    Gpoint    ul;    /* upper left-hand corner */
    Gpoint    lr;    /* lower right-hand corner */
} Grect;
 
typedef struct{  /* scale vector */
    Gfloat    x_scale;
    Gfloat    y_scale;
} Gscale;
 
typedef struct{  /* segment attributes */
    Gfloat    segtran[2][3];    /* segment tranformation matrix */
    Gsegvis   segvis;           /* visability of segment */
    Gseghi    seghi;            /* highlighting of the segment */
    Gfloat    segpri;           /* priority of the segment */
    Gsegdet   segdet;           /* detectability of the segment */
} Gsegattr;
 
typedef struct{  /* string state */
    Gimode        mode;      /* mode */
    Gesw          esw;       /* echo switch */
    Gchar         *string;   /* string data */
    Gint          pet;       /* prompt and echo type */
    Glimit        e_area;    /* echo area */
    Gstringrec    record;    /* string data record */
} Gstringst;
 
typedef struct{  /* string list */
    Gint      n_strings;   /* number of strings in list */
    Gchar     **strings;   /* array of pointers to strings */
} Gstrlist;
 
typedef struct{  /* stroke state */
    Gimode        mode;      /* mode */
    Gesw          esw;       /* echo switch */
    Gstroke       stroke;    /* stroke data */
    Gint          pet;       /* prompt and echo type */
    Glimit        e_area;    /* echo area */
    Gstrokerec    record;    /* stroke data record */
} Gstrokest;
 
typedef struct{  /* transformation */
    Glimit    w;    /* window */
    Glimit    v;    /* viewport */
} Gtran;
 
typedef struct{  /* text facilities */
    Gint     fps;           /* number of fonts and presisions */
    Gtxfp    *fp_list;      /* list of avaliable fonts and presisions */
    Gint     heights;       /* number of character heights */
    Gfloat   min_ht;        /* minimum height */
    Gfloat   max_ht;        /* maximum height */
    Gint     expansions;    /* number of character expansion factors */
    Gfloat   min_exp;       /* minimum expansion factor */
    Gfloat   max_exp;       /* maximum expansion factor */
    Gint     predefined;    /* number of predefined bundles */
} Gtxfac;
 
typedef struct{  /* valuator state */
    Gimode        mode;      /* mode */
    Gesw          esw;       /* echo switch */
    Gfloat        val;       /* valuator data */
    Gint          pet;       /* prompt and echo type */
    Glimit        e_area;    /* echo area */
    Gvalrec       record;    /* valuator data record */
} Gvalst;
 
typedef struct{  /* workstation connection and type */
    Gchar    *conn;    /* workstation connection */
    Gchar    *type;    /* workstation type */
} Gwsct;
 
typedef struct{  /* workstation deferral and updata state */
    Gdefmode      defmode;    /* defferal mode */
    Gdspsurf      dspsurf;    /* display surface */
    Girgmode      irgmode;    /* implicit regeneration mode */
    Gnframe       nframe;     /* new frame action at update */
} Gwsdus;
 
typedef struct{  /* workstation maximum numbers */
    Gint    open;      /* number of open workstations */
    Gint    active;    /* number of active workstations */
    Gint    assoc;     /* number of associated workstations */
} Gwsmax;
 
typedef struct{  /* length of workstation tables */
    Gint    line;     /* polyline tables */
    Gint    mark;     /* polymarker tables */
    Gint    text;     /* text tables */
    Gint    fill;     /* fill area tables */
    Gint    pat;      /* pattern tables */
    Gint    colour;   /* colour tables */
} Gwstables;
 
typedef struct{  /* workstation transformation information */
    Gwstus    wstus;     /* workstation transformation update state */
    Gtran   request;     /* requested transformation */
    Gtran   current;     /* current transformation */
} Gwsti;

/*
 * Chromatics GKS structure extensions
 */

/* connection types between the host and the CX */
#define CXITTY	0	/* packed serial interface (not avail) */
#define CXIDMA	1	/* DMA interface */
#define CXINET	2	/* tcp network interface */
#define CXIRTTY 3	/* unpacked tty (not avail) */
#define CXISIM  4	/* simulation (i/o to DR11 socket)*/
#define CXITEST 5	/* debug test (printf)*/
#define CXIMAX  5	/* last legal connection */

/*
 * Definitions of trace flags
 */

#define GDBCTL 0x0001
#define GDBOUT 0x0002
#define GDBATT 0x0004
#define GDBINP 0x0008
#define GDBSEG 0x0010
#define GDBINQ 0x0020
#define GDBMET 0x0040
#define GDBXFM 0x0080
#define GDBUTL 0x0100
#define GDBESC 0x0200
#define GDBINT 0x0400
#define GDBALL 0xfbff

/* standard scan tables */
#define GCXS1280	0
#define GCXS1280X	1
#define GCXS640		2

/* cxsvpp priority definitions */

#define GCXHIGHER	0
#define GCXLOWER	1
#define GCXBURY		2
#define GCXUNBURY	3

/* cxtmde definitions */
#define GLINETYPE   0x01
#define GMARKERTYPE 0x02
#define GHATCHTYPE  0x04

/* Escape structures */

typedef enum {   /* type definition mode */
	GUNSHARED,
	GSHARED
} Gtypemode;

#define CXSLOTS 21
typedef struct
	{
	Gint	xres;			/* max X resolution */
	Gint	yres;			/* max Y resolution */
	Gint	iopmem;			/* IOP memory size in bytes*/
	Gint	dlmmem;			/* Display List Memory size in bytes */
	Gint	bmm[4];			/* Bit Mapped Memory planes per head1 */
	Gint	ovly[4];		/* BMM overlay planes per head*/
	Gint	frameg;			/* head fields */
	Gint	hvghd;			/* HVG head assignments */
	Gint	panelsw; 		/* IOP panel/board switches */
	Gint	optmask;		/* option mask (1-installed) */
	Gint	promrel;		/* IOP EPROM release */
	Gint	fwrel;			/* Boot Firmware release */
	Gint	testmsk;		/* bit test mask (failure if bit = 1) */
	Gint	model;			/* model code */
	Gint	xxx[7];			/* reserved */
	Gint	slotnum;		/* number of slots (max of 21) */
	Gint	typerev[CXSLOTS];	/* slot type and revision code */
} Gcxhw;

typedef struct {
	Gshort ldi;
	Gshort low;	   /* low range of trigger value */
	Gshort hi;     /* hi range of trigger value */
	Gshort base;
} Gcxtrigger;

typedef enum {
	GPN_NORM=0,
	GPN_CONT
	} Gpmode;

typedef struct {
	Glnattr ln;
	Gint curnum;	/* locator cursor number */
	Gint wkid;		/* navigation workstation id */
	Gfloat scale;	/* dc -> ndc scale factor */
	Gfloat up;		/* mult factor when zooming up */
	Gfloat down;	/* mult factor when zooming down */
	Gfloat zmax;	/* maximum zoom limit trigger */
	Gfloat zmin;	/* minimum zoom limit trigger */
	Gfloat maxzmax;	/* RED maximum zoom limit */
	Gfloat maxzmin;	/* RED minimum zoom limit */
	Glimit wdw;		/* pan area (ndc) trigger */
	Glimit maxwdw;	/* RED pan area (ndc) */
	Glimit navarea;	/* nav area (ndc) */
	Gint bgci;		/* echo area bg color */
	Gpmode mode;	/* GPN_NORM or GPN_CONT */
	} Gpanpet0001;

typedef union{
	Gpanpet0001 panpet1_datarec;
	} Gpanrec;

typedef struct{
    Glimit  area;	    /* pan area (ndc) */
	Gptrig	status;		/* limit trigger status */
} Gpan;

typedef struct{  /* locator state */
    Gimode    mode;    /* mode */
    Gesw      esw;     /* echo switch */
    Gloc      loc;     /* locator data */
    Gint      pet;     /* prompt and echo type */
    Glimit    e_area;  /* echo area */
    Gpanrec   record;  /* locator data record */
} Gpanst;

typedef struct{  /* request pan */
    Gpnstat   status;    /* input status */
    Gpan      pan;       /* pan data */
} Gqpan;

typedef struct { /* CX memory statistics */
	Gint heapsize;	/* total heap size */
	Gint heapfree;	/* total heap free */
	Gint heapmem;	/* largest contiguous free space in heap */
	Gint segavail;	/* total segment memory */
	Gint segfree;	/* free segment memory */
	Gint segmem;	/* largest available */
} Gcxmem;

typedef struct {
	Gint left_edge;	/* border extension */
	Gint right_edge;
	Gint bottom_edge;
	Gint top_edge;
} Gbdrlim;

/* definitions for filesys option */

#define CXHDREAD    1
#define CXHDWRITE   2
#define CXHDEDIT    3
#define HDNAMESIZE	16		/* number of characters in filenames */

typedef struct {
	Gint	 size;		/* size of file in bytes */
	Gint	 start;		/* number of first block on disk */
	Gint	 blocks;	/* count of blocks used on disk */
	Gint	 date;		/* time of last write */
	Gchar	 filename[HDNAMESIZE];
} Ghdfile;

typedef struct {
	Gint	 count; 	/* number returned */
	Ghdfile *files; 	/* list of files */
} Ghdlist;

typedef struct {
	Gchar	 filename[HDNAMESIZE];
	Gint	 size;		/* size of file in bytes */
	Gint	 date;		/* time of last write */
} Gtpfile;

typedef struct {
	Gint	 count; 	/* number returned */
	Gtpfile *files; 	/* list of files */
} Gtplist;
