	cpu Z8601
	page 0
	include stddefZ8.inc

;********************************************************************
; 
;              Apple 5MB ProFile - Z8 diag firmware
;                         Version D3.11
;            original code (c) by Apple Computer Inc., 1981
;
;           disassembly and comments by Patrick Schfer, 2013
;                      last changes 2014-01-23 PS
;
;********************************************************************


ROMsize		SET 2048
DontListIncls	SET 1				; set to skip listing for .inc

VersionHi	SET 003h
VersionLo	SET 011h



	include DefsProFile5LLF.inc

	org 00000h
 		DB 000h, 09Eh, 001h, 001h 
	
; step motor: 2 bipolar phases connected to P0.4..P0.7
; it takes two steps from one track to the next one
StepVal		DB 050h,040h,060h,020h		; sw, w, nw, n directions
		DB 0A0h,080h,090h,010h		; ne, e, se, s directions

;
;********************************************************************
;  This is the Reset entry point
;********************************************************************
;
Start		clr IMR				; disable all interrupts
		ei     
		di     
		ld P01M,#016h			; P1,P0L = A8..11, P0H = output
		ld SPL,#Stack_Top		; stack starts at 080h  
		srp #WorkingRegs		; select register bank 4
	assume RP:WorkingRegs
		ld R0,#0FFh
		ld P2,R0			; set all bits of P2 high
		ld R1,#7
ClrLoop1	ld ActCyl-1(R1),R0		; set 011..017h to 0FFh
		djnz R1,ClrLoop1
		ld R2,#11
ClrLoop2	ld Status1-1(R2),R1		; set 006..00Fh to 000h
		djnz R2,ClrLoop2
 		ld ActCyl,#180			; far away from cylinder 0
		ld RAM_MSB,#RAM/256
		clr HeaderBufLSB
 		ld P2M,#007h			; P2.7..P2.3 output, P2.2..P2.0 input
		ld P3,#WRTSM			; set WRTSM, clear HS0, HS1, RDHDR
 		ld P3M,#001h			; port 2 push-pull, P3H output, P3L input
		call InitCTC			; initialize i8253 counter
		inc PwrFlg0			; check for cold start
		jr nz,SpinUpDly			; PwrFlg0 <> 0FFh -> power on!
		dec PwrFlg1			; PwrFlg1 <> 001h -> power on!
		jr nz,SpinUpDly
		ld Status2,#Power_Reset
		jr WarmStart
; wait 18 s for the spindle motor
SpinUpDly	ld R0,#105
SpinUpLoop	call WaitR12ms
		djnz R0,SpinUpLoop
;
;********************************************************************
; and here we go...
;********************************************************************
;
WarmStart	clr Cylinder			; seek to track 0
		call Seek1
WarmStart1	ld PwrFlg0,#0FFh		; set warm start flags
		ld PwrFlg1,#001h
		ld SPL,#Stack_Top		; dump stack
WarmStart2	ld R14,#1			; 01 means waiting for command
		call DoHandshake		; wait for host to assert /CMD
;
; *** we end up here after successful 01 - 55 handshake ***
; get command bytes from host
GetHostCmd	ld R0,#HostCmdBuffer/256
		ld R1,#HostCmdBuffer#256
		call SetRAMforHost		; set RAM adress to HostCmdBuffer
		and P2,#0FFh-DRW_Read-Msel0-Msel1-BSY	; Apple --> Mem & set BSY
 		call WaitCmdLine		; wait for host to dma in command bytes and assert /CMD
 		call RAMtoZ8			; set Mem --> Z8
		ld R15,#HostCommand		; copy them into 022h..026h
		call CopyHostCmd
		ld ActSector,Sector
		cp HostCommand,#011h		; invalid command (>11h)?
		jr ugt,WarmStart2		;  yes --> abort
; process host command
		ld R14,HostCommand
		inc R14
		inc R14				; generate response byte
		call SetResponse		; and send it to host
		and Status1,#Stat_Seek_Err	; clear everything but seek error	
		clr Status4			; zero number of errors
		ld R2,#CommandTable/256
		ld R3,#CommandTable#256
		rl HostCommand
		add R3,HostCommand		; point to command vector
		ldc R10,@RR2			; get MSB of command address
		inc R3
		ldc R11,@RR2			; get LSB
		jp @RR10			; and go there
;
; these are ProFile's debug commands
CommandTable	DW HostCmdRead		; 00 READ
		DW HostCmdWrite		; 01 WRITE
		DW HostCmdWrite		; 02 WRITE/VERIFY
		DW HostCmdFormat	; 03 FORMAT
		DW HostCmdScan		; 04 SCAN
		DW HostCmdInit		; 05 INIT SPARE TABLE
		DW HostCmdReadReg	; 06 READ REGISTER
		DW HostCmdWriteReg 	; 07 WRITE REGISTER
		DW HostCmdReadRAM	; 08 READ RAM
		DW HostCmdWriteRAM	; 09 WRITE RAM
		DW HostCmdLoopS		; 0A LOOP ON FORMAT SECTOR MARKS
		DW HostCmdLoopH		; 0B LOOP ON FORMAT HEADERS
		DW HostCmdLoopD		; 0C LOOP ON FORMAT DATA FIELDS
		DW HostCmdReadHdr	; 0D READ HEADER
		DW HostCmdLoopSH	; 0E LOOP ON FORMAT SECTOR MARKS AND HEADERS
		DW HostCmdLoopSHD	; 0F LOOP ON FORMAT SM, HEADERS AND DATA 
		DW HostCmdStepMot	; 10 TURN OFF STEPPER
; 
;********************************************************************
; *** Host Command 03: Format
; 
; Parameters:	none
; Returns:	Status4: number of potential bad blocks
;		RAM: list of bad blocks followed by FF FF FF FF
;********************************************************************
;
HostCmdFormat	clr CurStep
		call MoveStepMot1		; force step motor phase 0
		ld ActCyl,#180
		call FmtRTab_Init		; prepare result table and zero cyl/hd
		call Seek1			; go to track 0
; format one track	
Fmt_NextTrk	clr ActSector		
Fmt_NextHd	call Seek1			; move to next cylinder/head
		call Fmt_SectorMarks		; write sector marks
		call Fmt_Headers		; write headers
		call Fmt_DataFields		; set up data fields
		add ActSector,#3		; interleave
		and ActSector,#15
		inc Head			; next head
		and Head,#3
		jr nz,Fmt_NextHd		; all four done?
		inc Cylinder			;  then next cylinder
		cp Cylinder,#153		; all 153 done?
		jr nz,Fmt_NextTrk
; all done, exit
Scn_Exit	ld Cylinder,#155
		call Seek1			; park on track 155
SendFState	ld R0,#(FmtResultTab-4)/256
		ld R1,#(FmtResultTab-4)#256
		jp SendState1
; 
;********************************************************************
; *** Host Command 10: Turn off stepper
;
; Parameters:	none
; Returns:	nothing
;********************************************************************
;
HostCmdStepMot	clr P0				; turn off stepper
		jr SendFState			; and exit
; 
;********************************************************************
; *** Host Command 04: Scan
;
; Parameters:	none
; Returns:	Status4: number of potential bad blocks
;		RAM: list of bad blocks followed by FF FF FF FF
;********************************************************************
;
HostCmdScan	call FmtRTab_Init		; prepare result table and zero cyl/hd
; scan one track
Scn_Next	call Seek
		add R5,#10
		tm Status1,#Stat_Seek_Err	; seek error?
		jr z,HostCmdScn1		;  no -->
		call WaitSctrPulse
		sub R5,#3
HostCmdScn1	ld T1,#15
		call Wait1ms_1
		ld ActSector,R5
		and ActSector,#15
		ld R13,#2			; first do 0, A, 4, E, 8, 2, C, 6
HostCmdLp2	ld R14,#8			;     then 3, D, 7, 1, B, 5, F, 9
HostCmdLp1	and Status1,#Stat_Seek_Err	; clear everything but seek error
		call DoScan
		or Status1,RWstat		; error occurred?
		jr z,HostCmdScn2		;  no --> continue
		call FmtRTab_Enter		; otherwise record block number into FmtRTab
HostCmdScn2	add ActSector,#10
		and ActSector,#15
		ld T1,#15
		call Wait1ms_1
		djnz R14,HostCmdLp1
		sub ActSector,#3		; do second group
		and ActSector,#15
		djnz R13,HostCmdLp2
; 16 sectors done
		inc Head			; next head
		and Head,#3
		jr nz,Scn_Next			; all four done?
		inc Cylinder			;  then next cylinder
		cp Cylinder,#153		; all 153 done?
		jr nz,Scn_Next
		jr Scn_Exit			; leave via format routine
; 
;********************************************************************
; *** Host Command 05: Init spare table
;
; Parameter:	none
; Returns:	Status4: number of faulty blocks
;		RAM: list of bad blocks 
;********************************************************************
;
HostCmdInit	ld Cylinder,#77	
		ld Head,#2
Init_NextHd	call Seek			; go to spare track
		tm Status1,#Stat_Seek_Err	; seek error?
		jr z,HostCmdIn1			;  no -->
		jp SendState			;  else abort
HostCmdIn1	ld ActSector,#15
Init_NextSctr	call Copy_ID_Block		; copy spare table template into RAM
		ld R2,#0FFh
		ld R3,#100			; followed by 200 bytes 0FFh
Init_Loop1	lde @RR0,R2
		incw RR0
		lde @RR0,R2
		incw RR0
		djnz R3,Init_Loop1
		ld R0,#(WriteBuffer+ST_SpareMapEnd)/256
		ld R1,#(WriteBuffer+ST_SpareMapEnd)#256
		ld R2,#SpareSublists/256
		lde @RR0,R2			; 108E = 012h (byte 66h)
		inc R1
		ld R2,#SpareSublists#256
		lde @RR0,R2			; 108F = 08Eh (byte 67h)
		call WriteBlockCHS		; write block onto disk
		jr nc,HostCmdIn2		;  ok? -->
; here we found a faulty block
		or Status3,ActSector		; merge sector number into Status3
		ld R0,Head
		swap R0		
		and R0,#010h
		or Status3,R0			; merge in head (2->0, 3->1)
		ld R0,#050h			; store results in register 050h ff
		add R0,Status4			; calculate pointer
		ld @R0,Status3			; and store result byte
		inc Status4			; bump error counter
HostCmdIn2	dec ActSector			; next sector
		jr pl,Init_NextSctr		; all 15 done?
		inc Head			; next head
		and Head,#3
		jr nz,Init_NextHd		; both done?
; two tracks finished, exit
		ld R0,#ReadBuffer/256
		ld R1,#ReadBuffer#256
		ld R2,#050h
		ld R3,#32
Init_Loop2	ldei @RR0,@R2			; copy results into ReadBuffer
		djnz R3,Init_Loop2
		ld Cylinder,#155		
		call Seek1			; park on track 155
		jr SendState
; 
;********************************************************************
; *** Host Command 01/02: Write / WriteVerify
;
; Parameter:	cylinder/head/sector
;		RAM: user data
; Returns:	Status
;********************************************************************
;
HostCmdWrite	cp Cylinder,#155		; valid cylinder?
		jr ule,HostCmdWrt1		;  yes --> continue
		or Status2,#Illegal_Track
		jr SendState
HostCmdWrt1	and Head,#3			; clip head
		and ActSector,#15		;  and sector
		call Seek			;  and go there
		ld R0,#WriteBuffer/256
		ld R1,#WriteBuffer#256
		call SetRAMforHost
		and P2,#0FFh-DRW_Read-BSY	; clear P2.7, set BSY
		ld R14,#6			; 06 means write confirmation
		call DoHandshake		; wait for host to assert /CMD
; 
; *** now the host DMAs his data into the write buffer... ***
; we end up here after successful 01 - 55 handshake
		call WriteBlockCHS		; do actual write operation
		jr SendState
; 
;********************************************************************
; *** Host Command 00: Read
;
; Parameter:	cylinder/head/sector
; Returns:	Status
;		RAM: user data
;********************************************************************
;
HostCmdRead	cp Cylinder,#0FFh		; spare table?
		jr nz,HostCmdRd1		;  no -->
		call Copy_ID_Block		; get spare table template
		ld R1,#(WriteBuffer+ST_FwRev)#256	
		ld R2,#0D0h+VersionHi		; insert FW revision MSB
		lde @RR0,R2	
		ld R1,#(WriteBuffer-4)#256
		jr SendState1
; regular data blocks	
HostCmdRd1	cp Cylinder,#155		; valid cylinder?
		jr ule,HostCmdRd2		;  yes --> continue
		or Status2,#Illegal_Track
		jr SendState
HostCmdRd2	and Head,#3			; clip head
		and ActSector,#15		;  and sector
		call Seek			;  and go there
		call DoRead			; do actual read operation
		or Status1,RWstat
;
; copy status bytes into ReadBuffer
;
SendState	ld R0,#(ReadBuffer-4)/256
		ld R1,#(ReadBuffer-4)#256
		ld P3,P3Mask2
		or P2,#MSel0+MSel1		; Z8 --> Mem
		ld P01M,#016h			; connect bus
		or P2,#DRW_Read+DSTART		; stop state machine
		and P0,#0FFh-PreComp
;
; copy status bytes into RAM buffer at RR0 and prepare for DMA 
;
SendState1	ld R2,#Status1
		ld R3,#4			; lenght 4 bytes
SendSt_Lp	ldei @RR0,@R2			; copy status bytes into buffer
		djnz R3,SendSt_Lp
		sub R1,#4			; set RAM pointer back to buffer start
;
; give control to host with DMA pointer at RR0
;
SendState2	call SetRAMforHost
		and P2,#0FFh-BSY		; set BSY
; *** now the host may pick up his status bytes ***
		clr Status2
		jp WarmStart1
;
;
; *** copy ID block (spare table constants) into WriteBuffer
;
Copy_ID_Block	ld R0,#WriteBuffer/256
		ld R1,#WriteBuffer#256
		ld R2,#ID_Block/256
		ld R3,#ID_Block#256
		ld R4,#26			; 26 bytes
Copy_ID_Loop	ldc R5,@RR2
		lde @RR0,R5
		incw RR0
		incw RR2
		djnz R4,Copy_ID_Loop
		ret    
; 
;********************************************************************
; *** Host Command 06: Read registers
;
; Parameter:	first register to be read
; Returns:	RAM: selected register and all following ones
;
; There is a bug -- the parameter is ignored. The RAM buffer always 
; starts at register 0.
;********************************************************************
;
HostCmdReadReg	push 07Ch			; backup last four registers
		push 07Dh
		push 07Eh
		push 07Fh
		clr 07Dh			; point R13 to first register
		ld 07Eh,#ReadBuffer/256		; point RR14 to RAM buffer
		ld 07Fh,#ReadBuffer#256
		ld 07Ch,#07Ch			; copy 124 bytes
		srp #070h
	assume RP:070h
HostCmdRRegLp1	ldei @RR14,@R13
		djnz R12,HostCmdRRegLp1		; copy registers into RAM buffer
		srp #WorkingRegs
	assume RP:WorkingRegs
		ld R0,07Eh			; ex RR14 into RR0
		ld R1,07Fh
		pop 07Fh			; restore regs
		pop 07Eh
		pop 07Dh
		pop 07Ch
		ld R2,#07Ch
		ld R3,#4			; copy last four bytes into RAM
HostCmdRRegLp2	ldei @RR0,@R2
		djnz R3,HostCmdRRegLp2
		ld R2,#0F0h
		ld R3,#16			; then copy SFRs
HostCmdRRegLp3	ldei @RR0,@R2
		djnz R3,HostCmdRRegLp3
		push Cylinder			; get number of requested register
		and Cylinder,#0F0h
		cp Cylinder,#0F0h		; SFR?
		pop Cylinder
		jr nz,HostCmdRReg1		;  no -->
		sub Cylinder,#070h		;  else adjust for position in RAM
HostCmdRReg1	ld R0,#ReadBuffer/256	
		ld R1,#ReadBuffer#256	
		add R1,Cylinder			; point RR0 to register in RAM
		jp SendState			; !!! this should have been SendState2
; 
;********************************************************************
; *** Host Command 07: Write register
;
; Parameter:	register, value
; Returns:	nothing
;********************************************************************
;
HostCmdWriteReg	ld R0,Cylinder			; register number
		ld R1,Head			; value
		ld 0(R0),R1
		ld R0,#RAM/256			; set DMA pointer to first RAM address
		clr R1
SendState2a	jr SendState2			; return 'status' is RAM
; 
;********************************************************************
; *** Host Command 08: Read RAM
;
; Parameter:	first RAM address to be read
; Returns:	RAM: selected RAM address and all following ones
;********************************************************************
;
HostCmdReadRAM	ld R0,Cylinder			; set DMA pointer to given address
		ld R1,Head
		jr SendState2a			; return 'status' is RAM
; 
;********************************************************************
; *** Host Command 09: Write RAM
;
; Parameter:	first register to be written
;		RAM: user data (dma in 1..532 bytes)
; Returns:	nothing
;********************************************************************
;
HostCmdWriteRAM	ld R0,Cylinder			; set DMA pointer to given address
		ld R1,Head
		call SetRAMforHost
		and P2,#0FFh-DRW_Read-BSY
		ld R14,#6			; 06 means write confirmation
		call DoHandshake		; wait for host to assert /CMD
; 
; now the host DMAs his data into the write buffer...
; we end up here after successful 01 - 55 handshake
		jr SendState2a			; return 'status' is curren RAM address
; 
;********************************************************************
; *** Host Command 0A: Loop on format sector marks
;
; Parameter:	none
; Returns:	nothing
; 
; start any other command to abort
;********************************************************************
;
HostCmdLoopS	call HostCmdLp_Seek
HostCmdLpS_Lp	call Fmt_SectorMarks
		tm P2,#CMD			; loop until CMD asserted
		jr z,HostCmdLpS_Lp
		clr MaskSctrErr			; enable sector errors
		jr WarmStart1b
; 
;********************************************************************
; *** Host Command 0B: Loop on format headers
;
; Parameter:	none
; Returns:	nothing
; 
; start any other command to abort
;********************************************************************
;
HostCmdLoopH	call HostCmdLp_Seek
HostCmdLpH_Lp	call Fmt_Headers
		tm P2,#CMD			; loop until CMD asserted
		jr z,HostCmdLpH_Lp
		clr MaskSctrErr			; enable sector errors
		jr WarmStart1b
; 
;********************************************************************
; *** Host Command 0C: Loop on format data fields
;
; Parameter:	none
; Returns:	nothing
; 
; start any other command to abort
;********************************************************************
;
HostCmdLoopD	call HostCmdLp_Seek
HostCmdLpD_Lp	call Fmt_DataFields
		tm P2,#CMD			; loop until CMD asserted
		jr z,HostCmdLpD_Lp
		clr MaskSctrErr			; enable sector errors
WarmStart1b	jr WarmStart1a
; 
;********************************************************************
; *** Host Command 0D: Read header
;
; Parameter:	cylinder/head/sector/retry count
; Returns:	RAM: Status1 + header + user data
; 
; Retry count = 000h: test loops infinite until next command
;   ProFile does not get busy.
; Retry count = 081h, 0C1h, 0E1h, 0F1h, 0F9h, 0FDh, 0FFh:
;   test is done 1..7x, then result is transferred to host
;********************************************************************
;
HostCmdReadHdr	dec RetryCnt
		jr pl,HostCmdRH1		; loop test?
		and P2,#0FFh-BSY		;  no, assert BSY
HostCmdRH1	cp Cylinder,#153		; valid cylinder?
		jr c,HostCmdRH2			;  yes -->
		clr Cylinder			;  else use cylinder 0
HostCmdRH2	and Head,#3			; clip head
		call Seek
		ld RAM_MSB,#RAM/256		; point to first RAM address
		clr HeaderBufLSB
; now repeat the following 1..7x or until /CMD goes low
HostCmdRH_Next	tm P2,#CMD
		jr nz,WarmStart1a		; abort on CMD set
		ld R13,Sector
		call WaitIdxPulse		; wait for index
HostCmdRH4	djnz R13,HostCmdRH3		; skip unwanted sectors
		call WaitSctrPulse
		call LoadCTCforRd
		ld P3,P3Mask1
		call ReadHeader			; do actual read operation
		or Status1,RWstat
		and P3,#0FFh-RDHDR
		rl RetryCnt			; left shift RetryCnt
		jr c,HostCmdRH_Next		;  retry if bit 7 was 1
; done or aborted -- exit
HostCmdRH_Done	ld R0,#RAM/256
		ld R1,#RAM#256
		ld R2,Status1
		lde @RR0,R2			; write status into first buffer location
		jp SendState2
;
HostCmdRH3	call WaitSctrPulse		; wait for next sector
		jr HostCmdRH4
; 
;********************************************************************
; *** Host Command 0E: Loop on format sector marks and headers
;
; Parameter:	none
; Returns:	nothing
; 
; start any other command to abort
;********************************************************************
;
HostCmdLoopSH	call HostCmdLp_Seek
HostCmdLpSH_Lp	call Fmt_SectorMarks
		call Fmt_Headers
		tm P2,#CMD			; loop until CMD asserted
		jr z,HostCmdLpSH_Lp
		clr MaskSctrErr			; enable sector errors
WarmStart1a	jp WarmStart1
;
;
; *** do range check and seek to requested CHS (for host LoopOn commands)
;
HostCmdLp_Seek	cp Cylinder,#155		; valid cylinder?
		jr ule,HostCmdLp_Sk1		;  yes -->
		ld Cylinder,#155		;  otherwise clip to highest cylinder
HostCmdLp_Sk1	and Head,#3 			; clip head and sector values
		and ActSector,#15
		and P2,#0FFh-BSY		; assert BSY
		ld MaskSctrErr,#0FFh		; ignore sector errors
		jp Seek1
; 
;********************************************************************
; *** Host Command 0F: Loop on format sector marks, headers and data
;
; Parameter:	none
; Returns:	nothing
; 
; start any other command to abort
;********************************************************************
;
HostCmdLoopSHD	call HostCmdLp_Seek
HostCmdLpSD_Lp	call Fmt_SectorMarks
		call Fmt_Headers
		call Fmt_DataFields
		tm P2,#CMD			; loop until CMD asserted
		jr z,HostCmdLpSD_Lp
		clr MaskSctrErr			; enable sector errors
		jr WarmStart1a
;
;
; *** enter current block number into FmtResultTab
;
FmtRTab_Enter	ld R0,#FmtResultTab/256
		ld R1,Status4			; number of bad block
		cp Status4,#255			; stop at 255
		jr z,FmtRTab_Exit
		cp Status4,#32			; more than 32 faults?
		jr nc,FmtRTab_Exit1		; skip detailed reporting
; enter bad block + Status1
		rl R1
		rl R1
		add R1,#FmtResultTab#256	; calculate table address
		ld R2,#ActCyl
		ldei @RR0,@R2			; ActCyl
		ldei @RR0,@R2			; ActHead 
		ldei @RR0,@R2			; ActSector 
		ld R2,#Status1
		ldei @RR0,@R2			; Status1
; write end mark (FF FF FF FF) into RAM buffer
FmtRTab_WrEnd	ld R3,#4			; set four bytes
		ld R2,#0FFh			;  to 0FFh
FmtRTab_WE1	lde @RR0,R2
		incw RR0
		djnz R3,FmtRTab_WE1
FmtRTab_Exit1	inc Status4			; bump number of faults
FmtRTab_Exit	ret    
;
; *** prepare format/scan result table 
;
FmtRTab_Init	ld R0,#FmtResultTab/256		; point to start of result buffer
		ld R1,#FmtResultTab#256
		clr Cylinder
		clr Head
		dec Status4
		jr FmtRTab_WrEnd		; and write end mark
;
;
; *** setup data fields, i.e. fill 16 sectors with a D6B9 pattern
; Ignore any write errors if MaskSctrErr = 0FFh, otherwise record bad 
; blocks into FmtRTab.
;
Fmt_DataFields	ld R5,#2
		ld R0,#WriteBuffer/256
		ld R1,#WriteBuffer#256
		ld R2,#0D6h			; fill pattern
		ld R3,#0B9h
		clr R4				; fill 2x 256 bytes
FmtDF_Loop	ld R6,#WorkingRegs+2		; (this is R2)
		ldei @RR0,@R6			; copy R2 contents into WriteBuffer
		ldei @RR0,@R6			; copy R3 contents into WriteBuffer
		djnz R4,FmtDF_Loop
		ld R4,#16			; fill 2x 16 bytes
		djnz R5,FmtDF_Loop
; write 16 blocks
		ld R14,#16			; fill 16 sectors
FmtDF2		and Status1,#0FFh-Stat_No_Hdr	; clear header error
		call DoWrite			; and write data to disk
		tm MaskSctrErr,#0FFh		; shall we ignore errors?
		jr nz,FmtDF1			;  yes --> skip
		or Status1,RWstat		; was there an error?
		jr nc,FmtDF1			;  no --> skip
		call FmtRTab_Enter		; otherwise record block number into FmtRTab 
FmtDF1		inc ActSector			; next sector
		and ActSector,#15
		djnz R14,FmtDF2			; all done?
		ret 
;
;
; *** fill the current track with zeroes and write 16 sector marks onto it
;
Fmt_SectorMarks	ld R0,#FMTEN/256
		ld R1,#FMTEN#256
		ld P3,P3Mask2
		and P2,#0FFh-DRW_Read-Msel0	; Mem --> State Machine (Disk)
		lde @RR0,R2			; dummy write to open write gate (if jumper closed)
; now the disk spins while a continuous 0 is applied -- this erases the track
		ld P01M,#01Ch			; tristate bus lines (P1)
		and P0,#0FFh-PreComp
		cp ActCyl,#128
		jr c,FmtSM1
		or P0,#PreComp			; enable precompensation above track 128
FmtSM1		ld R0,#16			; 16 sector marks to be written
		ld R1,#211			; (delay between index and first sector)
		call WaitIdxPulse		; wait for index
		call WaitIdxPulse		; wait another revolution
; now write 16 sector marks
FmtSM2		djnz R1,FmtSM2			; wait some more		
		ld R1,#209
		ld R2,#3			; (20s duration of sector mark)
		and P3,#0FFh-WRTSM		; begin sector mark...
FmtSM3		djnz R2,FmtSM3			;  ...wait...
		or P3,#WRTSM			;  ... done.
		djnz R0,FmtSM2			; next one
; done, exit
		ld P01M,#016h			; reconnect bus
		or P2,#DRW_Read+Msel1+Msel0	; Z8 --> Mem
		ret    
;
;
; *** write a header after each sector mark
;
Fmt_Headers	ld R0,#RAM/256
		ld R1,#RAM#256
		ld R3,#0
		ld R9,#22			; zero first 22 bytes in buffer
FmtHdr1		lde @RR0,R3
		incw RR0
		djnz r9,FmtHdr1
		ld R3,#1
		lde @RR0,R3			; 1017h = 001h
		incw RR0
		call BuildWrtHdr		; build header template for first sector
		and P2,#0FFh-Msel1		; Z8 --> Timer 
		ld R1,#3			; i8253 control register
		ld R2,#030h			; counter 0 mode 0 (16 bit count)
		ld R3,#070h			; counter 1 mode 0 (16 bit count)
		ld P01M,#036h			; select slow memory timing 
		lde @RR0,R2
		lde @RR0,R3
		ld R1,#0
		clr FLAGS			; clear user flag for extra loop
		ld P3,P3Mask1
		ld R10,#16			; 16 headers to be written
		call WaitIdxPulse		; wait for index 
; now write a header after each sector mark
		ld R9,#32
FmtHdr2		djnz R9,FmtHdr2			; wait some more time
		tm FLAGS,#1			; first loop run?
		jr nz,FmtHdr3			;  no --> execute extra code
FmtHdr7		and P2,#0FFh-DRW_Read-DSTART 	; start state machine
		or P2,#Msel1+Msel0
		and P2,#0FFh-MSel0		; Mem --> State Machine (Disk)
		lde @RR0,R2			
		ld P01M,#01Ch			; tristate bus lines
		and P0,#0FFh-PreComp
		cp ActCyl,#128
		jr c,FmtHdr4
		or P0,#PreComp			; enable precompensation above track 128
FmtHdr4		call WaitSctrPulse		; wait for sector mark
		jr z,FmtHdr_Failed		; timeout?
		or FLAGS,#1			; the next one is not the first header anymore
		ld R9,#32
		jr FmtHdr2			; and do next run
; prepare for next header to be written
FmtHdr3		or P2,#Msel1+Msel0		; Z8 --> Mem
		and P0,#0F0h
		ld P01M,#016h			; back to fast memory timing
		or P2,#DRW_Read+DSTART 		; stop state machine
		ld R1,#(RAM+26)#256
		ld R0,RAM_MSB
		inc ActSector			; adjust header template for next sector
		and ActSector,#15
		ld R7,ActSector
		ld R8,ActSector
		com R8
		lde @RR0,R7			; sector in 101Ah
		add R1,#3
		lde @RR0,R8			; complemented sector in 101Dh
		ld R1,#0
		ld R11,#3			; check for 3 sector marks
		ld R9,#213
FmtHdr5		nop   				; wait some time
		djnz R9,FmtHdr5
; now wait for three sector pulses. Abort on timeout.
FmtHdr6		call WaitSctrPulse		; wait for sector mark
		jr z,FmtHdr_Failed		;  abort on timeout
		djnz R11,FmtHdr6
		djnz R10,FmtHdr7		; ok, go back to main loop
; all done. Now restore the CTC registers and exit
		ld P3,P3Mask2
;
; initialize i8253 counter (one shot mode: a L->H transition at gate starts the pulse)
InitCTC		ld R1,#003h			; control register at 0FF03h
		ld R3,#032h			; counter 0 mode 1 (one shot 16 bit)
		ld R4,#072h			; counter 1 mode 1 (one shot 16 bit)
		ld R5,#092h			; counter 2 mode 1 (one shot 8 bit)
		ld P01M,#036h			; set slow memory timing
		and P2,#0FFh-Msel1  		; select Z8 --> Timer 
		lde @RR0,R3
		lde @RR0,R4
		lde @RR0,R5
		jp RAMtoZ8a
;
FmtHdr_Failed	rl MaskSctrErr			; shall we report errors?
		jr c,Ret_2			;  nope, exit
		or Status1,#Stat_NoSect		; otherwise set sector mark timeout flag
		jp SendState
;
; ***** spare table template *****
;
ID_Block	DB "PROFILE      "
		DB 000h, 000h, 000h
		DB 0D0h, VersionLo
		DB 000h, 026h, 000h
		DW 00214h
		DB 020h, 000h, 000h
;
; ***** do handshake with host *****
; profile waits for CMD to go active, then puts (R14) onto data bus
; after CMD went inactive again, 55h is expected as ACK
;	
DoHandshake	call WaitCmdLine		; wait for CMD
SetResponse	or P2,#Msel0+Msel1    		; Z8 --> Mem
		ld P01M,#006h	 		; set P1 as output
		ld P1,R14			; and send response to host
		or P2,#BSY	   		; clear BSY
DoHsk_Wait	tm P2,#CMD
		jr nz,DoHsk_Wait		; wait until CMD line goes low
		ld P01M,#00Eh			; set P1 as input
		and P2,#0FFh-Msel0-Msel1  	; Apple --> Mem
		and P2,#0FFh-Msel0-Msel1-DRW_Read
		ld R0,P1			; get answer from host
		call RAMtoZ8			; Mem --> Z8
		cp R0,#055h			; ACK?
		jr z,Ret_2			; ok, finished
		or Status1,#Bad_55		; record NAK in status byte
		jp SendState
;
; ***** wait for host /CMD *****
; this routine waits until CMD (P2.2) is pulled high by the host
;
WaitCmdLine	ld P01M,#01Ch			; tristate bus lines
WaitCmdLineLp	tm P2,#CMD			; did host pull CMD high?
		jr z,WaitCmdLineLp
Ret_2		ret  
;
;********************************************************************
; store WriteBuffer into current Cylinder/Head/Sector
; read back and compare if HostCommand = 2
; exit with Carry set if failed
;********************************************************************
;
WriteBlockCHS	clr Status3
		call DoWrite			; perform actual write operation
		or Status1,RWstat		; merge result into Status1
		jr c,Ret_2			; write fault --> exit
		cp HostCommand,#2		; simple write?
		jr z,Ret_2			; yes --> exit
; verify the block we just have written
		ld R12,#10
		call WaitR12ms			; wait 10ms
		ld RAM_MSB,#AuxBuffer/256	; build header for readback at 1240h
		ld HeaderBufLSB,#AuxBuffer#256	;  and store data at 1254h ff.
		or Status3,#ReadTimeout		; set read timeout bit	
		call DoRead1			; read back our data
		or Status1,RWstat		; merge result into Status1
		call RdErrCRC			; and set CRC bit if read error
		jr c,Ret_2			; read fault --> exit
; now compare the data we read back with the bytes we got from the host
		ld R0,#WriteBuffer/256		; original data from host
		ld R1,#WriteBuffer#256
		ld R2,#(AuxBuffer+20)/256	; data just read back from disk
		ld R3,#(AuxBuffer+20)#256
		ld R4,#428/256			; sorry, we can compare only the first 
		ld R5,#428#256			;  428 bytes -- there is not enought RAM !
		or Status3,#DataCompare		; set data mismatch bit
WB_CHS_CmpLp1	lde R6,@RR0
		lde R7,@RR2
		incw RR0
		incw RR2
		cp R6,R7			; now compare each byte
		jr nz,WB_CHS_VfyErr		; exit on mismatch
		decw RR4
		jr nz,WB_CHS_CmpLp1
		and Status3,#0FFh-ReadCRC-DataCompare	; clear error flags
; copy the last 104 bytes host data to end of RAM
		ld R0,#(WriteBuffer+428)/256	; original data from host
		ld R1,#(WriteBuffer+428)#256
		ld R2,#(01400h-532+428)/256	
		ld R3,#(01400h-532+428)#256
		ld R4,#104
WB_CHS_CmpLp2	lde R5,@RR0
		lde @RR2,R5
		incw RR0
		incw RR2
		djnz R4,WB_CHS_CmpLp2
; read the block a second time
		call DoRead			; read back our data
		or Status1,RWstat		; merge result into Status1
		call RdErrCRC			; and set CRC bit if read error
		jr c,Ret_3			; read fault --> exit
; and compare the remaining bytes
		ld R0,#(ReadBuffer+428)/256
		ld R1,#(ReadBuffer+428)#256
		ld R2,#(01400h-532+428)/256	; moved host data
		ld R3,#(01400h-532+428)#256
		ld R4,#532-428			; now do the remaining 104 bytes
		or Status3,#DataCompare		; set data mismatch bit
WB_CHS_Cmp2	lde R6,@RR0
		lde R7,@RR2
		incw RR0
		incw RR2
		cp R6,R7			; now compare each byte
		jr z,WB_CHS_Cmp1		; ok --> next one
; verify failed, exit with C=1
WB_CHS_VfyErr	or Status1,#Stat_VfyFailed
		scf    
		ret    
; next byte to cpmpare
WB_CHS_Cmp1	djnz R4,WB_CHS_Cmp2
		clr Status3			; clear error flags
		rcf    
Ret_3		ret    
;
; copy read error (CRC) bit from RWstat into Status3
;
RdErrCRC	tm RWstat,#Stat_Rd_Err		; read error occurred?
		jr z,RdErrCRC1			;  no -->
		or Status3,#ReadCRC		;  else set CRC bit in Status3
RdErrCRC1	ret  
;
; copy host command from RAM (R0.R1) to registers (R15)
;
CopyHostCmd	ld R14,#6			; copy seven bytes
CopyHostCmdLp	ldei @R15,@RR0		
		djnz R14,CopyHostCmdLp
		ret    
;
; wait for a index pulse. timeout (Z=0) if none has arrived within 26 ms.
;
WaitIdxPulse	clr IRQ
		call SetT0_26ms
WaitIP_Loop	tm T0,#0FFh
		jr nz,WaitIdxPulse1
		or Status1,#Stat_NoIdx
		jp SendState
;
WaitIdxPulse1	tm IRQ,#1			; did a index pulse (P3.2=hi) occur?
		jr z,WaitIP_Loop
		ret    
;
; wait for a sector pulse. timeout (Z=0) if none has arrived within 26 ms.
;
WaitSctrPulse	call SetT0_26ms
		clr IRQ				;  and clear P3.1 interrupt flag
WaitSP_Loop	tm T0,#0FFh			; did timer run off?
		jr z,WaitSP_Done
		tm IRQ,#4			; did a sector pulse (P3.1=hi) occur?
		jr z,WaitSP_Loop
WaitSP_Done	ret    				; return if timer run off or sector pulse arrived
;
; wait for the state machine to finish. DiskSM_Timeout = 0FFh if timeout, Z=0 if ok.
;
WaitDiskSM	clr RWstat
;		ld R5,#6
		clr DiskSM_Timeout
WaitDSM4	call SetT0_26ms			; timeout = 6* 26ms = 156ms
WaitDSM2	tm T0,#0FFh			; timer expired?
		jr nz,WaitDSM1			;  no --> check state machine
;		rl DSM_FastTo			;  slow timeout?
;		jr nz,WaitDSM5			;   no --> fault!
;		dec R5				;   else wait again
;		jr nz,WaitDSM4
WaitDSM5	or RWstat,#Stat_No_Hdr		; report timeout error 
		dec DiskSM_Timeout
		ret    
;
WaitDSM1	ld R4,#2
WaitDSM3	tm P2,#SECTDN			; state machine finished?
		jr nz,WaitDSM2			;  no --> continue waiting
		djnz R4,WaitDSM3		;  yes, check again to be sure
		ret    
;
; setup T0 for a single 26.1 ms delay
;
SetT0_26ms	ld T0,#0FFh
		clr PRE0
		ld TMR,#00000011b		; load & start T0
		ret  
; 
; 
; *** build a header for current CHS and put it into (R0.HeaderBufLSB)
;
BuildHeader	ld R1,HeaderBufLSB 		; LSB of header address
BuildHdr1	ld R10,#1
		ld R3,#3			; complement 3 bytes
BldHdr_Lp1	ld R4,ActCyl-1(R3)		; copy 011..013h (cylinder, head, sector)
		com R4
		ld ComCyl-1(R3),R4		;  complemented into 014..016h
		djnz R3,BldHdr_Lp1
		ld R2,#7			; copy 7 bytes
		ld R15,#HeaderImage
BldHdr_Lp2	ldei @RR0,@R15			; copy 010..016 into RAM (R0.01Dh)
		djnz R2,BldHdr_Lp2
		ld R9,#9
BldHdr_Lp3	lde @RR0,R2			; clear the following 9 bytes
		inc R1
		djnz R9,BldHdr_Lp3
		ret   
; 
; set RAM address to (R0.HeaderBufLSB) and prepare RAM for disk access
;
SetRAMforDisk	ld R1,HeaderBufLSB 
		and P2,#0FFh-DSTART-Msel0	; State Machine --> Mem, start state machine
SetRAM		lde @RR0,R2			; dummy write to set RAM address to R0.R1
		ld P01M,#01Ch			; release data & address bus
		ret    
; 
; set RAM address to RR0 and prepare RAM for host access
;
SetRAMforHost	and P2,#0FFh-Msel0-Msel1	; Apple --> Mem
		jr SetRAM
;
; prepare i8253 CTC
;
LoadCTCforRd	ld R2,#551#256
		ld R3,#553#256
		ld R4,#17
LoadCTC		and P2,#0FFh-Msel1		; Z8 --> Timer
		ld R0,RAM_MSB
		ld R1,#0			; counter 0 data register
		ld R5,#551/256			; MSB is the same for all ctrs
		ld P01M,#036h			; select slow memory timing
		lde @RR0,R2			; set counter 0 = 551 (16 bit, LSB first)
		lde @RR0,R5
		inc R1
		lde @RR0,R3			; set counter 1 = 553 (16 bit, LSB first)
		lde @RR0,R5
		inc R1
		lde @RR0,R4			; set counter 2 = 17 (8 bit)
		ld P3,P3Mask2			; WRTSM + Heads
		jr RAMtoZ8a
;
;
; *** do actual read operation ***
; returns carry set when error occurred
;
DoRead		ld StatusBufLSB,#(ReadBuffer-4)#256
		ld RAM_MSB,#RAM/256
		clr HeaderBufLSB 		; read header will be built at 01000h
DoRead1		call WaitSctrPulse		; wait for sector mark
DoScan		call LoadCTCforRd		; start timers
		call BuildHeader		; build header image in RAM
ReadHeader	call SetRAMforDisk		; start state machine
		call WaitDiskSM			; and wait for its job to be done
		jr nz,ReadHdr1			; timeout --> 
		tm P3,#CRCERR			;  no, CRC fault?
		jr nz,ReadHdr1			;   no -->
		dec DiskSM_Timeout		;   else set fault flag,
		or RWstat,#Stat_Rd_Err		;   and set CRC error flag
ReadHdr1	and P3,#0FFh-RDHDR
DoWrite3	or P2,#DSTART			; stop state machine
; give RAM back to our microcontroller
RAMtoZ8		or P2,#DRW_Read
RAMtoZ8a	or P2,#Msel0+Msel1		; Z8 --> Mem
		and P0,#0F0h
		ld P01M,#016h			; reconnect bus
		rl DiskSM_Timeout		; and set carry if fault occurred
		ret    
; 
; *** write block to disk
; returns carry set when error occurred
;
DoWrite		ld StatusBufLSB,#(WriteBuffer-4)#256
		tm Status1,#Stat_Seek_Err	; did the seek fail?
		jr nz,DoWrite_Abort		;  yes --> abort
		rl SettlingReqd			; did we just move the heads?
		jr nc,DoWrite1			;  no --> continue
		clr SettlingReqd
		ld R12,#40			; else wait some time to settle
		call WaitR12ms
DoWrite1	call WaitSctrPulse		; wait for sector mark
		ld RAM_MSB,#RAM/256
		clr HeaderBufLSB 		; build write header at 01000h
		ld R2,#570#256
		ld R3,#574#256
		ld R4,#38
		call LoadCTC			; prepare i8253 for write sequence
		clr R1
		call BuildWrtHdr		; build header image in RAM
		call SetRAMforDisk		; start state machine
		and P2,#0FFh-DRW_Read
		and P0,#0FFh-PreComp
		cp ActCyl,#128
		jr c,DoWrite2
		or P0,#PreComp			; enable precomp for cylinders >128
DoWrite2	call WaitDiskSM			; wait for state machine to be finished
		jr DoWrite3			; and leave via ReadHeader
;
DoWrite_Abort	ld DiskSM_Timeout,#0FFh		; set fault flag
		jr RAMtoZ8a			; and leave
;
BuildWrtHdr	call BuildHdr1			; build regular header image
		ld R9,#22
		call BldHdr_Lp3			; zero another 22 bytes
		lde @RR0,R10			; followed by a 001h
		inc R1
		lde @RR0,R2			; followed by another 000h
		ret    
;
;
; *** Seek Routine ***
;
Seek1		and Status1,#0FFh-Stat_Seek_Err	; clear seek error
		dec MaskChkHdr			; don't check headers
; enter here for R/W seek
Seek		clr OnTrackFlg
; move heads until ActCyl = Cylinder
Seek_Loop	cp CurStep,#0			; are we at Phase 0?
		jr nz,Seek_NextStep		;  no -->
		tm P2,#Trk0			; are we on Track 0?
		jr nz,Seek_NextStep		;  no -->
		clr ActCyl			;  else syncronize ActCyl to the HDA
Seek_NextStep	cp Cylinder,ActCyl		; did we reach our destination?
		jr z,Seek_OnTrack		;  yes -->
		ld R1,#1			; seek direction forward...
		jr uge,Seek_NxtStp1
		ld R1,#-1			; ...or backwards?
Seek_NxtStp1	add SeekDir,R1			; old + new direction
		jr nz,Seek_NxtStp2		;  =0 means direction has changed!
		call Wait_22ms			;  then wait some time to settle
Seek_NxtStp2	ld SeekDir,R1			; update old direction
		add ActCyl,R1			; update actual cylinder
		call MoveStepMot		;  and move one step
		ld R12,#4
		call WaitR12ms			; wait 2.56ms
		call MoveStepMot		;  and move another step
		ld T1,#10
		ld TMR,#12			; load & start timer (8ms)
		call Wait1msLoop
		jr Seek_Loop
; now we arrived at our destination track
Seek_OnTrack	and Head,#3
		ld R0,Head
		swap R0
		or R0,#WRTSM
		ld P3Mask2,R0			; generate P3 masks: 005 = 01hh0000
		ld P3,R0			; select head
		or R0,#WRTSM+RDHDR
		ld P3Mask1,R0			; 004 = 11hh0000
		ld R12,#1
		ld R0,ActHead			; remember old head number in R0
		ld ActHead,Head			;  and update ActHead
		rl MaskChkHdr			; skip header checks?
		clr MaskChkHdr		
		jr nc,Seek_OnTrk1		;  no -->
		ld R12,#86			;  else exit via WaitR12ms
		jp WaitR12ms
; see if there was an old seek error or the heads have been moved
Seek_OnTrk1	tm Status1,#Stat_Seek_Err	; was there an old seek error?
		jr nz,Seek_OnTrk2		;  yes -->
		inc OnTrackFlg			; have the heads been moved?
		jr z,Seek_OnTrk2		;  yes -->
		cp R0,Head			; has the head changed?
		jr nz,WaitR12ms			;  yes --> wait and leave from there
		ret   				;  else leave now
; now let's read three consecutive headers within four disk revolutions
Seek_OnTrk2	clr SeekDir
		call Wait_22ms
		ld OnTrackCtr,#4*16		; four disk revolutions = 64 sectors
		ld RAM_MSB,#SeekHeaderBuf/256
		ld HeaderBufLSB,#SeekHeaderBuf#256
		call WaitSctrPulse
Seek_BadHdr	ld R13,#3			; three headers to be checked
Seek_OnTrk3	dec OnTrackCtr			; bump trial counter
		jr nz,Seek_ChkHdr		;  and check next one
		or Status1,#Stat_Seek_Err	; set seek error if counter expired
		ret   
; 
Seek_ChkHdr	ld T1,#15
		call Wait1ms_1
;		dec DSM_FastTo			; set fast state machine timeout
		call LoadCTCforRd
		ld P3,P3Mask1			; WRTSM + RDHDR + Heads
		call ReadHeader			; read next header
		clr DSM_FastTo			; restore slow timeout
		jr nz,Seek_BadHdr		; abort on fault
		inc R1
		inc R1				; RR0 = 13E2h
		ld R15,#WorkingRegs+3
		call CopyHostCmd		; copy header into R3..R8
		cp R3,#153
		jr nc,Seek_BadHdr		; cylinder out of range
		cp R5,#16
		jr nc,Seek_BadHdr		; sector out of range
		adc R6,R3
		jr nz,Seek_BadHdr		; cylinder & complement mismatch
		adc R7,R4
		jr nz,Seek_BadHdr		; head & complement mismatch
		adc R8,R5
		jr nz,Seek_BadHdr		; sector & complement mismatch
		ld ActCyl,R3
		cp ActCyl,Cylinder
		jr nz,Seek_ChkHdr1		; wrong cylinder
		cp ActHead,R4
		jr z,Seek_ChkHdr2
Seek_ChkHdr1	or Status2,#Stat_Seek		; set seek to wrong track flag
		jp Seek_Loop			;  and try again
Seek_ChkHdr2	djnz R13,Seek_OnTrk3		; decrement todo list
; done -- we successfully read three headers within four disk revolutions
		and Status1,#0FFh-Stat_Seek_Err	; clear seek error
		ret  
;
; ***** pause for 0.64 ms *****
;
Wait1ms		ld T1,#100
Wait1ms_1	ld PRE1,#012h			; use internal clock/4 (156.25kHz)
		ld TMR,#00Ch			; load & start timer
Wait1msLoop	tm T1,#0FFh
		jr nz,Wait1msLoop
		ret   
;
; ***** pause for 21.76 ms *****
;
Wait_22ms	ld R12,#34			; 34*0.64 ms = 21.76 ms
; pause for R12 * .064 ms
WaitR12ms	call Wait1ms			; wait for 0.64 ms
		djnz R12,WaitR12ms
		ret    
;
; ***** move step motor ****
;
MoveStepMot	add CurStep,R1			; R1=+->next, R1=-1->previous
		and CurStep,#7
MoveStepMot1	ld OnTrackFlg,#0FFh
		ld SettlingReqd,#0FFh
		ld R2,#StepVal/256
		ld R3,#StepVal#256
		add R3,CurStep
		ldc R4,@RR2			; get step value from table
		ld P0,R4			; and write it into both H-bridges
		ret    
 
	if $>ROMsize
		error "\aROM size exceeded !!!"
	elseif
		DB ROMsize-$ dup(0FFh)		; pad with FF's
	endif
	end
