#include	"mac.h"
#include	"mac.x"

/*
 * Main routine of the assembler
 *
 * Process options, and read in src file names
 * Src file(s) and generate intermediate code file
 * Rewind intermediate code file
 * Generate object/relocation code, if obj asked for
 * Output global symbols if obj asked for
 * Run src through a second time for listings, if asked for
 *
 */
main(argc, argv)
char *argv[];
{
	register int pid;
	register int i;
	register char *r;
/*
 * check if the program was called as 'mac'.
 * if not, use the program name as the name of the rfile
 */
	if(strncmp(argv[0],"mac",3))
	  arg[nfile++] = argv[0];	/* pgm name is rfile if not 'mac' */

/*
 * process arguments
 * flags may be from A -> z
 */
	for (i=1; i<argc; i++){
	  p = argv[i];
	  if (*p++ == '-'){
	    while(*p){
	      if((*p >='A')&&(*p <= 'z')){
	        if (*p == 'r') *option('a') = TRUE; /* rel assumes a */
		if (*p == 'l') *option('s') = TRUE; /* lst assumes s */
	        *option(*p) = TRUE;
		/*
		 * 'z' option takes next chr as numeric argument
		 */
		if (*p++ == 'z'){
		  if(*p != 0) *option('z') = (*p++)-'0';
		  else        *option('z') = 0;
		}
	      }
	      else
		fprintf(stderr,"-%c ignored\n",*p);
	    }
	  }
	  else{
	    if(nfile > MAXFILES)
	      fprintf(stderr,"Max %d files, %s ignored\n",MAXFILES,argv[i]);
	    else
	      arg[nfile++] = argv[i];
	  }
	}

/*
 *   Test all of the source files to make sure they're all there
 */
	for(i = 1; i < nfile; i++){
	  if(!(srcfil = freopen(arg[i],"r",stdin))){
	    fprintf(stderr,"Can't find %s\n",arg[i]);
	    exit(1);
	  }
	}
/*
 *   Try to open r-file.
 *   try 'file'	first, and if that fails,
 *   try '/usr/lib/mac/file'.
 */
	for (i=0; i<13;	i++)
	  srcbuf[i] ="/usr/lib/mac/"[i];

	if(nfile < 2){
	  if(!strncmp(argv[0],"mac",3))
	    fprintf(stderr,"Usage: mac <-opts> rfile src src ..\n");
	  else
	    fprintf(stderr,"Usage: %s <-opts> src src ..\n",argv[0]);
	  exit(1);
	}
	r = arg[0];			/* rfile always 1st arg */
	for (i=13; *r != '\0'; i++)
	  srcbuf[i] = *r++;

 	rfile = open(&srcbuf[0], 0);	/* check library */
	if (rfile < 0)
	  rfile = open(&srcbuf[13], 0);	/* then try cur dir */
	if (rfile < 0)  {
	  fprintf(stderr,"Can't open r-file %s\n",&srcbuf[13]);
	  exit(1);
	}

	initbl(arg[0]);		/* initialize parse table */
	close(rfile);

/*
 *   Make temp file.
 */
	pid = getpid();
	num(pid, tmp+8);
	intfil = creat(tmp, 0600);
	if (intfil < 0)  {
	  fprintf(stderr,"Can't create intermediate file\n");
	  exit(1);
	}
	close(intfil);
	intfil = open(tmp, 2);

	if(*option('u') == 0) 	/* u = preserve temp file */
	 unlink(tmp);

/*
 * process all the src files
 */
	for(i = 1; i < nfile; i++){
	  srcfil = freopen(arg[i],"r",stdin);
	  srcnam = arg[i];
	  nline = 0;
	  pass1();
	  close(srcfil);
	  if(errcount){
	    fprintf(stderr,"Errors in pass 1\n", arg[i]);
	    exit(1);
	  }
	}

	lseek(intfil,(long int)0,0);

	if(*option('a')){
	  if ((objfil = creat("m.out", 0666)) < 0)  {
	    synerr("Can't create m.out");
	    exit(1);
	  }
	}

	adjust();		/* adjust location counters for	assembly */
	lastsym = ERR;		/* reset lsb idx */
	ctitle[0] = '\0';	/* zero out title buffer */

	for( i = 1; i < nfile; i++){
	   srcfil = freopen(arg[i],"r",stdin);
	   srcnam = arg[i];
	   lpage = 1;
	   pass2();
	}

	if(*option('d'))	/* dump code summary */
	  dmpsum();

	if(*option('a'))	/* create m.out if generating binaries */
	  makobjf();

	if(*option('s')&&(lastsym != ERR)){	/* print symbol table  */
	  prtsyms();	
	  printf("\n%d Total Symbol Tbl Entries",(endcore-symtab)/ST);
	  printf("\nCore Allocated = %06o\n",sbrk(0));
	}
	exit(0);
}

/*
 * Initialize the internal data structures with the machine 
 * description (rfile)
 */

initbl(name)
char *name;
{

	register struct	st *s;
	register int i;


	/*
	 *	read header record:
	 *
	 *	contains number	of format descriptors,
	 *	and number of opcode descriptors,
	 *	pre-defined labels, literals,
	 *	and the	size of	the parser table.
	 *	It also	contains interesting information
	 *	about the target machine.
	 *
	 *	the file contains:-
	 *		literals;
	 *		format descriptors;
	 *		opcode table;
	 *		parser table;
	 *		pre-defined labels;
	 *
	 *	calculate core requirements and	sbrk()
	 *	for the	core.
	 */

	read(rfile, &head, HT);
	if(head.h_magic != RMAGIC){
	  fprintf(stderr,"%s not an rfile\n",name);
	  exit(1);
	}

	i = head.h_literals;
	if (i){
	  i = i * 8;
	  literals = sbrk(i);
	  read(rfile, literals, i);
	}

	i = FD * head.h_formats;
	memory = sbrk(i);
	read(rfile, &memory[0], i);

	i = head.h_o_len * head.h_ops;
	opcode = sbrk(i);
	read(rfile, &opcode[0], i);

	i = head.h_p_len * TBL;
	parse =	sbrk(i);
	read(rfile, &parse[0], i);

	symtab = coreptr = sbrk(32*ST);		/* alloc space for 32 syms */
	endcore = &symtab[32];			/* first invalid spot      */

	i = head.h_labels;
	while (i-- > 0)	 {
	  read(rfile, srcbuf, ST);	/* enter label in symbol table */
	  s = srcbuf;
	  defsym(s->s_name, any(srcbuf[0],alptab), s->s_value, s->s_mode);
	}

#ifdef DEBUG
	if(*option('Z')){
	 printf("literals = %06o memory = %06o opcode = %06o parse = %06o\n",
	         literals,memory,opcode,parse);
	 printf("symtab   = %06o coreptr = %06o endcore = %06o\n",
	         symtab,coreptr,endcore);
	}
#endif
	return;
}

adjust()
{
	register struct	lt *q;
	register int rs;
	register int i;
	register int nwrd;

	/*
	 *   adjust all	locn. counters and
	 *   set up code pointers. brk core.
	 *
	 *	l_rel_f	:	pointer	to start of core segment
	 *	l_start	:	start addr of code seg.	(logical)
	 */
	rs = 0;
	q = &locn[0];
	for (i=0; i<LCOUNT; i++)  {
	  if (q->l_value > q->l_limit)		/* backwards org ??? */
	    q->l_limit = q->l_value;
	  rs += (q->l_limit - q->l_start);
	  q->l_value = 0;
	  q++;
	}

	/*
	 *   rs:  Number of basic units	in all segments.
	 *	  Allow	1 word / byte.
	 *	  If r option is on - allow space for reloc info.
	 */
	if (*option('r'))  rs =* 2;

	code = sbrk(rs * INT);
	if (code == -1)  {
	  synerr("no core for assembly");
	  exit(1);
	}
	endcore	= sbrk(0);		/* highest core addr used */

	/*
	 *   Fix pointers to core for pass 2 assembly
	 */
	rs = 0;
	q = &locn[0];
	for (i=0; i<LCOUNT; i++)  {
	  q->l_rel_f = q->l_next = code + rs;
	  nwrd = q->l_limit - q->l_start;
	  if (*option('r'))  {
	    q->l_rel_n = q->l_reloc = code + rs + nwrd;
	    rs += (nwrd * 2);
	  }
	  else
	    rs +=  nwrd;
	  q++;
	}
	lcntr =	0;		/* Reset segment counters */
	return;
}

