
#include	"mac.h"
#include	"mac.x"


/*
 *   Define constant routines.
 */
prdc1(){
	prdc(0);
	return;
}

prdc2(){
	prdc(1);
	return;
}

prdc3(){
	prdc(2);
	return;
}

prdc4(){
	prdc(3);
	return;
}

prdc(n)
register int n;
{
	p = intercode.i_opr;
	if (!*p)  {
	  synerr("expression required");
	  return;
	}

	/*
	 *   Bump pc up	by the length of the constant.
	 */
	locn[lcntr].l_value += (head.dctype[n].f_len );

}



/*
 *   Special dc.
 *	Can define strings or constants.
 */
prdcs(){

	register struct	fd *f;
	register int len;

	/*
	 *   Allow a string, or	a single expr.
	 */

	f = &head.dctype[4];
	if (!f->f_len)	{	/* dc has not been declared in the r-file */
	  synerr("dc not allowed");
	  return;
	}

	p = intercode.i_opr;

	if (*p == '"')	{
	  p++;
	  len = 0;
	  while (*p++ != '"')
	    len++;
	  locn[lcntr].l_value += ( (len * f->f_len)  );
	  return;
	}

	/*
	 *   Expr.
	 */

	locn[lcntr].l_value += (f->f_len );
	return;
}



/*
 *   Null routine - just return.
 */
prnull(){
	return;
}



/*
 *   Equate a label to a value.	(defined expression)
 *   A check has already been made for a re-defined
 *   label tag.
 */
prequ(){

	register struct	st *q;
	register int l;

	p = intercode.i_opr;		/* operand field */
	l = intercode.i_label;
	if (l == ERR)  {
	  synerr("label tag required");
	  return;
	}

	q = &symtab[l];
	q->s_value = expr();
	q->s_mode |= (reloc|LITR);  /* {ch} added LITR */
	return;
}


/*
 *   Turn on export indicator.
 *   Make label availible to the outside world
 */
prexport(){

	register struct	st *q;
	register int i;

	p = intercode.i_opr;
	if (*p++ != '$')  {
	  synerr("label required");
	  return;
	}

	i = argnum();
	q = &symtab[i];
	q->s_mode |= (EXPO | gblidx++);

}

/*
 *   Turn on external indicator.
 *   Operands referencing external variables are resolved at link time
 *   More than one external reference cannot be used in an operand
 */
prextern(){

	register struct	st *q;
	register int i;

	p = intercode.i_opr;
	if (*p++ != '$')  {
	  synerr("label required");
	  return;
	}

	i = argnum();
	q = &symtab[i];
	q->s_mode |= (EXT | DEFN | gblidx++);	/* {ch} was  EXT | DEFN */
	q->s_sect = -1;			/* {added} no section */
	return;
}


/*
 *   Align pc to an even multiple of expr().
 *   If	already	at the boundary	- no align done.
 */
pralign(){

	int v;
	int l;	

	p = intercode.i_opr;
	v = expr();
	if (v <	1)
	  return;
	l = locn[lcntr].l_value;
	v = (l + v) % v;
	if (!v)		/* no align needed */
	  return;
	locn[lcntr].l_value += v;
}


/*
 *   Set origin	of pc
 */

prorg(){

	int v;
	int l;

	p = intercode.i_opr;
	v = expr();

	/*
	 *   Check l_limit:
	 *	if backwards org, check	that l_limit
	 *	is max(l_limit,	l_value).
	 *
	 *	This is	so that	we know	the overall
	 *	size of	a code segment for pass	2.
	 *
	 *   Check l_start:
	 *	if no code generated yet - set start addr of
	 *	code to	v;
	 *	else ensure l_start = min(l_start, v);
	 *
	 *   This will NOT work	if the user orgs, generates
	 *	code, then orgs	to zero	and doesn't generate
	 *	any code.
	 */
	if (!locn[lcntr].l_value)
	  /*
	   *   No code - init start adr
	   */
	  locn[lcntr].l_start = v;
	else
	  if (v < locn[lcntr].l_start) /*{ch}*/
	    /*
	     *   Lower org than we have - remember it.
	     */
	    locn[lcntr].l_start = v;

	/*
	 *   Check limit.
	 */

	l = locn[lcntr].l_value;

	if ( v < l  &&  l >  locn[lcntr].l_limit)
	  locn[lcntr].l_limit = l;

	locn[lcntr].l_value = v;		/* org pc */
	return;
}

/*
 *   Set segment indicator to absolute
 */

prasect(){

	register int v;

	p = intercode.i_opr;
	v = expr();

	if (v <	0 || v >= LCOUNT)  {
	  synerr("no such location counter");
	  return;
	}

	lcntr =	v;
	locn[lcntr].l_attrib = ABS;
	return;
}
/*
 *   Set segment indicator to relocatable
 */
prpsect(){

	register int v;

	p = intercode.i_opr;
	v = expr();

	if (v <	0 || v >= LCOUNT)  {
	  synerr("no such location counter");
	  return;
	}

	lcntr =	v;
	locn[lcntr].l_attrib = REL;
	return;
}


/*
 *   Reserve (n) bu's of null storage.
 */
prds(){

	int v;

	p = intercode.i_opr;

	v = expr();
				
	if (v <	0){				
	  synerr("negative ds");
	  return;
	}

	locn[lcntr].l_value += v;
	return;
}


/*
 */
prend(){
	return;
}


/*
 *   Structure offset definition.
 */
prstruc(){

	register struct	st *q;
	register int l;

	p = intercode.i_opr;		/* operand field */
	l = intercode.i_label;

	if (l != ERR)  {
	  /* Equate label to struct offset */
	  q = &symtab[l];
	  q->s_value = nstruc;
	}

	nstruc += expr();

	return;
}



/*
 *   End structure offset counter.
 */
prends(){

	register struct	st *q;
	register int l;

	l = intercode.i_label;
	if (l != ERR)  {
	  q = &symtab[l];
	  q->s_value = nstruc;
	}

	nstruc = 0;		/* reset structure counter */
	return;
}
