;
; VT100 cursor movement and scrolling
; region commands.  Control chars that
; move the cursor are also handled here.
;
;
;
; ESC [ Pn A - cursor up Pn rows.
;
; If cursor is above the scrolling region, don't
; move it past top of screen, otherwise don't
; move it past top of scrolling region.
;

curup:
	bsl	getpn		; get number rows to move up.
	cmp	#0		; map 0 to 1.
	bne	$1
	lda	#1
$1:	cmp	<cury		; # rows preposterous ?
	bcc	$2		; br if no.
	lda	<cury		; yes, make it max reasonable.
	dec	a
$2:	sta	<temp		; save cursor increment.
	lda	<srtop		; get top of scrolling region
	cmp	<cury		; cursor above it already?
	bcs	$3		; br if no, stop at srtop.
	lda	#1		; yes, stop at screen top.
$3:	sta	<temp1		; save min for new cursor row.
	sec			; calculate new cursor row.
	lda	<cury		; get cursor row.
	sbc	<temp		; subtract # rows to move up.
	cmp	<temp1		; compare with legal min row.
	bcs	$ok		; new row >= min, ok.
	lda	<temp1		; new row < min, stop at min.
$ok:
	cmp	<cury
	beq	$4
	sta	<cury		; save new cursor row.
	brl	chngln
$4:	rts

;
; ESC [ Pn B - cursor down Pn rows.
;
; If cursor is below the scrolling region, don't
; move it past bottom of screen, otherwise don't
; move it past bottom of scrolling region.
;

curdn:
	bsl	getpn		; get number rows to move down.
	cmp	#0		; map 0 to 1.
	bne	$1
	lda	#1
$1:	cmp	<rowmax		; # rows preposterous ?
	bcc	$2		; br if no.
	lda	<rowmax		; yes, make it max reasonable.
	dec	a
$2:	sta	<temp		; save cursor increment.
	lda	<cury		; get current cursor row.
	cmp	<srbot		; cursor below scrolling region?
	bcc	$3		; br if no, stop at srbot.
	beq	$3
	lda	<rowmax		; yes, stop at screen bottom.
	bra	$4
$3:	lda	<srbot		; stop at bottom of scrolling region
$4:	sta	<temp1		; save max for new cursor row.
	clc			; calculate new cursor row.
	lda	<cury		; get cursor row.
	adc	<temp		; add # rows to move down.
	cmp	<temp1		; compare with legal max row.
	bcc	$ok		; new row < max, ok.
	lda	<temp1		; new row >= max, stop at max.
$ok:
	cmp	<cury
	beq	$5
	sta	<cury		; save new cursor row.
	brl	chngln
$5:	rts

;
; ESC [ Pn C - move cursor right Pn columns.
;

currt:
	bsl	getpn		; get # columns to move.
	cmp	#0		; map 0 to 1.
	bne	$1
	lda	#1
$1:	cmp	<ncol		; preposterously large ?
	bcs	$2		; br if yes.
	clc			; calculate new cursor column.
	adc	<curx
	bcs	$2		; br if result huge.
	cmp	<ncol		; result > max this line ?
	bcc	$ok		; br if no.
$2:	lda	<ncol		; too big, stop at end.
$ok:	sta	<curx
	stz	<vauto
	rts

;
; ESC [ Pn D - move cursor left Pn columns.
;

curlt:
	bsl	getpn		; get # columns to move.
	cmp	#0		; map 0 to 1.
	bne	$1
	lda	#1
$1:	cmp	<curx		; preposterously large ?
	bcc	$2		; br if no, # columns < current col.
	lda	#1		; yes, stop at first column.
	bra	$ok
$2:	sec
	sta	<temp
	lda	<curx
	sbc	<temp		; calculate new cursor column.
$ok:	sta	<curx
	stz	<vauto
	rts

;
; ESC [ r;c H (or f).  Move cursor to row r, column c.
;
; r is relative to the top of the scrolling region if
; origin mode is set, else to the screen.
; If origin mode is set, this command cannot move
; the cursor outside of the scrolling region.  
;

currc:
	bsl	getpn		; get new row.
	cmp	#0		; map 0 to 1.
	bne	$1
	lda	#1
$1:	cmp	<rowmax		; new row preposterous ?
	bcc	$2		; br if no.
	lda	<rowmax		; yes, make it max reasonable.
$2:	bit	<ormode		; origin mode set ?
	bpl	$ok		; br if no.

	clc			; convert srtop relative to abs.
	adc	<srtop
	bcs	$3		; br if result overflowed.
	dec	a		
	cmp	<srbot		; result still above srbot ?
	bcc	$ok		; br if yes, it's ok.
$3:	lda	<srbot		; too big, stop at srbot.
$ok:
	cmp	<cury
	beq	$4
	sta	<cury		; save new cursor row.
	bsl	chngln		; update current line info (ncol).
$4:	
	bsl	getpn		; get new column.
	cmp	#0		; map 0 to 1.
	bne	$11
	lda	#1
$11:	cmp	<ncol		; column too big ?
	bcc	$12		; br if no.
	lda	<ncol		; yes, make it max legal.
$12:	sta	<curx		; save new column.
	stz	<vauto
	rts

;
; ESC D - cursor down.
;

index:
	lda	<cury		; get cursor line.
	cmp	<srbot		; at bottom of scrolling region ?
	bne	$1		; br if no.
	brl	scrlup		; yes, scroll screen up a line.
$1:	cmp	<rowmax		; at bottom of screen ?
	beq	$done		; br if yes, can't do anything.
	inc	<cury		; usual case, move down a line.
	brl	chngln		; update current line info.
$done:	rts			; done.

;
; ESC M - cursor up.
;

rindex:
	lda	<cury		; get cursor line.
	cmp	<srtop		; at top of scrolling region ?
	bne	$1		; br if no.
	brl	scrldn		; yes, scroll region down a line
				; and return.
$1:	cmp	#1		; at top of screen ?
	beq	$done		; br if yes, can't do anything.
	dec	<cury		; usual case, move up a line.
	brl	chngln		; update current line info.
$done:	rts			; done.

;
; ESC E - next line.
;

nxtlin:
	lda	#1		; move cursor to begin of line.
	sta	<curx
	brl	index		; go move down a line if poss.
;
; Linefeed (or vert tab, form feed).
;

ffctl:				; VT100 maps FF to LF.
vtctl:				; ditto VT.
lfctl:
	bit	<nlmode		; do crlf for lf ?
	bmi	nxtlin		; br if yes.
	brl	index		; nope, just go down a line.

;
; Carriage return.
;

crctl:	lda	#1
	sta	<curx
	stz	<vauto
	rts
;
; Backspace.
;

bsctl:	dec	<curx
	bne	$1
	inc	<curx
$1:	stz	<vauto
	rts

;
; Horizontal tab.
;

tabctl:
	ldy	<curx
	lda	#'T'
$1:	cmp	(<tabs),y
	beq	$tab
$2:	iny
	cpy	<ncol
	bcc	$1
	ldy	<ncol
	dey
$tab:	iny
	sty	<curx
	stz	<vauto
	rts

settab:
	ldy	<curx
	dey
	lda	#'T'
	sta	(<tabs),y
	rts

clrtab:
	bsl	getpn
	cmp	#3		; clear all tabs ?
	beq	$all		; br if yes.
	cmp	#0		; clear tab at cursor ?
	bne	$done		; done if no.
	ldy	<curx
	dey
	sta	(<tabs),y	; store 0.
	rts
$all:
	rep	#0x20
	ldy	#0
	lda	##0
$loop:	sta	(<tabs),y
	iny
	iny
	cpy	#132
	bcc	$loop
	sep	#0x20
$done:	rts

;
; ESC 7 - save cursor position.
;
; Also saves G0,G1, and selected font.
;
savcur:
	lda	<curx
	sta	<savx
	lda	<cury
	sta	<savy
;;	lda	<g0set
;	sta	<savg0
;	lda	<setg1
;	sta	<savg1

;	rep	#0x20
;	lda	<fntptr
;	sta	<savfnt
;	lda	<g0ptr
;	sta	<sv0ptr
;	lda	<g1ptr
;	sta	<sv1ptr
	sep	#0x20
	rts
;
; ESC 8 - restore cursor position.
;

rstcur:
;	lda	<savg0
;	sta	<g0set
;	lda	<savg1
;	sta	<setg1

;	rep	#0x20
;	lda	<savfnt
;	sta	<fntptr
;	lda	<sv0ptr
;	sta	<g0ptr
;	lda	<sv1ptr
;	sta	<g1ptr

	sep	#0x20
	lda	<savx
	sta	<curx
	lda	<savy
	cmp	<cury
	beq	$1
	sta	<cury		; save new cursor row.
	bsl	chngln		; update current line info.
$1:
	rts

;
; ESC [ top;bottom r - set scrolling region.
;

setreg:
	bsl	getpn		; get top of scrolling region.
	cmp	#0		; default ?
	bne	$l1
	lda	#1
$l1:	sta	<temp		; save it for later.
	bsl	getpn		; get bottom.
	cmp	#0
	bne	$l2
	lda	<rowmax
$l2:	cmp	<rowmax		; bottom <= max row value ?
	bcc	$1		; br if < max, ok.
	bne	$done		; br if > max, just return.
;
; see if region contains at least 2 lines.
;
$1:
	dec	a
	cmp	<temp		; (bottom - 1) > top ?
	bcc	$done		; just return if no.
;
; save new scrolling region margins.
;
	inc	a		; recover bottom value.
	sta	<srbot		; store it.
	lda	<temp		; get new top.
	sta	<srtop		; store it.
;
; move cursor to new home - 
; (1,1) if origin mode clear,
; else (1,srtop).
;
	lda	#1
	sta	<curx		; move cursor to left margin.
	bit	<ormode		; origin mode set ?
	bpl	$2		; br if no, move cursor to screen top.
	lda	<srtop		; yes, move cursor to top of region.
$2:
	cmp	<cury
	beq	$done
	sta	<cury		; save new cursor row.
	brl	chngln		; update current line info.
$done:	stz	<vauto
	rts			; done, return.



scrlup:
	php
	rep	#0x30
	phx
	phy
;
; make top of scrolling region
; the current line and erase it
; from screen.
;
	sep	#0x30
	lda	<srtop
	sta	<cury
	bsl	chngln
	lda	#1		; first col to erase.
	ldy	<nchr		; ditto last.
	bsl	undisp		; go erase.

;	bsl	scroll		; scroll the screen up.
	bsl	dispup
;
; make bottom line of region current and erase it
; from screen.
;
	lda	<srbot
	sta	<cury
	bsl	chngln
	lda	#1
	ldy	<nchr
	bsl	undisp

;
; rotate linmap.
;
	ldy	<srtop
	dey
	lda	(<linmap),y
	pha			; save new linmap[srbot]

	sec
	lda	<srbot
	sbc	<srtop
	tay			; # elements of linmap to move.

	rep	#0x30

	clc
	lda	<srtop
	and	##0x1f
	adc	<linmap
	tax		
	dex			; pointer to first target element.

	sep	#0x20
$loop:
	lda	1,x
	sta	0,x
	inx
	dey
	bne	$loop

	sep	#0x30
	ldy	<srbot
	sty	<cury
	dey
	pla
	sta	(<linmap),y
	bsl	chngln
	lda	#1
	ldy	<nchr
	beq	$done
	bsl	erase
	stz	<nchr
	lda	<colmax
	sta	<ncol
	lda	#0
	bsl	chgsiz
$done:
	rep	#0x30
	ply
	plx
	plp
	rts
	

scrldn:
	php
	rep	#0x30
	phx
	phy
;
; make bottom of scrolling region
; the current line and erase it
; from screen.
;
	sep	#0x30
	lda	<srbot
	sta	<cury
	bsl	chngln
	lda	#1		; first col to erase.
	ldy	<nchr		; ditto last.
	beq	$1
	bsl	undisp		; go erase.
$1:
	bsl	dispdn		; scroll display down.
;
; make top line of region current and erase it
; from screen.
;
	lda	<srtop
	sta	<cury
	bsl	chngln
	lda	#1
	ldy	<nchr
	beq	$2
	bsl	undisp
$2:

;
; rotate linmap.
;
	ldy	<srbot
	dey
	lda	(<linmap),y
	pha			; save new linmap[srtop]

	sec
	lda	<srbot
	sbc	<srtop
	tay			; # elements of linmap to move.

	rep	#0x30

	clc
	lda	<srbot
	and	##0x1f
	adc	<linmap
	tax		
	dex			; pointer to first target element.
	dex			; pointer to first source element.

	sep	#0x20
$loop:
	lda	0,x
	sta	1,x
	dex
	dey
	bne	$loop

	sep	#0x30
	ldy	<srtop
	sty	<cury
	dey
	pla
	sta	(<linmap),y
	bsl	chngln
	lda	#1
	ldy	<nchr
	beq	$done
	bsl	erase
	stz	<nchr
	lda	<colmax
	sta	<ncol
	lda	#0
	bsl	chgsiz
$done:
	rep	#0x30
	ply
	plx
	plp
	rts
	
	end
