;
; VT100 host I/O and control char routines.
;

;;;;;;;;;;;;;;;;;;;;;;;;;
; Send byte to host.	;
;;;;;;;;;;;;;;;;;;;;;;;;;

putchr:
	pei	<hstqcb
	jsl	>0,Putoutq
	bcs	putchr
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Return next processable character from host.	;
; This routine filters out del and control chars;
; (except for ESC,CAN and SUB).  Return is with	;
; carry set if ESC received, overflow set for	;
; CAN and SUB.					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getchr:
	rep	#0x43		; clear carry,overflow,zero.
	php
	sep	#0x20
$get:
	lda	(<bytcnt)	; host data avail ?
	bmi	$1		; go get if yes..
	plp
	sep	#2		; set zero for no data.
	rts

$1:	pei	<hstqcb		; push pointer to host qcb.
	jsl	>0,Getinq	; get byte from input q.

	cmp	#0x20		; control char ?
	bcs	$notctl		; br if no.
	cmp	#ESC
	beq	$esc
	cmp	#SUB
	beq	$abt
	cmp	#CAN
	beq	$abt
	cmp	#0		; null ?
	beq	$get		; yes, ignore it.
	bsl	ctlchr		; valid control char, execute it.
	bra	$get		; go get next host byte.

$notctl:
	cmp	#127		; delete ?.
	beq	$get		; yes, ignore it.
	plp			; no, return char with
	rts			; flags clear.

$abt:
	plp			; CAN/SUB, return overflow set.
	sep	#0x40
	rts

$esc:
	plp			; ESC, return carry set.
	sec
	rts
;
; Jump to handler for executable control chars.
;

ctlchr:
	cmp	#LF
	bne	$1
	brl	lfctl
$1:	cmp	#CR
	bne	$2
	brl	crctl
$2:	cmp	#HT
	bne	$3
	brl	tabctl
$3:	cmp	#BS
	bne	$4
	brl	bsctl
$4:	cmp	#SO
	bne	$5
	brl	soctl
$5:	cmp	#SI
	bne	$6
	brl	sictl
$6:	cmp	#BEL
	bne	$7
	brl	$beep
$7:	cmp	#FF
	bne	$8
	brl	ffctl
$8:	cmp	#VT
	bne	$9
	brl	vtctl
$9:	cmp	#ENQ
	bne	$done
	brl	ansbck
$beep:
	lda	#2
	tsb	Beeper
	
$done:

	rts
	


	end
