;
;	disassemble the instruction pointed
;	to by the currently open address
;

	title	"65816 Disassembler"
;
;	Disassemble the instruction pointed
;	to by the currently open address.
;	In the case of #imm or ##imm instructions
;	the disassembly may be incorrect, since
;	the psw when the instruction is executed
;	isn't known (except when single stepping).
;

dasm:
	php			; preserve caller's status
	rep	#0x30		; 16 bit memory/idx
	pei	<curadr		; preserve this for debugger

	lda	[<curadr]	; get opcode	
	and	##0xff		; save only the opcode
	asl	a
	tay
	per	opctyp
	lda	(1,s),y		; get entry for this opcode
	plx			; pop off the base adr

	pha			; save copy for later
	xba			; get type index
	and	##0xff
	asl	a
	asl	a		; mult * 4
	per	opcnam
	clc
	adc	1,s		; calculate adr of name
	plx			; pop opcnam
	pha			; push adr onto stack
	bsl	putstr		; output the opcode
	bsl	putsp

	inc	<curadr		; point pc past opcode

	pla			; get the opcode
	and	##0xff		; mask off high byte

	cmp	##0
	bne	$acc		; implied?
	brl	$999		; output crlf, return to debugger

$acc:	cmp	##1		; a?
	bne	$rest
	lda	##'a'
	bsl	putchr
	brl	$999		; output crlf, return to debugger

;
;	opctype 2 - 16 are very easy, only the printf format
;	varies.  see if we're lucky
;
$rest:	cmp	##17
	blt	$lucky
	brl	$17

$lucky

;
;	make an index into the format offsets table
;	from the opcode type in a (2..16)
;
	dec	a
	dec	a
	asl	a
	tay			; save format offset index

	lda	[<curadr]	; get byte/word to print
	pha
	pea	##2		; push arg byte count for printf

;
;	make a pointer to our format string.
;	$forms + $fmtabl[i] is the address of
;	the i'th string in $forms
;
	per	$forms		; push address of format string pool
	per	$fmtabl		; push format offsets table addr
	lda	(1,s),y		; get offset for our format
	clc			; add string offset to pool addr
	adc	3,s		; now a points to format string

	ply			; clean stack
	ply

	pha			; push pointer to string for printf
	brl	$998		; go printf etc.



$17:	cmp	##17		; rel8
	bne	$18
$rel8:	lda	[<curadr]	; get offset
	and	##0xff		; sign extend offset
	bit	##0x80
	beq	$17a
	ora	##0xff00
$17a	
	dec	a		; compute addr to branch to 
	bra	$18a		; and output it

$18:	cmp	##18		; rel16?
	bne	$19
$rel16:	lda	[<curadr]	; get offset
$18a:
	clc
	adc	<curadr		; add to pc+1
	inc	a		; add 2 more for (ahem)
	inc	a		; good measure

	bsl	wtox		; output addr branched to
	brl	$999		; output crlf, return to debugger

$19:	cmp	##19		; >dbr,adr
	bne	$20

	ldy	##2		; get offset of dbr
	lda	[<curadr],y	; get dbr
	pha			; push it for printf
	lda	[<curadr]	; get adr 
	pha			; push it for printf

	pea	##4		; push arg byte count
	per	$19fmt		; push pointer to format
	brl	$998		; go printf etc.


$20:	cmp	##20		; >dbr,adr,x
	bne	$21
	ldy	##2		; get offset of dbr
	lda	[<curadr],y	; get dbr
	pha			; push it for printf
	lda	[<curadr]	; get adr 
	pha			; push it for printf
	pea	##4		; push arg byte count
	per	$20fmt		; push pointer to format
	brl	$998		; go printf etc


$21:	cmp	##24		; some kind of imm? (21 22 23)
	bge	$24

	lda	[<curadr]	; get immediate byte or word
	pha			; push it for printf
	pea	##2		; push arg byte count

;
;	find out if the instruction is 2 or 3 bytes long
;
	dec	<curadr		; point back to opcode
	lda	[<curadr]	; get the opcode
	bsl	inslen		; get instr length in acc
	cmp	##2		; instr 2 byte long ?
	beq	$21a

	per	$21ft2		; output ##imm
	brl	$998
$21a:
	per	$21fmt1		; output #imm
	brl	$998

$24:	lda	[<curadr]	; >bank,>bank
	pha			; push first bank for printf
	xba			; get 2nd bank
	pha			; push it for printf
	pea	##4		; push arg byte count
	per	$24fmt		; push format
;	bra	$998		; go printf etc


$998
	bsl	printf
$999
	bsl	crlf
	rep	#0x20
	pla			; restore original value 
	sta	<curadr		; of <curadr
	plp
	rts

$fmtabl
	dcw	$2fmt-$2fmt
	dcw	$3fmt-$2fmt
	dcw	$4fmt-$2fmt
	dcw	$5fmt-$2fmt
	dcw	$6fmt-$2fmt
	dcw	$7fmt-$2fmt
	dcw	$8fmt-$2fmt
	dcw	$9fmt-$2fmt
	dcw	$10fmt-$2fmt
	dcw	$11fmt-$2fmt
	dcw	$12fmt-$2fmt
	dcw	$13fmt-$2fmt
	dcw	$14fmt-$2fmt
	dcw	$15fmt-$2fmt
	dcw	$16fmt-$2fmt

$forms
$2fmt	dcs	"<%b\0"
$3fmt	dcs	"<%b,x\0"
$4fmt	dcs	"<%b,y\0"
$5fmt	dcs	"(<%b)\0"
$6fmt	dcs	"(<%b),y\0"
$7fmt	dcs	"(<%b,x)\0"
$8fmt	dcs	"[<%b]\0"
$9fmt	dcs	"[<%b],y\0"
$10fmt	dcs	"%b,s\0"
$11fmt	dcs	"(%b,s),y\0"
$12fmt	dcs	"%x\0"
$13fmt	dcs	"%x,x\0"
$14fmt	dcs	"%x,y\0"
$15fmt	dcs	"(%x)\0"
$16fmt	dcs	"(%x,x)\0"

$19fmt	dcs	">%b,%x\0"
$20fmt	dcs	">%b,%x,x\0"
$21fmt1	dcs	"#%b\0"
$21ft2	dcs	"##%x\0"
$24fmt	dcs	">%b,>%b\0"

bsrfmt:	dcs	"bsr \0"	; bsr printf fmt
bslfmt:	dcs	"bsl \0"	; bsl printf fmt

	end


