
;
; I/O addresses (pc version).
;

ACE	equ	0x20	; bank containing asynchs.
EEP	equ	0x60	; ditto eeprom.
ROM	equ	0x40	; ditto prom.
PtrCtl	equ	0xff38	; read returns Centronics status.
			; set bit 0 to set Centronics PRIME signal.
			; set bit 1 to set Centronics STROBE signal.
PtrPrt	equ	0xff39	; Centronics output port.
DmaCtl	equ	PtrCtl	; set bit 2 to enable external cycles (vdma)
			; set bit 3 to enable data flag.
DmaCmd	equ	0xff30	; write drawing processor DMA commands
			; here - bit 0 of command set = read from
			; refresh buffer.
Clrvb	equ	0xff31	; write to turn off vertical irq.
DevEnd	equ	0xff20	; write to pulse device end - intrpt host
ParIn	equ	0xff00	; parallel input port (2 bytes).
ParOut	equ	0xff3c	; parallel output port. 
			; Writing the low byte sends data to and sets
			; byte assembled for the host.

CdmPrt	equ	0xff04

Iemask	equ	0xff34	; Interrupt enable mask reg.
DmaEna	equ	0xff00	; write asserts data flag.
DmaDsb	equ	0xff10	; write clears data flag always and 
			; requests an external cycle if video dma
			; is enabled (see DmaCtl).
PolDev	equ	0xff1c	; device polling is done by inspecting 
			; bits in this word.
Dpdone	equ	0xff1d	; done if bit 6 set.
vbmask	equ	128	; vertical retrace if vbmask and Vbflag.
Vbflag	equ	0xff1d

;  
;	0xff1c :
;	bit 7 - host command out, set if data available
;		in parallel port.
;	bit 6 - host data out.
;
;	0xff1d :	
;	bit 7 - set during vertical retrace.
;	bit 6 - set if dpu done.
;
;	0xff1e :
;	bit 7 - set if eeprom ready (writeable without wait states).
;	bit 6 - set if host cpu ok is false 
;		(i.e. can't talk over parallel interface).
;

EEace0	equ	512	; asynch data in eeprom.
;	512-517		ac0: dll
;			     dlh
;			     data bits (5-8)
;			     stop bits (1-2)
;			     parity ('N','E','O','0','1')
;			     handshake ('X','M','0')
;	518-523		ac1
;	524-529		ac2
;	530-535		ac3


byte	equ	1
word	equ	2
quad	equ	4
;
;
; Preliminary 'fixed' address list.
; Interrupt vectors and fixed firmware entry points
;
;
; The vector prom at ffe0 points to the next 5 labels.
; If you want to handle brk,nmi,abt or cop, put a
; jump long instruction to your service routine at
; the appropriate label. (jmp	>bank,addr).
; Note that your routine is responsible for preserving 
; registers on entry and restoring them on exit.
;
; irq is a little different - there are 15 possible sources
; of irq in the 1280.  You can handle any of the sources
; by placing a jmp >bank,addr in the table at 0x7fc0.  Your
; routine will then be jumped to after the code at irqsav (below)
; preserves all the registers.  Your routine should exit with a
; jump to Irqdon, which restores the environment as
; preserved at irqsav.
; 
;
; Memory map :
;
; 0-?		initial heap
; ?-?		stack
; ?-Start-1	downloaded code
;
; 7700-77ff	kernel jump table
; 7800-78ff	Blink table(56 bytes)
; 7900-797f	interpreter jump table
; 7980-79ff	user jump table
; 7a00-7aff	vt100 direct page
; 7b00-7bff	graphics direct page
; 7c00-7eff	color table image
; 7f00-7f7f	kernel variables
; 7f80-7f8f	vectors(irq,nmi etc)
; 7f90-7fbf	irq entry/exit routines
; 7fc0-7fff	irq jump table
;

;
; Fixed kernel entry points.
;
;	org	0x7700		; ends at 77ff (64 entries).

Start	equ	0x7700		; where to go after init complete.
DlTabl	equ	Start+4		; table driven Downld,Malloc.
Downld	equ	Start+8		; move code from prom to ram.
Malloc	equ	Start+12	; get buffer from high ram.
GetHeap	equ	Start+16	; get buffer from heap.
FreHeap	equ	Start+20	; return buffer to heap.
ChkHeap	equ	Start+24	; check heap free list.
Getinq	equ	Start+28	; get char from ACE input q.
Putoutq	equ	Start+32	; put char into ACE output q.
Getace	equ	Start+36	; input char via ACE.
Putace	equ	Start+40	; output char via ACE.
Getpar	equ	Start+44	; input byte via parallel port.
Putpar	equ	Start+48	; output byte via parallel port.
Getcdm	equ	Start+52	; get command dma byte.
Cdmctl	equ	Start+56	; set/reset command dma mode.
Qcbini	equ	Start+60	; initialize a qcb.
GetKey	equ	Start+64	; get next key from kbd input q.
GetHst	equ	Start+68	; get next byte from host serial in q.
SndHst	equ	Start+72	; q byte for output to host.
Break	equ	Start+76	; send break over host ace.
SetClt	equ	Start+80	; update clt dacs.
Erase	equ	Start+84	; full screen erase.
Vt100	equ	Start+88	; enter vt100 mode.
SelFnt	equ	Start+92	; select font (7*9 or 12*16).
ChSize	equ	Start+96	; set char height/width single/double.
SaveDa	equ	Start+100	; save drawing acc state.
RstrDa	equ	Start+104	; undo a SaveDa.
SavFnt	equ	Start+108	; save font current info.
RstFnt	equ	Start+112	; undo SavFnt.
AceSet	equ	Start+116	; set asynch data format.
Cnout	equ	Start+120	; send byte to Centronics port.
AceSav	equ	Start+124	; save asynch format in eeprom.
AceRst	equ	Start+128

;
; Blink table array (56 bytes,
; rest of page available).
;
Bltab	equ	0x7800

;
; Fixed interpreter entries (32 max).
; (Moved to $SIMP/intrp.h)
;
;Get	equ	Start+256
;Send	equ	Start+260
;Dispa	equ	Start+264	; interpret byte as gfx command.
;Dchar	equ	Start+268	; interpret byte in alpha mode.
;ChkKbd	equ	Start+272	; keep kbd input moving.
;Dcurs	equ	Start+276	; draw cursor at x,y reg.
;Setup	equ	Start+280	; enter setup mode.
;

Vt1drp	equ	0x7a00		; vt100 direct page.
Intdrp	equ	0x7b00		; graphics interp direct page.

Redclt	equ	0x7c00
Grnclt	equ	0x7d00
Bluclt	equ	0x7e00

;
; Fixed addresses in firmware data space.
;
;	org	0x7f00		; beginning of fixed firmware
				; storage, ends at 0x7f7f. (128 bytes)
Qcbac0	equ	0x7f00		; pointer to qcb for ACE at 200000 (pad).
Qcbac1	equ	Qcbac0+2	; ditto 2000010 (aux).
Qcbac2	equ	Qcbac0+4	; 2000020 (host).
Qcbac3	equ	Qcbac0+6	; 2000030 (kbd).
StkBas  equ	Qcbac0+8	; addr highest free ram.
StkMin	equ	Qcbac0+10
HeapTop	equ	Qcbac0+12	; high addr allowed to Heap.
Inierr	equ	Qcbac0+14	; power up error flag.
Cdmsw	equ	Qcbac0+16
Cdmbuf	equ	Qcbac0+18
Leds	equ	Qcbac0+20
Beeper	equ	Qcbac0+21
Vcount	equ	Qcbac0+22	; vertical interrupt counter.
OldLed	equ	Qcbac0+24
Iqcnt0	equ	Qcbac0+26	; negative byte count for ace 0 input q.
Iqcnt1	equ	Qcbac0+28	; negative byte count for ace 1 input q.
Iqcnt2	equ	Qcbac0+30	; negative byte count for ace 2 input q.
Iqcnt3	equ	Qcbac0+32	; negative byte count for ace 3 input q.
ParStat	equ	Qcbac0+34	; for signals via parallel interface.
Setupk	equ	Qcbac0+36	; decremented when setup key received.
DaRev	equ	Qcbac0+37	; drawing acc rev.
Blink	equ	Qcbac0+38
Acedat	equ	Qcbac0+39	; 3 blocks of 6 bytes asynch info.
Tabdat	equ	Acedat		; baud rate (word), #data bits,
Auxdat	equ	Acedat+6	; # stop bits, parity select,handshake.
Hstdat	equ	Acedat+12

;
; Jump table for Brk,Nmi,Cop,Abt.
;

Brkvec	equ	0x7f80
Nmivec	equ	0x7f84
Copvec	equ	0x7f88
Abtvec	equ	0x7f8c

;
; Irq entry/exit routine addresses.
;
Irqsav	equ	0x7f90
Irqdon	equ	0x7fb0

;
; Interrupt vectors, from low to high priority.
;

Ivpack	equ	0x7fc0		; Centronics printer acknowledge
Ivpflt	equ	0x7fc4		; Centronics printer fault
Iveerd	equ	0x7fc8		; eeprom ready
Ivbus4	equ	0x7fcc		; bus device 4
Ivbus3	equ	0x7fd0		; bus device 3
Ivbus2	equ	0x7fd4		; bus device 2
Ivbus1	equ	0x7fd8		; bus device 1
Ivbus0	equ	0x7fdc		; bus device 0
Ivdato	equ	0x7fe0		; host data out (DMA data from host)
Ivcmdo	equ	0x7fe4		; host parallel command out
Ivtcnt	equ	0x7fe8		; terminal count
Ivblnk	equ	0x7fec		; vertical blank
Ivace0	equ	0x7ff0		; ACE at 200000
Ivace1	equ	0x7ff4		; ACE at 200010
Ivace2	equ	0x7ff8		; ACE at 200020
Ivace3	equ	0x7ffc		; ACE at 200030





	psect	0
	
; Each ACE that uses interrupts is assumed to have
; an associated queue control block (qcb).  A pointer
; to the qcb is at a known location in the kernel RAM.
;
; A qcb looks like this :
;

aceoff  struct byte ; offset (from 200000) of the ACE.
aceidx	struct byte ; ace # * 2 (for indexing Iqcnt, Qcbac arrays).
intmsk	struct byte ; ace interrupt enable mask.
choked  struct byte ; bit 7 set if output is inhibited,
		    ; bit 6 set if input is inhibited.
iocntl  struct byte ; bit 7 set if XOFF/XON handshake,
		    ; bit 6 set if RTS/CTS.
		    ; bit 5 set means allow input buffer to overflow,
		    ; else discard input to a full buffer.
icmask	struct byte ; for masking non-data bits in input
qerror	struct byte ; error reporting bits.
qercnt	struct byte ; error interrupt count.
iqptr   struct word ; input buffer (FIFO) address (bank 0).
iqbank	struct byte ; 0, for [<iqptr],y addr mode
iqhead  struct byte ; iqptr + iqhead is address of first char in buffer.
iqtail  struct byte ; iqptr + iqtail is address of next free space.
iqsize  struct byte ; size of the input buffer, in bytes.
iqhigh  struct byte ; high water mark - choke sender when q this full.
iqlow   struct byte ; low water mark - unchoke sender when q this full.
oqptr   struct word ; output buffer (FIFO) address (bank 0).
oqbank	struct byte ; 0, for [<oqptr],y addr mode
oqhead  struct byte ; oqptr + oqhead is address of first char in buffer.
oqtail  struct byte ; oqptr + oqtail is address of next free space.
oqsize  struct byte ; size of the output buffer, in bytes.
qcbsiz:	ends



