;
; Asynch setup routines.
; Entries -
;
;	acedef - write default default asynch setup
;		 info to eeprom, and call aceset.
;	acesav - write current asynch settings to eeprom.
;	aceset - 
;
;
; Asynch data format setter upper for
; the rest of the world.
; Enter with pointer to data format stuff on stack,
; and ace number in x reg (0..2).
; The data pointed to looks like
;	dcw	baud rate.
;	dcb	databits (5..8).
;	dcb	stopbits (1,2).
;	dcb	parity ('N' none,'E' even,'O' odd,
;			'0' stick at 0,'1' stick at 1).
;	dcb	handshake ('X' xon/xoff, 'M' rts/cts, 0 none)
;		(aceset ignores this field).
; Note - above format is also used in eeprom.
;
; This routine will not set up the keyboard ace.
; This routine builds a record in the format
; desired by setdfmt, and calls setdfmt.
; If any of the fields are invalid, carry is returned set
; and no update performed.  In any case, the pointer is
; removed from the stack.  If this routine completes
; successfully, the callers data is copied to the
; corresponding variables in the kernel.
;
aceset:
	clc			; assume success.
	php
	rep	#0x30
	pha
	phx
	phy
	phb

	pea	##0		; this is where we build the
	pea	##0		; record passed to setdfmt.

$ptr	equ	16
$psw	equ	12
$acn	equ	8
$lcr	equ	4
$div	equ	2
$acoff	equ	1


	sep	#0x30
	lda	$acn,s		; get ace number
	cmp	#3		; legal ?
	bcc	$offsok		; br if yes.
	brl	$error		; nope, exit.
$offsok:
	asl	a		; convert to ace offset.
	asl	a
	asl	a
	asl	a
	sta	$acoff,s	; save for setdfmt.
;
; get requested baud rate.  search for corresponding
; 'divisor'.  error if baud rate not in table.
;

	ldy	#0
	rep	#0x20
	lda	($ptr,s),y	; get baud rate.
	phb			; save dbr.
	phk			; set dbr = pbr.
	plb
	per	$brtab		; baud rate table.
	ldy	#$lastbr	; last br table entry.
$loop:	cmp	(1,s),y		; find their baud rate ?
	beq	$found		; br if whoopee.
	dey			; nope, point to next in table.
	dey
	dey
	dey
	bpl	$loop		; br if match still possible.
;
; bad baud rate, clean up stack and exit.
;
	pla			; remove baud table pointer.
	plb			; restore saved dbr.
	brl	$error		; exit.
;
; good baud rate, get divisor.
;

$found:
	iny			; point to corresponding divisor.
	iny
	lda	(1,s),y		; fetch it.
	sta	$div+3,s	; save it for setdfmt.
	pla			; clean up stack (br table).
	plb			; restore dbr.
;
; Now do data bit count, stop bit count
; and parity select.  These values all get 
; converted to bits in a byte destined for
; the asynchs' line control register.
; convert count = (5..8) to LCR bit field (0..3) (bits 0,1),
; stop bit count = (1,2) to (0,4), (bit 2)
; parity select (N,E,O,1,0) to (0,24,8,56,40) (bits 3,4,5).
;

	sep	#0x20
	ldy	#2		; pointer to databit count.
	lda	($ptr,s),y	; get it.
	iny
	sec
	sbc	#5		; convert count to LCR bit field.
	cmp	#4		; legal ?
	bcc	$dbok		; br if yes.
	brl	$error
$dbok:	sta	$lcr,s		; save for setdfmt.

	lda	($ptr,s),y
	iny
	dec	a
	beq	$par
	cmp	#1
	beq	$sb1
	brl	$error
$sb1:	lda	#4	
	ora	$lcr,s
	sta	$lcr,s

$par:	
	lda	($ptr,s),y
	iny
	cmp	#'N'
	beq	$doit
	tax
	lda	#8
	cpx	#'O'
	beq	$pok
	lda	#8+16
	cpx	#'E'
	beq	$pok
	lda	#8+32
	cpx	#'0'
	beq	$pok
	lda	#8+16+32
	cpx	#'1'
	beq	$pok
	brl	$error
$pok:
	ora	$lcr,s
	sta	$lcr,s
$doit:

;
; now generate a pointer to the setdfmt data on
; the stack, set dbr = 0, and call setdfmt.
;
	phb
	lda	#0
	pha
	plb
	rep	#0x20
	clc
	tsc
	adc	##$acoff+1
	pha
	bsl	setdfmt
	pla			;(setdfmt doesn't clean up stack).
	plb
;
; now update the kernels notion
; of how the ace is set up. copy
; the callers 6 bytes to kernel area.
;
	sep	#0x30
	lda	$acoff,s	; get ace# * 16
	lsr	a		; convert to *4
	lsr	a	
	sta	$acoff,s	; temp
	lsr	a		; ace # *2
	clc
	adc	1,s		; + *4
	tax			; = * 6
	ldy	#0
$copy:	lda	($ptr,s),y
	sta	>0,Acedat,x
	inx
	iny
	cpy	#6
	bne	$copy
	bra	$done

$error:
	sep	#0x20
	lda	$psw,s
	ora	#1
	sta	$psw,s
;
; clean up stack.  at this point it looks like
; 	ptr lo,hi
;	ret bank
;	ret addr lo,hi
;	psw
;	acc lo,hi
;	x lo,hi
;	y lo,hi
;	dbr
;	4 bytes local stuff.
; sp-->

$done:
	rep	#0x30
	lda	$ptr-2,s	; remove pointer.
	sta	$ptr,s
	lda	$ptr-4,s
	sta	$ptr-2,s
	pla			; remove local data.
	pla
	plb			; restore callers dbr
	ply			; and y
	plx			; and x
	pla			; and a
	sta	1,s		; was $ptr-4
	pla			; a again
	plp
	rtl

;
; baud rate / divisor table.
; I suspect some of these will
; never be used, but what the hey. 
; Got to have something to cut out
; when space gets tight.
;

$brtab:
	dcw	50
	dcw	2304

	dcw	75
	dcw	1536

	dcw	110
	dcw	1047

	dcw	134
	dcw	857

	dcw	150
	dcw	768

	dcw	300
	dcw	384

	dcw	600
	dcw	192

	dcw	1200
	dcw	96

	dcw	1800
	dcw	64

	dcw	2000
	dcw	58

	dcw	2400
	dcw	48

	dcw	3600
	dcw	32

	dcw	4800
	dcw	24

	dcw	7200
	dcw	16

	dcw	9600
	dcw	12

	dcw	19200
	dcw	6

	dcw	38400
	dcw	3

$lastbr equ	!-$brtab

	dcw	56000
	dcw	2


acesav:
	php
	rep	#0x30
	pha
	phx
	phy
	phb
	sep	#0x30
	lda	#0
	pha
	plb
	ldx	#3*6-1
$loop:
	bit	0xff1e
	bpl	$loop
	lda	Acedat,x
	cmp	>EEP,EEace0,x
	beq	$1
	sta	>EEP,EEace0,x
$1:	dex
	bpl	$loop
$2:	bit	0xff1e
	bpl	$2
	rep	#0x30
	plb
	ply
	plx
	pla
	plp
	rtl
;
; local routine to init eeprom asynch data.
; enter with ace number in x (0,1,2).
;

acedef:
	php
	rep	#0x30
	pha
	phx
	phy
	phb
;
; calculate addr of table + 6*x
; leave result on stack for aceset
;
	txa
	and	##0xff		; acc = ace number.
	asl	a		; acc = x*2
	cmp	##6		; legal value ?
	bcs	$error		; error exit if no.
	per	$table		; push base addr of table.
	pha			; push x*2.
	asl	a		; acc = x*4
	adc	1,s		; acc = x*6
	tax			; save for indexing eeprom.
	adc	3,s		; x*6 + table
	sta	3,s		; replace base addr.
	pla			; clean up.

	sep	#0x30
	phk
	plb
	ldy	#0
	
$loop:
	lda	>0,0xff1e	; eerdy ?
	bpl	$loop		; wait if no
	lda	(1,s),y		; get default default.
	cmp	>EEP,EEace0,x	; don't write if already there
	beq	$11		; (eeprom wears out).
	sta	>EEP,EEace0,x	; store default in eeprom.
$11:	inx			; point to next in eeprom
	iny			; ditto prom.
	cpy	#$tabl1-$table	; more defaults ?
	bne	$loop

;
; get ace number and call aceset to set it up.
; (pointer to data still on stack is removed by aceset).
;
	lda	6,s
	tax
	jsl	>0,AceSet	
;
; make sure last eeprom write is complete.
;
$12:	bit	0xff1e		; eerdy ?
	bpl	$12		; wait if no

$error:
	rep	#0x30	
	plb
	ply
	plx
	pla
	plp
	rts

;
; This table is a copy of the 
; default default asynch setup
; data stored in eeprom.
;
	
$table:
	dcw	9600		; baud rate (mouse)
	dcb	7		; # data bits
	dcb	2		; # stop bits
	dcb	'O'		; parity
	dcb	0		; handshake

$tabl1:
	dcw	19200		; baud rate (aux)
	dcb	7		; # data bits
	dcb	2		; # stop bits
	dcb	'N'		; parity
	dcb	0		; handshake

	dcw	9600		; baud rate (host)
	dcb	8		; # data bits
	dcb	2		; # stop bits
	dcb	'N'		; parity
	dcb	'X'		; handshake


	end

