/*
 * draw Sierpinski curves
 * a+ds=pgms pg 136
 */

#include <stdio.h>

#define MAX 6
#define SIZE 1024

char*  clr="\0\1\2\3\4\5\6\7";
long numvecs;
int i,h,x,y,x0,y0;
main(){
	i=0;
	h = SIZE/4;
	x0 = 2*h;
	y0 = 3*h;
	printf("\033G18888~");			/* ers */
	putchar('e');
	putw(200,stdout);
	setclr(1,200,0,200);
	setclr(2,250,0,0);
	setclr(3,220,220,0);
	setclr(4,0,200,0);
	setclr(5,0,0,180);
	setclr(6,90,90,90);
	setclr(7,0,0,120);
	do{
	 i=i+1;
	 putw((clr[i]<<8)|'C',stdout);
	 x0 = x0-h;
	 h = h/2;
	 y0 = y0+h;
	 x= x0;
	 y = y0;
	 move(x,y);
	 a(i); x=x+h; y=y-h; plot();
	 b(i); x=x-h; y=y-h; plot();
	 c(i); x=x-h; y=y+h; plot();
	 d(i); x=x+h; y=y+h; plot();
	}
	 while(i<MAX);
	fprintf(stderr,"total vectors = %ld\n",numvecs);
}


a(i){
	if(i>0){
	 a(i-1); x=x+h; y=y-h; plot();
	 b(i-1); x=x+2*h; plot();
	 d(i-1); x=x+h; y=y+h; plot();
	 a(i-1);
	}
}

b(i){
	if(i>0){
	 b(i-1); x=x-h; y=y-h; plot();
	 c(i-1); y=y-2*h; plot();
	 a(i-1); x=x+h; y=y-h; plot();
	 b(i-1);
	}
}

c(i){
	if(i>0){
	 c(i-1); x=x-h; y=y+h; plot();
	 d(i-1); x=x-2*h; plot();
	 b(i-1); x=x-h; y=y-h; plot();
	 c(i-1);
	}
}

d(i){
	if(i>0){
	 d(i-1); x=x+h; y=y+h; plot();
	 a(i-1); y=y+2*h; plot();
	 c(i-1); x=x-h; y=y+h; plot();
	 d(i-1);
	}
}

move(){
	register unsigned hxy,lxy;
	hxy  = (x&0xf00)<<4;
	hxy |= (y&0xf00);
	hxy |= 'Q';
	lxy = ((y&0xff)<<8)|(x&0xff);
	putw(hxy,stdout);
	putw(lxy,stdout);
}

plot(){
	register unsigned hxy,lxy;
	hxy  = (x&0xf00)<<4;
	hxy |= (y&0xf00);
	hxy |= 'A';
	lxy = ((y&0xff)<<8)|(x&0xff);
	putw(hxy,stdout);
	putw(lxy,stdout);
	numvecs++;
}

setclr(clr,r,g,b){
	putc('K',stdout);
	putc(clr,stdout);
	putc(1,stdout);
	putc(r,stdout);
	putc(g,stdout);
	putc(b,stdout);
}
