/*
 * eight bouncing squares
 *
 * al kossow (AED)
 * april 1984
 */

#include <stdio.h>

#define UPXUPY 1
#define UPXDNY 2
#define DNXUPY 3
#define DNXDNY 4
#define RAND   -1

#define TOP	400
#define BOT	260
#define LEFT	250
#define RIGHT	650

struct clrt {
		char r;
		char g;
		char b;
	    };

/*
 * drag in a hierarchical color table synthesisied by "mkhier.c"
 */

#include "hier.tbl"

/*
 * define some balls..
 */

struct ball {
	int	x;
	int	y;
	int	dir;
	int	idx;
	int	clr;
	int	mask;
       } ball[] = {
		500,  300,  DNXDNY, 10, 0x01, 0x01,
		500,  300,  UPXDNY, 10, 0x02, 0x02,
		500,  300,  UPXDNY, 10, 0x04, 0x04,
		500,  300,  DNXUPY, 10, 0x08, 0x08,
		500,  310,  UPXDNY, 10, 0x10, 0x10,
		500,  310,  DNXUPY, 10, 0x20, 0x20,
		500,  310,  DNXDNY, 10, 0x40, 0x40,
		500,  310,  UPXUPY, 10, 0x80, 0x80,
		500,  300,  DNXDNY, 10, 0x00, 0x01,
		500,  300,  UPXDNY, 10, 0x00, 0x02,
		500,  300,  UPXDNY, 10, 0x00, 0x04,
		500,  300,  DNXUPY, 10, 0x00, 0x08,
		500,  310,  UPXDNY, 10, 0x00, 0x10,
		500,  310,  DNXUPY, 10, 0x00, 0x20,
		500,  310,  DNXDNY, 10, 0x00, 0x40,
		500,  310,  UPXUPY, 10, 0x00, 0x80,
		-1,   0,      0,  0, 0
		};

main(){
	register struct ball *bp;
	register struct clrt *tp;
	register i;

	printf("\033G18888~");
/*
 * set up the hierarchical color table
 */
	tp = &clrt[0];
	for(i=0; i<256; i++){
	 putchar('K');
	 putchar(i);
	 putchar(1);
	 putchar(tp->r);
	 putchar(tp->g);
	 putchar(tp->b);
	 tp++;
	}

	while(1){
	 bp = &ball[0];
	 while(bp->x >= 0){
	  next(bp);
	 bp++;
	 }
	}
}	 

next(bp)
register struct ball *bp;
{
	 switch(bp->dir){
	  case UPXUPY:
	   if((bp->y+bp->idx)>=TOP){
	    bp->dir = UPXDNY;
	    break;
	   }
	   if((bp->x+bp->idx)>=RIGHT){
	    bp->dir =DNXUPY;
	    break;
	   }
	  bp->x += bp->idx; bp->y += bp->idx;
	  rec(bp->x,bp->y,bp->clr,bp->mask);
	  break;

	  case UPXDNY:
	   if((bp->x+bp->idx)>=RIGHT){
	    bp->dir = DNXDNY;
	    break;
	   }
	   if((bp->y-bp->idx)<=BOT){
	    bp->dir = UPXUPY;
	    break;
	   }
	   bp->x += bp->idx; bp->y -= bp->idx;
	   rec(bp->x,bp->y,bp->clr,bp->mask);
	   break;

	  case DNXUPY:
	   if((bp->x-bp->idx)<=LEFT){
	    bp->dir = UPXUPY;
	    break;
	   }
	   if((bp->y+bp->idx)>=TOP){
	    bp->dir = DNXDNY;
	    break;
	   }
	   bp->x -= bp->idx; bp->y += bp->idx;
	   rec(bp->x,bp->y,bp->clr,bp->mask);
	   break;

	  case DNXDNY:
	   if((bp->x-bp->idx)<=LEFT){
	    bp->dir = UPXDNY;
	    break;
	   }
	   if((bp->y-bp->idx)<=BOT){
	    bp->dir = DNXUPY;
	    break;
	   }
	   bp->x -= bp->idx; bp->y -= bp->idx;
	   rec(bp->x,bp->y,bp->clr,bp->mask);
	   break;
	 }
}

char	c;
rec(x,y,clr,mask){
	register unsigned xyh,xyl;
	xyh = (x&0xf00)<<4;
	xyh |= (y&0xf00);
	xyh |= 'Q';
	xyl = (((y&0xff)<<8)|(x&0xff));
	putw(xyh,stdout);
	putw(xyl,stdout);
	if(++c == 7) c = 1;
	if(clr>=0){
	 putw((mask<<8)|'L',stdout);
	 putw((clr<<8)|'C',stdout);
	}
	else
	 putw((c<<8)|'C',stdout);
	putchar(',');
	putw((16<<8)|16,stdout);
}
                                                                                                                                   
