   \ZORAN\VEXAMPLE\FORPACK.FOR                                                                                               C === FORPACK.FOR: FORTRAN subroutines for Example 4
C     Subroutines in this module are called from EXAMPLE4.C
C     Last edit 3/1/86 JJC

C --- SQRWAV: Generate a square wave in external memory
      SUBROUTINE SQRWAV(IEXTMEM)
      INTEGER*2 IEXTMEM(1)
      DO 100 I=1,64
      IX=2*I-1
C     *** Generate a square wave of maximum amplitude                   
      IF (I.LT.33) IEXTMEM(IX)=16384
      IF (I.GE.33) IEXTMEM(IX)=-16384
      IEXTMEM(2*I)=0
 100  CONTINUE
C     *** Set the endpoint values of the square wave                  
      IEXTMEM(1)=0
      IEXTMEM(64)=0
      END


C --- OUTFFT: Print the VSP FFT results
      SUBROUTINE OUTFFT(IEXTMEM)
      INTEGER*2 IEXTMEM(1)
      DO 100 I=1,64
      IX=2*I+127
      WRITE(*,50) I-1, IEXTMEM(IX), I-1, IEXTMEM(IX+1)
 50   FORMAT( ' real(' ,I6, ')=',I6,'  ,imag(',I6,')=',I6)
 100  CONTINUE
      END


C --- OUTPWR: Print the VSP power spectrum results
      SUBROUTINE OUTPWR(IEXTMEM)
      INTEGER*2 IEXTMEM(1)
      DO 100 I=1,64
      IX=2*I+255
      WRITE(*, 50) I-1, IEXTMEM(IX)
 50   FORMAT( ' magnitude of bin ',I6, '=', I6)
 100  CONTINUE
      WRITE(*, 150)
C     *** this final print statement forces the output out to the terminal
 150  FORMAT( ' ')
      END
