   \ZORAN\VM\FFP.H                                                                                                           /*+ .sh 2 "ffp.h 1.24 3/18/86"                                                      */
/**/


#include "sys.h"


#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "condcodes.h"
#include "nmffps.h"

#define zrglobpi 3.14159265358979323844
char *realloc();
char *zrmalloc();
char *strcat(),*strcpy();

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #include <stdio.h>                                                       */
/*+ #include <math.h>                                                        */
/*+ #include <ctype.h>                                                       */
/*+ #include "condcodes.h"                                                   */
/*+ #include "nmffps.h"                                                      */
/*+                                                                          */
/*+ char *realloc();                                                         */
/*+ char *zrmalloc();                                                        */
/*+ char *strcat(),*strcpy();                                                */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ This is the main header file included in all VSP simulator               */
/*+ code and in VSP user programs. It contains data elements                 */
/*+ common to many or most VSP subroutines.                                  */
/*+                                                                          */
/*+                                                                          */
/*+                                                                          */
/*+ .sh 3 "typedef's for Portability"                                         */
/*+                                                                          */
/*+ #define zrrdef 1                                                         */
/*+ #define zrlongtm 32767                                                   */
/*+ #define zrffpcld 1                                                       */
/*+ .(l                                                                      */
/*+ typedef int mlong;                                                       */
/*+ typedef short int mshort;                                                */
/*+ typedef short unsigned mushort;                                          */
/*+ typedef unsigned int mulong;                                             */
/*+ .)l                                                                      */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The compile time flag 'zrrdef' inhibits redeclaration of                 */
/*+ the variables used for defering instructions in VSP language             */
/*+ output (the C output from the VSP parser.) 'zrlongtm' is                 */
/*+ a define used as a parameter for clock count that insures                */
/*+ simulated instructions will complete execution. If the                   */
/*+ parameter were too small the instruction simulation will                 */
/*+ stop after the specified number of clocks.                               */
/*+ The above typedef's are used to ease porting the simulator to            */
/*+ different hosts. 'mlong' and 'mulong' must both be 32 bits or            */
/*+ more. 'mshort' and 'mushort' must both be 16 bits.                       */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define zrrdef 1
#define zrlongtm 32767
#ifndef zrffpcld
#define zrffpcld 1
#if (zrsys == zrunix) || (zrsys == zrvms)
typedef int mlong;
typedef short int mshort;
typedef short unsigned mushort;
typedef unsigned int mulong;
#endif
#if (zrsys == zrmsdos)
typedef long int mlong;
typedef int mshort;
typedef unsigned mushort;
typedef unsigned long int mulong;
#endif
#endif

#if (zrsys==zrunix) || (zrsys == zrvms)
#define zrexmax 65536
#endif
#if zrsys==zrmsdos
#define zrexmax 16384
#endif
#define zrexmaxi 1048575
#define zrgptr &zrglobbuf[0]
#define zrpage 22

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+ .sh 3 "Defines Used in Accessing and Displaying Memory"                  */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #define zrrombs 1                                                        */
/*+ #define zrfmembs 2                                                       */
/*+ #define zremembs 3                                                       */
/*+ #define zrzerst 4                                                        */
/*+ #define zrlits 8                                                         */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The above defines are used in the routines: 'zrcmxstr',                  */
/*+ \'zrcmxstri', 'zrdumpval', 'zrdumpvali' and 'zrgetopnd' in 'ffputi.c'.   */
/*+ These routines have a common calling sequence which include the          */
/*+ addresses for the result and for two operands.                           */
/*+ They have the following meanings: 1 - the first operand is in ROM,       */
/*+ 2 - both operands are in FFP internal memory, 3 - the first operand      */
/*+ is in external memory, 4 - the result is forced to be zero (this         */
/*+ options and the next is only used in zrcmxstr.                           */
/*+ 8 - is used only in zrcmxstr and indicates that a literal                */
/*+ value is to be stored.                                                   */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define zrrombs 1  /* One operand in ROM */
#define zrfmembs 2 /* Both operands in FFP memory */
#define zremembs 3 /* One operand in external memory */
#define zrzerst 4  /* Zero memory */
#define zrlits 8   /* Literal Store */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Defines For VSP Registers"                                        */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ There are a large number of defines for VSP registers.                   */
/*+ These are listed below:                                                  */
/*+                                                                          */
/*+ .in +4                                                                   */
/*+ zrcycmem  (zrminter->datmem[274]) - this is used to hold the             */
/*+ value used for CYCMEM. This is separate from the field in                */
/*+ the mode register. The contents of that field must be used               */
/*+ to update this value whenever the mode register is udated.               */
/*+                                                                          */
/*+ zrifetch  265                                                            */
/*+ .br                                                                      */
/*+ zrzrafetch zrminter->datmem[zrifetch] - this is the                      */
/*+ fetch register inside the VSP.                                           */
/*+                                                                          */
/*+ zriwfetch 264                                                            */
/*+ .br                                                                      */
/*+ zrzrradr zrminter->datmem[zriwfetch] - this is the actual                */
/*+ address used for fetching. It may be different from 'zrzrafetch'         */
/*+ in that 'zrzrafetch' should always agree with the fetch register         */
/*+ in the actual chip. When we are not modeling the hardware                */
/*+ queue 'zrzrradr' will differ from 'zrzrafetch'.                          */
/*+                                                                          */
/*+ zromaxsc  263                                                            */
/*+ .br                                                                      */
/*+ zruomaxsc zrminter->datmem[zromaxsc] - the old max scale                 */
/*+ register in the VSP.                                                     */
/*+                                                                          */
/*+ zriustatus  266                                                          */
/*+ .br                                                                      */
/*+ zrustatus zrminter->datmem[zriustatus] - the status register in the VSP. */
/*+                                                                          */
/*+ zriumaxsc  267                                                           */
/*+ .br                                                                      */
/*+ zrumaxsc  zrminter->datmem[zriumaxsc] - max scale register in the VSP.   */
/*+                                                                          */
/*+ zriuscale  268                                                           */
/*+ .br                                                                      */
/*+ zruscale  zrminter->datmem[zriuscale] - scale register iv VSP.           */
/*+                                                                          */
/*+                                                                          */
/*+ zriuiamsb  269                                                           */
/*+ .br                                                                      */
/*+ zruiamsb  zrminter->datmem[zriuiamsb] - most significant
/*+ bits of imaginary accumlator for VSP16 BFP.                              */ 
/*+                                                                          */
/*+ zriuialsb  270                                                           */
/*+ .br                                                                      */
/*+ zruialsb  zrminter->datmem[zriuialsb] - least                            */
/*+ significant bits of imaginary                                            */
/*+ accumlator for VSP16 FP.                                                 */
/*+                                                                          */
/*+ zriuramsb  271                                                           */
/*+ .br                                                                      */
/*+ zruramsb  zrminter->datmem[zriuramsb] - most significant bits of real    */
/*+ accumlator for VSP16 BFP.                                                */
/*+                                                                          */
/*+ zriuralsb  272                                                           */
/*+ .br                                                                      */
/*+ zruralsb  zrminter->datmem[zriuralsb] - least significant bits of real   */
/*+ accumlator for VSP16 BFP.                                                */
/*+                                                                          */
/*+ zriurmode  273                                                           */
/*+ .br                                                                      */
/*+ zrumode zrminter->datmem[zriurmode] - VSP mode register.                 */
/*+                                                                          */
/*+ zrlastscale (zrminter->datmem[276])	                                     */
/*+                                                                          */
/*+ zrixscl 280 - begining if 16 16 bit VSP scale registers.                 */
/*+                                                                          */
/*+ zriaccr 298                                                              */
/*+ .br                                                                      */
/*+ zraccrr (zrminter->datmem[zriaccr]) - real VSP16 BFP accumlator          */
/*+ before it is broken into parts to be read by user.                       */
/*+                                                                          */
/*+ zriacci 299                                                              */
/*+ .br                                                                      */
/*+ zraccir (zrminter->datmem[zriacci]) - imaginary VSP16 BFP                */
/*+ accumulator before it is broken into parts to be read by user.           */
/*+                                                                          */
/*+ zrrs0zrscl zrminter->datmem[300]                                         */
/*+ .br                                                                      */
/*+ zrrs1zrscl zrminter->datmem[301]                                         */
/*+ .br                                                                      */
/*+ zrnrs0zrscl zrminter->datmem[302]                                        */
/*+ .br                                                                      */
/*+ zrnrs1zrscl zrminter->datmem[303] - the above four locations are         */
/*+ the overflow flags for each RAM section. The first two are for           */
/*+ the previous step and are used to access data. The next two              */
/*+ are set by the current instruction and used by the next one.             */
/*+                                                                          */
/*+ zrstsnms zrminter->datmem[304] - this indicates the number of            */
/*+ RAM sections and must be set whenever the mode register is change.       */
/*+ 0 corresponds to two RAM sections and 1 corresponds to 1 RAM section.    */
/*+                                                                          */
/*+ zrsclstn zrminter->datmem[305] - this is the modulo four counter         */
/*+ used in the FFT instruction to store the next scale nibble.              */
/*+                                                                          */
/*+ zrd3si zrminter->datmem[306] - indicates three word instructions         */
/*+ this must be set whenever the mode is change.                            */
/*+                                                                          */
/*+ zrrdins zrminter->datmem[307] - this set when instruction fetch is       */
/*+ active.                                                                  */
/*+                                                                          */
/*+ zrdefadr zrminter->datmem[308] - this is the adress to which instructions*/
/*+ are deferred.                                                            */
/*+                                                                          */
/*+ zrFRZ zrminter->datmem[310] - this is set for shadow mode when           */
/*+ instrucions are not fetched from data space. It must be updated          */
/*+ whenever the mode is changed.                                            */
/*+                                                                          */
/*+ zrminter->datmem[311] - this no longer used it is availible.             */
/*+                                                                          */
/*+                                                                          */
/*+ zrsclflgi zrminter->datmem[312] - scale flags for vsp32 BFP.             */
/*+                                                                          */
/*+ zrxsclptr zrminter->datmem[313] - pointer used by the SW field in the    */
/*+ FFT instruction in the vsp32 when it writes to scale RAM.                */
/*+                                                                          */
/*+ zrmaxaddi 314                                                            */
/*+ zrmaxaddreg zrminter->datmem[314]                                        */
/*+ */
/*+ zrbaseaddi 315  */
/*+ zrbaseaddreg zrminter->datmem[ zrbaseaddi ] */
/*+                                                                          */
/*+ 316 - next location availible.                                           */
/*+ zriaccri 260                                                             */
/*+                                                                          */
/*+                                                                          */
/*+ .br                                                                      */
/*+ zraccrri (zrminter->memi[zriaccri]) - imaginary accumlator               */
/*+ for 32 BFP VSP.                                                          */
/*+                                                                          */
/*+ zriaccii 261                                                             */
/*+ .br                                                                      */
/*+ zracciri (zrminter->memi[zriaccii]) - real accumlator for 32 BFP VSP.    */
/*+                                                                          */
/*+ zrmaxvali 262 - last location availible in the floating point            */
/*+ array of registers for the 32 bit VSP parallel registers.                */
/*+                                                                          */
/*+ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
#define zrcycmem   (zrminter->datmem[274])
#define zrifetch   265
#define zrzrafetch zrminter->datmem[zrifetch] 
#define zriwfetch  264
#define zrzrradr zrminter->datmem[zriwfetch]
#define zromaxsc   263
#define zruomaxsc zrminter->datmem[zromaxsc]
#define zriustatus 266
#define zrustatus zrminter->datmem[zriustatus]
#define zriumaxsc  267
#define zrumaxsc  zrminter->datmem[zriumaxsc]
#define zriuscale  268
#define zruscale  zrminter->datmem[zriuscale]
#define zriuiamsb  269
#define zruiamsb  zrminter->datmem[zriuiamsb]
#define zriuialsb  270
#define zruialsb  zrminter->datmem[zriuialsb]
#define zriuramsb  271
#define zruramsb  zrminter->datmem[zriuramsb]
#define zriuralsb  272
#define zruralsb  zrminter->datmem[zriuralsb]
#define zriurmode  273
#define zrumode	zrminter->datmem[zriurmode]
#define zrlastscale (zrminter->datmem[276])		   
#define zrixscl 280 /* beginning of ffp scale registers */
#define zriaccr 298
#define zraccrr (zrminter->datmem[zriaccr])
#define zriacci 299
#define zraccir (zrminter->datmem[zriacci])
#define zrrs0zrscl zrminter->datmem[300]
#define zrrs1zrscl zrminter->datmem[301]
#define zrnrs0zrscl zrminter->datmem[302]
#define zrnrs1zrscl zrminter->datmem[303]
#define zrstsnms zrminter->datmem[304]
#define zrsclstn zrminter->datmem[305]
/* int rs0scl,rs1scl;  scale or overflow vectors for FFP ram sections */
/* int nrs0scl,nrs1scl; overflow flags for next pass */
/* int stsnms;    0 indicates two ram sections, 1 indicates 1 ram section */
/* int sclstn; Modulo four counter indicating which nibble scale value is stored to */
#define zrd3si zrminter->datmem[306]
#define zrrdins zrminter->datmem[307]
#define zrdefadr zrminter->datmem[308]
#define zrFRZ zrminter->datmem[310]
/* int zrds3i;  flag indicating dump 3 word instructions always */
/* int zrrdins; flag indicating we are reading instructions */
/* mlong zrdefadr; */
/* int zrdefer; */
/*  scale flags for vsp32	*/
#define zrsclflgi zrminter->datmem[312]
/* zrxsclptr is the pointer used by the SW field in the 
	FFT instruction in the vsp32 when it writes to scale ram */
#define zrxsclptr zrminter->datmem[313]
#define zrmaxaddi 314
#define zrmaxaddreg zrminter->datmem[314]
#define zrbaseadd0 315
#define zrbaseaddreg0 zrminter->datmem[ zrbaseadd0 ]
#define zrbaseadd1 316
#define zrbaseaddreg1 zrminter->datmem[ zrbaseadd1 ]
#define zrloopcount 317
#define zrloopcounter zrminter->datmem[ zrloopcount ]
/* 318 next location availible */


#if cki&2
#define zriaccri 260
#define zraccrri (zrminter->memi[zriaccri])
#define zriaccii 261
#define zracciri (zrminter->memi[zriaccii])
#define zrmaxvali 262
#define zrmaxvalreg (zrminter->memi[zrmaxvali])
#endif

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Defines for Message Levels"                                       */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #define zrverbose 1                                                      */
/*+ mshort zrmdbgflg;                                                        */
/*+ #define zrdbgtst if (zrmdbgflg&1)                                        */
/*+ #define zrdumpdisk (zrmdbgflg&32)                                        */
/*+ int zrprtline;                                                           */
/*+ mshort zrdbgreal;                                                        */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The above defines are used to control message level. 'zrverbose'         */
/*+ is a compile time switch which can disable the message level             */
/*+ 3 output. Clearing this option has never been tested and                 */
/*+ this should probably not be used as an option. 'zrmdbgflg' is            */
/*+ a word of bit flags used to control message levels and                   */
/*+ options. 'zrdbgtst' is the test for level 3 messages.                    */
/*+ Meanings of other bits in 'zrmdbgflg' are: &2 - display instruction      */
/*+ and source code line number (set message level 2 and 3). &4 - wait       */
/*+ for message level menu selection at each instrucion, &8 - display timing */
/*+ information. &16 - enable timing computation                             */
/*+ (this must be set in addition to &8) for timing to be displayed.         */
/*+ The default is &16 set and &8 clear. &32 - provide disk dump of          */
/*+ instructions and character based plots. 'zrprtline' enables              */
/*+ display of the source code line number and file name from                */
/*+ which a given VSP instruction originated.                                */
/*+ \'zrdbgreal' is a flag which controls the data output                    */
/*+ format. Values it can take on are: 0 - decimal integer,                  */
/*+ 1 - real fractions, 2 - hexadecimal integers, 3 - binary integers.       */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define zrverbose 1
#define zrdbgtst if (zrmdbgflg&1) 
#define zrdumpdisk (zrmdbgflg&32)

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "zrdum: Widely Used Temporary Global"                              */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ mlong zrdum;                                                             */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ This variable is used for temporary storage usually for inputting        */
/*+ parameters in a number of routines.                                      */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Defines Used For Simulating Integer Arithmetic"                   */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #define zrdvfac17 131072                                                 */
/*+ #define zrdvfac20 1048576                                                */
/*+ #define zrdvfac26 67108864                                               */
/*+ #define zrdvfac16 65536                                                  */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ These defines are used in doing the rounding                             */
/*+ to simulate intefer arithmetic.                                          */
/*+ They are various integer powers or 2. They used in calls                 */
/*+ to 'zrffpmod' contained in 'ffputi.c'.                                   */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define zrdvfac17 131072
#define zrdvfac20 1048576
#define zrdvfac26 67108864
#define zrdvfac16 65536



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "STATUS and MODE Register Fields"                                  */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ Masks for all the fields in the modes and STATUS                         */
/*+ registers are defined with same names as used in the VSP                 */
/*+ engineering specification. In addition                                   */
/*+ there is a shift distance defined for the CYCMEM field called: SCYCMEM.  */
/*+ Following are the mode register defines:                                 */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #define RST          0x8000                                              */
/*+ #define RSS          0x4000                                              */
/*+ #define SYN          0x2000                                              */
/*+ #define NCS          0x1000                                              */
/*+ #define NMS          0x0800                                              */
/*+ #define TST          0x0400                                              */
/*+ #define CRQ          0x0200                                              */
/*+ #define FRZ          0x0100                                              */
/*+ #define INL          0x0080                                              */
/*+ #define CYCMEM       0x0070                                              */
/*+ #define IDO          0x0008                                              */
/*+ #define ICA          0x0004                                              */
/*+ #define ILI          0x0001                                              */
/*+ #define SCYCMEM      4                                                   */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ The  mode register fields for the 32 bit BFP simulator have similar      */
/*+ names. These fields all have an 'I' appended to their name.              */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #define RSTI	 0x08000*/
/*+ #define RSSI	 0x04000*/
/*+ #define SYNI	 0x02000*/
/*+ #define NCSI	 0x01000*/
/*+ #define NMSI	 0x00800*/
/*+ #define TSTI	 0x00400*/
/*+ #define CRQI	 0x00200*/
/*+ #define CYCMEMI	 0x001e0  */
/*+ #define IDOI	 0x00010  */
/*+ #define IRAI	 0x00008  */
/*+ #define IIAI	 0x00004  */
/*+ #define IFHI	 0x00002  */
/*+ #define IFOI	 0x00001  */
/*+ #define SCYCMEMI 5  */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ Both the ARINSCD and FIFOSTAT fields of the status                       */
/*+ register have shift distances defined for them.                          */
/*+ Following are DEFINEs for the STATUS register that differ                */
/*+ from those of the MODE register:                                         */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ +#define ARINSCD   0xF800                                                 */
/*+ #define MIC       0x0400                                                 */
/*+ #define FIFOSTAT  0x0380                                                 */
/*+ #define IMI       0x0020                                                 */
/*+ #define IAI       0x0010                                                 */
/*+ #define IFO       0x0001                                                 */
/*+ #define SARINSCD  11                                                     */
/*+ #define SFIFOSTAT  7                                                     */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ Following are the STATUS register fields for the 32 bit BFP machine      */
/*+ that differ from those in the mode register.                             */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ #define ARINSCDI 	0x7c000   */
/*+ #define MICI	0x03000   */
/*+ #define FIFOSTATI	0x00e00  */
/*+ #define IMII	0x00100  */
/*+ #define IAII	0x00080  */
/*+ #define ICII        0X00040  */
/*+ #define IFUI    	0x00020   */
/*+ #define SARINSCDI	14  */
/*+ #define SFIFOSTATI	9  */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* following are mode register fields */
#define RST 	 0x8000
#define RSS	 0x4000
#define SYN	 0x2000
#define NCS	 0x1000
#define	NMS	 0x0800
#define TST	 0x0400
#define CRQ	 0x0200
#define FRZ	 0x0100
#define INL      0x0080
#define CYCMEM	 0x0070
#define IDO	 0x0008  /* enable interrupt on overflow */
#define ICA	 0x0004
#define	ILI	 0x0002
#define ILO	 0x0001
#define SCYCMEM 4

/* These are the mode register definitions for the vsp32 */
#define RSTI	 0x08000
#define RSSI	 0x04000
#define SYNI	 0x02000
#define NCSI	 0x01000
#define	NMSI	 0x00800
#define TSTI	 0x00400
#define CRQI	 0x00200
#define CYCMEMI	 0x001e0
#define IDOI	 0x00010  /* enable interrupt on overflow */
#define IRAI	 0x00008  
#define IIAI	 0x00004
#define	IFHI	 0x00002
#define IFOI	 0x00001
#define SCYCMEMI 5

/* following are status register fields */
#define ARINSCD 	0xF800
#define MIC             0x0400
#define FIFOSTAT	0x0380
#define IMI		0x0020
#define IAI		0x0010
/* #define IDO	 	0x0008  defined above same as in mode */
/* #define ICA		0x0004  defined above same as in mode */
/* #define ILI		0x0002  defined above same as in mode */
#define IFO		0x0001
#define SARINSCD	11
#define SFIFOSTAT	7

/* These are the definitions for the vsp32 status register */
#define ARINSCDI 	0x7c000
#define MSI		0x03000
#define FIFOSTATI	0x00e00
#define IMII		0x00100
#define IAII		0x00080
#define ICII            0X00040
#define IFUI    	0x00020 
/* #define IDOI	 	0x00010  defined above same as in mode */
/* #define IRAI	 	0x00008  defined above same as in mode */
/* #define IIAI	 	0x00004 defined above same as in mode */
/* #define IFHI		0x00002  defined above same as in mode */
/* #define IFOI		0x00001 defined above same as in mode */
#define SARINSCDI	14  /* no of bits to shift no. to put in ARINSCD */
#define SFIFOSTATI	9

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Function Declarations"                                            */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ mlong zrffpmod ();                                                       */
/*+ mlong zrffpmmod();                                                       */
/*+ mlong zrffpamod();                                                       */
/*+ mlong zrsffpmod();                                                       */
/*+ mshort zrgetshort();                                                     */
/*+ mlong zrgetlong();                                                       */
/*+ mlong zrfrnd();                                                          */
/*+ mlong zrdsum();                                                          */
/*+ mlong zrcmem();                                                          */
/*+ char *zrgetname();                                                       */
/*+ struct zrinsdes *zrinsdump();                                            */
/*+ char *zrmygetname();                                                     */
/*+ char *zrmalloc();                                                        */
/*+ char *zrmalloc();                                                        */
/*+ mlong zrcmpfa();                                                         */
/*+ char *zregets();                                                         */
/*+                                                                          */
/*+ #if cki&2                                                                */
/*+ double zrgetrami();                                                      */
/*+ double zrtestaddi();                                                     */
/*+ double zrtrni();                                                         */
/*+ double zrunbtrni();                                                      */
/*+ double zrmemtypi();                                                      */
/*+ double zrmulti();                                                        */
/*+ #endif                                                                   */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The above are declarations for various widely used functions             */
/*+ that return a type other than integer. Those routines in the             */
/*+ conditional compilation are only used in the 32 bit BFP simulator.       */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
mlong zrffpmod ();
mlong zrffpmmod();
mlong zrffpamod();
mlong zrsffpmod();
mshort zrgetshort();
mlong zrgetlong();
mlong zrfrnd();
mlong zrdsum();  /* routine to sum FFP accumlator values in FFP RAM */
mlong zrcmem();
char *zrgetname();
struct zrinsdes *zrinsdump();
char *zrmygetname();
char *zrmalloc();
char *zrmalloc();
mlong zrcmpfa();
char *zregets();

#if cki&2
double zrgetrami();
double zrtestaddi();
double zrtrni();
double zrunbtrni();
double zrmemtypi();
double zrmulti();
#endif



#ifdef zrdec 

mshort zrmdbgflg;
int zrprtline; /* flag to print line and file for code */
mshort zrdbgreal;
mlong zrdum;
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Clock Related Declarations"                                       */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ mlong zrclocktick,zrinstcnt,zrextsec,zrclockns;                          */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The following declarations five a count of the total cumulative          */
/*+ clocks, 'zrclocktick', the instruction count, 'zrinstcnt', the           */
/*+ number of clocks for each external memory access 'zrextsec' and          */
/*+ the cummulative clock time including a 5% overhead 'zrclockns'.          */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
mlong zrclocktick,zrinstcnt,zrextsec,zrclockns;
/* clocktick and instcnt are current clock and instruction count,*/
/*	extsec is number of clocks for external ram access,*/
/*	clockns is clock time in ns.  */


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "zrsffpint: Model of Internal Memory"                              */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ struct zrsffpint {                                                       */
/*+ mlong datmem[400];                                                       */
/*+ double *memi;                                                            */
/*+ mlong *romem;                                                            */
/*+ double *romemi;                                                          */
/*+ } *zrffpint[zrmaxffps];                                                  */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ This data structure descrives the internal memory. 'datmem' is           */
/*+ used for the internal RAM and various other internal registers           */
/*+ as described later in this file. 'memi' is used for internal             */
/*+ register in the 32 bit BFP chip that are more than 32 bits.              */
/*+ This includes all of the internal RAM. 'romem' and 'romemi' are          */
/*+ the ROM coefficeints for the 16 and 32 bit BFP simulators                */
/*+ respectively. A pointer to this structure is defined for each VSP.       */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
struct zrsffpint {
	mlong datmem[400];
	double *memi;
	mlong *romem;
	double *romemi;
	/* # THIS DESCRIBES THE INTERNAL REGISTERS OF 1 FFP */
} *zrffpint[zrmaxffps];
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Structures and Defines for Modeling External Memory"              */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ struct zrsffpext{                                                        */
/*+ mshort *exmem;                                                           */
/*+ } zrffpext;                                                              */
/*+                                                                          */
/*+ struct zriffpext{                                                        */
/*+ mlong *exmem;                                                            */
/*+ } zrffpexti;                                                             */
/*+                                                                          */
/*+ struct {                                                                 */
/*+ mshort ar[2049];                                                         */
/*+ } zrauxptr;                                                              */
/*+                                                                          */
/*+ struct zrsffpsys {                                                       */
/*+ struct zrsffpint *inter;                                                 */
/*+ struct zrsffpext *exter;                                                 */
/*+ mshort *auxer ;                                                          */
/*+ } zrfps;                                                                 */
/*+                                                                          */
/*+ struct zrsffpint *zrminter;                                              */
/*+ struct zrsffpext *zrmexter;                                              */
/*+ struct zriffpext *zrimexter;                                             */
/*+ struct zrfffpext *zrfmexter;                                             */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The above defines 'zrexmax' and 'zrexmaxi' give the upper limits         */
/*+ on external memory addresses for the 16 and 32 BFP chips                 */
/*+ respectively. 'zrsffpext' and 'zriffpext' contain pointers to            */
/*+ the external memory for the two simulators. 'zrauxptr.ar' is             */
/*+ an array of indicies used for doing bit reversal. See 'bitrev.c'         */
/*+ for that data stored in this array. 'zrffpsys' collects all the          */
/*+ information for one VSP in a single structure. This is setyp             */
/*+ but not used in the current simulator. 'zrminter' is the                 */
/*+ pointer for internal memory of the currently executing VSP. 'zrmexter'   */
/*+ is the pointer to external memory. 'zrimexter' and 'zrfmexter' are       */
/*+ the pointers for the 32 BFP and floating point simulators.               */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
struct zrsffpext{
	mshort *exmem;
} zrffpext;

struct zriffpext{
	mlong *exmem;
} zrffpexti;

struct zrfffpext{
	double *exmem;
} zrffpextf;

struct {
	mshort ar[2049];
} zrauxptr;


struct zrsffpsys {
	struct zrsffpint *inter;
	struct zrsffpext *exter;
	mshort *auxer ;
} zrfps;

struct zrsffpint *zrminter;
struct zrsffpext *zrmexter;
struct zriffpext *zrimexter;
struct zrfffpext *zrfmexter;



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Declarations Associated with I/O"                                 */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ FILE *zrdiskout;                                                         */
/*+ FILE *zrdsyiout;                                                         */
/*+                                                                          */
/*+ struct zrfild {                                                          */
/*+ FILE *zrfil;                                                             */
/*+ char *zrname;                                                            */
/*+ char zrlbuf[150];                                                        */
/*+ int zrline;                                                              */
/*+ int zrflags;                                                             */
/*+ char zrsvchr;                                                            */
/*+ };                                                                       */
/*+                                                                          */
/*+integer zrdefer;*/
/*+ char zrglobbuf[120];                                                     */
/*+ char *zrfnm;                                                             */
/*+ int zrfldmpfg;                                                           */
/*+ mlong zrinsmema;                                                         */
/*+ char zrdodsyins;                                                         */
/*+ char *zrmsgprefix;                                                       */
/*+ char zrmsar[40];                                                         */
/*+                                                                          */
/*+ int zrdmterm;                                                            */
/*+                                                                          */
/*+ struct zrfild *zrsigin;                                                  */
/*+ int zrsigmsg;                                                            */
/*+                                                                          */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ The file for disk output of instructions and character plots             */
/*+ is 'zrdiskout'. The file for used for DAISY dumps is 'zrdsyiout'.        */
/*+ A special file structure 'zrfil' is declared for input to the            */
/*+ validation software. The fields are 'zrfil' which is the system          */
/*+ file desscriptor, 'zrname' which is the file name, 'zrlbuf'              */
/*+ which is a line buffer, 'zrline' which is the current input              */
/*+ line number 'zrflags' which is a word of flags and 'zrsvchr'             */
/*+ which is used to 'unget' a character. Currently 'zrflags' is             */
/*+ set in 'zrmopen' (in 'valdte.c'). The only use is for the                */
/*+ VISIBLE option in the validation software.                               */
/*+                                                                          */
/*+ .pp                                                                      */
/*+The variable 'zrdefer' indicates if instructions are deferred.*/
/*+ The character array 'zrglobbuf' is used through the define 'zrgptr'      */
/*+ in generating the data written to 'zrdiskout'. Data is first             */
/*+ written to this character array and then output to the terminal          */
/*+ and file 'zrdiskout' by calling 'zrmyprintf' in 'ckmsg.c'. 'zrfnm'       */
/*+ is the name of the file written to by 'zrmyprintf'. 'zrfldmpfg'          */
/*+ enables display of help file names before they are displayed.            */
/*+ This is useful for determing which file needs to be                      */
/*+ edited. 'zrpage' is the number of lines in a page. This is               */
/*+ used in displaying help files.                                           */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ Daisy instruction dump is controlled by 'zrinsmema' which                */
/*+ is the next address to write instructions to and 'zrdodsyins'            */
/*+ which is the flag which enables and disables Daisy instruction           */
/*+ dump.                                                                    */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ \'zrmsgprefix' points to 'zrmsar'                                        */
/*+ and contains the prefix for the system files. This includes              */
/*+ the  help files and various data files used by the signal                */
/*+ processing and applications libraries. 'zrdmterm' is a flag              */
/*+ that disables all special screen control characters. It is               */
/*+ set to allow operating with any kind of terminal. 'zrsigin'              */
/*+ is the file used to redirect input for operations like                   */
/*+ signal generation when the validation mode is being used.                */
/*+ The flag 'zrsigmsg' causes input to be redirected from                   */
/*+ a file when the validation software is used.                             */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
FILE *zrdiskout;
FILE *zrdsyiout; /* file for instruction to daisy */
struct zrfild {
FILE *zrfil;
char *zrname;
char zrlbuf[150];
int zrline;
int zrflags;
char zrsvchr;
};
int zrdefer;
char zrglobbuf[120];
char *zrfnm;
int zrfldmpfg;
mlong zrinsmema; /* address to write next instruction to for daisy output */
char zrdodsyins;	/* flag for outputting daisy instructions */
char *zrmsgprefix;
char zrmsar[40];

int zrdmterm; /* flag for dumb terminal */
struct zrfild *zrsigin; /* file for reading signal parameters */
int zrsigmsg; /* flag for reading input froma validation files
		0 - from terminal
		1 - from file
	      */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*+                                                                          */
/*+ .sh 3 "Various Miscellaneous Defines and Declarations"                   */
/*+                                                                          */
/*+ .(l                                                                      */
/*+ mlong zrcklf;                                                            */
/*+ mlong zrbsus;                                                            */
/*+ int zrcffp;                                                              */
/*+ int zrffpdef;                                                            */
/*+ mlong zrmaxext;                                                          */
/*+ int zrsmaxffp;                                                           */
/*+ char zrtypeflg;                                                          */
/*+ int (*zrprcint)();                                                       */
/*+ #define zrglobpi 3.141592654                                             */
/*+ .)l                                                                      */
/*+                                                                          */
/*+ .pp                                                                      */
/*+ \'zrcklf' is a                                                           */
/*+ flag whcih indicates that a user break point has been set. 'zrbsus'      */
/*+ is the count of bus cycle usage. 'zrcffp' is the current VSP             */
/*+ being simulated. 'zrmaxext' contiain the number of words of              */
/*+ external memory currently availible. 'zrsmaxffp' contains                */
/*+ the maximum number of VSPs availible. 'zrtypeflg' determines             */
/*+ the current simulator type 's' indicates the 16 bit simulator            */
/*+ and anything else is the 32 bit simulator. 'zrprcint' is                 */
/*+ the pointer for a user interrupt routine. If this is set                 */
/*+ and unmasked interrupt occurs the routine at that location               */
/*+ will be called. If unmaked interrupt occurs and 'zrprcint' is            */
/*+ NULL then an error message will be displayed. 'zrglobpi' is PI.          */
/*+                                                                          */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
mlong zrcklf;
mlong zrbsus;
	/* when positive zrcklf = clocks to execute before break */
	/* zrbsus = bus cycle count */

int zrcffp;  	     /* index of FFP currently being simulated */

int zrffpdef; /* default ffp in compiler */

mlong zrmaxext; /* maximum external memory being simulated */
int zrsmaxffp;  /* maximum number of ffps being simulated */

char zrtypeflg;
int (*zrprcint)(); /* user settable pointer to a procedure for */
		/* processing interrupts */






#else

extern struct zrsffpint {
	mlong datmem[400];
	double *memi;
	mlong *romem;
	double *romemi;
	/* # THIS DESCRIBES THE INTERNAL REGISTERS OF 1 FFP */
} *zrffpint[];

extern struct zrsffpext{
	mshort *exmem;
} zrffpext;

extern struct zriffpext{
	mlong *exmem;
} zrffpexti;

extern struct zrfffpext{
	double *exmem;
} zrffpextf;

extern struct {
	mshort ar[2049];
} zrauxptr;

extern struct zrsffpsys {
	struct zrsffpint *inter;
	struct zrsffpext *exter;
	mshort *auxer ;
} zrfps;

extern struct zrsffpint *zrminter;

extern struct zrsffpext *zrmexter;

extern struct zriffpext *zrimexter;

extern struct zrfffpext *zrfmexter;

extern mshort zrmdbgflg;

extern int zrprtline; /* flag to print line and file for code */

extern mshort zrdbgreal;

extern mlong zrdum;

extern mlong zrclocktick,zrinstcnt,zrextsec,zrclockns;

extern FILE *zrdiskout;

extern FILE *zrdsyiout; /* file for instruction to daisy */

extern struct zrfild {
FILE *zrfil;
char *zrname;
char zrlbuf[150];
int zrline;
int zrflags;
char zrsvchr;
};

extern int zrdefer;

extern char zrglobbuf[120];

extern char *zrfnm;

extern int zrfldmpfg;

extern mlong zrinsmema; /* address to write next instruction to for daisy output */

extern char zrdodsyins;	/* flag for outputting daisy instructions */
extern char *zrmsgprefix;
extern char zrmsar[40];

extern int zrdmterm; /* flag for dumb terminal */
extern struct zrfild *zrsigin; /* file for reading signal parameters */
extern int zrsigmsg; /* flag for reading input froma validation files
		0 - from terminal
		1 - from file
	      */

extern mlong zrcklf;
extern mlong zrbsus;
	/* when positive zrcklf = clocks to execute before break */
	/* zrbsus = bus cycle count */

extern int zrcffp;  	     /* index of FFP currently being simulated */

extern int zrffpdef; /* default ffp in compiler */

extern mlong zrmaxext; /* maximum external memory being simulated */
extern int zrsmaxffp;  /* maximum number of ffps being simulated */

extern char zrtypeflg;
extern int (*zrprcint)(); /* user settable pointer to a procedure for */
		/* processing interrupts */
#endif

