: TESTVSPE.BAT: Test MSDOS VSP-161 user simulator with VSPE board support.
: Runs on \ZORAN\VEXAMPLE and expects to find 'testvspe.inp', 'testvspe.tst',
: and user simulator EXAMPLE1.EXE (linked with VSPE support) there.
: Last edit 7/25/86 JJC
echo off
cls

echo ===== TESTVSPE: ZORAN USER SIMULATOR TEST WITH VSPE BOARD SUPPORT =====

: Check for required files
if exist example1.exe goto simexist
echo User simulator 'EXAMPLE1.EXE' not found
goto end

:simexist
if exist testvspe.inp goto inpexist
echo File 'TESTVSPE.INP' not found on this directory
goto end

:inpexist
if exist testvspe.tst goto tstexist
echo File 'TESTVSPE.TST' not found on this directory
goto end

:tstexist
echo   
echo                     -----  N O T E  -----
echo   
echo This test assumes user simulator 'EXAMPLE1.EXE' was linked with
echo VSPE board support (via 'CREATE EXAMPLE1 VSPE' or 'VL EXAMPLE1 VSPE').
echo   
echo       The test will run automatically for several minutes.
echo   
echo             I G N O R E   S C R E E N   O U T P U T
echo   
echo                until "Test results:" appears.
echo   
pause   

echo   
echo Testing...

: Delete old validation results file, if any
if exist testvspe.err del testvspe.err

: Bring up user simulator and submit installation test input file
example1 < testvspe.inp

: Rename results so user sees it's okay to delete them
rename valdte.err testvspe.err

: Display results
cls
echo ===== TESTVSPE: ZORAN USER SIMULATOR TEST WITH VSPE BOARD SUPPORT =====
echo Test results:
echo   
echo ---------------------------------------
type testvspe.err
echo ---------------------------------------

:end
