# xnfprep.ml created 1994/05/11 15:27:23
# 
# DO NOT EDIT THIS FILE!  It is derived from other files.
#
# ------------------ alert.m ------------------ 
#
#@(#)alert.m	6.1  12/2/92


B ALERT
: Error condition alert system

#
# These messages are used as alert pre/postfixes
#
M CANNOT_CONTINUE
: Execution cannot continue until this error is fixed
M TERMINATE
> theProgram s
> theStatus s
: [theProgram] was terminated with a [theStatus] status

E ALERT
#
# ------------------ feature.m ------------------ 
#
# @(#)feature.m	6.3 9/3/93


B FEATURE -start1051 -end1100 -current1082
: Feature License Manager

#
# Nasty Low-Level Error Messages
#
M UNKNOWN_ERROR -e1051
> feature s
: License checkout for feature "[feature]" failed[.br]
: because of some, unknown error condition.  
: Please contact your system administrator for help.
M OS_ERROR -e1052
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level or operating system error ([errtext]).
: Please contact your system administrator for help.
M BAD_SERVER_DATA_ERROR -e1053
> feature s
: License checkout for feature "[feature]" failed[.br]
: because invalid data was returned from the license server .
: Please contact your system administrator for help.
M READ_SERVER_ERROR -e1054
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot read from the servers listed in the license data 
: file.  Please contact your system adminstrator for help.
M WRITE_SERVER_ERROR -e1055
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot write to the servers listed in the license data 
: file.  Please contact your system adminsitrator for help.
M SELECT_ROUTINE_ERROR -e1056
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] a call to an internal select routine failed.
: Please contact your system adminsitrator for help.
M BUSY_SERVER_ERROR -e1057
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] failed to connect to a majority of the servers listed in the
: license data file.  Please contact your system adminsitrator for help.
M CHECKIN_FEATURE_ERROR -e1058
> feature s
: License checkin for feature "[feature]" failed[.br]
: Don't worry, be happy.

#
# Possible User Errors
#
M NO_LICENSE_FILE_ERROR -e1059
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the license data file.
: The default location for this file is usually
: /usr/local/data/license.dat.  It may be placed elsewhere at your site, in 
: which case you must define the environmental variable LM_LICENSE_FILE to
: point to it.  Make sure you can access the file from the same shell you are
: trying to run the program.
M NO_FEATURE_ERROR -e1060
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the feature in the license data
: file.  If you have not yet called customer
: service to obtain the authorization codes for this feature please do so.  If
: you have obtained the codes, please make sure that you have added the codes
: to the license data file.
M LICENSES_EXHAUSTED_ERROR -e1061
> feature s
: License checkout for feature "[feature]" failed[.br]
: because all the valid licenses for the feature are currently in use.  
: Try again later.
M EXPIRED_AUTHCODE_ERROR -e1062
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the required license has expired.  
: Please call customer service to obtain a new license.
M UNSUPPORTED_VERSION_ERROR -e1063
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the license data file does not contain a feature of the required
: version number.  Please call custommer service to obtain a license for 
: the new version of the feature.
M NO_KEY_ERROR -e1064
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program could not find a valid Xilinx protection key
: on the parallel port of your computer.  
: Please make sure that the key is attached securely to the parallel port.
M TAMPERED_KEY_ERROR -e1065
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program detected an invalid Xilinx protection key
: on the parallel port of your computer.  
: The key's memory has been corrupted.  Please call customer service to
: obtain a new key.
M DEMO_EXPIRED_ERROR -e1066
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because your demo version of the [program] program has expired.
: Please contact customer service
: or your sales representative to purchase the software you have been
: using.
M TAMPERED_DATE_ERROR -e1067
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the current date on your computer is set to a time which is
: before the date when you last ran this program.   
: Please reset your computer's date to the current
: date and rerun the program.
M XACT_VARIABLE_ERROR -e1068
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the XACT environmental variable has not been defined.
: Use the SET XACT=value dos command 
: to define the location of the XACT software.
M INVALID_DATE_ERROR -e1069
> feature s
: License checkout for feature "[feature]" failed[.br]
: because line in the license data file line which describes the feature
: contains an invalid date.  See the file XACT\data\license.dat.  
: All dates must be of the form 
: DD-MMM-YYYY, where DD is an integer 0-31; MMM is the first three 
: letters of the (English) month name: JAN, FEB, MAR, APR, MAY, JUN, JUL,
: AUG, SEP, OCT, NOV, or DEC; and YYYY is an integer 1990-2118.
M LOLEVEL_ERROR -e1070
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level error ([errtext]).

#
# Possible Installation Errors
#
M MULT_FEATURE_ERROR -e1071
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected multiple occurences of FEATURE lines for the 
: feature in the license file.  A feature
: may appear only once in the license file for it to be valid.  Please remove
: one of the feature lines from the license file.
M LICENSE_FILE_SYNTAX_ERROR -e1072
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected a syntax error in the license date
: file.  Please make sure that you have 
: correctly entered the authorization codes which you obtained from customer 
: service.
M NO_SERVER_ERROR -e1073
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect to the network license server.  
: Please make sure that the lmgrd program is 
: currently running on the computers described as servers in the license data 
: file.
M NO_SERVICE_ERROR -e1074
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the program [program] could not find the TCP "license" service. 
: Make sure that the /etc/services file has
: the license service number defined in it, or add a socket number to the the
: SERVER line of the license data file.
M BAD_AUTHCODE_ERROR -e1075
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected an inconsistency in the authorization code on the
: feature line of the license data file.  
: Please make sure that you have correctly entered the authorization codes
: which you obtained from customer service.
M WRONG_HOST_ERROR -e1076
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the host listed in one of the
: server lines of the license data file.  
: Please make sure that the server information in the license data file is 
: correct.
M BAD_DATE_ERROR -e1077
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] found an invalid date in the license data file.  
: Please make sure that the date information in the
: license data file is correct.  The correct date format is DD-MMM-YY (for
: example 30-JUN-91).  In previous versions of the program, dates of the form
: DD-MMM-YYYY were acceptable, but they are no longer.  To make the correction,
: stop the license server, edit the license.dat file to remove the '19' from
: the year number of all features, restart the license server and rerun the 
: program.
M NO_SERVER_LINES_ERROR -e1078
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find and server lines in the license data file.  
: Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M BAD_SERVER_NAME_ERROR -e1079
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] encountered an illegal server name in the license 
: data file.  Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M CONNECT_SERVER_ERROR -e1080
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect over the network to the license server
: program.  Please make sure that the lmgrd 
: program is currently running on the computers described as servers in the
: license data file.

#
# Error due to PC key
#
M PC_KEY_ERROR -e1081
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: [errtext]

E FEATURE
#
# ------------------ msg.m ------------------ 
#
#@(#)msg.m	6.3 9/3/93


B MSG -start1011 -end1030 -current1016
: The Message System Messages

#
# Message fragments for the MSGFILE error
M MSGIO_EOLJUNK
: Extra characters at the end of a valid line
M MSGIO_UNKNOWN_LINE
: Unknown message file line type
M MSGIO_MSGSET_NAME
: Message set name is required
M MSGIO_MSGDEF_NAME
: Message definition name is required
M MSGIO_MSGARG_NAME
: Message definition argument name is required
M MSGIO_MSGARG_TYPE
: Message definition argument type is required
M MSGIO_UNKNOWN
: Unknown error number

#
# These messages are used by the message system when something goes
# wrong while reading a message file, or instantiating a message
#

M MSGFILE_ERROR -e1011
> theErrorName  m
> theLineNumber d
> theFileName   s
> theLine       s
> thePosition   z
: [theErrorName][.br]
: The error is on Line [theLineNumber] of "[theFileName]"[.br]
: The line is "[theLine]"[.br]
: -------------[thePosition]
M MSGSET_MISSING -e1012
> theCompName s
: The message set for "[theCompName]" does not exist [.br]
: in any of the standard message files.
M MSGSET_NULL
> theCompNumber d
> theCompName s
: The message set pointer for component [theCompNumber], "[theCompName]"[.br]
: does not point to a valid message set.
M MSGSET_NDEFS -e1013
> theMsgnum d
> theMsgname s
> theNumberOfDefs d
> theCompName s
: An attempt was made to invoke message "[theMsgname]",[.br]
: with a message number of [theMsgnum].  However, the message set for[.br]
: component "[theCompName]" has only [theNumberOfDefs] messages.
M MSGSET_MSGNAMES -e1014
> theMsgnum d
> theMsgname s
> theRealMsgname s
> theCompName s
: Message #[theMsgnum] of the message set for component "[theCompName]"[.br]
: was invoked with a name of "[theMsgname]".  Its name in the message[.br]
: file is "[theRealMsgname]".
M MSGSET_NPARAMS -e1015
> theMsgname s
> theNparams d
> theRealNum d
> theCompName s
: Message "[theMsgname]" of the message set for component "[theCompName]"[.br]
: was invoked with [theNparams] parameters.  It is defined with [theRealNum]
: in the message file.

#
# Message id severity names
# These are used in the creation of errors to describe how severe the
# error really is.  THE ORDER OF THESE NAMES IS VERY, VERY IMPORTANT.
# SEE MSGINST_SEVERITY IN MSGINST.C IF YOU DON'T BELIEVE ME.
#

M MSGSEV_INFO
: Information
M MSGSEV_WARNING
: WARNING
M MSGSEV_ERROR
: ERROR
M MSGSEV_FATAL
: Fatal Error
M MSGSEV_INTERNAL
: Internal Error

E MSG
#
# ------------------ mxcomm.m ------------------ 
#
# @(#)mxcomm.m	6.2  9/3/93


B MXCOMM -start1001 -end1010 -current1003
: Mx Program Communications

# Boolean values
M TRUE_VALUES
: Y YES T TRUE ON
M FALSE_VALUES
: N NO F FALSE OFF

# These two messages are used in rwdict error messages
M STARTUP_NAME
: startup file

# These error messages are used by mxaccs directly
M STARTUP_OPEN_FAILED -e1001
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: exists, but could not be opened for some reason

M NO_STARTUP_FILE -e1002
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: does not exist, so it could not be opened

E MXCOMM
#
# ------------------ report.m ------------------ 
#
#@(#)report.m	6.1  12/2/92
 
 
B REPORT
: Report Generator Messages
 
M PAGE
: Page
M CONTINUED
: (continued)
M XILINX
: Xilinx, Inc.
M COPYRIGHT
> year d
: (c) Copyright [year].  All Rights Reserved.
M TABLE_OF_CONTENTS
: Table of Contents[.br]
: -----------------[.br]
M TOC_ENTRY
> entry s
: [entry]
E REPORT
#
# ------------------ rwdict.m ------------------ 
#
#TMF 1.0
# @(#)rwdict.m	6.2  9/3/93


B RWDICT -start1031 -end1050 -current1035
: Dictionary File Reader/Writer

M MISSING_EQUALSIGN -e1031 -w1032
> linenumber d
> filename   s
> dicttype   s
> line       s
: Missing equal sign in the name-value assignment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[line]"

M ILLEGAL_NAME -e1033 -w1034
> linenumber d
> filename   s
> dicttype   s
> name       s
: Illegal name used in the name-value assigment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[name]"


E RWDICT
#
# ------------------ xnfprep.m ------------------ 
#
#@(#)xnfprep.m	6.40  4/11/94
 
 
B XNFPREP -start5001 -end5300 -current5005
: XNF Prepare
 
# Tool description (for program help)
M DESCRIPTION
: XNFPREP prepares the flattened XFF file or the XBLOX-generated
: XG file by removing unused and disabled logic. It also performs 
: a design rule check to locate  potentially invalid or inefficient
: use of the LCA architecture.[.br]
: USAGE: xnfprep <design> [[<outfile>] {<parameters>} 
	
# External Parameter Names
M DESIGN
: Input XFF File or XG File
M REPORT
: The name of the Report file
M SAVESIG
: Savesig mode
M DRC_ONLY
: run Design Rule Checker only
M ROM_TRIM
: ROM Trimming mode
M PARTTYPE
: Part type used in the design
M TRIMMED_FILE
: Trimmed file path and name
M MIGNORE_TIMESPEC
: Ignores timespecs in the XNF and the constraints file.
M MT_ALL
: Ignore ALL timespecs.
M MT_NONE
: Don't ignore any timespecs.
M MT_CST
: Ignore timespecs in the constraints file.
M MT_DESIGN
: Ignore timespecs in the input design.
M CSTFILE
: Constraints file name
M IGNORE_RLOCS
: Ignore RLOCs option
M MIGNORE_LOCS     
: Ignore XNF LOCs option
M MT_LOCS_ALL
: Ignore ALL XNF LOC constraints.
M MT_LOCS_NONE
: Do not ignore any XNF LOC constraints.
M MT_LOCS_IO 
: Ignore I/O LOC constraints.
M MT_LOCS_INTERIOR
: Ignore non-I/O LOC constraints. 
M MLOGIC_OPT
: Logic Optimization level. 
M MSAVE_XNF
: Save output XTF file.

# Help Messages
M HDESIGN
: This argument specifies the name of the flattened XFF file
: or XBLOX-generated XG file.
M HREPORT
: This option specifies an alternate name for the report file. If no
: name is specified, the report file will have the input design name.
M HSAVESIG
: When this option is TRUE, XNFPREP will not remove signals that are
: sourceless or loadless. This option is useful when working with 
: partial designs.
M HDRC_ONLY
: If this option is set to TRUE, XNFPREP will run only Design Rule Checker
: and exit. This is necessary to support the Orcad functional simulation flow
: if XBLOX symbols are included in the design.
M HROM_TRIM
: If this option is set to TRUE, XNFPREP will remove ROM address inputs which
: are unneeded for the specified INIT value. 
M HPARTTYPE
: If no part type is specified in the XFF file, this option must be used
: to specify the part type. If there is a parttype specified in the XFF
: file, this option may be used to override it.
M HTRIMMED_FILE
: This option specifies an alternate name for the output design file.
: If no name is specified, the input design name will be used.
M HIGNORE_TIMESPEC
: By default, XNFPREP processes all TIMESPEC and TIMEGRP statements in
: the design file and CST file. This option can be used to direct XNFPREP
: to ignore statements in one or both of these places. Ignored statements
: are removed and will not be processed by PPR.
M HT_ALL
: Ignore timespecs in the input design and the constraints file.
M HT_NONE
: All timespecs in the input design and the constraints file will
: be processed.
M HT_CST
: Timespecs in the constraints file will be ignored.
M HT_DESIGN
: Timespecs in the input design file will be ignored.
M HIGNORE_LOCS
: This option can be used to direct XNFPREP to ignore some or all LOC
: parameters in the design file. Ignored constraints are omitted from
: the output design.
M HT_LOCS_ALL
: All LOC constraints will be ignored.
M HT_LOCS_NONE
: LOC constraints will not be ignored.
M HT_LOCS_IO
: LOC constraints on I/O symbols will be ignored.
M HT_LOCS_INTERIOR
: LOC constraints except I/O symbols will be ignored.
M HIGNORE_RLOCS
: This option can be used to direct XNFPREP to ignore RLOC parameters found
: in the design.  If this option is TRUE, XNFPREP will omit RLOC parameters
: from the output design.
M HCSTFILE
: This option can be used to specify an alternate name for the CST file,
: if it is not named after the input design. The CST file must be found
: by XNFPREP if it contains TIMESPEC or TIMEGRP statements.
M HLOGIC_OPT
: If this option is set to 0 duplicate inputs of boolean symbols will
: not be trimmed.
M HSAVE_XNF
: If there are any errors found in the design output XTF file will not be deleted.

M RPT_TITLE
> designname s
> version s
: XNFPREP For Design [designname][.br]
: From XNFPREP Version [version][.br]

M WARNING_CHAP_TITLE
: XNFPREP Warnings [.br]
: ----------------

M ERR_CHAP_TITLE
: XNFPREP Errors [.br]
: --------------

M CLKSIG_CHAP_TITLE
: Clock Signals Report [.br]
: --------------------

# Error and Warning Messages
M NO_ERRORS
: No XNFPREP errors were issued. [.br]

M NO_WARNINGS
: No XNFPREP warnings were issued. [.br]

M DRC1_STATUS
: [.br]xnfprep:  running design rule checker ...[.br]

M DRC2_STATUS
: [.br]xnfprep:  running design rule checker on trimmed design...[.br]

M TRIMMING_STATUS
: [.br]xnfprep:  trimming unnecessary and redundant logic...[.br]

M PRE_TSPREP_STATUS
: [.br]xnfprep:  checking XACT-Performance specifications ...[.br]

M POST_TSPREP_STATUS
: [.br]xnfprep:  reverifying XACT-Performance specifications in trimmed design ...[.br]

M FILE_READ_ERROR -e5001
: XNFPREP was aborted because it could not read in the
: input design due to the following error(s):

M FILE_NOT_FOUND -e5002
> name s
: XNFPREP was aborted because it could not find the
: input design [name].[.br]
: Note that filenames may not contain any uppercase letters.[.br]

M FILE_EXT -e5003
> name s
: XNFPREP was aborted because it could not find a
: [name].xff.  Since no file extension was specified, XNFPREP looked
: for a flattened (XFF) file. (A flattened XFF file is produced by XNFMERGE.)[.br]
: Note that filenames may not contain an uppercase letters.[.br]
 
M REPORT_OPENFAILED -e5004
> rpt s
> designname s
: The XNFPREP report file '[rpt]' for design
: `[designname]' could not be opened.[.br]

# Informational and Other Messages
M ERROR_SUMMARY
> error_count d
> warn_count d
> rpt s
: [.br]XNFPREP SUMMARY [.br]
: ---------------[.br]
: [error_count] Errors found[.br]
: [warn_count] Warnings found[.br]
: [.br]Refer to the [rpt] file for details.[.br]
: [.br]

M SUMMARY
> inv_buf_rm_count d
> sym_rm_count d
> sig_rm_count d
> warn_count d
> rpt s
: [.br]XNFPREP SUMMARY [.br]
: ---------------[.br]
: 0 Errors found[.br]
: [warn_count] Warnings found[.br]
: [inv_buf_rm_count] Unnecessary inverters and buffers removed[.br]
: [sym_rm_count] Unnecessary or disabled symbols removed[.br]
: [sig_rm_count] Sourceless or loadless signals removed[.br]
: [.br]Refer to the [rpt] file for details.[.br]

M OUTPUT_SUMMARY
> file s
: Output netlist written to file [file].[.br]
: [.br]
E XNFPREP
#
# ------------------ tsprep.m ------------------ 
#
#@(#)tsprep.m	6.55  5/2/94
 
 
B TSPREP -start7801 -end8800 -current7992
: TIMESPEC and TIMEGRP Prepare
 
###################################
# Tool description (for program help)
###################################
M DESCRIPTION
: TSPREP performs syntax and semantic checking for TIMESPEC and TIMEGRP symbols
: and prepares timespec delay information for the PPR Path Analisys.
 
###################################
# External Parameter Names
###################################
# What is this parameter?  This is the...(a short & pithy 1-liner)
M DESIGN
: Input XNF design

M MPOST_TRIM
: Reverifies XACT-Performance specifications in trimmed design.

M MSYNTAX_ONLY
: Verifies timing specifications syntax only.

M MREPORT
: The name of the Report file.

M MCST_FILE
: The name of the constraints file.

M MIGNORE_TIMESPEC
: Ignores timing specifications in the XNF and the constraints file.

M MT_ALL
: Ignore ALL timespecs.

M MT_NONE
: Don't ignore any timespecs.

M MT_CST
: Ignore timespecs in the constraints file.

M MT_DESIGN
: Ignore timespecs in the input design.

M MSAVE_XNF
: Save output XTF file.

###################################
# Help Messages
###################################
# What does this parameter do?  This parameter...(verbose multi-liner)

M HDESIGN
: The name of the XNF file to use.

M HPOST_TRIM
: The syntax of timing specifications which occur on 'TIMESPEC' and 
: 'TIMEGRP' symbols will be reverified and warnings due to trimming
: process will be reported. All timing specifications will be resolved.
: 
M HSYNTAX_ONLY
: The syntax of timing specifications which occur on 'TIMESPEC' and 
: 'TIMEGRP' symbols will be verified and errors will be reported.
: No calculations will be performed if that option is used.

M HREPORT
: This optional field specifies a name for the report file generated by
: TSPREP.  If no file name is specified here, the name of the report
: file will be TSPREP.RPT.

M HCST_FILE
: You can specify timespecs and timegrps in the constraints file. 
: If no constraints file extension is specified, '.cst' is assumed.
: If you specify timespecs and timegrps in the constraints file,
: any duplicate specifications in your schematic will be overwritten.

M HIGNORE_TIMESPEC
: Timing specifications on 'TIMESPEC' and 'TIMEGRP' symbols entered
: on your schematic or in a constraints file can be removed from the
: design using the following options.

M HT_ALL
: Ignore timespecs in the input design and the constraints file.

M HT_NONE
: All timespecs in the input design and the constraints file will 
: be processed.

M HT_CST
: Timespecs in the constraints file will be ignored.

M HT_DESIGN
: Timespecs in the input design file will be ignored.

M HSAVE_XNF
: If there are any errors found in the design output XTF file will not be deleted.

M RPT_TITLE
> designname s
> version s
: Timing Specifications Report For Design [designname][.br]
: From TSPREP Version [version][.br]
 
M WARNING_CHAP_TITLE
: Timing Specification Warnings [.br]
: -----------------------------[.br]
  
M ERR_CHAP_TITLE
: Timing Specification Errors [.br]
: ---------------------------[.br]

M SUMMARY_CHAP_TITLE
: Timing Specification Summary [.br]
: ----------------------------[.br]

M TSPREP_INTRO
> name s
: The following timing specifications will be used for the design[.br]
: '[name]': [.br]

M TSPREP_SIGNALS_REMOVED
: Check that the specified signals exist in the design. Note that, if
: the signals are not at the topmost level of hierarchy, a hierarchical
: prefix must be added to the beginning of the name.[.br]

M TSPREP_SIGNALS_REMOVED_POST
: Check the Logic Trimming section of this report file to find out why
: the corresponding signals were removed or absorbed. If the specified
: signals were properly removed, the specification shown above must be
: removed from the design. If the specified signals were absorbed into
: other signals, you should use the surviving signal names in the specification;
: alternatively, you can place an X (explicit) parameter on the original
: signals to prevent them from being absorbed.[.br]

M LOOP_MSG
> name s
> value s
: [name]=[value];

M LOOP_TIMEGRP
> class s
> pattern s
: [class] matched by [pattern]

M BLANK_LINE
> space s
: [space]

M DUPL_SPEC
> name s
: [name];

M CST_DUPL_TSPEC_CONT
: Each TIMESPEC statement must have a unique TSid identifier.[.br]

M CST_DUPL_TGRP_CONT
: A TIMEGRP name may be defined only once, although it can be used any number
: of times in the definition of other TIMEGRP names.[.br]

###################################
# Error Messages
###################################
M NO_ERRORS
: No Timing Specification Errors were issued.[.br]
 
M NO_WARNINGS
: No Timing Specification Warnings were issued.[.br]

M FILE_READ_ERROR -e7802 -w7880
: TSPREP was aborted because it could not read in the
: input design due to the following error(s):[.br]
 
M FILE_NOT_FOUND -e7803 -w7881
> name s
: TSPREP was aborted because it could not find the input design '[name]'.[.br]

M NONEXISTENT_CONSTRAINTS_FILE -e7804 -w7882
> file_name s
: The constraints file "[file_name]" does not exist.[.br]

M REPORT_OPENFAILED -e7805 -w7883
> name s
: The Report file for design "[name]" could not be opened.[.br]

M DUPLICATE_ID -e7806 -w7884
> id s
: TS attribute id '[id]' is used more than once. One of the instances of
: its use must be re-named.[.br]

M DUPLICATE_TGRP -e7807 -w7885
> id s
: Timegroup '[id]' is used more than once. One of the instances of
: its use must be re-named.[.br]

M ATTRIB_NOT_FOUND -e7808 -w7886
> id s
: TS attribute '[id]' was never defined in a TIMESPEC primitive.[.br]

M TS_TYPE_MISSING -e7809 -w7887
> ts_id s
> field s
: For TS attribute '[ts_id]=[field]', there is nothing specified after the
: identifier.  You must specify which class of timespec this specification
: refers to.[.br]

M TS_ID_MISSING -e7810 -w7888
> ts s
: TSid is missing for TS attribute '[ts]'.[.br]

M TIMESPEC_STATEMENT_MISSING -e7811 -w7889
> ts s
: Timespec statement is missing for TS attribute '[ts]'.[.br]

M TNM_MISSING -e7812 -w7890
> tgrp s
: Tnm is missing for timegrp '[tgrp]'.[.br]

M DERIVED_GRP_MISSING -e7813 -w7891
> tgrp s
: Derived group is missing for timegrp '[tgrp]'.[.br]

M MULT_BY_ZERO -e7814 -w7892
> id s
> type s
> field s
> delay s
: For TS attribute id '[id]=[type]:[field]' delay '[delay]' specifies a multiply/divide
: operand of zero. This must be corrected.[.br]

M INVALID_END_SYNTAX -e7815 -w7893
> ts s
> field s
: The syntax for END statement of TS attribute '[ts]=[field]' is invalid.[.br]
: The valid syntax is "TSid=END".[.br]

M INVALID_CONTINUE_SYNTAX -e7816 -w7894
> ts s
> field s
: The syntax for CONTINUE statement of TS attribute '[ts]=[field]' is invalid.[.br]
: The valid syntax is "TSid=CONTINUE".[.br]

M INVALID_TRACE_SYNTAX -e7817 -w7895
> ts s
> field s
: The syntax for TRACE statement of TS attribute '[ts]=[field]' is invalid.[.br]
: The valid syntax is "TSid=TRACE:pin_:mode".[.br]

M INVALID_IGNORE_SYNTAX -e7818 -w7896
> ts s
: The syntax for IGNORE type TS attribute '[ts]' is invalid.[.br]
: The valid syntax is "TSid1=IGNORE{:TSid2}".[.br]

M INVALID_PIN_PAIR -e7819 -w7897
> ts s
> pin s
: The pin qualifier '[pin]' specified by TS attribute '[ts]' is invalid.[.br]
: The valid pin qualifiers are: WE_O, D_O, D_Q, O_I, T_I.[.br]

M INVALID_TRACE_MODE -e7820 -w7898
> ts s
> mode s
: The TRACE mode '[mode]' specified by TS attribute '[ts]' is invalid. [.br]
: The valid mode values are 'CONTINUE' or 'END'.[.br]

M TRACE_MODE_CONFLICT -e7821 -w7899
> ts s
> pin s
> mode s
: The TRACE mode '[mode]' for pin qualifier '[pin]' of TS attribute '[ts]'
: conflicts with the previously specified trace mode for that pin
: qualifier.  The trace mode for each pin qualifier can only be
: specified once.[.br]

M TS_FIELD_MISSING -e7822 -w7900
> ts s
> field s
: For TS attribute '[ts]=[field]', there is nothing specified after the
: identifier and type.[.br]
: The proper syntax for a TIMESPEC attribute depends on the type of
: specification desired. The syntax is summarized below by spec type.[.br][.br]
: Spec Type  TIMESPEC Attribute Syntax[.br]
: ---------  --------------------------------------------------------[.br]
: FROM-TO    TS<id>=FROM:<group>:TO:<group>=<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: C2S        TS<id>=C2S:<delay>[[:<high_time>][.br]
: C2P        TS<id>=C2P:<delay>[[:<to_pad_name>][.br]
: P2S        TS<id>=P2S:<delay>[[:<from_pad_name>][.br]
: P2P        TS<id>=P2P:<delay>:<from_pad_name>:<to_pad_name>[.br]
: ---------  --------------------------------------------------------[.br]
: DC2S       TS<id>=DC2S:<delay>[[:<high_time>][.br]
: DC2P       TS<id>=DC2P:<delay>[.br]
: DP2S       TS<id>=DP2S:<delay>[.br]
: DP2P       TS<id>=DP2P:<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: IGNORE     TS<id>=IGNORE[.br]
: LINK       TS<id>=LINK:TS<id_1>:TS<id_2>[[:TS<id_3> ...][.br]

M ILLEGAL_TS_TYPE -e7823 -w7901
> ts s
> field s
: The first component after the TSid of the TS attribute '[ts]=[field]' is not one
: of the following legal types:[.br]
: DC2S, DP2S, DC2P, DP2P, C2S, P2S, C2P, P2P, IGNORE, LINK,[.br]
: CONTINUE, END, BREAKLOOP, TRACE.[.br]
: This could be due to illegal TS syntax.  There must be a colon ':'
: between the type and the delay fields.[.br]

M ILLEGAL_PIN_TS -e7824 -w7902
> sym s
> pin s
> ts s
> field s
: The TS flag for '[ts]' on a pin '[pin]' of '[sym]' symbol has a value
: '[field]' included in it after the '[ts]'.  The TS flag should be 
: defined in a TIMESPEC symbol, not on the pin itself.[.br]

M TS_ATTRIB_MISSING -e7825 -w7903
> id s
> mult_id s
: TS attribute '[id]' is specified in terms of non-existent TS attribute '[mult_id]'.[.br]

M TS_LINK_ERROR -e7826 -w7904
> ts s
> field s
: For TS attribute '[ts]=[field]', there are no TS ids specified after the
: "LINK".[.br]

M LINK_MISSING_TS -e7827 -w7905
> id s
> ts_id s
: TS attribute '[id]' specifies a link with non-existent TS attribute '[ts_id]'.[.br]

M ILLEGAL_LINK -e7828 -w7906
> id s
> ts_id s
> type s
: TS attribute '[id]' specifies a link with TS attribute '[ts_id]', whose
: type '[type]' is not legal for a LINK.[.br]
: The following TS attribute types are legal for a LINK:[.br]
: C2S, C2P, P2S, CONTINUE, END and BREAKLOOP.[.br]

M UNDEFINED_TGRP -e7829 -w7907
> id s
: The group '[id]' is used in a TIMEGRP statement but is never defined.[.br][.br]
: If '[id]' is meant to be a group name, it should either be defined
: by a TIMEGRP parameter or be matched by a TNM parameter somewhere in 
: the design. (If '[id]' is already defined by a TIMEGRP parameter, 
: check the other messages in this section to see if that TIMEGRP was 
: found to be invalid.)[.br]
: If '[id]' is meant to refer to a whole class of symbols, it should
: be one of the following values: FFS, PADS, RAMS or LATCHES.[.br]

M UNFINISHED_TS -e7830 -w7908
> id s
: TS attribute '[id]' was assigned to a pin or LINK, but it was never defined in a
: TIMESPEC primitive.[.br]

M CIRCULAR_LINK -e7831 -w7909
> link_id s
> ts_id s
: A circular-link (a chain of links that leads back to itself) was found
: from TS attribute '[link_id]' back to itself by way of '[ts_id]'.
: This must be resolved by referencing a real specification at some
: point in the chain as circular links are not supported.[.br]

M CIRCULAR_CHAIN -e7832 -w7910
> grp s
> tgrp s
: A circular chain (a chain of tnms that leads back to itself) was found
: from tnm '[grp]' back to itself by way of '[tgrp]'.  At some point in the
: chain a tnm group must reference design elements. [.br]

M MULT_LOOP -e7833 -w7911
> ts_id s
> mult_id s
: A chain of TSids that are specified in terms of each other and leads
: back to itself was found from TS attribute '[ts_id]' back to itself by
: way of '[mult_id]'. This must be resolved by referencing a real
: specification at some point in the chain as circular links are not
: supported.[.br]

M TS_ATTRIB_NOT_NUMBER -e7834 -w7912
> ts_id1 s
> type s
> field s
> ts_id2 s
: For TS attribute '[ts_id1]=[type]:[field]' delay '[ts_id2]' has no amount
: specified to multiply/divide or the amount specified is not a number.[.br]

M INVALID_TS_SYNTAX -e7835 -w7913
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' in the XNF file is invalid.[.br]
: The proper syntax for a TIMESPEC attribute depends on the type of
: specification desired. The syntax is summarized below by spec type.[.br][.br]
: Spec Type  TIMESPEC Attribute Syntax[.br]
: ---------  --------------------------------------------------------[.br]
: FROM-TO    TS<id>=FROM:<group>:TO:<group>=<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: C2S        TS<id>=C2S:<delay>[[:<high_time>][.br]
: C2P        TS<id>=C2P:<delay>[[:<to_pad_name>][.br]
: P2S        TS<id>=P2S:<delay>[[:<from_pad_name>][.br]
: P2P        TS<id>=P2P:<delay>:<from_pad_name>:<to_pad_name>[.br]
: ---------  --------------------------------------------------------[.br]
: DC2S       TS<id>=DC2S:<delay>[[:<high_time>][.br]
: DC2P       TS<id>=DC2P:<delay>[.br]
: DP2S       TS<id>=DP2S:<delay>[.br]
: DP2P       TS<id>=DP2P:<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: IGNORE     TS<id>=IGNORE[.br]
: LINK       TS<id>=LINK:TS<id_1>:TS<id_2>[[:TS<id_3> ...][.br]

M INVALID_HIGH_TIME -e7836 -w7914
> ts s
> type s
> field s
: The high time value for TS attribute '[ts]=[type]:[field]' must be
: less than the clock period.[.br]

M INVALID_DEFAULT_SYNTAX -e7837 -w7915
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: Too many delay timing parameters are specified.[.br]

M ILLEGAL_DELAY_VALUE -e7838 -w7916
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: The delay time cannot be specified as IGNORE.[.br]

M INVALID_P2P_SYNTAX -e7839 -w7917
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: 'Source' and 'destination' parameters are required.[.br]

M INVALID_BREAKLOOP_SYNTAX -e7840 -w7918
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: The valid syntax is "BREAKLOOP:max_delay".[.br]

M ILLEGAL_TNM_VALUE -e7841 -w7919
> name s
: The timegroup definition of '[name]' is illegal.[.br]
: Names like PADS, FFS, RAMS, LATCHES, EXCEPT, RISING or FALLING are
: reserved.[.br]

M DUPL_TIMEGRP_NAME -e7842 -w7920
> name s
: The timegroup definition of '[name]' duplicates another definition
: of that group. One of the definitions should be renamed.[.br]

M INVALID_RISE_FALL_SYNTAX -e7843 -w7921
> dgrp s
: The rise/fall syntax defined by group '[dgrp]' is invalid.[.br]
: The valid syntax is: RISING:timegrp or FALLING:timegrp.[.br]

M DIFF_GRP_TYPE -e7844 -w7922
> type s
> dgrp s
> dtype s
> grp s
: The first group encountered in the definition of '[dgrp]' was of type
: [dtype]. The subsequent group '[grp]' is of type [type].[.br][.br]
: All groups in a TIMEGRP statement must be of the same type.[.br]

M INVALID_TIMEGRP_SYNTAX -e7845 -w7923
> ts s
> type s
> field s
> name s
: The following TS parameter is invalid because '[name]' 
: could not be found.[.br][.br]
: [ts]=[type]:[field][.br][.br]
: If '[name]' is meant to be a group name, it should either be defined
: by a TIMEGRP parameter or be matched by a TNM parameter somewhere in 
: the design. (If '[name]' is already defined by a TIMEGRP parameter, 
: check the other messages in this section to see if that TIMEGRP was 
: found to be invalid.)[.br]
: If '[name]' is meant to refer to a whole class of symbols, it should
: be one of the following values: FFS, PADS, RAMS or LATCHES.[.br]

M TIMEGRP_NO_CLASS -e7846 -w7924
> name s
: The timegroup definition of a group '[name]' has no class qualifier.[.br]
: The class qualifier should be one of the following:[.br]
: FFS, PADS, RAMS or LATCHES.[.br]

M INVALID_TNM_TYPE -e7847 -w7925
> name s
> tnm s
: The timegroup statement defines a rise_fall derived group '[name]'
: where tnm '[tnm]' is the wrong type.[.br]
: Tnm '[tnm]' should only appear on FFS or LATCHES.[.br]

M RISE_FALL_INVALID_CLASS -e7848 -w7926
> name s
> class s
: The timegroup statement defines a rise/fall derived group '[name]'
: for the whole class category '[class]'.[.br]
: Rise_fall groups can only be defined for the classes 'FFS' and 'LATCHES'.[.br]

M TIMEGRP_INVALID_CLASS -e7849 -w7927
> name s
> class s
: The timegroup statement defines a group '[name]' with the 
: whole class category specified as '[class]' This value is invalid.[.br]
: The whole class value should be one of the following:[.br]
: FFS, PADS, RAMS or LATCHES.[.br]

M INVALID_WHOLE_CLASS -e7850 -w7928
> ts s
> type s
> field s
> name s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: The '[name]' refers to a whole class of elements and it's value
: should be one of the following:[.br]
: FFS, PADS, RAMS or LATCHES.[.br]

M NO_PATTERN -e7851 -w7929
> ts s
> type s
> field s
> class s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: No timegroup is specified in the pattern '[class]()'.[.br]

M TIMEGRP_INVALID_PATTERN -e7852 -w7930
> type s
> group s
: The following signal specification (in the [type] definition '[group]')
: was not matched in the design.[.br]

M INVALID_PATTERN -e7853 -w7931
> group s
> pattern s
: The syntax for group '[group]=[pattern]' is invalid.[.br]
: There should be a signal name specified after the ':'.[.br]

M INVALID_FROM_TO_SYNTAX -e7854 -w7932
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: The valid syntax is: FROM:timegrp:TO:timegrp=max_delay.[.br]

M MISSING_KEYWORD -e7855 -w7933
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: The keyword 'TO' is missing.[.br]

M WILDCARD_FOUND -e7856 -w7934
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: You may not specify only a wildcard symbol as the external pad.[.br]
: Use D[type] timing if you want to specify the timing for all paths.[.br]

M P2P_WILDCARD_FOUND -e7857 -w7935
> ts s
> type s
> field s
: The syntax for TS attribute '[ts]=[type]:[field]' is invalid.[.br]
: The 'source' and 'destination' parameters cannot be both wildcards.[.br]
: What you are specifying is actually the default DP2P, so use the DP2P
: attribute instead of P2P.[.br]

M DELAY_UNIT_ERROR -e7858 -w7936
> ts s
> delay s
> type s
> field s
: The delay specification of '[delay]' in the TIMESPEC attribute 
: '[ts]=[type]:[field]' is not valid. The delay must be
: specified in one of the following ways:[.br][.br]
: (1) A number followed by a unit designation (either us, ns, kHz
:     or MHz). If no unit is given, nanoseconds is assumed.[.br][.br]
: (2) One of the words 'AUTO' or 'IGNORE'.[.br][.br]
: (3) A multiple or fraction of another specification, such as
:     'TS01*4' or 'TS02/2'. The TSid MUST be specified first,
:     followed by the operator (* or /) and a number.[.br]

M TS_FLAG_NOT_FOUND -e7859 -w7937
> id s
> type s
: '[type]' type TS attribute '[id]' needs an associated TS flag attached
: to a net or pin.[.br]

M TS_FLAG_FOUND -e7860 -w7938
> id s
> type s
: '[type]' type TS attribute '[id]' does not need an associated TS flag attached
: to a net or pin.[.br]

M HIGH_TIME_FOUND -e7861 -w7939
> ts s
> type s
> field s
> delay s
: For TS attribute '[ts]=[type]:[field]', since the first delay field was
: specified as '[delay]' timing, specification of a high time is illegal.[.br]

M ILLEGAL_HIGH_TIME -e7862 -w7940
> ts s
> type s
> field s
> delay s
: The high time of TS attribute '[ts]=[type]:[field]' cannot be specified as
: '[delay]' timing.[.br]

M ADD_PARAM_ERROR -e7863 -w7941
> sym s
> ts s
: Error while adding '[ts]' parameter to a '[sym]' symbol.[.br]

M NAME_COLLISION -e7864 -w7942
> name s
: TNM identifier '[name]' is not a valid group name because it is used
: as a TIMESPEC label.[.br]

M DUPL_TNM_SYM -e7865 -w7943
> symtype s
> symname s
> tnm s
> foundtype s
> expectedtype s
: The TNM '[tnm]' was found on the [symtype] symbol '[symname]', which
: implies that the TNM should group symbols of type [foundtype]. However,
: this same TNM was also found on elements of type [expectedtype].[.br][.br]
: Correct the TNM definitions for '[tnm]' so that only one type of symbol
: is grouped.[.br]

M DUPL_TNM_PIN -e7866 -w7944
> symtype s
> symname s
> pin s
> tnm s
> expectedtype s
: The TNM '[tnm]' was found on a load pin (pin '[pin]' of the [symtype]
: symbol '[symname]'), which implies that the TNM should group flip-flops.
: However, this same TNM was also found on elements of type [expectedtype].[.br][.br]
: Correct the TNM definitions for '[tnm]' so that only one type of symbol
: is grouped. Note that TNM parameters on signals and/or load pins can only 
: be used to group flip-flops or input latches. To group other types of 
: symbols, attach the TNM parameter directly to those symbols.[.br]

M DUPL_TNM_EXT -e7867 -w7945
> tnm s
> type s
: The TNM '[tnm]' is used to group symbols of type PADS and of type [type].
: A single TNM group can contain only one type of path endpoint (except for
: the types FFS and LATCHES, which can be mixed).[.br][.br]
: Change the TNM on either the PADS or [type] to have a different name.[.br]

M ILLEGAL_PARAM_TNM -e7868 -w7946
> sym s
> param s
: Parameter 'TNM=[param]' is illegal on '[sym]' symbol.[.br]

M ADD_SYM_PARAM_ERROR -e7869 -w7947
> sym s
> ts s
> type s
> field s
: Error while adding '[ts]=[type]:[field]' parameter to a '[sym]' symbol.[.br]

M ADD_PIN_PARAM_ERROR -e7870 -w7948
> pin s
> sym s
> ts s
: Error while adding '[ts]' parameter to a '[pin]' pin of a '[sym]' symbol.[.br]

M MULT_DELAY_ERROR -e7871 -w7949
> ts s
> type s
> field s
> mts s
> mtype s
: For TS attribute '[ts]=[type]:[field]', the reference to '[mtype]' type
: TS attribute '[mts]' is not allowed.[.br]

M NO_SYMS_FOUND -e7950
> type s
> grp s
> class s
: The [type] definition '[grp]' references the group '[class]' but there are no
: [class] type symbols in the design.[.br]

M NO_SYMS_FOUND_POST -e7951
> type s
> grp s
> class s
: The [type] definition '[grp]' references the group '[class]' but there are no
: [class] type symbols in the trimmed design.[.br][.br]
: Check the Logic Trimming section of this report to find out why all symbols
: of this type were removed.[.br]

M INVALID_USERPARAM_SYNTAX -e7952
> name s
> value s
: The syntax for TIMEGRP attribute '[name]=[value]' in the XNF file
: is invalid.[.br][.br]
: The proper syntax for a TIMEGRP attribute is summarized below.[.br][.br]
: Group By     TIMEGRP Attribute Syntax[.br]
: ---------  --------------------------------------------------------[.br]
: combining    <new_grp>=<grp1>[[:<grp2>...][.br]
: excluding    <new_grp>=<grp1>[[:<grp2>...]:EXCEPT:<grp3>[[:<grp4>...][.br]
: ---------  --------------------------------------------------------[.br]
: rising edge  <new_grp>=RISING:<grp1>[.br]
: falling edge <new_grp>=FALLING:<grp1>[.br][.br]
: Note that most XNF interface packages will automatically insert the
: leading equals sign. If this is the case for your interface package,
: you should not specify the first equals sign.[.br]

M INVALID_SYM_TNM_SYNTAX -e7953 -w7954
> name s
> type s
> param s
: The syntax of the following TNM parameter on symbol '[name]'
: (type=[type]) is invalid.[.br]
: TNM=[param][.br]
: A TNM parameter on a symbol should have the following syntax:[.br]
: TNM=<group_name>[[;group_name][.br]
: where <group_name> is a user-assigned name for this group.[.br]
: If more than one group name is to be assigned to the same symbol, they
: should be combined into one TNM parameter, separated by semicolon (;)
: characters, as shown in the following example.[.br]
: TNM=group1;group2[.br]

M INVALID_PIN_TNM_SYNTAX -e7953 -w7954
> pin s
> name s
> type s
> param s
: The syntax of the following TNM parameter on pin '[pin]' of symbol '[name]'
: (type=[type]) is invalid.[.br]
: TNM=[param][.br]
: A TNM parameter on a pin should have the following syntax:[.br]
: TNM=<group_name>[[;group_name][.br]
: where <group_name> is a user-assigned name for this group.[.br]
: If more than one group name is to be assigned to the same pin, they
: should be combined into one TNM parameter, separated by semicolon (;)
: characters, as shown in the following example.[.br]
: TNM=group1;group2[.br]

M INVALID_EXT_TNM_SYNTAX -e7953 -w7954
> pad s
> param s
: The syntax of the following TNM parameter on pad '[pad]' is invalid.[.br]
: TNM=[param][.br]
: A TNM parameter on a pad should have the following syntax:[.br]
: TNM=<group_name>[[;group_name][.br]
: where <group_name> is a user-assigned name for this group.[.br]
: If more than one group name is to be assigned to the same pad, they
: should be combined into one TNM parameter, separated by semicolon (;)
: characters, as shown in the following example.[.br]
: TNM=group1;group2[.br]
 
M INVALID_XBLOX_CLASS -e7955 -w7956
> symname s
> symtype s
> class s
> param s
: The TNM parameter TNM=[param] on symbol '[symname]' (type=[symtype]) contains
: the illegal class qualifier '[class]'.[.br]
: A TNM parameter on a symbol should have the following syntax:[.br]
: TNM=[[<qualifier>:]<group_name>[.br]
: where <qualifier> is one of the symbol classes FFS, RAMS, LATCHES or PADS,
: and <group_name> is a user-assigned name for this group.[.br]
: If more than one group name is to be assigned to the same symbol, they
: should be combined into one TNM parameter, separated by semicolon (;)
: characters, as shown in the following example.[.br]
: TNM=FFS:reg_group;RAMS:mem_group[.br]

M ILLEGAL_TSID -e7957 -w7958
> char s
> id s
: TS identifier '[id]' includes invalid character '[char]'.[.br]
: Names may contain only letters, digits and underscores.[.br][.br]

M ILLEGAL_TGRP -e7959 -w7960
> char s
> grp s
: Timegroup '[grp]' includes invalid character '[char]'.[.br]
: Group names may contain only letters, digits and underscores.[.br][.br]
: If this is intended to represent a class of symbols driving specific signal
: names, it should be in one of the following forms:[.br]
: FFS(name)[.br]
: RAMS(name)[.br]
: PADS(name)[.br]
: LATCHES(name)[.br]

M TIMEGRP_INVALID_EDGE -e7961 -w7962
> name s
> edge s
: The timegroup statement defines a group '[name]' with the
: edge category specified as '[edge]'. This value is invalid.[.br]
: The edge value should be one of the following:[.br]
: RISING or FALLING.[.br]

M INVALID_XBLOX_TNM_SYNTAX -e7963 -w7964
> name s
> type s
> param s
: The syntax of the following TNM parameter on symbol '[name]'
: (type=[type]) is invalid.[.br]
: TNM=[param][.br]
: A TNM parameter on a symbol should have the following syntax:[.br]
: TNM=[[<qualifier>:]<group_name>[.br]
: where <qualifier> is one of the symbol classes FFS, RAMS, LATCHES or PADS,
: and <group_name> is a user-assigned name for this group.[.br]
: If more than one group name is to be assigned to the same symbol, they
: should be combined into one TNM parameter, separated by semicolon (;)
: characters, as shown in the following example.[.br]
: TNM=FFS:reg_group;RAMS:mem_group[.br]

M INVALID_DIFF_SYNTAX -e7965 -w7966
> name s
> value s
: The timegroup statement defines a derived group '[name]=[value]'
: which is invalid.[.br]
: Only one EXCEPT clause is allowed in a timegroup.[.br]

M NO_XBLOX_CLASS -e7967 -w7968
> symname s
> symtype s
> param s
: The TNM parameter TNM=[param] is illegal on symbol '[symname]' (type=[symtype])
: or contains no class qualifier.[.br]
: If TNM is a legal parameter it should have the following syntax:[.br]
: TNM=<qualifier>:<group_name>[.br]
: where <qualifier> is one of the symbol classes FFS, RAMS, LATCHES or PADS,
: and <group_name> is a user-assigned name for this group.[.br]
: If more than one group name is to be assigned to the same symbol, they
: should be combined into one TNM parameter, separated by semicolon (;)
: characters, as shown in the following example.[.br]
: TNM=FFS:reg_group;RAMS:mem_group[.br]

M CST_DUPL_TSPEC -e7969
> id s
: The following TIMESPEC statements in the constraints file all have
: the same TS identifier ('[id]').[.br]

M CST_DUPL_TGRP -e7970
> name s
: The TIMEGRP '[name]' was defined more than once in the constraints file,
: as shown below.[.br]

M ZERO_DELAY -e7971
> ts s
> type s
> field s
: The delay time in TS attribute '[ts]=[type]:[field]' is not legal.[.br]
: The delay must be greater then zero.[.br]

M INVALID_CST_TS_SYNTAX -e7973
> tspec s
: The syntax for TIMESPEC '[tspec]' in the constraints file is invalid.[.br]
: The proper syntax for a TIMESPEC attribute depends on the type of
: specification desired. The syntax is summarized below by spec type.[.br][.br]
: Spec Type  TIMESPEC Attribute Syntax[.br]
: ---------  --------------------------------------------------------[.br]
: FROM-TO    TS<id>=FROM:<group>:TO:<group>=<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: C2S        TS<id>=C2S:<delay>[[:<high_time>][.br]
: C2P        TS<id>=C2P:<delay>[[:<to_pad_name>][.br]
: P2S        TS<id>=P2S:<delay>[[:<from_pad_name>][.br]
: P2P        TS<id>=P2P:<delay>:<from_pad_name>:<to_pad_name>[.br]
: ---------  --------------------------------------------------------[.br]
: DC2S       TS<id>=DC2S:<delay>[[:<high_time>][.br]
: DC2P       TS<id>=DC2P:<delay>[.br]
: DP2S       TS<id>=DP2S:<delay>[.br]
: DP2P       TS<id>=DP2P:<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: IGNORE     TS<id>=IGNORE[.br]
: LINK       TS<id>=LINK:TS<id_1>:TS<id_2>[[:TS<id_3> ...][.br]

M INVALID_CST_TNM_SYNTAX -e7974
> tspec s
: The syntax for TIMEGRP attribute '[tspec]' in the constraints file
: is invalid.[.br][.br]
: The proper syntax for a TIMEGRP attribute is summarized below.[.br][.br]
: Group By     TIMEGRP Attribute Syntax[.br]
: ---------  --------------------------------------------------------[.br]
: combining    <new_grp>=<grp1>[[:<grp2>...][.br]
: excluding    <new_grp>=<grp1>[[:<grp2>...]:EXCEPT:<grp3>[[:<grp4>...][.br]
: ---------  --------------------------------------------------------[.br]
: rising edge  <new_grp>=RISING:<grp1>[.br]
: falling edge <new_grp>=FALLING:<grp1>[.br]

M DATA_ERROR -e7975
> space s
: [space]

M ILLEGAL_SYM_TNM_VALUE -e7978 -w7979
> sym s
> type s
> param s
: The definition of TNM=[param] parameter on symbol '[sym]'
: (type=[type]) is illegal.[.br]
: Names like PADS, FFS, RAMS, LATCHES, EXCEPT, RISING or FALLING are
: reserved.[.br]

M ILLEGAL_PIN_TNM_VALUE -e7980 -w7981
> pin s
> sym s
> type s
> param s
: The definition of TNM=[param] parameter on pin '[pin]' of symbol '[sym]'
: (type=[type]) is illegal.[.br]
: Names like PADS, FFS, RAMS, LATCHES, EXCEPT, RISING or FALLING are
: reserved.[.br]

M ILLEGAL_EXT_TNM_VALUE -e7982 -w7983
> pad s
> param s
: The definition of TNM=[param] parameter on pad '[pad]' is illegal.[.br]
: Names like PADS, FFS, RAMS, LATCHES, EXCEPT, RISING or FALLING are
: reserved.[.br]

M ILLEGAL_COMPOUND_TGRP -e7984 -w7985
> char s
> grp s
> derived_grp s
: The TIMEGRP definition for '[derived_grp]' refers to '[grp]'.[.br][.br]
: If this is intended to be a regular group name (defined by another
: TIMEGRP or by TNM parameter), it contains the invalid character '[char]'.
: Group names may contain only letters, digits and underscores.[.br][.br]
: If this is intended to represent a class of symbols driving specific signal
: names, it should be in one of the following forms:[.br]
: FFS(name)[.br]
: RAMS(name)[.br]
: PADS(name)[.br]
: LATCHES(name)[.br]

M ILLEGAL_COMPOUND_TNM_VALUE -e7986 -w7987
> name s
> derived_grp s
: The timegroup '[derived_grp]' defines illegal group '[name]'.[.br]
: Names like PADS, FFS, RAMS, LATCHES, EXCEPT, RISING or FALLING are
: reserved.[.br]

M ILLEGAL_FROMTO_TNM -e7988 -w7989
> char s
> name s
> ts s
> type s
> field s
: TS attribute [ts]=[type]:[field] defines group '[name]' which includes
: invalid character '[char]'.[.br]
: Group names may contain only letters, digits and underscores.[.br][.br]
: If this is intended to represent a class of symbols driving specific signal
: names, it should be in one of the following forms:[.br]
: FFS(name)[.br]
: RAMS(name)[.br]
: PADS(name)[.br]
: LATCHES(name)[.br]

M RESERVED_FROMTO_TNM -e7990 -w7991
> name s
> ts s
> type s
> field s
: TS attribute [ts]=[type]:[field] defines illegal group '[name]'.[.br]
: Names like PADS, FFS, RAMS, LATCHES, EXCEPT, RISING or FALLING are
: reserved.[.br]

###################################
# Warning Messages
###################################
M TS_MULT_NO_OPERATOR -w7872
> ts_id1 s
> type s
> field s
> ts_id2 s
: TS attribute '[ts_id1]=[type]:[field]' is specified in terms of TS attribute
: '[ts_id2]'.[.br]
: Delay '[ts_id2]' has no multiplication/division operator (* or /) and amount specified.[.br]
: '[ts_id2]*1' is assumed.[.br]

M ILLEGAL_SCALING -w7873
> id s
> mult_id s
> delay s
: TS attribute '[id]' is specified in terms of TS attribute '[mult_id]'
: with the '[delay]' timing parameter. '[id]' will not be scaled, but instead will
: be assigned '[delay]' timing.[.br]

M DELAY_UNREALISTIC -w7874
> ts s
> type s
> field s
: TS attribute '[ts]=[type]:[field]' specifies a delay which is virtually zero.[.br]

M ONE_LINK_ID -w7875
> ts s
> field s
: For TS attribute '[ts]=[field]', there is only one TS id specified in
: the LINK.  Links are used to connect multiple specifications together
: so that one timespec flag on a schematic can represent multiple
: specifications.  [.br]

M DUPLICATE_TRACE_STATEMENT -w7876
> ts s
> pin s
> mode s
: TS attribute '[ts]' specifies a TRACE statement with pin qualifier
: '[pin]' and mode '[mode]' that has been previously defined.  This
: duplicate specification is unnecessary.[.br]

M CST_OVERWRITE -w7878
> cstspec s
> name s
> field s
: Timing specification '[name]=[field]' in the input netlist will be 
: overwritten by timing specification '[cstspec]' from the constraints file.[.br]

M NO_CST_FILE -w7879
: You have specified 'ignore_timespec=cst' but have not specified a constraints
: file.[.br]

M TSPREP_USER_PARAM -w7975
: The TIMESPEC symbol contains the following parameters which are not
: defined in the Xilinx flow (these are also known as "user parameters").[.br]

M TSPREP_TS_TRIMMED -w7976
: The following timing specifications were removed as the result of
: trimming process: [.br]

M TSPREP_TGRP_TRIMMED -w7977
: The following timing specifications were changed as the result of
: trimming process: [.br]

###################################
# Informational and Other Messages
###################################
M IGNORE_ERRORS
> option s
: You have specified 'ignore_timespec=[option]'. All timing specifications will
: be ignored during processing. No Timing Specification Errors will be issued.[.br]
 
M IGNORE_WARNINGS
> option s
: You have specified 'ignore_timespec=[option]'. All timing specifications will
: be ignored during processing. No Timing Specification Warnings will be issued.[.br]

M IGNORE_ALL_OPT
> option s
: You have specified 'ignore_timespec=[option]'. All timing specifications will
: be ignored during processing.[.br]

M IGNORE_DESIGN_OPT
: You have specified 'ignore_timespec=DESIGN'. All timing specifications in 
: the input netlist will be ignored during processing. Any timing specifications
: in the constraints file will be processed.[.br]

M IGNORE_CST_OPT
: You have specified 'ignore_timespec=CST'. All timing specifications in 
: the constraints file will be ignored during processing.[.br]

M IGNORE_NONE_OPT
: All timing specifications will be processed.[.br]

M USER_PARAM_FOUND
: If any of these parameters were intended to be timing specifications, they
: will not be recognized as such. Check that the syntax of these parameters 
: is correct: the valid syntax for TIMESPEC statements is summarized below.[.br][.br]
: If these parameters were not intended to be timing specifications or were
: not applied by the user, this warning can be ignored.[.br][.br]
: Spec Type  TIMESPEC Attribute Syntax[.br]
: ---------  --------------------------------------------------------[.br]
: FROM-TO    TS<id>=FROM:<group>:TO:<group>=<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: C2S        TS<id>=C2S:<delay>[[:<high_time>][.br]
: C2P        TS<id>=C2P:<delay>[[:<to_pad_name>][.br]
: P2S        TS<id>=P2S:<delay>[[:<from_pad_name>][.br]
: P2P        TS<id>=P2P:<delay>:<from_pad_name>:<to_pad_name>[.br]
: ---------  --------------------------------------------------------[.br]
: DC2S       TS<id>=DC2S:<delay>[[:<high_time>][.br]
: DC2P       TS<id>=DC2P:<delay>[.br]
: DP2S       TS<id>=DP2S:<delay>[.br]
: DP2P       TS<id>=DP2P:<delay>[.br]
: ---------  --------------------------------------------------------[.br]
: IGNORE     TS<id>=IGNORE[.br]
: LINK       TS<id>=LINK:TS<id_1>:TS<id_2>[[:TS<id_3> ...][.br]

E TSPREP
#
# ------------------ xnftrim.m ------------------ 
#
#@(#)xnftrim.m	6.73  5/2/94
 

B XNFTRIM -start4001 -end4500 -current4085
: XNF Logic Trimming

# Tool description (for program help)
M DESCRIPTION
: This tool trims the unused logic from a flattened XFF file.
M DESIGN
: Input XFF Design
M REPORT
: The name of the Report file
M SAVESIG
: Savesig mode
M ROM_TRIM
: ROM Trimming mode
M PARTTYPE
: Part type used in the design
M IGNORE_RLOCS
: Ignore RLOCs option
M MIGNORE_LOCS
: Ignores LOCs option
M MT_LOCS_ALL
: Ignore ALL LOC constraints.
M MT_LOCS_NONE
: Do not ignore any LOC constraints.
M MT_LOCS_IO
: Ignore I/O LOC constraints.
M MT_LOCS_INTERIOR
: Ignore non-I/O LOC constraints.
M MLOGIC_OPT
: Logic Optimization level.

# Help Messages
M HDESIGN
: The name of the XFF design to be trimmed.
M HREPORT
: This optional field specifies a name for the report file generated by
: XNFPREP.  If no file name is specified here, the name of the report 
: file will be XNFPREP.RPT.
M HSAVESIG
: When this option is used, sourceless or loadless signals are assigned the
: SAVESIG parameter.  These signals will not be trimmed.
M HROM_TRIM
: When this option is set to TRUE, ROM symbols will be trimmed.
M HPARTTYPE
: This optional field specifies the part type to be used in the design.
: If the parttype is specified in the XFF file, it does not need to be
: included here.
M HIGNORE_LOCS
: This option can be used to direct XNFPREP to ignore all or only specific
: LOC parameters.
M HT_LOCS_ALL
: All LOC constraints will be ignored and will be removed from the output file.
M HT_LOCS_NONE
: LOC constraints will not be ignored and will not be removed from the output file.
M HT_LOCS_IO
: This affects any LOC that is on a pad or I/O symbol.
M HT_LOCS_INTERIOR
: This affects any LOC that is not on a pad or I/O symbol.
M HIGNORE_RLOCS
: This option can be used to direct XNFPREP to ignore all RLOC parameters found
: in the design.  If this option is TRUE, XNFPREP will ignore all RLOC
: parameters found in the design.
M HLOGIC_OPT
: If this option is set to 0 duplicate inputs of boolean symbols will
: not be trimmed.

M RPT_TITLE
> designname s
> version s 
: XNFPREP For Design [designname][.br]
: From XNFPREP Version [version][.br]

M CHAP_TITLE
: Logic Trimming [.br]
: --------------

M WARNING_CHAP_TITLE
: XNFPREP Warnings [.br]
: ---------------

M ERR_CHAP_TITLE
: XNFPREP Errors [.br]
: -------------

M XNFTRIM_INTRO
: This chapter shows the logic removed from your design due to sourceless
: or loadless signals and VCC or ground connections.  If the removal of a
: signal or symbol results in the subsequent removal of an additional
: signal or symbol, the message explaining that second removal will
: be indented.  This indentation will be repeated as a chain of related
: logic is removed.[.br]
: [.br]To quickly locate the original cause for the removal of a chain of
: logic, look at the lines which begin at the leftmost edge of the page
: below.

M XNFTRIM_SUMMARY
: XNF Logic Removal Summary[.br]
: -------------------------

#---------------------- Removed Logic Messages ------------------------
M DISABLED_SYM
: Disabled

M UNNEEDED
: Unneeded

M UNUSED_INDENT
: Unused

M UNUSED
: Unused

M ABSORBED
: One-input 

M REDUCED_SYM
: Logically reduced

M REDUCED_SYM_INDENT
: Logically reduced

M DUPLICATE
: Duplicate input

M VCC_PIN
: VCC input

M GNDED_PIN
: Grounded input

M USED
: Used

M SOURCELESS
: Sourceless

M LOADLESS
: Loadless

M LOOP_SYM
: Unnecessary

M BLANK_LINE
> space s
: [space]

M IOB_CHANGE_SYMBOL
> iob s
> old_type s
> new_type s
> dir s
: [dir] configuration of IOB symbol '[iob]' changed from
: [old_type] symbol to [new_type] symbol.

M IOB_CHANGE_SYM_W_INPUT
> iob s
> old_type s
> new_type s
> sig s
: OUTPUT configuration of IOB symbol '[iob]' changed from
: [old_type] symbol to [new_type] symbol, with [sig] signal as input.

M IOB_TIE2GLOBL
> iob s
> sig s
: INPUT configuration of IOB symbol '[iob]' removed and
: its output connected to [sig].

M CLB_TIE2GLOBL
> clb s
> symname s
> sig s
: [symname] specified in the configuration of CLB symbol '[clb]' removed and
: its output connected to [sig].

M CLB_EQN_PIN_RMVD
> clb s
> pin s
> fg s
: Input '[pin]' removed from [fg] Func Gen equation in CLB symbol '[clb]'.

M IOB_RM_SYM
> iob s
> sym s
: [sym] specified in the configuration of IOB symbol '[iob]' removed.

M CLB_RM_SYM
> clb s
> sym s
: [sym] specified in the configuration of CLB symbol '[clb]' removed.

M CHANGE_SYMBOL
> symbol_name s
> old_symbol_type s
> new_symbol_type s
: [old_symbol_type] symbol '[symbol_name]' changed to [new_symbol_type].

M CHANGE_SYM_W_INPUT
> symbol_name s
> old_symbol_type s
> new_symbol_type s
> sig s
: [old_symbol_type] symbol '[symbol_name]' changed to [new_symbol_type] with
: signal '[sig]' as input.

M REMOVE_SYMBOL
> symbol_type s
> symbol_name s
> reason m
: [reason] [symbol_type] symbol '[symbol_name]' removed.

M REMOVE_SIG
> sig_name s
> reason m
: [reason] signal '[sig_name]' removed.

M GLOBAL_INPUT_INV
> pin s
> sym s
> type s
> global s
: Due to [global] signal on inverted pin '[pin]' of [type] symbol '[sym]':

M LOOPBACK
> type s
> sym s
: Due to the output of [type] symbol '[sym]' looping back only to itself:

#M NO_PINS
#> pin s
#> type s
#> sym s
#: Due to no [pin] pins being used on [type] symbol '[sym]':

#M NO_PIN
#> pin s
#> type s
#> sym s
#: Due to no [pin] pin being used on [type] symbol '[sym]':

M CLB_GLOBAL_INPUT_INV
> sym s
> type s
> cfg s
> global s
: Due to inverted [global] input to [cfg] configuration of [type] symbol '[sym]':

M CLB_GLOBAL_INPUT
> sym s
> type s
> cfg s
> global s
: Due to [global] input to [cfg] configuration of [type] symbol '[sym]':

M GLOBAL_INPUT
> pin s
> sym s
> type s
> global s
: Due to [global] signal on pin '[pin]' of [type] symbol '[sym]':

M XOR_XNOR_O_INV
> sym s
> type s
: Output pin of [type] symbol '[sym]' inverted.

M GLOBAL_ROM_INIT
> sym s
> global s
: Due to ROM symbol '[sym]' INIT value being reduced to [global]:

M REMOVE_PIN
> pin_name s
> symbol_name s
> type s
> reason m
: [reason] pin '[pin_name]' on [type] symbol '[symbol_name]' removed.

M DUP_PIN_INV
> pin s
> inv_pin s
> sym s
> type s
: Due to duplicate input pins '[pin]' and '[inv_pin]' on [type] symbol '[sym]':

M DUP_OPPOSITE_INV
> pin s
> inv_pin s
> sym s
> type s
: Due to duplicate inputs of opposite sense on pins '[pin]' and '[inv_pin]' on
: [type] symbol '[sym]':

M INVS_ABSORBED
: [.br][.br]Inverters were found in the design and were optimized by merging
: them with adjacent functions.  The following signals were removed as a
: result of this optimization:[.br]
: [.br](Note that the replaced signal will not appear in the output netlist, and
: that the signal which replaces it is the opposite sense.)

M BUFS_ABSORBED
: [.br][.br]Buffers were found in the design and were removed.  The
: following signals have been merged together as a result:[.br]
: [.br](Note that the merged signal name is used in the output netlist.)

M SYMS_LOOP
> list s
: [list]

M CLB_X_Y_SAME
> sym s
: Because both X and Y are configured the same for CLB symbol '[sym]':

M CLB_DLAT_ABSORBED
> sym s
: DLAT configuration specified in CLB '[sym]' D input merged with Q output.

M SYMBOL_ABSORBED
> symbol_name s
> symbol_type s
: [symbol_type] symbol '[symbol_name]' absorbed.

M SYMBOL_TYPE_CHANGED
> symbol_name s
> symbol_type s
: Single input [symbol_type] symbol '[symbol_name]' changed to INV symbol.

M SYMBOL_TYPE_CHANGED_BUF
> symbol_name s
> symbol_type s
: Single input [symbol_type] symbol '[symbol_name]' changed to BUF symbol.

M TIE_TO_GLOBAL
> old_sig s
> new_sig s
: Signal '[old_sig]' tied to [new_sig].

M REPLACE_SIG
> old_sig s
> new_sig s
: Signal '[old_sig]' merged into signal '[new_sig]'.

M REPLACE_INV_SIG
> old_sig s
> new_sig s
: Inverted sense of signal '[old_sig]' merged into signal '[new_sig]'.

M RM_PULLUP
> symbol s
> type s
> global s
: [type] symbol '[symbol]' replaced with [global] signal:

M RM_LOOP
: The following feedback loop does not source any other logic:

M INIT_CHANGED
> sym s
> global s
: The init value of ROM symbol '[sym]' has been changed to reflect the
: [global] value on the address input pin. 

M BUFG_CONVERTED
> bufg s
> newtype s
> sig s
: BUFG symbol '[bufg]' (driving signal '[sig]') converted to architecture
: specific [newtype] clock symbol. 

M CARRY_REDUCED
> sym s
> oldmode s
> newmode s
> sig s
: Carry mode [oldmode] of CY4 symbol '[sym]' (COUT0 signal='[sig]') changed 
: to carry mode [newmode] since COUT pin is unused.

M GSR_REDUNDANCY
> sym s
> type s
> sig s
: The 'RD' pin of [type] symbol '[sym]' (driving signal '[sig]') removed; this
: pin was connected to the global reset signal, which is a redundant connection.

M CHANGED_TO_EXAMINE_CI
> carry s
> mode s
: Carry mode '[mode]' of CY4 symbol '[carry]' changed to carry mode 
: `EXAMINE-CI' since neither COUT0 nor COUT pin is used.

M UNBONDED_PAD_OUTPUT
: Due to output sourcing only unbonded pad:

M TSPEC_TNM_MOVED
> value s
> outsig s
: TNM '[value]' moved to load pin(s) on signal '[outsig]'

M TSPEC_TS_MOVED
> name s
> outsig s
: TS '[name]' moved to load pin(s) on signal '[outsig]'

M TSPEC_DPIN_MOVED
> name s
> value s
> symtype s
> symname s
: [name] '[value]' moved to pin 'D' of [symtype] symbol '[symname]'

M TSPEC_REMOVED
> symname s
> symtype s
> name s
> value s
: [symtype] symbol '[symname]' removed from [name] '[value]' 

#----------------------------- Error Messages ---------------------
M FILE_READ_ERROR -e4001
: XNFPREP was aborted because it could not read in the
: input design due to the following error(s):

M FILE_NOT_FOUND -e4002
> name s
: XNFPREP was aborted because it could not find the input design [name].[.br]

M FILE_EXT -e4003
> name s
: XNFPREP was aborted because it could not find a
: [name].xff or [name].xg file.  Since no file extension was specified,
: XNFPREP looked for a flattened (XFF) or XBLOX (XG) file. (A flattened
: XFF file is produced by XNFMERGE.)[.br]
 
M REPORT_OPENFAILED -e4004
> name s
: The XNFPREP report file for design "[name]" could not be opened.[.br]

M PARTTYPE_ERROR -e4005
> parttype s
: The parttype '[parttype]' is illegal.[.br]

M PARTTYPE_MISSING -e4006
> filename s
: The part type is not specified in the design [filename].
: You may specify the part type from the command line.[.br]

M ALL_DELETED -e4007
: Everything in the design was deleted.  This was probably
: caused by a number of key signals being sourceless or loadless.
: See the Logic Trimming Summary section below for details. [.br]

M TBUF_ENABLED -e4008
> symbol s
> sig s
: After logic trimming, TBUF symbol '[symbol]' is permanently enabled due
: to the "T" pin being driven by GND.  This causes contention with other
: sources on the signal '[sig]'.[.br]

M PULLUPDOWN_ERROR -e4009
: The following PULLUP or PULLDOWN symbols are used illegally.[.br]

M ROM_PIN_MISSING -e4010
> symbol s
> pinname s
> outsig s
: Pin(s) [pinname] on ROM symbol '[symbol]' (output signal = [outsig])
: are not connected or the signals driving them were trimmed.[.br][.br]
: These pin(s) are required based on the ROM INIT value. See the
: Logic Trimming section of this report to find out if any address
: inputs were trimmed. Also check that the specified INIT value
: can be represented given the number of address inputs to the ROM. [.br]

M IOB_ILLEGAL_EQN -e4011
> iob s
> fg s
> outsig s
: The IOB symbol '[iob]' (output signal = [outsig]) contains the CFG '[fg]' 
: statement. CFG EQUATE statement is not allowed on IOB symbol.[.br]

M ROM_INIT_ERROR -e4012
> symbol s
> outsig s
: Symbol '[symbol]' (type = ROM, output signal = [outsig]) does not have
: the required INIT parameter.[.br]

M EQN_PARAM_ERROR -e4013
> symbol s
> outsig s
: Symbol '[symbol]' (type = EQN, output signal = [outsig])
: does not have the required EQN parameter.[.br]

M BUFG_ERROR -e4014
> symbol s
: The BUFG symbol '[symbol]' cannot be converted to an
: architecture specific clock symbol.  Because the output signal drives non-clock
: pins, only the ACLK buffer could be used.  However, ACLK is already being used
: for another signal.  To allow this BUFG to be converted to a GCLK buffer, connect
: the non-clock pins to the BUFG input signal rather than the output.[.br]

M EQN_PIN_MISSING -e4015
> symbol s
> pinname s
> outsig s
> eqn s
: Pin(s) [pinname] on EQN symbol '[symbol]'
: (output signal = [outsig]) are not connected or the signals driving them were
: trimmed.  These pin(s) are required based on the EQN=[eqn] parameter.[.br]

M ILLEGAL_EQUATION -e4016
> symbol s
> eqn s
> outsig s
: The EQN=[eqn] parameter of symbol '[symbol]'
: (type = EQN, output signal = [outsig]) contains non-legal character(s) or
: signal names.[.br]

M MUX_CTRL_IN_EQN -e4077
> sym s
> ctrl s
> eqn s
> outsig s
: Because the Base is specified FGM, the MUX control input pin '[ctrl]' cannot
: be specified in the [eqn] equation for CLB symbol '[sym]' (output signal = [outsig]).[.br]
 
M BASE_EQN_INPUTS_ERR -e4072
> sym s
> base s
> eqn s
> num d
> inputs s
> outsig s
: Because the Base is specified "[base]", only [num] of the inputs {[inputs]} can be specified
: in the [eqn] equation for CLB symbol '[sym]' (output signal = [outsig]).[.br]
 
M BASE_EQN_INPUT_EXCLUSIVE -e4073
> sym s
> base s
> eqn s
> excl s
> outsig s
: Because the Base is specified "[base]", the [excl] inputs cannot both be specified
: in the [eqn] equation for CLB symbol '[sym]' (output signal = [outsig]).[.br]
 
M BASE_EQN_REQ -e4074
> sym s
> base s
> eqn s
> outsig s
: The [eqn] equation is required for a BASE [base] CLB, but is not specified
: for CLB symbol '[sym]' (output signal = [outsig]).[.br]
 
M BASE_EQN_NOT_ALLOWED -e4075
> sym s
> base s
> eqn s
> outsig s
: The [eqn] equation is not allowed to be specified for a BASE [base] CLB.  This
: illegal configuration is specified for CLB symbol '[sym]' (output signal = [outsig]).[.br]
 
M BASE_REQ_X_Y -e4076
> sym s
> base s
> outsig s
: Because the Base is specified "[base]" for CLB symbol '[sym]' (output
: signal = [outsig]), either the X or the Y tag must be configured in the "CFG, Config"
: statement.[.br]

M BASE_FGM_ERROR -e4065
> sym s
> tag s
> base s
> value s
> outsig s
: Because the Base is specified "[base]" for CLB symbol '[sym]' (output
: signal = [outsig]), the configuration [tag]:[value] is not legal.[.br]

M CFG_TAG_ERROR -e4081
> sym s
> type s
> outsig s
> cfg s
> tag s
: Illegal tag '[tag]' was found in the CFG statement "[cfg]" for the symbol
: '[sym]' (type = [type], output signal = [outsig]).[.br]

M CFG_CONFIG_ERROR -e4017
> sym s
> type s
> outsig s
> cfg s
: Syntax error in the CFG statement "[cfg]" for the symbol
: '[sym]' (type = [type], output signal = [outsig]).[.br]

M CLB_EQN_MISSING_PIN -e4018
> clb s
> fg s
> eqn s
> pinname s
> outsig s
: Pin(s) [pinname] for symbol '[clb]' (type = CLB, output
: signal = [outsig]) are not connected or the signals driving them were
: trimmed.  These pin(s) are required based on the CFG statement
: 'EQUATE [fg]=[eqn]'.[.br]

M CLB_ILLEGAL_EQN2 -e4068
> clb s
> fg s
> outsig s
: The CFG statement '[fg]' for CLB symbol '[clb]'
: (output signal = [outsig]) does not contain a legal equation.[.br]
 
M CLB_MUX_TRIMMED -e4071
> clb s
> outsig s
: After logic trimming, only the control signal of the MUX configuration 
: specified for CLB symbol '[clb]' (output signal = [outsig]) remained
: intact.  This configuration is not legal.[.br]

M CLB_ILLEGAL_EQN -e4020
> clb s
> fg s
> eqn s
> outsig s
: The CFG statement 'EQUATE [fg]=[eqn]' for CLB symbol '[clb]'
: (output signal = [outsig]) does not contain a legal equation.[.br]

M NO_CARRY4KXCT -e4021
: The Carry4k.xct file could not be read in.[.br]

M CARRY_INPUTS_ERROR_COUT -e4022
> sym s
> pinname s
> mode s
> sig s
: Input pin(s) [pinname] on CY4 symbol '[sym]' (COUT pin output signal = [sig])
: are not connected or the signals driving them were trimmed. 
: These pin(s) are required based on the carry mode [mode].[.br]

M CARRY_INPUTS_ERROR_COUT0 -e4023
> sym s
> pinname s
> mode s
> sig s
: Input pin(s) [pinname] on CY4 symbol '[sym]'
: (COUT0 pin output signal = [sig]) are not connected or the signals
: driving them were trimmed.
: These pin(s) are required based on the carry mode [mode].[.br]

M CARRY_INPUTS_ERROR -e4024
> sym s
> pinname s
> mode s
: Input pin(s) [pinname] on CY4 symbol '[sym]'
: are not connected or the signals driving them were trimmed.  These pin(s) are
: required based on the carry mode [mode].[.br]

M CFG_EQUATE_ERROR -e4025
> sym s
> type s
> outsig s
> cfg s
: No equation is included in the CFG statement "[cfg]"
: for the symbol '[sym]' (type = [type], output signal = [outsig]).[.br]

M NO_CYMODE -e4026
> carrymode s
> carry s
: Carry mode symbol '[carrymode]', associated with CY4
: symbol '[carry]', does not have a mode specified.[.br]

M INVALID_CYMODE_COUT -e4027
> cymode s
> carry s
> mode s
> sig s
: Carrymode symbol '[cymode]' has an invalid CYMODE parameter
: value '[mode]'; this is not a valid carry mode.  This carrymode symbol is
: associated with CY4 symbol '[carry]' (COUT pin output signal = [sig]).[.br]

M INVALID_CYMODE_COUT0 -e4028
> cymode s
> carry s
> mode s
> sig s
: Carrymode symbol '[cymode]' has an invalid CYMODE parameter
: value '[mode]'; this is not a valid carry mode.  This carrymode symbol is
: associated with CY4 symbol '[carry]' (COUT0 pin output signal = [sig]).[.br]

M INVALID_CYMODE -e4029
> cymode s
> carry s
> mode s
: Carrymode symbol '[cymode]' has an invalid CYMODE parameter
: value '[mode]'; this is not a valid carry mode.  This carrymode symbol is
: associated with CY4 symbol '[carry]'.[.br]

M CFG_BASE_NO_DATA -e4030
> sym s
> type s
> outsig s
> cfg s
: No Base data is included in the CFG statement "[cfg]"
: for the symbol '[sym]' (type = [type], output signal = [outsig]).[.br]

M CFG_UNKNOWN -e4031
> sym s
> type s
> outsig s
> cfg s
: Unrecognized CFG statement "[cfg]" for the
: symbol '[sym]' (type = [type], output signal = [outsig]).[.br]

M CLB_EQN_INPUTS -e4032
> sym s
> eqn s
> outsig s
: There are too many pins specified in the equation for
: CFG statement "[eqn]" for the symbol '[sym]' (type = CLB, output
: signal = [outsig]).[.br]

M CFG_ILLEGAL_BASE -e4064
> sym s
> type s
> base s
> outsig s
: The 'CFG, Base [base]' statement for symbol '[sym]' (type = [type],
: output signal = [outsig]) specifies an invalid Base.[.br]

M CFG_NO_BASE -e4033
> sym s
> type s
> outsig s
: There is no 'CFG, Base' statement specified for the symbol
: '[sym]' (type = [type], output signal = [outsig]).[.br]

M CFG_MISSING_EQUATE -e4066
> sym s
> base s
> eqn s
> outsig s
: There is no 'CFG, Equate [eqn]' statement specified for the symbol
: '[sym]' (type = CLB, output signal = [outsig]); this statement is
: required for a Base [base] CLB.[.br]
 
M CFG_EXTRA_EQUATE -e4067
> sym s
> outsig s
: The 'CFG, Equate G' statement is illegal for symbol '[sym]'
: (type = CLB, output signal = [outsig]) because this CLB has Base F.[.br]

M IBUF_TNM_FOUND -e4034
> param s
> sym s
> pad s
> inff_inlat s
> name s
> outsig s
: The parameter TNM=[param] is attached to the I pin of the IBUF symbol '[sym]'
: connected to pad '[pad]'.[.br]
: Because this pad is also connected to an '[inff_inlat]' symbol '[name]',
: the TNM parameter will not be correctly interpreted to apply only to the
: unregistered input path.[.br]
: To specify the TNM unambiguously, move the parameter from the I pin of the IBUF
: to the IBUF output signal '[outsig]'.

M PARAMS_HEADER -e4035
> pad s
: The following input symbols are connected to the pad '[pad]' but have
: conflicting parameters.[.br]
: Either remove the parameter from one of these symbols or change the parameters
: to be consistent.[.br]

M PACKAGE_READ_ERROR -e4036
> part s
: XNFPREP was aborted because it could not read in the
: package for the '[part]' parttype.[.br]

M NO_MATCH_FOUND -e4037
> sym s
> outsig s
> pad s
> pin s
: The BUFG symbol '[sym]' (output signal='[outsig]') is sourced by a
: pad '[pad]'. This pad is constrained to pin '[pin]' which is not a
: dedicated clock buffer input (or is not a valid I/O pin).[.br][.br]
: Either remove the LOC or change it to one of the dedicated clock buffer
: input pins. If none of the dedicated inputs are available, a normal IOB
: may be used if an IBUF is inserted between the pad and the BUFG.[.br]
: The dedicated inputs are indicated in the data book pinouts as PGCK1-4
: and SGCK-4 for XC4000, or TCLKIN and BCLKIN for XC3000.[.br]
: Also note that a pin number for any package except a pin grid array must
: be prefixed with a "P" character.[.br]

M BUFG_IN_USE -e4038
> sym s
> outsig s
> pad s
> pin s
> type s
> type1 s
: Pad '[pad]' sources the BUFG symbol '[sym]' (output signal='[outsig]')
: and has been constrained to pin '[pin]'. This requires that a BUFG element
: be used, but all [type] elements are already in use (either by explicit
: [type] symbols or by other BUFG symbols with LOC constraints).[.br][.br]
: Either remove the LOC or change it to a dedicated [type1] input pin.
: If no dedicated [type1] inputs are available, a normal IOB may be used if
: an IBUF is inserted between the pad and the BUFG symbol.[.br]

M IOB_REQUIRED_PIN_MISSING -e4078
> blk s
> type s
> pins s
> config s
> insig s
: Pin(s) [pins] for symbol '[blk]' (type = [type], output
: is sourced by signal [insig]) are not connected or the signals driving them were
: trimmed.  These pin(s) are required based on the CFG statement
: '[config]'.[.br]

M CLB_IOB_REQUIRED_PIN_MISSING -e4061
> blk s
> type s
> pins s
> config s
> outsig s
: Pin(s) [pins] for symbol '[blk]' (type = [type], output
: signal = [outsig]) are not connected or the signals driving them were
: trimmed.  These pin(s) are required based on the CFG statement
: '[config]'.[.br]

M CFG_TAG_VALIDITY_ERR -e4062
> sym s
> type s
> err s
> outsig s
: The following tag values in the Config statement for the symbol
: '[sym]' (type = [type], output signal = [outsig]) are not valid:[.br]
: [err]
 
M CFG_TAG_USAGE_ERR -e4063
> sym s
> type s
> err s
> outsig s
: The Config statement for the symbol '[sym]' (type = [type], output
: signal = [outsig]) contains the following errors:[.br]
: [err]

M LOC_PARAMS_COLLISION
> name1 s
> type1 s
> name2 s
> type2 s
> pname1 s
> val1 s
> pname2 s
> val2 s
: Symbol Type=[type1];  Symbol Name=[name1][.br]
: Parameter [pname1][val1][.br][.br]
: Symbol Type=[type2];  Symbol Name=[name2][.br]
: Parameter [pname2][val2][.br]

M PARAMS_COLLISION
> name1 s
> type1 s
> name2 s
> type2 s
> pname1 s
> val1 s
> pname2 s
> val2 s
: Symbol Type=[type1];  Symbol Name=[name1][.br]
: Parameter [pname1]=[val1][.br][.br]
: Symbol Type=[type2];  Symbol Name=[name2][.br]
: Parameter [pname2]=[val2][.br]

M PARAMS_CONFLICT
> name1 s
> type1 s
> name2 s
> type2 s
> pname1 s
> pname2 s
: Symbol Type=[type1];  Symbol Name=[name1][.br]
: Parameter [pname1][.br][.br]
: Symbol Type=[type2];  Symbol Name=[name2][.br]
: Parameter [pname2][.br]

M CFG_DATA_ERROR -e4080
> sym s
> value s
: The configuration for CLB symbol '[sym]' indicates both 'X:[value]' and
: 'Y:[value]'. Although the device architecture allows one signal to be
: sourced by both CLB output pins, the partition, place and route software
: does not currently support it. Change this CLB so that the [value] signal
: is connected to either X: or Y: but not both.[.br]

M CFG_NO_CONFIG -e4084
> sym s
> type s
> outsig s
: CFG CONFIG statement is missing for the
: symbol '[sym]' (type = [type], output signal = [outsig]).[.br]

#------------------------ Warning Messages --------------------------------
M SIG_X_TAG -w4034
: The "X" Parameter on the following signals caused
: inefficient logic partitioning because the symbol listed could not be
: absorbed.[.br]

M SIG_X_TAG_BOTH -w4035
: The "X" Parameters on the following signals caused
: inefficient logic partitioning because the symbol listed could not be
: absorbed.[.br]

M TBUF_TPIN_GNDED -w4036
> symbol s
> outsig s
: After logic trimming, symbol '[symbol]' (type = TBUF,
: output signal = [outsig]) is permanently enabled due to the "T" pin being
: driven by GND.  Therefore, the symbol was changed to a BUF symbol and
: absorbed.[.br]

M INV_INEFFICIENT -w4037
: These inverters could not be absorbed and each will be implemented
: in a single function generator.  This will introduce additional
: delay and use resources inefficiently. (Note that some of the symbols
: listed below may have been reduced to inverters by earlier trimming.)[.br]

M IOB_SYM_NOT_ENABLED_INV -w4079
> symbol s
> outsig s
: After logic trimming, the OUTPUT configuration of IOB symbol '[symbol]' 
: (output is sourced by signal [outsig]) is never enabled due to inverted "T"
: pin being driven by GND.  Therefore, the OUTPUT configuration of the IOB
: symbol was removed.[.br]

M IOB_SYM_NOT_ENABLED -w4070
> symbol s
> outsig s
: After logic trimming, the OUTPUT configuration of IOB symbol '[symbol]' 
: (output is sourced by signal [outsig]) is never enabled due to "T"
: pin being driven by VCC.  Therefore, the OUTPUT configuration of the IOB
: symbol was removed.[.br]

M SYM_NOT_ENABLED -w4038
> symbol s
> type s
> outsig s
: After logic trimming, symbol '[symbol]' (type = [type],
: output signal = [outsig]) is never enabled due to "T" pin being driven by VCC.
: Therefore, the symbol was removed.[.br]

M TPIN_MISSING -w4039
> symbol s
> type s
> outsig s
: The symbol '[symbol]' (type = [type], output signal = '[outsig]')
: was removed because the "T" pin was not connected or the signal
: driving it was trimmed.[.br]

M GNDED_WAND -w4040
> symbol s
> sig s
: After logic trimming, the input of WAND symbol '[symbol]'
: is being driven by GND.  This causes the output signal '[sig]' to always be
: low.  Therefore, all WANDs and/or WORANDs driving this signal were removed.[.br]

M GNDED_WORAND -w4041
> symbol s
> sig s
: After logic trimming, both inputs of WORAND symbol '[symbol]'
: are being driven by GND.  This causes the output signal '[sig]' to
: always be low.  Therefore, all WANDs and/or WORANDs driving this signal were
: removed.[.br]

M SPEC_SYM_REMOVED -w4042
> symbol_type s
> symbol_name s
: [symbol_type] symbol '[symbol_name]' was removed;
: the required pins may not be connected correctly or the signals
: driving them were trimmed.[.br]

M PULLUP_DOWN_UNNEEDED -w4043
> symbol_name s
> symbol_type s
> outsig s
: [symbol_type] symbol '[symbol_name]' (output signal = [outsig])
: was removed because it serves no useful purpose.[.br]

M ROM_GLOBAL -w4044
> name s
> global s
> outsig s
: The INIT value of ROM symbol '[name]' (output signal = [outsig])
: reduces to [global].  The ROM was removed and its output tied to [global].[.br]

M EQN_IS_GLOBAL -w4045
> name s
> global s
> outsig s
: The equation for EQN symbol '[name]' (output signal = [outsig])
: has been reduced to [global].  The symbol was removed and its output
: connected to [global].[.br]

M TPIN_GNDED -w4046
> symbol s
> type s
> outsig s
: After logic trimming, the 3-state output symbol `[symbol]'
: (type = [type], pad signal = [outsig]) was permanently enabled.
: The corresponding device pin will always be driving.[.br]

M MULT_WAND_INV -w4047
> wand1 s
> wand2 s
> outsig s
> insig s
: The two WAND symbols '[wand1]' and '[wand2]' use the
: same input signal '[insig]' and the same output signal '[outsig]'.  Since
: one of the WANDs has an inverted input, the WANDs were removed, and the
: output tied to GND.[.br]

M MULT_WAND -w4048
> wand1 s
> wand2 s
> outsig s
> insig s
: The two WAND symbols '[wand1]' and '[wand2]' use the same
: input signal '[insig]' and the same output signal '[outsig]', so the WAND symbol
: '[wand2]' was removed.[.br]

M NEW_TNM_PARAM -w4049
> name1 s
> type1 s
> name2 s
> type2 s
> pad s
> val1 s
> val2 s
: The following TNM parameters are applied to input symbols on the pad '[pad]'.[.br][.br]
: Symbol Type=[type1];  Symbol Name=[name1][.br]
: TNM=[val1][.br]
: Symbol Type=[type2];  Symbol Name=[name2][.br]
: TNM=[val2][.br][.br]
: A TIMESPEC requirement referring to either of these TNM names will be
: applied to both the INFF and INLAT. There is no way to specify different timing
: requirements for the INFF and INLAT in a single IOB.[.br]

M TRIMMED_SYM_PARAMS -w4050
> details z
: The following illegal parameters were trimmed from these symbols:[.br]
: [details][.br]

M TRIMMED_PIN_PARAMS -w4051
> details z
: The following illegal parameters were trimmed from these symbol pins:[.br]
: [details][.br]

M TRIMMED_EXT_PARAMS -w4052
> details z
: The following illegal parameters were trimmed from these pads:[.br]
: [details][.br]

M TRIMMED_SIG_PARAMS -w4053
> details z
: The following illegal parameters were trimmed from these signals:[.br]
: [details][.br]

M IOB_TPIN_REMOVED -w4054
> symbol s
> outsig s
: After logic trimming, the "T" pin of symbol '[symbol]'
: (type = IOB, output is sourced by signal [outsig]) was not connected or
: the signal driving it was trimmed.  This IOB output is now permanently enabled.[.br]

M TPIN_SYM_REMOVED -w4055
> symbol s
> type s
> outsig s
: After logic trimming, the "T" pin of symbol '[symbol]'
: (type = [type], output signal = [outsig]) was unconnected or
: the signal driving it was trimmed.  Therefore, the symbol was removed.[.br]

M IOB_TPIN_GNDED -w4056
> iob s
> outsig s
: After logic trimming, the "T" pin of symbol '[iob]'
: (type = IOB, output is sourced by signal [outsig]) was being driven by GND.
: The IOB output is now permanently enabled.[.br]

M CARRY_INPUTS_RMVD_COUT -w4057
> symbol s
> pinname s
> mode s
> sig s
: Input pin(s) [pinname] on CY4 symbol '[symbol]' 
: (COUT pin driving signal '[sig]') were removed because they are not
: required, based on the carry mode [mode].[.br]

M CARRY_INPUTS_RMVD_COUT0 -w4058
> symbol s
> pinname s
> mode s
> sig s
: Input pin(s) [pinname] on CY4 symbol '[symbol]'
: (COUT0 pin driving signal '[sig]') were removed because they are not required,
: based on the carry mode [mode].[.br]

M CARRY_INPUTS_RMVD -w4059
> symbol s
> pinname s
> mode s
: Input pin(s) [pinname] on CY4 symbol '[symbol]'
: were removed because they are not required, based on the carry mode [mode].[.br][.br]
: Note that the mode of this CY4 symbol may have been changed if the COUT pin
: and/or COUT0 pin were unused. See the section on "Logic Trimming" below for
: more information.[.br]

M CYMODE_OVERWRITE -w4060
> cymode s
> carry s
> mode s
: The CYMODE parameter on a CY4 symbol '[carry]' will be overwritten by the
: mode '[mode]' of the attached carrymode symbol '[cymode]'.[.br]

M CY4_LOCS -w4061
> option s
> details z
: Although the ignore_locs = [option] option was specified, the following
: LOC parameters could not be ignored because they are attached to CY4
: symbols. Every CY4 symbol must have a single-location LOC parameter.[.br]
: [details][.br]

M CY4_RLOCS -w4062
> details z
: Although the ignore_rlocs = TRUE option was specified, the following
: RLOC parameters could not be ignored because they are attached to CY4
: symbols. Every CY4 symbol must have an RLOC parameter.[.br]
: [details][.br]

M MULT_LOCS -w4063
> sym s
> outsig s
> pad s
> loc s
: Pad '[pad]' sources the BUFG symbol '[sym]' (output signal='[outsig]'
: and has multiple LOC constraints. In order to determine the appropriate
: architecture-specific clock symbol, the first LOC= value ([loc]) will
: be used. Other LOC= values on this pad will be ignored.[.br]

M DOUBLE_PULLUP -w4082
: Double pullups were found on TBUF-driven longlines and/or edge decoder
: longlines. Requiring two pullups would prevent half-length longlines
: from being used, and design placement and resource utilization would be
: adversely affected.[.br][.br]
: One pullup is being removed from each of these longlines. PPR will
: activate both pullups if the signal is routed using a complete longline.[.br]

M TBUF_RLOCS -w4083
> details z
: The following RLOC sets were found to contain TBUF symbols. An RLOC
: set which is not fixed by an RLOC_ORIGIN parameter may not contain TBUFs.
: The RLOCs on these TBUFs will be ignored. If you wish to preserve the
: structure of these TBUFs, attach an RLOC_ORIGIN parameter to the set to
: define an absolute location on the device.[.br]
: [details][.br]

E XNFTRIM

#
# ------------------ xnferr.m ------------------ 
#
#@(#)xnferr.m	6.91  5/11/94
 
 
B XNFERR -start3501 -end4000 -current3686
: XNF Pre-XNFTRIM Design Rule Checker

#-edge
 
# Tool description (for program help)

M DESCRIPTION
: This tool checks for design rule violations in a flattened XNF netlist.
: This tool is run before XNFTRIM.
M DESIGN
: Input XFF Design
M REPORT
: The name of the Report file
M PARTTYPE
: Part type used in the design
M SAVESIG
: Savesig mode
M MIGNORE_LOCS
: Ignores LOCs option
M MT_LOCS_ALL
: Ignore ALL LOC constraints.
M MT_LOCS_NONE
: Do not ignore any LOC constraints.
M MT_LOCS_IO
: Ignore I/O LOC constraints.
M MT_LOCS_INTERIOR
: Ignore non-I/O LOC constraints. 
M IGNORE_RLOCS
: Ignore RLOCs option


# Help Messages

M HDESIGN
: This required argument is the name of the flattened XNF design to be trimmed.
M HREPORT
: This optional field specifies a name for the report file generated by
: XNFERR.  If no file name is specified here, the name of the report
: file will be the base name of the input design, with the extension ".pre".
M HPARTTYPE
: This optional field specifies the part type to be used in the design.
: If the parttype is specified in the XFF file, it does not need to be
: included here.
M HSAVESIG
: This option can be used to direct XNFPREP to keep signals that are either
: sourceless or loadless.  When this option is TRUE, XNFPREP will not trim
: the sourceless or loadless signals, and will add the Savesig "S" parameter
: to these signals.  This option is useful when working with partial designs.
M HIGNORE_LOCS
: This option can be used to direct XNFPREP to ignore all or only specific
: LOC parameters.
M HT_LOCS_ALL
: All LOC constraints will be ignored and will be removed from the output file.
M HT_LOCS_NONE
: LOC constraints will not be ignored and will not be removed from the output file.
M HT_LOCS_IO
: This affects any LOC that is on a pad or I/O symbol.
M HT_LOCS_INTERIOR
: This affects any LOC that is not on a pad or I/O symbol.
M HIGNORE_RLOCS
: This option can be used to direct XNFPREP to ignore all RLOC parameters found
: in the design.  If this option is TRUE, XNFPREP will ignore all RLOC
: parameters found in the design.
 

# Informational and Other Messages

M RPT_TITLE
> designname s
> version s 
: XNFPREP For Design [designname][.br]
: From XNFPREP Version [version][.br]

M ERROR_CHAP_TITLE
: XNFPREP Errors [.br]
: --------------

M WARNING_CHAP_TITLE
: XNFPREP Warnings [.br]
: ----------------



#---------------------------- Error and Warning Messages ----------------------



#---------------------------- Input Design File -------------------------------

M INFILE_NOT_FOUND -e3501
> name s
: XNFERR was aborted because it could not find the input design file `[name]'.
: Note that the file names may not contain any upper case letters.[.br]

M INFILE_NOT_XFF_XG -e3502
> name s
: XNFERR was aborted because the input design file `[name]' is neither of type
: XFF nor XG. XNFERR can be run only on a flattened XNF file (XFF) or an xblox
: generated XNF file (XG). (A flattened XFF file is produced by XNFMERGE.)[.br]

M INFILE_XFF_EXT_NOT_FOUND -e3503
> name s
: XNFERR was aborted because it could not find the [name].xff file.
: Since no file extension was specified, XNFERR looked for the default
: flat XNF (XFF) file. If you wish to run XNFERR on the xblox generated XNF
: (XG) file, then you must explicitly specify the .XG extension.[.br]

M INFILE_READ_ERROR -e3504
: XNFERR was aborted because it could not read in the input design due to the
: following error(s):[.br]



#---------------------------- Report File -------------------------------------

M REPORT_OPENFAILED -e3505
> filename s
> designname s
: The XNFPREP report file `[filename]' for design `[designname]' could not
: be opened.[.br][.br]
:
: Please ensure that you have the permission to write in the directory.[.br]



#---------------------------- Sub Networks Found ------------------------------

M PRE_MAPPED_XNF_FILE -e3506
> designname s
: The design `[designname]' contains MODEL records. XNFPREP cannot be run on
: previously-mapped XNF files. Please rerun XNFMERGE on the original XNF file(s)
: produced by your design entry interface, and then rerun XNFPREP.[.br]



#---------------------------- Program Records ---------------------------------

M XNFMERGE_NOT_RUN -e3507
> designname s
: XNFMERGE Version 5.0 or later has not been run on the design
: `[designname]'.[.br][.br]
:
: You must run the XNFMERGE program on the unflattened, top-level XNF file
: before running XNFPREP or any other program. The XNFMERGE program resolves
: relative location (RLOC) constraints and the XACT-Performance TS and TNM
: parameters. For this reason, the XNFMERGE program is required even for
: non-hierarchical designs.[.br]



#---------------------------- Part Type ---------------------------------------

M PARTTYPE_ERROR -e3508
> parttype s
: The part type `[parttype]' is illegal.[.br]

M PARTTYPE_MISSING -e3509
> filename s
: The part type is not specified in the design [filename].[.br]
: You may specify the part type from command line.[.br]



#---------------------------- Attribute Missing in partlist.xct File ----------

M ATTRIB_MISSING -e3510
> attribute m
: Unable to read attribute `[attribute]' from partlist.xct file.[.br]



#---------------------------- Param Value Missing -----------------------------

M PARAM_VALUE_MISSING -e3511
> symtype s
> symname s
> outsig s
> paramtype s
: The `[paramtype]' parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) does not have any value assigned to it.[.br]

M PARAM_VALUE_MISSING_EXT -e3512
> padname s
> paramtype s
: The `[paramtype]' parameter on pad `[padname]' does not have any value
: assigned to it.[.br]



#---------------------------- Pin Missing -------------------------------------

M PIN_MISSING -e3513
> symtype s
> symname s
> outsig s
> pinname s
: Pin `[pinname]' does not exist on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br]



#---------------------------- LIBVER Parameter ---------------------------------

M LIBVER_INVALID -e3514
: The following symbols have invalid LIBVER parameter:[.br]

M LIBVER_INVALID_LOOP
> symtype s
> symname s
> outsig s
> libver s
: Symbol Type = [symtype] ; LIBVER = [libver] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]

M LIBVER_INVALID_SYMS_GT_10
: There are more symbols with invalid library version, however they are
: not listed.[.br]

M LIBVER_INVALID_EXPL
: This is probably caused by an error in the library or the translator
: that generated the XNF file. Please contact the vendor that provided the XNF
: interface.[.br]


M LIBVER_UNIFIED_LIBRARY -e3515
: The design file contains a mixture of symbols from the new Unified Libraries
: (library version 2) and the older family-specific libraries.[.br][.br]
:
: The majority of symbols in the design are from the older family-specific
: libraries, however the following symbols from the new Unified Libraries
: were found in the design:[.br]

M LIBVER_UNIFIED_LOOP
> symtype s
> symname s
> outsig s
: Symbol Type = [symtype] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]

M LIBVER_UNIFIED_SYMS_GT_10
: There are more symbols from the Unified Libraries, however they are
: not listed.[.br]


M LIBVER_FAMILY_SPECIFIC -e3516
: The design file contains a mixture of symbols from the new Unified Libraries
: (library version 2) and the older family-specific libraries.[.br][.br]
:
: The majority of symbols in the design are from the new Unified Libraries,
: however the following symbols from the old family-specific libraries were
: found in the design:[.br]

M LIBVER_FAMILY_LOOP
> symtype s
> symname s
> outsig s
: Symbol Type = [symtype] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]

M LIBVER_FAMILY_SYMS_GT_10
: There are more symbols from the family-specific Libraries, however
: they are not listed.[.br]


M LIBVER_EXPL
: Symbols from the two versions of libraries may not be combined in the
: same design. Please ensure that all schematic symbols are taken from the same
: library version. If the inconsistent symbols are generated by a synthesis
: program, there should be an option in that program which controls the library
: version used.[.br]



#---------------------------- Valid Symbol and Signal Names -------------------

M SYM_INVALID_NAMES -e3517
: The following symbol names contain invalid characters:[.br]
: [.br]
: Symbol Name[.br]
: -----------

M SYM_NAMES_LOOP
> symname s
: [symname]

M NAMES_EXPL
: [.br]
: The legal characters are: alphanumeric characters, $, -, _, <, >, and /.
: The names must contain at least one non-digit character. They may start
: with any legal character.[.br]


M SIG_INVALID_NAMES -e3518
: The following signal names contain invalid characters:[.br]
: [.br]
: Signal Name[.br]
: -----------

M SIG_NAMES_LOOP
> signame s
: [signame]



#---------------------------- Hard Macros --------------------------------------

M HARD_MACROS_FOUND -e3519
: The following hard macros were found in the design:[.br]
: [.br]
: Hard Macro Name[.br]
: ---------------

M HARD_MACROS_LOOP
> symtype s
: [symtype]

M HARD_MACROS_EXPL
: [.br]
: The old type of hard macro is no longer supported. Existing hard macros
: can be converted to Relationally Placed Macros (RPMs), which provide the
: same partitioning and placement control as hard macros did. The method
: to incorporate RPM replacements is described below:[.br][.br]
:
: The XNFMERGE program must be rerun to merge in RPMs. XMAKE will rerun
: XNFMERGE automatically UNLESS you are using the -X option or you are
: using the MAK file as input to XMAKE. In these latter two cases, use
: the XMAKE -R option to force all programs to rerun.[.br][.br]
:
: For hard macros from the Xilinx Hard Macro Library, the XNFMERGE program
: will automatically merge in RPM equivalents (provided that the XACT
: environment variable is properly defined, as described in the installation
: instructions). XNFMERGE must be run before XNFPREP.[.br][.br]
:
: For user-created hard macros, use the HM2RPM program to convert existing
: hard macro files to RPMs. HM2RPM creates a logically equivalent XNF netlist
: (using CY4 symbols to represent carry logic) and adds FMAP/HMAP and RLOC
: constraints to duplicate the layout of the original hard macro. After
: running HM2RPM on all hard macros, XNFMERGE must be rerun to merge in the
: RPM equivalent files.[.br]



#---------------------------- Invalid Symbols ----------------------------------

M SYM_INVALID -e3520
> parttype s
: The following are invalid primitives in part `[parttype]'.[.br]

M SYM_INVALID_LOOP
> symtype s
> symname s
> outsig s
: Symbol Type = [symtype] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]

M SYM_INVALID_EXPL
: The design may not have been flattened completely. Check the XNFMERGE
: report file (design.MRG) to see if XNFMERGE encountered any errors in
: flattening the design.[.br][.br]
:
: The symbol type(s) shown above may not be available in the selected part
: family. Please ensure that the design was entered using the correct library.
: [.br][.br]
:
: If the design has been flattened and the correct libraries were used,
: there may be an error in the library or translator that generated the XNF file.
: Please contact the vendor that provided the XNF interface.[.br]



#---------------------------- XBLOX modules in XC3000/XC3100 Designs ----------

M XBLOX_IN_XC3000 -e3521
> partstyle s
: The XBLOX modules were found in the design. The [partstyle] family does not
: support the use of XBLOX modules. The XBLOX modules can be used with the
: XC3000A/XC3100A/XC3000L/XC3100L family devices.[.br]



#---------------------------- RAM/ROM in XC4000D Designs ----------------------

M MEMORY_IN_XC4000D -e3522
: Memory symbols were found in the design. The XC4000D family does not support
: the use of RAM or ROM elements. If your design requires these features, use
: a device from one of the other XC4000 families.[.br]



#---------------------------- Invalid Hydra Symbols ----------------------------

M HYDRA_SYM_INVALID -e3523
> parttype s
: The following input/output registers have been found in the design
: (part = [parttype]):[.br]

M HYDRA_SYM_INVALID_LOOP
> symtype s
> symname s
> outsig s
: Symbol Type = [symtype] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]

M HYDRA_SYM_INVALID_EXPL
: All input/output registers have been eliminated in the XC4000H family.
: Use the CLB flip-flops instead.[.br]



#---------------------------- Invalid Pins -------------------------------------

M PIN_COMB_SYM -e3524
> symtype s
> symname s
> outsig s
> parttype s
> numinpins d
> maxinpins d
: The combinatorial symbol `[symname]' (type = [symtype], output signal = [outsig])
: has [numinpins] input pins. The maximum allowed for the part `[parttype]' are
: [maxinpins].[.br][.br]
:
: This is probably caused by an error in the library or the translator that
: generated the XNF file. Please contact the vendor that provided the XNF
: interface.[.br]

M PIN_INVALID -e3525
> symtype s
> symname s
> outsig s
> pinname s
: Symbol `[symname]' (type = [symtype], output signal = [outsig]) has an
: invalid pin `[pinname]'.[.br][.br]
:
: This is probably caused by an error in the library or the translator that
: generated the XNF file. Please contact the vendor that provided the XNF
: interface.[.br]

M PIN_INVERSION_ILLEGAL -e3526
> symtype s
> symname s
> outsig s
> pinname s
: The pin `[pinname]' on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) is illegally inverted. This pin is
: non-invertible.[.br][.br]
:
: This is probably caused by an error in the library or the translator that
: generated the XNF file. Please contact the vendor that provided the XNF
: interface.[.br]



#----------------------------  Pad Connections ----------------------------------

M PAD_INVALID_CONNS -e3527
> padname s
: The pad `[padname]' is connected to the following invalid symbol pins:[.br]

M PAD_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M PAD_CONNS_EXPL
: [.br]
: A pad can be connected only to the input pin of input symbols/clock buffers
: (such as, the `I' pin of IBUF), and the output pin of output
: symbols/PULLUPs/PULLDOWNs (such as, the `Q' pin of OUTFF).[.br]



#----------------------------  Shorted Input/Output Symbols ------------------------

M IOSYM_SHORTED -e3528
> symtype s
> symname s
> signame s
> inpin s
> outpin s
: The input `[inpin]' and output `[outpin]' pins of the symbol `[symname]'
: (type = [symtype]) are shorted via the signal `[signame]'.[.br]



#----------------------------  Input/Output Symbols In Series ----------------------

M IOSYM_SERIES -e3529
> inorout s
: The following [inorout] symbols are connected in series:[.br]

M IOSYM_SERIES_LOOP
> symtype s
> symname s
> pinname s
> outsig s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]

M IOSYM_SERIES_EXPL
> inorout s
: [inorout] symbols may not be connected in series. The IOB flip-flop and
: latch symbols include the appropriate drivers, so it is not necessary to connect
: an IBUF or OBUF symbol in series. The XBLOX INPUTS or BIDIR_IO symbol should
: not be connected in series with an IOB input symbol (IBUF/INFF/INLAT/INREG).
: Similarly, the XBLOX OUTPUTS or BIDIR_IO symbol should not be connected in
: series with an IOB output symbol (OBUF/OUTFF/OUTFFT).[.br][.br]
:
: On an input, the registered and non-registered input can be brought on-chip
: by connecting an IBUF and input flip-flop in parallel from the pad.[.br]



#----------------------------  IOSig Connections --------------------------------

M IOSIG_INVALID_CONNS -e3530
> signame s
: The signal `[signame]' is illegally connected to I/O symbols as shown below:

M IOSIG_HDR_1
: [.br]
: The following symbol pins correspond to an I/O pad on the device:[.br]
: -----------------------------------------------------------------

M IOSIG_HDR_2
: [.br]
: The following symbol pins correspond to internal device logic:[.br]
: --------------------------------------------------------------

M IOSIG_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M IOSIG_CONNS_EXPL
> signame s
: [.br]
: If the signal `[signame]' is intended to be an I/O signal, only symbol pins
: corresponding to an I/O pad may be connected to it. Check the design for I/O
: symbols which may have been reversed.[.br][.br]
: 
: If the signal is intended to be an internal signal, it may not be connected
: to any symbol pins which correspond to I/O pads.[.br]



#----------------------------  IOSig Connected to VCC/GND ------------------------

M IOSIG_VCC_CONN -e3531
> padname s
: The pad `[padname]' is illegally connected to VCC.[.br][.br]
:
: To drive an LCA output to VCC or GND, connect VCC or GND to
: the input of an OBUF.[.br]

M IOSIG_GND_CONN -e3532
> padname s
: The pad `[padname]' is illegally connected to GND.[.br][.br]
:
: To drive an LCA output to VCC or GND, connect VCC or GND to
: the input of an OBUF.[.br]



#---------------------------  4K Special Input Pads TDI, TMS, TCK ----------------

M SPL_INPAD_TDI_TMS_TCK -e3533
> padtype s
> padname s
> padsig s
: The special input pad `[padname]' (type = [padtype], input signal = [padsig])
: is connected to the following invalid symbol pins:[.br]

M SPL_INPAD_TDI_TMS_TCK_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M SPL_INPAD_TDI_TMS_TCK_EXPL
> padtype s
: [.br]
: The [padtype] pad can be connected either to the `[padtype]' pin on the
: BSCAN primitive, and/or to the `I' pin of IBUF; `D' pins of INFF, INLAT,
: INREG; `Q' pin of OUTFF, `O' pins of OBUF, OBUFT, OUTFFT.[.br]



#---------------------------  4K Special Input Pads MD0, MD2 ---------------------

M SPL_INPAD_MD0_MD2 -e3534
> padtype s
> padname s
> padsig s
: The special input pad `[padname]' (type = [padtype], input signal = [padsig])
: is connected to the following invalid symbol pins:[.br]

M SPL_INPAD_MD0_MD2_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M SPL_INPAD_MD0_MD2_EXPL
> padtype s
: [.br]
: The [padtype] pad can be connected only to the `I' pin of an IBUF symbol.[.br]



#---------------------------  4K Special Output Pad TDO --------------------------

M SPL_OUTPAD_TDO -e3535
> padtype s
> padname s
> padsig s
: The special output pad `[padname]' (type = [padtype], output signal = [padsig])
: is connected to the following invalid symbol pins:[.br]

M SPL_OUTPAD_TDO_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M SPL_OUTPAD_TDO_EXPL
> padtype s
: [.br]
: The [padtype] pad can be connected either to the `[padtype]' pin of BSCAN
: primitive, or to the `O' pin of OBUF/OBUFT symbols.[.br]
: Note: It can not be connected to both BSCAN and OBUF/OBUFT symbols.[.br]

M SPL_OUTPAD_TDO_BOTH -e3536
> padtype s
> padname s
> padsig s
: The special output pad `[padname]' (type = [padtype], output signal = [padsig])
: is connected to both BSCAN and OBUF/OBUFT symbol:[.br]



#---------------------------  4K Special Output Pad MD1 --------------------------

M SPL_OUTPAD_MD1 -e3537
> padtype s
> padname s
> padsig s
: The special output pad `[padname]' (type = [padtype], output signal = [padsig])
: is connected to the following invalid symbol pins:[.br]

M SPL_OUTPAD_MD1_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M SPL_OUTPAD_MD1_EXPL
> padtype s
: [.br]
: The [padtype] pad can be connected only to the `O' pin of an OBUF or
: OBUFT symbol.[.br]



#---------------------------  4K BSCAN Connections -------------------------------

M BSCAN_CONNS -e3538
> pinname s
> symname s
: The `[pinname]' pin of BSCAN symbol `[symname]' is not connected to the
: special [pinname] pad.[.br][.br]
:
: The TDI, TMS, TCK and TDO pins on the BSCAN symbol must be connected directly
: to the corresponding special pad symbols. Do not use IBUF or OBUF symbols
: when connecting these special pads to BSCAN.[.br]



#---------------------------- Count Input Symbols on a Pad ------------------------

M IOSIG_MULTIPLE_INPINS -e3539
> padname s
: The pad `[padname]' is connected to multiple input symbols:[.br]

M IOSIG_MULTIPLE_INPINS_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M IOSIG_MULTIPLE_INPINS_EXPL
: [.br]
: A pad can normally be connected to only one input symbol. A few exceptions to
: this rule are described below.[.br][.br]
:
: For an XC3000 or XC4000 design, an IBUF may be connected in parallel
: with an input flip-flop or an input latch in order to access both the
: registered and non-registered input signals. In addition, for an 
: XC4000 design, an input flip-flop and input latch may be connected
: in parallel to access both the level-sensitive and edge-triggered 
: register outputs.[.br]



#---------------------------- Count Output Symbols on a Pad ------------------------

M IOSIG_MULTIPLE_OUTPINS -e3540
> padname s
: The pad `[padname]' is connected to multiple output symbols:[.br]

M IOSIG_MULTIPLE_OUTPINS_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M IOSIG_MULTIPLE_OUTPINS_EXPL
:[.br]
: A pad can be connected to only one output symbol.[.br]



#---------------------------- IBUF and INFF|INLAT Combinations on Pads --------------

M IOSIG_IBUF_INFF_INLAT -e3541
> padname s
> symtype s
: The pad `[padname]' is connected to both an IBUF and to an [symtype] symbol
: on which the non-registered input path is used:[.br]

M IOSIG_IBUF_INFF_INLAT_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M IOSIG_IBUF_INFF_INLAT_EXPL
> symtype s
: [.br]
: An XC3000 or XC4000 IOB has only two input paths. Either
: remove the IBUF or remove the signal on the [symtype] O pin.[.br]



#---------------------------- INFF and INLAT Combination on Pads -------------------

M IOSIG_INFF_INLAT -e3542
> padname s
: The pad `[padname]' is connected to both an input flip-flop and an input latch,
: but the polarities of the clock and enable pins are not consistent:[.br]

M IOSIG_INFF_INLAT_LOOP
> symtype s
> pinname s
> signame s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Signal Name = [signame]

M IOSIG_INFF_INLAT_EXPL
: [.br]
: In order for the input flip-flop and the input latch to be
: combined into one IOB, the pair must be one of the following:[.br][.br]
:
: (1) a rising-edge triggered flip-flop and a transparent-Low latch; or[.br]
: (2) a falling-edge triggered flip-flop and a transparent-High latch.[.br][.br]
:
: The other combinations of input flip-flop and input latch are invalid.[.br]



#---------------------------- Potential Internal Pad ------------------------------

M IOSIG_MAY_BE_INTERNAL -w3543
> signame s
: The signal `[signame]' is connected to both an input symbol and a permanently
: enabled output symbol. This input/output signal will be placed on a bonded
: IOB.[.br][.br]
:
: If this signal was meant to be placed on an unbonded IOB, attach the INTERNAL
: parameter to either the input or output symbol in your design.[.br]



#---------------------------- XBLOX Input Pin Connections --------------------

M XBLOX_INPIN_CONN -e3544
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signal
: connected to the [pinname] input pin. The [pinname] pin of [symtype] must
: be connected.[.br]

M XBLOX_ALL_INPIN_CONNS -e3545
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signals
: connected to the following pins:[.br][.br]
:
: Pin Name[.br]
: --------

M XBLOX_ALL_INPIN_CONNS_LOOP
> pinname s
: [pinname]

M XBLOX_ALL_INPIN_CONNS_EXPL
> symtype s
: [.br]
: The above pin(s) of the symbol [symtype] must be connected.[.br]



#---------------------------- XBLOX Output Pin Connections -------------------

M XBLOX_OUTPIN_CONN -e3546
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signal
: connected to the [pinname] output pin. The [pinname] pin of [symtype] must
: be connected.[.br]

M XBLOX_ALL_OUTPIN_CONNS -e3547
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has none of its output
: pins connected. At least one of the output pins of [symtype] must be
: connected.[.br]



#---------------------------- XBLOX Pin Connections --------------------------

M XBLOX_ONEPIN_CONN -e3548
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signal
: connected to the [pinname] pin. The [pinname] pin of [symtype] must be
: connected.[.br]



#---------------------------- XBLOX Two Pins ---------------------------------

M XBLOX_TWO_PINS -e3549
> symtype s
> symname s
> signame s
> pinname1 s
> pinname2 s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal `[signame]'
: connected to the [pinname1] pin, but there is no signal connected to the
: [pinname2] pin. To use the [pinname1] pin, the [pinname2] pin must be
: connected.[.br]



#---------------------------- MUXBUSn Pin Connections -------------------------

M XBLOX_MUXBUSn_PINS -e3550
> symtype s
> symname s
> size d
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any of the
: input pins (M0 ... M[size]) connected. At least one of these must be
: connected.[.br]



#---------------------------- SHIFT Loading -----------------------------------

M XBLOX_SHIFT_ASYNC_VAL -e3551
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has an ASYNC_VAL of zero,
: and no other way of loading the SHIFT register. Either specify a non-zero
: ASYNC_VAL, or specify a non-zero SYNC_VAL and connect the SYNC_CTRL pin,
: or connect one of the PAR_IN, MS_IN, or LS_IN pins.[.br]

M XBLOX_SHIFT_SYNC_VAL -e3552
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has a SYNC_VAL of zero,
: and no other way of loading the SHIFT register. Either specify a non-zero
: SYNC_VAL, or specify a non-zero ASYNC_VAL, or connect one of the PAR_IN,
: MS_IN, or LS_IN pins.[.br]

M XBLOX_SHIFT_LOADING -e3553
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has no way of loading the
: SHIFT register. Either specify a non-zero ASYNC_VAL, or specify a non-zero
: SYNC_VAL and connect the SYNC_CTRL pin, or connect one of the PAR_IN, MS_IN,
: or LS_IN pins.[.br]



#---------------------------- XBLOX SHIFT Direction --------------------------

M XBLOX_SHIFT_DIRECTION -e3554
> symtype s
> symname s
> signame1 s
> signame2 s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal `[signame1]'
: connected to its LS_IN pin, and a signal `[signame2]' connected to its
: MS_IN pin, but there is no signal connected to the
: RIGHT_LEFT pin. The RIGHT_LEFT pin must be connected in order to indicate
: the direction of the shift.[.br]



#---------------------------- XBLOX SHIFT Bounds ------------------------------

M XBLOX_SHIFT_BOUNDS -e3555
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have its ENCODING
: and BOUNDS defined. This may be done by adding a BUS_DEF symbol to either
: the PAR_IN or the PAR_OUT pins, or by defining the ENCODING and BOUNDS
: parameters.[.br]



#---------------------------- DECODE EN Pin Connections -----------------------

M XBLOX_DECODE_EN_PIN -e3556
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [pinname] pin tied low.
: This disables the [symtype] symbol.[.br]



#---------------------------- COUNTER Bounds ----------------------------------

M XBLOX_COUNTER_BOUNDS -e3557
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have its ENCODING
: and BOUNDS defined. This may be done by adding a BUS_DEF symbol to either
: the D_IN or the Q_OUT pins, or by defining the ENCODING and BOUNDS
: parameters, or by defining the COUNT_TO parameter.[.br]



#---------------------------- DATA_REG D_IN Pin -------------------------------

M XBLOX_DATA_REG_D_IN_PIN -w3558
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) has its [pinname] pin
: unconnected.[.br]



#---------------------------- BIDIR_IO Pin Connections ------------------------

M XBLOX_BIDIR_IO_PINS -e3559
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has both the INPUTS and
: the OUTPUTS pins unconnected. At least one of these pins must be connected.[.br]



#---------------------------- SLICE, ELEMENT, CAST Pin Connections ------------

M XBLOX_TWO_SINKS -e3560
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has both its pins being driven.
: This will cause the connected busses to have multiple sources.[.br]

M XBLOX_TWO_SOURCES -e3561
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has neither of its pins being
: driven. One of the connected busses must be driven.[.br]



#--------------------------- XBLOX RLOC Parameter Checks ------------------------

M XBLOX_RLOC_PARAM_3K -e3562
> symtype s
> symname s
> outsig s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype], output signal = [outsig]) has an
: invalid parameter [paramname].[.br][.br]
:
: The RLOC, RLOC_RANGE, RLOC_ORIGIN, USE_RLOC, and RLOC set parameters are not
: allowed in XC3000 designs.[.br]

M XBLOX_RLOC_PARAM_4K -e3563
> symtype s
> symname s
> outsig s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype], output signal = [outsig]) has an
: invalid parameter [paramname].[.br][.br]
:
: The RLOC and RLOC set parameters are not allowed on XBLOX modules.
: Relationally placed modules created by XBLOX can be placed directly using
: an RLOC_ORIGIN or RLOC_RANGE parameter, but the sets cannot be modified or
: merged with other sets via the RLOC parameter.[.br]



#---------------------------- Invalid XBLOX Parameters ------------------------

M XBLOX_INVALID_PARAM -w3564
> symtype s
> symname s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramname] parameter
: specified. The parameter [paramname] may not be used with a [symtype]. This
: parameter will be ignored.[.br]



#---------------------------- Required Parameter ------------------------------

M XBLOX_REQ_PARAM -e3565
> symtype s
> symname s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have the [paramname]
: parameter defined. This parameter must be defined.[.br]



#---------------------------- UParam Value Missing ----------------------------

M XBLOX_UPARAM_VALUE_MISSING -e3566
> symtype s
> symname s
> paramname s
: The `[paramname]' parameter on XBLOX symbol `[symname]' (type = [symtype])
: does not have any value assigned to it.[.br]



#--------Invalid Xblox Real Data Value Syntax, Keyword, Bits, Value  ----------

M XBLOX_INVALID_REALDATABITS_SYNTAX -e3567
> symtype s
> symname s
> paramname s
> paramvalue s
> indent s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: parameter [paramname].[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: The value may be either:[.br][.br]
:
: (1) A decimal real number. The number may contain underscore (_)[.br]
: [indent]  characters for readability. The number must contain at least[.br]
: [indent]  one digit.[.br][.br]
:
: (2) A number of the form <base>#<value>#, where <base> is an[.br]
: [indent]  integer between 2 and 36 inclusive. The <value> field should[.br]
: [indent]  be a real number and may include underscore (_) characters for[.br]
: [indent]  readability. The <value> field may also contain don't care[.br]
: [indent]  digits (?) if the base is one of 2, 4, 8, 16, or 32. The[.br]
: [indent]  <value> field should not consists only of _, . and ?, and the[.br]
: [indent]  <base> field must contain at least one digit.[.br][.br]
:
: (3) One of the keywords: SET, VCC, VDD, ALL_1, RESET, GND, ALL_0.[.br]
#: [.br]
#: (4) A number of the form bits(<value>), where <value> follows the[.br]
#: [indent]  syntax shown in cases 1, 2, or 3 above. The value field may[.br]
#: [indent]  not contain a radix point. This syntax forces the value to be[.br]
#: [indent]  treated as a bit string.[.br][.br]
#:
#: (5) A number of the form value(<value>), where <value> follows the[.br]
#: [indent]  syntax shown in cases 1, 2, or 3 above. This syntax forces the[.br]
#: [indent]  value field to be interpreted depending on the datatype of the[.br]
#: [indent]  attached bus.[.br]



#------ Invalid Xblox Real Data Value Syntax, No Keyword, No Bits, No Value ----

M XBLOX_INVALID_REALDATA_SYNTAX -e3568
> symtype s
> symname s
> paramname s
> paramvalue s
> indent s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: parameter [paramname].[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: The value may be either:[.br][.br]
:
: (1) A decimal real number. The number may contain underscore (_)[.br]
: [indent]  characters for readability. The number must contain at least[.br]
: [indent]  one digit.[.br][.br]
:
: (2) A number of the form <base>#<value>#, where <base> is an[.br]
: [indent]  integer between 2 and 36 inclusive. The <value> field should[.br]
: [indent]  be a real number and may include underscore (_) characters for[.br]
: [indent]  readability. The don't care digits (?) are not allowed. The[.br]
: [indent]  <value> field should not consists only of . and _, and the[.br]
: [indent]  <base> field must contain at least one digit.[.br]



#-------------------- Invalid Xblox Integer Data Value Syntax ------------------

M XBLOX_INVALID_INTDATA_SYNTAX -e3569
> symtype s
> symname s
> paramname s
> paramvalue s
> indent s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: parameter [paramname].[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: The value may be either:[.br][.br]
:
: (1) A decimal integer number. The number may contain underscore (_)[.br]
: [indent]  characters for readability. The number must contain at least[.br]
: [indent]  one digit.[.br][.br]
:
: (2) A number of the form <base>#<value>#, where <base> is an[.br]
: [indent]  integer between 2 and 36 inclusive. The <value> field should be[.br]
: [indent]  an integer number and may include underscore (_) characters for[.br]
: [indent]  readability. The don't care digits (?), and radix point are not[.br]
: [indent]  allowed. The <value> field should not consists only of _, and[.br]
: [indent]  the <base> field must contain at least one digit.[.br]



#------------------- Invalid Xblox Positive Integer Data Value Syntax ----------

M XBLOX_INVALID_POSINTDATA_SYNTAX -e3570
> symtype s
> symname s
> paramname s
> paramvalue s
> indent s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: parameter [paramname].[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: The parameter value should be a non-zero positive integer. The value may be
: either:[.br][.br]
:
: (1) A decimal integer number. The number may contain underscore (_)[.br]
: [indent]  characters for readability. The number must contain at least[.br]
: [indent]  one digit.[.br][.br]
:
: (2) A number of the form <base>#<value>#, where <base> is an[.br]
: [indent]  integer between 2 and 36 inclusive. The <value> field should be[.br]
: [indent]  an integer number and may include underscore (_) characters for[.br]
: [indent]  readability. The don't care digits (?), and radix point are not[.br]
: [indent]  allowed. The <value> field should not consists only of _, and[.br]
: [indent]  the <base> field must contain at least one digit.[.br]



#---------------------------- Invalid Xblox Integer Data Range Syntax ----------

M XBLOX_INVALID_INTDATARANGE_SYNTAX -e3571
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: parameter [paramname].[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: The syntax of the [paramname] parameter is MSB:LSB. The difference of the
: two indices, plus one, equals the width of the bus.[.br]



#---------------------------- ANDBUS STYLE Parameter --------------------------

M XBLOX_ANDBUS_STYLE_4K -e3572
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: For XC4000 designs, possible values for the [paramname] parameter are:
: DECODE and WAND. The [paramname] parameter may also be omitted altogether.[.br]

M XBLOX_ANDBUS_STYLE_3K -e3573
> symtype s
> symname s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype]) has the parameter [paramname]
: defined. This parameter may only be used on XC4000 designs.[.br]



#---------------------------- ANDBUS LOC Parameter ----------------------------

M XBLOX_LOC_ON_ANDBUS -e3574
> symtype s
> symname s
> outsig s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype], output signal = [outsig]) has an
: invalid parameter [paramname].[.br][.br]
:
: The [paramname] parameter is allowed on the ANDBUS symbol only when
: the STYLE parameter is specified and its value is either WAND or DECODE.[.br]



#---------------------------- ACCUM STYLE Parameters --------------------------

M XBLOX_ACCUM_STYLE_4K -e3575
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: For XC4000 designs, possible values for the [paramname] parameter are:
: ALIGNED, UNALIGNED, and RIPPLE. The [paramname] parameter may also be
: omitted altogether.[.br]

M XBLOX_ACCUM_STYLE_3K -e3576
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: For XC3000 designs, possible values for the [paramname] parameter are:
: FAST3KA and RIPPLE. The [paramname] parameter may also be omitted altogether.[.br]



#---------------------------- SHIFT STYLE Parameter ---------------------------

M XBLOX_SHIFT_STYLE -e3577
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: Possible values for the [paramname] parameter are: LOGICAL, CIRCULAR, and ARITH.
: The [paramname] parameter may also be omitted altogether.[.br]



#---------------------------- COUNTER STYLE Parameter -------------------------

M XBLOX_COUNTER_STYLE_VALUES -e3578
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: Possible values for the [paramname] parameter are: BINARY, JOHNSON, LFSR,
: and ONE_HOT. The [paramname] parameter may also be omitted altogether.[.br]



#---------------------------- COUNTER Parameters -----------------------------

M XBLOX_COUNTER_STYLE -e3579
> symtype s
> symname s
> paramname s
> style s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramname] parameter
: specified. The parameter [paramname] can not be used with a [style] counter.[.br]

M XBLOX_COUNTER_CONFLICT_PARAMS -e3580
> symtype s
> symname s
> paramname1 s
> paramvalue1 s
> paramname2 s
> paramvalue2 s
> indent s
: The XBLOX symbol `[symname]' (type = [symtype]) has conflicting [paramname1]
: and [paramname2] parameter values.[.br]
: [indent][paramname1]=[paramvalue1][.br]
: [indent][paramname2]=[paramvalue2][.br][.br]
:
: Both parameters should have ONE_HOT value.[.br]



#---------------------------- DATA_REG STYLE Parameter ---------------------------

M XBLOX_DATA_REG_STYLE -e3581
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: Possible values for the [paramname] parameter are: CLB, IOB, ILD, IFD, and OFD.
: The [paramname] parameter may also be omitted altogether.[.br]

M XBLOX_DATA_REG_STYLE_XC4000H -e3582
> symtype s
> symname s
> paramname s
> paramvalue s
> parttype s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramname] =
: [paramvalue] parameter, which indicates that it should be implemented
: in IOBs. This can not be done in XC4000H devices, since these devices
: do not contain any input or output flip-flops.[.br]
: Part Type Used = [parttype][.br]



#---------------------------- Conflicting Parameters -----------------------------

M XBLOX_CON_PARAM_INLATCH_FF -e3583
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it should be implemented in input latches. However,
: it also has the [conparamtext] parameter, which indicates that it should
: be implemented in flip-flops. These parameters conflict with each other.[.br]

M XBLOX_CON_PARAM_INREG_OUTREG -e3584
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it should be implemented in input registers. However,
: it also has the [conparamtext] parameter, which indicates that it should
: be implemented in output registers. These parameters conflict with each other.[.br]

M XBLOX_CON_PARAM_IOB_CLB -e3585
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it should be implemented in IOBs. However,
: it also has the [conparamtext] parameter, which indicates that it should
: be implemented in CLBs. These parameters conflict with each other.[.br]

M XBLOX_CON_PARAM_INLATCH_OUTFF -e3586
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it should be implemented in input latches. However,
: it also has the [conparamtext] parameter, which indicates that it should
: be implemented in output flip-flops. These parameters conflict with each other.[.br]

M XBLOX_CON_PARAM_INFF_INLATCH -e3587
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it should be implemented in input flip-flops. However,
: it also has the [conparamtext] parameter, which indicates that it should
: be implemented in input latches. These parameters conflict with each other.[.br]

M XBLOX_CON_PARAM_INFF_OUTFF -e3588
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it should be implemented in input flip-flops. However,
: it also has the [conparamtext] parameter, which indicates that it should
: be implemented in output flip-flops. These parameters conflict with each other.[.br]

M XBLOX_CON_PARAM_INELEM_OUTFF -e3589
> symtype s
> symname s
> paramtext s
> conparamtext s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramtext] parameter,
: which indicates that it is an input element. However, it also has the [conparamtext]
: parameter, which indicates that it should be implemented in output flip-flops.
: These parameters conflict with each other.[.br]



#---------------------------- COMPARE Parameters -----------------------------

M XBLOX_COMPARE_EQ_STYLE_4K -e3590
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: When only the equality comparison outputs are used in XC4000 designs,
: possible values for the [paramname] parameter are: ARITH, RIPPLE, TREE,
: and WIRED. The [paramname] parameter may also be omitted altogether.[.br]

M XBLOX_COMPARE_MAG_STYLE_4K -e3591
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: When the magnitude comparison outputs are used in XC4000 designs,
: possible values for the [paramname] parameter are: ARITH and TREE.
: The [paramname] parameter may also be omitted altogether.[.br]

M XBLOX_COMPARE_EQ_STYLE_3K -e3592
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: When only the equality comparison outputs are used in XC3000 designs,
: possible values for the [paramname] parameter are: ARITH, RIPPLE, and TREE.
: The [paramname] parameter may also be omitted altogether.[.br]

M XBLOX_COMPARE_MAG_STYLE_3K -e3593
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: When the magnitude comparison outputs are used in XC3000 designs,
: possible values for the [paramname] parameter are: ARITH and TREE.
: The [paramname] parameter may also be omitted altogether.[.br]



#---------------------------- ENCODING Parameter -----------------------------

M XBLOX_ENCODE_PARAM -e3594
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br]
: Parameter Value = [paramvalue][.br][.br]
:
: Possible values for the [paramname] parameter are: BIT, UBIN, ONE_HOT,
: and TWO_COMP.[.br]

M XBLOX_ENCODE_BOUNDS_PARAM -e3595
> symtype s
> symname s
> encodeparam s
> boundsparam s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have the
: [boundsparam] parameter defined. The [boundsparam] parameter must be
: specified when the [encodeparam] parameter is defined and its value is
: other than BIT.[.br]



#---------------------------- BUS_DEF BOUNDS Parameter -----------------------

M XBLOX_BUS_DEF_BOUNDS_PARAM -e3596
> symtype s
> symname s
> boundsparam s
> encodeparam s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have the
: [boundsparam] parameter defined. A [symtype] symbol must have the
: [boundsparam] parameter. This requirement is waived when the
: [symtype] has an [encodeparam] parameter with value BIT.[.br]



#---------------------------- CLK_DIV Parameters -----------------------------

M XBLOX_CLK_DIV_WARN -w3597
> symtype s
> symname s
> paramname s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [paramname] parameter
: specified. This function is currently not supported.[.br]



#---------------------------- PROM Parameters --------------------------------

M XBLOX_PROM_REQ_PARAM -e3598
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have the MEMFILE
: or the INIT parameters defined. One of these parameters must be defined in
: order to specify the contents of PROM. The INIT parameter may only be used
: if the width of the PROM is 32 bits or less.[.br]

M XBLOX_PROM_BOTH_PARAM -e3599
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has both the MEMFILE and
: the INIT parameters defined. Only one of these parameters may be used to
: specify the contents of the PROM.[.br]



#---------------------------- ASYNC_VAL & INIT Parameters --------------------

M XBLOX_BOTH_ASYNC_VAL_INIT_PARAMS -e3600
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has both ASYNC_VAL and INIT
: parameters defined. Only one of these parameters should be used to specify
: the initial value.[.br]



#---------------------------- INIT Parameter Value ---------------------------

M XBLOX_INIT_PARAM -e3601
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: The valid values for the [paramname] parameter are: R (reset) or S (set).[.br]



#---------------------------- FLOAT_VAL Parameter on I/O Symbols -------------

M XBLOX_IO_FLOATVAL -e3602
> symtype s
> symname s
> paramname s
> paramvalue s
> indent s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: parameter [paramname].[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: Possible values for the FLOAT_VAL parameter are PULLUP, PULLDOWN, or a
: data value. The data value may be either:[.br][.br]
:
: (1) A decimal real number. The number may contain underscore (_)[.br]
: [indent]  characters for readability. The number must contain at least[.br]
: [indent]  one digit.[.br][.br]
:
: (2) A number of the form <base>#<value>#, where <base> is an[.br]
: [indent]  integer between 2 and 36 inclusive. The <value> field should[.br]
: [indent]  be a real number and may include underscore (_) characters for[.br]
: [indent]  readability. The <value> field may also contain don't care[.br]
: [indent]  digits (?) if the base is one of 2, 4, 8, 16, or 32. The[.br]
: [indent]  <value> field should not consists only of _, . and ?, and the[.br]
: [indent]  <base> field must contain at least one digit.[.br][.br]
:
: (3) One of the keywords: SET, VCC, VDD, ALL_1, RESET, GND, ALL_0.[.br]
#: [.br]
#: (4) A number of the form bits(<value>), where <value> follows the[.br]
#: [indent]  syntax shown in cases 1, 2, or 3 above. The value field may[.br]
#: [indent]  not contain a radix point. This syntax forces the value to be[.br]
#: [indent]  treated as a bit string.[.br][.br]
#:
#: (5) A number of the form value(<value>), where <value> follows the[.br]
#: [indent]  syntax shown in cases 1, 2, or 3 above. This syntax forces the[.br]
#: [indent]  value field to be interpreted depending on the datatype of the[.br]
#: [indent]  attached bus.[.br]



#---------------------------- FLOAT_VAL Parameter on TRISTATE Symbol ---------

M XBLOX_TRI_FLOATVAL -e3603
> symtype s
> symname s
> paramname s
> paramvalue s
: The XBLOX symbol `[symname]' (type = [symtype]) has an invalid value for the
: [paramname] parameter.[.br][.br]
:
: Parameter Value = [paramvalue][.br][.br]
:
: Possible values for the [paramname] parameter are: PULLUP and PULLUP_D.[.br]



#------------------------ Invalid Parameters On Symbols and EXT Records --------

M SYM_PARAM_INVALID -e3604
> symtype s
> symname s
> outsig s
> paramname s
: The symbol `[symname]' (type = [symtype], output signal = [outsig]) has an
: invalid parameter [paramname].[.br]

M SYM_PARAM_CONFLICT -e3605
> symtype s
> symname s
> outsig s
> paramname s
> cparamname s
: The symbol `[symname]' (type = [symtype], output signal = [outsig]) has
: conflicting parameters: [paramname] and [cparamname].[.br]

M EXT_PARAM_INVALID -e3606
> padname s
> paramname s
: The pad `[padname]' has an invalid parameter [paramname].[.br]

M EXT_PARAM_CONFLICT -e3607
> padname s
> paramname s
> cparamname s
: The pad `[padname]' has conflicting parameters: [paramname] and [cparamname].[.br]



#------------------------ RLOC Parameters On Symbols -------------------------

M RLOC_ORIGIN_PRESENT -e3608
> symtype s
> symname s
> outsig s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has RLOC_ORIGIN parameter.[.br][.br]
:
: RLOC_ORIGIN parameters are resolved by the XNFMERGE program.
: Please run the XNFMERGE program first.[.br]

M RLOC_RANGE_NO_RLOC -e3609
> symtype s
> symname s
> outsig s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has RLOC_RANGE parameter, however it does not have any RLOC parameter.[.br]

M RLOC_NO_RLOC_SET -e3610
> symtype s
> symname s
> outsig s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has RLOC parameter, however it does not have any RLOC set parameter
: (H_SET/U_SET/HU_SET/F_SET).[.br]

M RLOC_SET_NO_RLOC -e3611
> symtype s
> symname s
> outsig s
> settype s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has the [settype] parameter, however it does not have any RLOC parameter.[.br]



#----------------------- Parameter Check Exceptions for 4K Parts --------------

M MEDFAST_MEDSLOW_PARAMS -e3612
> symtype s
> symname s
> outsig s
> paramname s
> parttype s
: The symbol `[symname]' (type = [symtype], output signal = [outsig]) has
: an invalid parameter [paramname].[.br]
: PartType = `[parttype]'.[.br][.br]
:
: MEDFAST and MEDSLOW parameters are allowed only in XC4000A parts.[.br]

M FAST_SLOW_PARAMS -e3613
> symtype s
> symname s
> outsig s
> paramname s
> parttype s
: The symbol `[symname]' (type = [symtype], output signal = [outsig]) has
: an invalid parameter [paramname].[.br]
: PartType = `[parttype]'.[.br][.br]
:
: FAST, SLOW, MEDFAST, MEDSLOW, and NODELAY parameters are not allowed in
: XC4000H parts.[.br]

M CAP_RES_TTL_CMOS_PARAMS -e3614
> symtype s
> symname s
> outsig s
> paramname s
> parttype s
: The symbol `[symname]' (type = [symtype], output signal = [outsig]) has
: an invalid parameter [paramname].[.br]
: PartType = `[parttype]'.[.br][.br]
:
: CAP, RES, TTL, and CMOS parameters are allowed only in XC4000H parts.[.br]

M MEDFAST_MEDSLOW_PARAMS_EXT -e3615
> padname s
> paramname s
> parttype s
: The pad `[padname]' has an invalid parameter [paramname].[.br]
: PartType = `[parttype]'.[.br][.br]
:
: MEDFAST and MEDSLOW parameters are allowed only in XC4000A parts.[.br]

M FAST_SLOW_PARAMS_EXT -e3616
> padname s
> paramname s
> parttype s
: The pad `[padname]' has an invalid parameter [paramname].[.br]
: PartType = `[parttype]'.[.br][.br]
:
: FAST, SLOW, MEDFAST, MEDSLOW, and NODELAY parameters are not allowed in
: XC4000H parts.[.br]

M CAP_RES_TTL_CMOS_PARAMS_EXT -e3617
> padname s
> paramname s
> parttype s
: The pad `[padname]' has an invalid parameter [paramname].[.br]
: PartType = `[parttype]'.[.br][.br]
:
: CAP, RES, TTL, and CMOS parameters are allowed only in XC4000H parts.[.br]



#---------------------------- EQN Param ------------------------------------------

M EQN_MISSING_EQN_PARAM -e3618
> symtype s
> symname s
> outsig s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: does not have the EQN parameter.[.br][.br]
:
: An EQN symbol must have the EQN parameter.[.br]



#---------------------------- ROM Param ------------------------------------------

M ROM_MISSING_INIT_PARAM -e3619
> symtype s
> symname s
> outsig s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: does not have the INIT parameter.[.br][.br]
:
: A [symtype] symbol must have an INIT parameter.[.br]


M ROM_INVALID_INIT_PARAM -e3620
> symtype s
> symname s
> outsig s
> paramvalue s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has an invalid INIT parameter value `[paramvalue]'.[.br][.br]
:
: The valid [symtype] INIT parameter value is a hexadecimal number with no
: more than 8 digits. A hexadecimal digit is in the range of '0' to '9' or
: 'A' to 'F' or 'a' to 'f'.[.br]



#---------------------------- 4K Flip-flop -----------------------------------------

M FF_INVALID_INIT_PARAM -e3621
> symtype s
> symname s
> outsig s
> paramvalue s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has invalid INIT parameter value `[paramvalue]'.[.br][.br]
:
: The valid INIT values on an XC4000 flip-flop are S (set)
: or R (reset).[.br]



#---------------------------- 4K DFF -----------------------------------------------

M DFF_BOTH_PRE_CLR_PINS -e3622
> symname s
> outsig s
: 4K DFF `[symname]' (output signal = [outsig]) has both asynchronous set
: (PRE/SD) and reset (CLR/RD) pins connected.[.br][.br]
:
: Only one of set and reset pin is available for connection.[.br]

M DFF_INIT_PARAM -e3623
> symname s
> outsig s
> pintype s
> pinname s
> paramvalue s
: The asynchronous [pintype] pin ([pinname]) used with the DFF `[symname]'
: (output signal = [outsig]) is inconsistent with the INIT parameter value
: `[paramvalue]'.[.br][.br]
:
: Since the initialization state and the behavior of the individual set/reset
: input is determined by the same logic, a flip-flop which has an asynchronous
: set input cannot be initialized as reset, and vice versa.[.br]



#---------------------------- TBUF Errors ---------------------------------------

M TBUF_OTPINS_SAME_SIG -e3624
> symtype s
> symname s
> signame s
: The signal `[signame]' is connected to both the 3-state and output pins
: of [symtype] symbol `[symname]'. Please check the design for misnamed or
: misconnected signals.[.br]

M TBUFS_TPINS_SAME_SIG -e3625
> Osigname s
> Tsigname s
: The following TBUFs drive the same output signal `[Osigname]', and are
: enabled by the same 3-state signal `[Tsigname]'.[.br]
: [.br]
: TBUF Symbol Name[.br]
: ----------------

M TBUFS_TPINS_SAME_SIG_LOOP
> symname s
: [symname]



#-------------------- Errors on Carry Mode Symbols ---------------------------------

M CY4MODE_CYMODE_PARAM_ABSENT -e3626
> symtype s
> symname s
> signame s
: The carry mode symbol `[symname]' (type = [symtype], C1 signal = [signame])
: does not have a CYMODE parameter.[.br][.br]
:
: This is probably caused by an error in the library or the translator that
: generated the XNF file. Please contact the vendor that provided the XNF
: interface.[.br]



#-------------------- Errors on CY4 and Carry Mode Symbol Connections --------------

M CY4_CYMODE_PARAM_ABSENT -e3627
> symname s
> outsig s
: The CY4 symbol `[symname]' (output signal = [outsig]) does not have a carry
: mode symbol attached to it. It also does not have any CYMODE parameter.[.br][.br]
:
: Either attach an appropriate carry mode symbol or add the equivalent CYMODE
: parameter on the CY4 symbol.[.br]

M CY4_MORE_THAN_ONE_CY4MODE_SYM -e3628
> symname s
> outsig s
: The CY4 symbol `[symname]' (output signal = [outsig]) has more than one carry
: mode symbols attached to it.[.br][.br]
:
: Only one carry mode symbol can be connected to a CY4 symbol.[.br]

M CY4_Cn_PIN_CONN_MORE_THAN_ONE_PIN -e3629
> symname s
> outsig s
> pinname s
: The [pinname] pin of CY4 symbol `[symname]' (output signal = [outsig]) is
: connected to more than one pin.[.br][.br]
:
: The [pinname] pin of CY4 symbol can be connected only to the [pinname] pin
: of carry mode symbol. Please verify connections between CY4 symbol and the
: attached carry mode symbol.[.br]

M CY4_Cn_PIN_WRONG_CONN -e3630
> symname s
> outsig s
> pinname s
: The [pinname] pin of CY4 symbol `[symname]' (output signal = [outsig]) is not
: connected to the [pinname] pin of carry mode symbol.[.br][.br]
:
: The [pinname] pin of CY4 symbol must be connected only to the [pinname] pin
: of carry mode symbol. Please verify connections between CY4 symbol and the
: attached carry mode symbol.[.br]



#--------------- LOC/RLOC values on CY4 and Carry Mode symbols --------------------

M CARRY_HAS_MULTIPLE_LOCS -e3631
> symtype s
> symname s
> pinname s
> outsig s
> loccount d
: The [symtype] symbol `[symname]' ([pinname] signal = [outsig]) has `[loccount]'
: LOC parameters.[.br][.br]
:
: A [symtype] symbol can have only one LOC parameter with one explicit value.
: Area, wild-card, and prohibit forms of the LOC parameter on this symbol are
: not valid.[.br]

M CARRY_HAS_MULTIPLE_LOCS_EXPL2
> symtype s
> option s
: Although the ignore_locs = [option] option was specified, the above LOC
: parameters could not be ignored because they are attached to a [symtype]
: symbol. Every CY4 or the attached carry mode symbol must have a
: single-location LOC/RLOC parameter.[.br]

M CARRY_LOC_HAS_PROHIBIT -e3632
> symtype s
> symname s
> pinname s
> outsig s
> paramvalue s
: The [symtype] symbol `[symname]' ([pinname] signal = [outsig]) has a LOC
: parameter with prohibit flag.[.br]
: LOC<>`[paramvalue]'.[.br][.br]
:
: A [symtype] symbol can have only one LOC parameter with one explicit value.
: Area, wild-card, and prohibit forms of the LOC parameter on this symbol are
: not valid.[.br]

M CARRY_LOC_HAS_PROHIBIT_EXPL2
> symtype s
> option s
: Although the ignore_locs = [option] option was specified, the above LOC
: parameter could not be ignored because it is attached to a [symtype]
: symbol. Every CY4 or the attached carry mode symbol must have a
: single-location LOC/RLOC parameter.[.br]

M CARRY_LOC_HAS_RANGE -e3633
> symtype s
> symname s
> pinname s
> outsig s
> locvalue1 s
> locvalue2 s
: The [symtype] symbol `[symname]' ([pinname] signal = [outsig]) has
: an area LOC parameter.[.br]
: LOC value for the upper left corner = `[locvalue1]'.[.br]
: LOC value for the lower right corner = `[locvalue2]'.[.br][.br]
:
: A [symtype] symbol can have only one LOC parameter with one explicit value.
: Area, wild-card, and prohibit forms of the LOC parameter on this symbol are
: not valid.[.br]

M CARRY_LOC_HAS_RANGE_EXPL2
> symtype s
> option s
: Although the ignore_locs = [option] option was specified, the above LOC
: parameter could not be ignored because it is attached to a [symtype]
: symbol. Every CY4 or the attached carry mode symbol must have a
: single-location LOC/RLOC parameter.[.br]

M CY4_CY4MODE_PARAM_VALUES_DIFF -e3634
> symtype s
> symname s
> symparam s
> outsig s
> modetype s
> modename s
> modeparam s
> paramname s
: The CY4 symbol `[symname]' (output signal = [outsig]) and the attached carry
: mode symbol `[modename]' (type = [modetype]) have different values for the
: [paramname] parameter.[.br][.br]
:
: Symbol Type = [symtype] ; [paramname] = [symparam] ; Symbol Name = [symname][.br]
: Symbol Type = [modetype] ; [paramname] = [modeparam] ; Symbol Name = [modename]
: [.br][.br]
:
: The CY4 symbol and the attached carry mode symbol must have the same [paramname]
: values.[.br]

M CY4_CY4MODE_PARAM_VALUES_DIFF_EXPL2
> option s
: Although the ignore_locs = [option] option was specified, the above LOC
: parameters could not be ignored because they are attached to CY4 and
: carry mode symbols. Every CY4 or the attached carry mode symbol must
: have a single-location LOC/RLOC parameter.[.br]

M CY4_CY4MODE_PARAM_VALUES_DIFF_EXPL3
> option s
: Although the ignore_rlocs = [option] option was specified, the above RLOC
: parameters could not be ignored because they are attached to CY4 and
: carry mode symbols. Every CY4 or the attached carry mode symbol must
: have a single-location LOC/RLOC parameter.[.br]



#---------------------------- Partial Carry Chains -------------------------------

M CY4_PARTIAL_CHAIN_CIN -e3635
> symname s
> signame s
> pinname s
: The signal `[signame]' on the [pinname] pin of the CY4 symbol `[symname]'
: does not have a source and can not be preserved as directed.[.br][.br]
:
: In order for the design to be implemented, every carry chain must be
: completely defined. Further, the COUT and COUT0 output signals can not
: be preserved for later connection to non-CY4 logic.[.br]

M CY4_PARTIAL_CHAIN_COUT -e3636
> symname s
> signame s
> pinname s
: The signal `[signame]' on the [pinname] pin of the CY4 symbol `[symname]'
: does not have a load and can not be preserved as directed.[.br][.br]
:
: In order for the design to be implemented, every carry chain must be
: completely defined. Further, the COUT and COUT0 output signals can not
: be preserved for later connection to non-CY4 logic.[.br]



#---------------------------- MAP Symbols ----------------------------------------

M MAP_INPUT_SIGNAL -w3637
> symtype s
> symname s
> signame s
> pinname s
: The signal `[signame]' is attached to the `[pinname]' pin of the [symtype]
: symbol `[symname]', but is not attached to any logic inputs.[.br][.br]
:
: The input signals on a [symtype] must correspond to the input signals on
: the logic which is being mapped. Please check the schematic for missing or
: misnamed signals.[.br]

M MAP_OUTPUT_SIGNAL -w3638
> symtype s
> symname s
> signame s
> pinname s
: The signal `[signame]' is attached to the `[pinname]' pin of the [symtype]
: symbol `[symname]', but is not sourced by any logic element.[.br][.br]
:
: The output signals on a [symtype] must correspond to the output signals on
: the logic which is being mapped. Please check the schematic for missing or
: misnamed signals.[.br]



#---------------------------- 2K, 3K CLBMAP ----------------------------------------

M CLBMAP_OUTPINS -e3639
> symtype s
> symname s
: The symbol `[symname]' (type = [symtype]) does not have any signals connected
: to its X or Y output pins.[.br]

M CLBMAP_OUTPINS_CONN -e3640
> symtype s
> symname s
> outsig s
: The X and Y output pins of the symbol `[symname]' (type = [symtype],
: output signal = [outsig]) are connected to each other.[.br]

M CLBMAP_OUTSIG -e3641
> symtype s
> symname s
> gatetype s
> gatename s
> outsig s
: The output signal `[outsig]' of [symtype] `[symname]' is driven by the symbol
: `[gatename]' (type = [gatetype]).[.br][.br]
:
: A CLBMAP symbol can only be used to specify the partitioning of
: AND/OR/NAND/NOR/XOR/XNOR/BUF/INV/EQN/DFF/DLAT logic combinations.
: No other type of element may be included.[.br]


M CLBMAP_RDPIN_CONN -e3642
> symtype s
> symname s
> outsig s
: The RD pin of symbol `[symname]' (type = [symtype], output signal = [outsig])
: is not connected to the RD (or CLR) pin of any DFF (D flip-flop).[.br][.br]
:
: The RD pin of a CLBMAP must be connected to the RD (or CLR) pin of at least
: one DFF.[.br]

M CLBMAP_ECPIN_CONN -e3643
> symtype s
> symname s
> outsig s
: The EC pin of symbol `[symname]' (type = [symtype], output signal = [outsig])
: is not connected to the CE pin of any DFF (D flip-flop).[.br][.br]
:
: The EC pin of a CLBMAP must be connected to the CE pin of at least one DFF.[.br]



#---------------------------- 4K FMAP --------------------------------------------

M FMAP_MAP_PARAM_INVALID -e3644
> symname s
> outsig s
> paramvalue s
: FMAP `[symname]' (output signal = [outsig]) has MAP=[paramvalue] parameter,
: however it does not have input signals on any of the input pins (I1-I4).[.br][.br]
:
: MAP=[paramvalue] parameter requires that all function generator inputs and
: outputs be specified on the FMAP symbol. If you wish to specify only the
: function generator output signal, use the MAP=PUO or MAP=PLO parameter.[.br]

M FMAP_HMAP_OUTSIG -e3645
> symtype s
> symname s
> gatetype s
> gatename s
> outsig s
: The output signal of [symtype] `[symname]' is driven by a non-Boolean gate
: `[gatename]' (type = [gatetype], output signal = [outsig]).[.br][.br]
:
: An FMAP or HMAP symbol can only be used to specify the partitioning of
: AND/OR/NAND/NOR/XOR/XNOR/BUF/INV/EQN logic combinations. No other type
: of element may be included.[.br]



#---------------------------- 4K HMAP --------------------------------------------

M HMAP_MAP_PARAM_INVALID -e3646
> symname s
> outsig s
> paramvalue s
: HMAP `[symname]' (output signal = [outsig]) has invalid MAP=[paramvalue]
: parameter.[.br][.br]
:
: Only MAP=PUC parameter is allowed on an HMAP symbol. Since an HMAP can only
: be a closed MAP, at least one input signal must be specified on the input
: pins (I1-I3).[.br]

M HMAP_INSIGS -e3647
> symname s
> outsig s
: HMAP `[symname]' (output signal = [outsig]) does not have input signals on
: any of the input pins (I1-I3).[.br][.br]
:
: Since an HMAP can only be a closed MAP, at least one input signal must be
: specified on the input pins (I1-I3).[.br]



#---------------------------- OSC4 Pins --------------------------------------------

M OSC4_PINS -e3648
> symtype s
> symname s
> outsig s
: Symbol `[symname]' (type = [symtype], output signal = [outsig]) is illegally
: connected.[.br][.br]
:
: Only the F8M pin and up to 2 of the F500K, F16K, F490, and F15 pins of an
: OSC4 can be used.[.br]
: The pins connected are:[.br]
: [.br]
: Pin Name[.br]
: --------

M OSC4_PINS_LOOP
> pinname s
: [pinname]



#---------------------------- Multiply Sourced Signals ----------------------------

M MULTSRC -e3649
> signame s
: The signal `[signame]' has multiple sources:[.br]

M MULTSRC_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M MULTSRC_EXPL
: [.br]
: Please check the schematic for duplicate signal names.[.br][.br]
:
: If the signal is connected to the INPUTS pin of BIDIR_IO symbol,
: then please ensure that its IE pin is connected.[.br]



#---------------------------- TBUF/WAND/WORAND Driven Horizontal Lines -----------

M HORI_LINE_3K -e3650
> signame s
: The signal `[signame]' is driven by the following non three-state symbols:[.br]

M SYM_LOOP
> symtype s
> symname s
: Symbol Type = [symtype] ; Symbol Name = [symname]

M HORI_3K_EXPL
: [.br]
: This signal can be driven only by TBUF, TRISTATE, BIDIR_IO (with IE pin
: connected), and PULLUP symbols.[.br]


M HORI_LINE_4K -e3651
> signame s
: The signal `[signame]' is driven by the following non three-state elements:[.br]

M HORI_4K_EXPL
: [.br]
: This signal can be driven only by TBUF, WORAND, WAND (without the DECODE
: parameter), TRISTATE, BIDIR_IO (with IE pin connected), and PULLUP symbols.[.br]


M HLINE_4K_MISSING_PULLUP -e3652
> signame s
: No PULLUPs are found on the signal `[signame]' driven by WANDs and WORANDs.
: A signal driven by WANDs and WORANDs must have a PULLUP.[.br]



#---------------------------- 4K DECODE Vertical Lines -------------------------

M DECODER_SIG_INVALID_SYMS -e3653
> signame s
: The DECODER output signal `[signame]' is driven by the following invalid
: symbols:[.br]

M DECODER_SIG_INVALID_SYMS_EXPL
: [.br]
: A DECODER output signal can be driven only by WANDs with the DECODE parameter,
: and PULLUPs.[.br]

M DECODER_SIG_MISSING_PARAM -e3654
> signame s
> symtype s
> symname s
: [symtype] `[symname]' driving the DECODER output signal `[signame]' does not
: have a DECODE parameter.[.br]

M DECODER_SIG_MISSING_PULLUP -e3655
> signame s
: No PULLUPs are found on the DECODER output signal `[signame]'. A DECODER
: output signal must have a PULLUP.[.br]



#---------------------------- VCC & GND Signals -----------------------------------

M VCC_AND_SYM -e3656
> signame s
> symtype s
> symname s
: The signal `[signame]' is sourced by VCC and the symbol `[symname]'
: (type = [symtype]).[.br][.br]
:
: Please check the schematic for duplicate signal names.[.br]

M GND_AND_SYM -e3657
> signame s
> symtype s
> symname s
: The signal `[signame]' is sourced by GND and the symbol `[symname]'
: (type = [symtype]).[.br][.br]
:
: Please check the schematic for duplicate signal names.[.br]



#---------------------------- PULLUP Connectivity --------------------------------

M PULLUP_IOSIGNAL -w3658
> pullupname s
> padname s
: The PULLUP `[pullupname]' is connected to a pad `[padname]', however this
: pad is not connected to any input/output symbol.[.br][.br]
:
: An IOB will be used to implement this PULLUP.[.br]


M PULLUP_INVALID_CONNS_3K -e3659
> pullupname s
> outsig s
: The PULLUP `[pullupname]' (output signal = [outsig]) is connected to the
: following invalid symbol pins:[.br]

M PULLUP_CONNS_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M PULLUP_CONNS_EXPL_3K
: [.br]
: In XC3000 designs, a PULLUP can be connected only to the input pin of an IOB
: input symbol or to a signal driven by TBUF and TRISTATE symbols.
: In XC3000 designs, a PULLUP can not be connected to an IOB output symbol.[.br]


M PULLUP_INVALID_CONNS_4K -e3660
> pullupname s
> outsig s
: The PULLUP `[pullupname]' (output signal = [outsig]) is connected to the
: following invalid symbols:[.br]

M PULLUP_CONNS_EXPL_4K
: [.br]
: In XC4000 designs, a PULLUP can be connected only to IOB input/output symbols
: or to a signal driven by TBUFs/WANDs/WORANDs/TRISTATEs.[.br]



#---------------------------- PULLUP DOUBLE Param ------------------------------

M PULLUP_IOSIG_DOUBLE -e3661
> signame s
> pullupname s
: The input/output signal `[signame]' has a PULLUP `[pullupname]' with the
: DOUBLE parameter.[.br][.br]
:
: There is only one PULLUP resistor in an IOB.[.br]

M PULLUP_LOWVOLT_DOUBLE -e3662
> signame s
> pullupname s
> parttype s
: The PULLUP resistor `[pullupname]' (output signal = [signame]) has a DOUBLE
: parameter.[.br][.br]
:
: In a low-voltage part `[parttype]', only one PULLUP resistor can be active
: on a TBUF driven signal.[.br]



#---------------------------- I/O SIG PULLUP Count ------------------------------

M PULLUP_IOSIG_COUNT -e3663
> signame s
: The input/output signal `[signame]' is driven by more than one PULLUP:[.br]
: [.br]
: PULLUP Name[.br]
: -----------

M PULLUP_LOOP
> symname s
: [symname]

M PULLUP_IOSIG_COUNT_EXPL
: [.br]
: There is only one PULLUP resistor in an IOB.[.br]



#---------------------------- Long Line PULLUP Count in a Low Voltage Part -------

M PULLUP_LOWVOLT_COUNT -e3664
> signame s
: The signal `[signame]' is driven by more than one PULLUP:[.br]
: [.br]
: PULLUP Name[.br]
: -----------

M PULLUP_LOWVOLT_COUNT_EXPL
> parttype s
: [.br]
: In a low-voltage part `[parttype]', only one PULLUP resistor can be active
: on a TBUF driven signal.[.br]



#---------------------------- Long Line PULLUP Count -----------------------------

M PULLUP_LLINE_COUNT -e3665
> signame s
: The signal `[signame]' is driven by more than two PULLUPs:[.br]
: [.br]
: PULLUP Name[.br]
: -----------

M PULLUP_LLINE_LOOP
> symname s
> double s
: [symname][double]

M PULLUP_LLINE_COUNT_EXPL
: [.br]
: A signal driven by TBUFs/WANDs/WORANDs can have at most two PULLUPs connected to it.
: Also a PULLUP with DOUBLE parameter is equivalent to two PULLUPs.[.br]



#---------------------------- PULLDOWN Connectivity --------------------------------

M PULLDOWN_IOSIGNAL -w3666
> symname s
> padname s
: The PULLDOWN `[symname]' is connected to a pad `[padname]', however this pad
: is not connected to any I/O symbol.[.br][.br]
:
: An IOB will be used to implement this PULLDOWN.[.br]

M PULLDOWN_OUTPIN -e3667
> symname s
> signame s
: The PULLDOWN `[symname]' is connected to an internal signal `[signame]'.[.br][.br]
:
: The PULLDOWN resistors can only be connected to a pad.[.br]



#---------------------------- PULLDOWN Count -------------------------------------

M PULLDOWN_IOSIG_COUNT -e3668
> signame s
: The input/output signal `[signame]' has more than one PULLDOWN connected to it:[.br]
: [.br]
: PULLDOWN Name[.br]
: -------------

M PULLDOWN_LOOP
> symname s
: [symname]

M PULLDOWN_IOSIG_COUNT_EXPL
: [.br]
: There is only one PULLDOWN resistor in an IOB.[.br]



#---------------------------- Both PULLUP & PULLDOWN ------------------------------

M PULLUP_AND_PULLDOWN -w3669
> signame s
: The input/output signal `[signame]' is connected to both PULLUP and PULLDOWN
: resistors. This will consume additional power and will serve no logical
: function.[.br]



#---------------------------- Primitive Count -------------------------------

M PRIMCOUNT_GCLK -e3670
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_ACLK -e3671
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_BUFGP -e3672
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_BUFGS -e3673
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_BUFG -e3674
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M CLKCOUNT_ERROR -e3675
: The design uses the following number of clock symbols:[.br]

M CLKCOUNT_LOOP
> clksymtype s
> count d
: Clock Symbol = [clksymtype] ; Count = [count]

M CLKCOUNT_EXPL
> maxoccr d
: [.br]
: The maximum number of clock symbols allowed is: [maxoccr].[.br]

M PRIMCOUNT_OSC -e3676
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_SPECIALFN -e3677
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_SPECIALPAD -e3678
> primname s
> maxoccr d
> occr d
: The design uses [occr] [primname] symbols.[.br]
: The maximum allowed is: [maxoccr].[.br]

M PRIMCOUNT_LOOP
> symtype s
> symname s
> outsigname s
: Symbol Type = [symtype] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsigname][.br]



#---------------------------- Warnings On Overall Design -------------------------

M RESET_PIN -w3679
> signame s
: The signal `[signame]' controls the asynchronous reset
: of every flip-flop in the design. The dedicated RESET
: pin on the device could be used to accomplish the same
: function without using any routing resources.[.br][.br]
:
: The RESET pin on the LCA performs an asynchronous clear
: of every register on the device (both CLB and IOB
: flip-flops). It has no schematic representation, as it is
: a dedicated package pin. The signal `[signame]' may be
: removed from your design if you choose to substitute
: the dedicated RESET pin for this function.[.br]


M GSR_SIGNAL -w3680
> signame s
: The signal `[signame]' controls the asynchronous set/reset
: of every flip-flop in the design. The dedicated GSR signal
: in the device could be used to accomplish the same
: function without using any routing resources.[.br][.br]
:
: To use GSR, disconnect the signal `[signame]' from the
: set/reset pin of every flip-flop in the design, and connect
: it to the GSR pin of the STARTUP symbol. Note that all flip-flops
: on the device will be preset or cleared when GSR goes active.[.br]


M GTS_SIGNAL -w3681
> signame s
: The signal `[signame]' controls the 3-state pin of every
: output symbol in the design. The dedicated GTS signal
: in the device could be used to accomplish the same
: function without using any routing resources.[.br][.br]
:
: To use GTS, disconnect the signal `[signame]' from the
: 3-state pin of every output symbol in the design, and connect
: it to the GTS pin of the STARTUP symbol. Note that every output
: on the device will be 3-stated while GTS is active.[.br]


M WIRED_MUX_AND -w3682
: There are three or less 3-state buffers on the following signals:[.br]
: [.br]
: Signal Name[.br]
: -----------

 
M WIRED_MUX_AND_EXPL
: [.br]
: For better routing completion, please reimplement
: the wired multiplexer or wired AND using regular logic.[.br]


M THREE_STATE_IOBS -w3683
: There are more than two signals each driving more than
: eight T-inputs to IOBs (OBUFT, OUTFFT).[.br]
: [.br]
: Signal Name[.br]
: -----------

 
M THREE_STATE_IOBS_EXPL
: [.br]
: These signals tend to be difficult to route. Careful
: reassignment of IOBs to appropriate die edges may
: alleviate this problem.[.br]


M EXT_OUTPUTS_SLOW -w3684
: All of the external outputs in this design are using
: slew-rate-limited output drivers.[.br][.br]
:
: The delay on speed critical outputs can be dramatically
: reduced by designating them as fast outputs in the
: schematic.[.br][.br]
:
: However, you should be careful not to designate too many
: outputs which switch together as fast because this can
: cause excessive ground bounce. For more information on
: this subject refer to the IOB switching characteristic
: guidelines for the device which you are using.[.br]


M HANDBUILT_LATCHES -w3685
: It appears that the following signals are latch outputs:[.br]
: [.br]
: Signal Name[.br]
: -----------
 

M HANDBUILT_LATCHES_EXPL
: [.br]
: Since flip-flops are more efficiently implemented than
: latches in the 3K and 4K architectures, it is advisable
: to re-design these functions using flip-flops.[.br]




M NCLBROWS_TEXT
: NCLBROWS

M NCLBCOLS_TEXT
: NCLBCOLS

M XNFERR_BREAK
: [.br]

E XNFERR
#
# ------------------ xnferr2.m ------------------ 
#
#@(#)xnferr2.m	6.82  5/11/94

 
 
B XNFERR2 -start4501 -end5000 -current4674
: XNF Post XNFTRIM Design Rule Checker

#-enable
 
# Tool description (for program help)

M DESCRIPTION
: This tool checks for design rule violations in a Post-XNFTRIM design file.
M DESIGN
: Input Post-XNFTRIM Design File.
M REPORT
: The name of the Report file.
M PARTTYPE
: Part type used in the design.
M SAVESIG
: Savesig mode


# Help Messages

M HDESIGN
: The name of the Post-XNFTRIM design file to be checked.
M HREPORT
: This optional field specifies a name for the report file generated by
: XNFPREP. If no file name is specified here, the name of the report
: file will be xnfprep.rpt.
M HPARTTYPE
: This optional field specifies the part type to be used in the design.
: If the parttype is specified in the XFF file, it does not need to be
: included here.
M HSAVESIG
: This option can be used to direct XNFPREP to keep signals that are either
: sourceless or loadless.  When this option is TRUE, XNFPREP will not trim
: the sourceless or loadless signals, and will add the Savesig "S" parameter
: to these signals.  This option is useful when working with partial designs.
 

# Informational and Other Messages

M RPT_TITLE
> designname s
> version s 
: XNFPREP For Design [designname][.br]
: From XNFPREP Version [version][.br]

M ERROR_CHAP_TITLE
: XNFPREP Errors [.br]
: --------------

M WARNING_CHAP_TITLE
: XNFPREP Warnings [.br]
: ----------------

M CLKSIG_CHAP_TITLE
: Clock Signals Report [.br]
: --------------------



#---------------------------- Error and Warning Messages ----------------------



#---------------------------- Input Design File -------------------------------

M INFILE_NOT_FOUND -e4501
> name s
: XNFERR2 was aborted because it could not find the input design file `[name]'.
: Note that the file names may not contain any upper case letters.[.br]

M INFILE_NOT_XTF -e4502
> name s
: XNFERR2 was aborted because the input design `[name]' is not a trimmed (XTF)
: file. If no file extension is specified, XNFERR2 will look for a trimmed (XTF)
: file. (A trimmed XTF file is produced by XNFTRIM.)[.br]

M INFILE_XTF_EXT_NOT_FOUND -e4503
> name s
: XNFERR2 was aborted because it could not find the [name].xtf file.
: Since no file extension was specified, XNFERR2 looked for the trimmed (XTF)
: file. (A trimmed XTF file is produced by XNFTRIM.)[.br]

M INFILE_READ_ERROR -e4504
: XNFERR2 was aborted because it could not read in the input design due to the
: following error(s):[.br]



#---------------------------- Report File -------------------------------------

M REPORT_OPENFAILED -e4505
> filename s
> designname s
: The XNFPREP report file `[filename]' for design `[designname]' could not
: be opened.[.br][.br]
:
: Please ensure that you have the permission to write in the directory.[.br]



#---------------------------- Part Type ---------------------------------------

M PARTTYPE_ERROR -e4506
> parttype s
: The part type `[parttype]' is illegal.[.br]

M PARTTYPE_MISSING -e4507
> filename s
: The part type is not specified in the design [filename].[.br]
: You may specify the part type from command line.[.br]



#---------------------------- Attribute Missing in partlist.xct File ----------

M ATTRIB_MISSING -e4508
> attribute m
: Unable to read attribute [attribute] from partlist.xct file.[.br]



#---------------------------- Param Value Missing -----------------------------

M PARAM_VALUE_MISSING -e4509
> symtype s
> symname s
> outsig s
> paramtype s
: The `[paramtype]' parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) does not have any value assigned to it.[.br]

M PARAM_VALUE_MISSING_EXT -e4510
> padname s
> paramtype s
: The `[paramtype]' parameter on pad `[padname]' does not have any value
: assigned to it.[.br]



#---------------------------- Pin Missing -------------------------------------

M PIN_MISSING -e4511
> symtype s
> symname s
> outsig s
> pinname s
: Pin `[pinname]' does not exist on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br]



#---------------------------- Misc checks on location parameters ----------------

M LOC_ON_WRONG_SYM_2K -w4512
> symtype s
> symname s
> outsig s
: LOC parameter present on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br][.br]
:
: A 2K design can have LOC parameters only on CLB, CLBMAP, DFF, DLAT, IOB,
: non-primitive (macro), and input/output symbols.[.br]

M LOC_ON_WRONG_SYM_3K -w4513
> symtype s
> symname s
> outsig s
: LOC parameter present on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br][.br]
:
: A 3K design can have LOC parameters only on CLB, CLBMAP, DFF, TBUF, PULLUP,
: IOB, FG, MUX, non-primitive (macro), and input/output symbols.[.br]

M LOC_ON_WRONG_SYM_4K -w4514
> symtype s
> symname s
> outsig s
: LOC parameter present on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br][.br]
:
: A 4K design can have LOC parameters only on FMAP, HMAP, DFF, CY4, CY4-XX, TBUF,
: WAND, WORAND, PULLUP, BUFGP, BUFGS, BUFG, RAM, ROM, FG, non-primitive (macro),
: and input/output symbols.[.br]


M RLOC_ON_WRONG_DESIGN_2K_3K -w4515
> symtype s
> symname s
> outsig s
> paramtype s
: [paramtype] parameter present on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br][.br]
:
: In 2K and 3K designs [paramtype] parameters can not be used.[.br]

M RLOC_ON_WRONG_SYM_4K -w4516
> symtype s
> symname s
> outsig s
> paramtype s
: [paramtype] parameter present on symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br][.br]
:
: A 4K design can have [paramtype] parameters only on FMAP, HMAP, DFF, CY4,
: TBUF, WORAND, WAND without DECODE parameter, RAM, ROM, FG, and non-primitive
: (macro) symbols.[.br]



#---------------------------- Invalid LOC Param Syntax --------------------------

M LOC_INVALID_SYNTAX -e4517
> symtype s
> symname s
> outsig s
> locvalue s
> validsyntax s
: The LOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value `[locvalue]'.[.br][.br]
:
: The valid syntax for this symbol's parameter is: [validsyntax].[.br]

M LOC_INVALID_ROW_COL -e4518
> symtype s
> symname s
> outsig s
> locvalue s
> rowcol s
> rowcolnum s
: The LOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid [rowcol] `[rowcolnum]'.[.br]
: LOC parameter value = [locvalue][.br]

M LOC_EMPTY_ROW_COL -e4519
> symtype s
> symname s
> outsig s
> locvalue s
> parttype s
> rowcol s
> rowcolnum s
: The LOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) is pointing to an empty [rowcol]
: `[rowcolnum]' for the part [parttype].[.br]
: LOC parameter value = [locvalue][.br]

M LOC_INVALID_SUFFIX -e4520
> symtype s
> symname s
> outsig s
> locvalue s
> suffix s
> validsuffixes s
: The LOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid suffix `[suffix]'.[.br]
: LOC parameter value = [locvalue][.br][.br]
:
: The valid suffixes for this symbol are: [validsuffixes].[.br]

M LOC_IOSYM_INVALID -e4521
> symtype s
> symname s
> outsig s
> locvalue s
> indent s
: The LOC parameter on input/output symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value `[locvalue]'.[.br][.br]
:
: The valid LOC values for input/output symbols are:[.br]
: [indent][indent] PADnn, Pnn, Unn, Ann, AAnn,[.br]
: [indent][indent] T, L, B, R, TL, LT, TR, RT, RB, BR, BL, LB.[.br]

M LOC_EXT_INVALID -e4522
> padname s
> locvalue s
> indent s
: The LOC parameter on pad `[padname]' has an invalid value `[locvalue]'.
: [.br][.br]
:
: The valid LOC values for pads are:[.br]
: [indent][indent] PADnn, Pnn, Unn, Ann, AAnn,[.br]
: [indent][indent] T, L, B, R, TL, LT, TR, RT, RB, BR, BL, LB.[.br]

M LOC_DEC_INVALID -e4523
> symtype s
> symname s
> outsig s
> locvalue s
> indent s
: The LOC parameter on DECODER `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value `[locvalue]'.[.br][.br]
:
: The valid LOC values for DECODERs are:[.br]
: [indent][indent] T, L, B, R, TL, LT, TR, RT, RB, BR, BL, LB.[.br]

M LOC_GBUF_INVALID -e4524
> symtype s
> symname s
> outsig s
> locvalue s
> indent s
: The LOC parameter on global buffer `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value `[locvalue]'.[.br][.br]
:
: The valid LOC values for global buffers are:[.br]
: [indent][indent] TL, TR, BR, BL.[.br]

M LOC_RANGE_INVALID_WILD_CARD -e4525
> symtype s
> symname s
> outsig s
> locvalue1 s
> locvalue2 s
: The LOC range parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has wild-card `*' characters.
: LOC range value = [locvalue1]:[locvalue2].[.br][.br]
:
: The LOC range value can not have wild-card `*' characters in any row or
: column position. The PPR does not currently support it.[.br]



#---------------------------- Invalid RLOC Param Syntax ---------------------

M RLOC_INVALID_SYNTAX -e4526
> symtype s
> symname s
> outsig s
> rlocvalue s
> validsyntax s
: The RLOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value.[.br]
: RLOC parameter value = `[rlocvalue]'.[.br][.br]
:
: The valid RLOC syntax is: [validsyntax].[.br]
: Where `n' and `m' are positive integers (including zero). Wildcard `*'
: character is not allowed on RLOC parameters.[.br]
: Example: R1C1.ffx[.br]

M RLOC_INVALID_ROW_COL -e4527
> symtype s
> symname s
> outsig s
> rlocvalue s
> rowcol s
> rowcolnum d
> validsyntax s
: The RLOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid [rowcol] `[rowcolnum]'.[.br]
: RLOC parameter value = `[rlocvalue]'.[.br][.br]
:
: The valid RLOC syntax is: [validsyntax].[.br]
: Where `n' and `m' are positive integers (including zero). Wildcard `*'
: character is not allowed on RLOC parameters.[.br]
: Example: R1C1.ffx[.br]

M RLOC_INVALID_SUFFIX -e4528
> symtype s
> symname s
> outsig s
> rlocvalue s
> suffix s
> validsuffixes s
: The RLOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid suffix `[suffix]'.[.br]
: RLOC parameter value = `[rlocvalue]'.[.br][.br]
:
: The valid suffixes for this symbol are: [validsuffixes].[.br]



#---------------------------- Invalid RLOC_ORIGIN Param Syntax ---------------------

M RLOC_ORIGIN_INVALID_SYNTAX -e4529
> symtype s
> symname s
> outsig s
> rlocoriginvalue s
> validsyntax s
: The RLOC_ORIGIN parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value.[.br]
: RLOC_ORIGIN parameter value = `[rlocoriginvalue]'.[.br][.br]
:
: The valid RLOC_ORIGIN syntax is: [validsyntax].[.br]
: Where `n' and `m' are non-zero positive integers. Wildcard `*'
: character is not allowed on RLOC_ORIGIN parameters.[.br]
: Example: R1C2[.br]

M RLOC_ORIGIN_INVALID_ROW_COL -e4530
> symtype s
> symname s
> outsig s
> rlocoriginvalue s
> rowcol s
> rowcolnum d
> validsyntax s
: The RLOC_ORIGIN parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid [rowcol] `[rowcolnum]'.[.br]
: RLOC_ORIGIN parameter value = `[rlocoriginvalue]'.[.br][.br]
:
: The valid RLOC_ORIGIN syntax is: [validsyntax].[.br]
: Where `n' and `m' are non-zero positive integers. Wildcard `*'
: character is not allowed on RLOC_ORIGIN parameters.[.br]
: Example: R1C2[.br]

M RLOC_ORIGIN_INVALID_SUFFIX -e4531
> symtype s
> symname s
> outsig s
> rlocoriginvalue s
: The RLOC_ORIGIN parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has a suffix.[.br]
: RLOC_ORIGIN parameter value = `[rlocoriginvalue]'.[.br][.br]
:
: The RLOC_ORIGIN parameters can not have suffixes.[.br]



#---------------------------- Invalid RLOC_RANGE Param Syntax -----------------

M RLOC_RANGE_INVALID_SYNTAX -e4532
> symtype s
> symname s
> outsig s
> rlocrangevalue s
> validsyntax s
: The RLOC_RANGE parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value.[.br]
: RLOC_RANGE parameter value = `[rlocrangevalue]'.[.br][.br]
:
: The valid RLOC_RANGE syntax is: [validsyntax].[.br]
: Where `n' and `m' are non-zero positive integers, or
: the wildcard `*' characters.[.br]
: Example: R1C1:R4C4[.br]

M RLOC_RANGE_INVALID_ROW_COL -e4533
> symtype s
> symname s
> outsig s
> rlocrangevalue s
> rowcol s
> rowcolnum s
> validsyntax s
: The RLOC_RANGE parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid [rowcol] `[rowcolnum]'.[.br]
: RLOC_RANGE parameter value = `[rlocrangevalue]'.[.br][.br]
:
: The valid RLOC_RANGE syntax is: [validsyntax].[.br]
: Where `n' and `m' are non-zero positive integers, or
: the wildcard `*' characters.[.br]
: Example: R1C1:R4C4[.br]

M RLOC_RANGE_INVALID_WILD_CARD -e4534
> symtype s
> symname s
> outsig s
> rlocrangevalue s
: The wild-card `*' characters are incorrectly used in RLOC_RANGE
: parameter on the symbol `[symname]' (type = [symtype],
: output signal = [outsig]).[.br]
: RLOC_RANGE parameter value = `[rlocrangevalue]'.[.br][.br]
:
: The wild-card `*' character can be used with either the row OR column
: on both sides of the range separator character `:'. It can not be used
: for the row character on one side and the column charcater on the other.
: It is also not valid to use the wild-cards for both row and column
: positions.[.br]
: Example: R*C1:R*C4[.br]

M RLOC_RANGE_INVALID_SUFFIX -e4535
> symtype s
> symname s
> outsig s
> rlocrangevalue s
: The RLOC_RANGE parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has a suffix.[.br]
: RLOC_RANGE parameter value = `[rlocrangevalue]'.[.br][.br]
:
: The RLOC_RANGE parameters can not have suffixes.[.br]



#---------------------------- Invalid USE_RLOC Param Syntax -----------------

M USE_RLOC_INVALID_SYNTAX -e4536
> symtype s
> symname s
> outsig s
> userlocvalue s
: The USE_RLOC parameter on symbol `[symname]' (type = [symtype],
: output signal = [outsig]) has an invalid value `[userlocvalue]'.[.br]
:
: Possible values for the USE_RLOC parameter are: TRUE or FALSE.[.br]



#-------------------- Check the Size of RLOC Sets ---------------------------

M RLOCSET_NO_RLOC -e4537
> symtype s
> symname s
> outsig s
> settype s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has the [settype] parameter, however it does not have any RLOC parameter.[.br]

M RLOCSET_TOO_BIG -e4538
> settype s
> setname s
> parttype s
> iNumRows d
> iNumCols d
> NClbRows d
> NClbCols d
: The [settype] set `[setname]' exceeds the size of part `[parttype]'.
: This set uses [iNumRows] rows and [iNumCols] columns, whereas only [NClbRows]
: rows and [NClbCols] columns are available in the part. The following symbols
: comprise this set:[.br]

M RLOCSET_TOO_BIG_LOOP
> symtype s
> symname s
> outsig s
: Symbol Type = [symtype] ; Symbol Name = [symname] ;[.br]
: Output Signal = [outsig][.br]



#------- Check the LOC value on i/o symbol against the package file -------------

# 
# The pad name does not exist in package file.
#
M LOC_IOSYM_PADNAME_ABSENT -e4539
> symtype s
> symname s
> padname s
> locvalue s
> partname s
: The I/O symbol `[symname]' (type = [symtype], connected to pad `[padname]')
: has an invalid LOC parameter value `[locvalue]'.[.br][.br]
:
: The location `[locvalue]' is not a valid I/O pad on the part `[partname]'.[.br]

# 
# The i/o symbol is connected to a bonded pad but the LOC value refers to
# an unbonded IOB.
#
M LOC_IOSYM_BONDED_PADNAME_UNBONDED -e4540
> symtype s
> symname s
> padname s
> locvalue s
> partname s
: The I/O symbol `[symname]' (type = [symtype], connected to pad `[padname]')
: has an invalid LOC parameter value `[locvalue]'. This pad location refers
: to an unbonded IOB on the part `[partname]' but the indicated I/O symbol
: is connected to a bonded pad symbol.[.br][.br]
:
: Either change the LOC value to correspond to a bonded IOB, or connect the
: I/O symbol to an unbonded pad symbol.[.br]

# 
# The package pin does not exist in the package file.
#
M LOC_IOSYM_PKGPIN_ABSENT -e4541
> symtype s
> symname s
> padname s
> locvalue s
> partname s
: The I/O symbol `[symname]' (type = [symtype], connected to pad `[padname]')
: has an invalid LOC parameter value `[locvalue]'.[.br][.br]
:
: The location `[locvalue]' is not a valid I/O pin on the part `[partname]'.[.br]

#
# The i/o symbol is connected to an unbonded pad but the LOC value refers to
# a bonded IOB.
#
M LOC_IOSYM_UNBONDED_PADNAME_BONDED -e4542
> symtype s
> symname s
> padname s
> locvalue s
> partname s
: The I/O symbol `[symname]' (type = [symtype], connected to pad `[padname]')
: has an invalid LOC parameter value `[locvalue]'. This location refers
: to a bonded IOB on the part `[partname]' but the indicated I/O symbol
: is connected to an unbonded pad symbol.[.br][.br]
:
: Either change the LOC value to correspond to an unbonded IOB, or connect the
: I/O symbol to a bonded pad symbol.[.br]

#
# The i/o symbol is connected to an unbonded pad but the LOC value is neither
# of PADnn nor Unn format.
#
M LOC_IOSYM_UNBONDED_PADNAME_INVALID -e4543
> symtype s
> symname s
> padname s
> locvalue s
: The I/O symbol `[symname]' (type = [symtype], connected to pad `[padname]')
: has an invalid LOC parameter value `[locvalue]'.[.br][.br]
:
: The I/O symbol is connected to an unbonded pad, however the specified LOC
: value `[locvalue]' does not refer to an unbonded IOB. The LOC value for
: an unbonded pad should be of the form PADnn or Unn.[.br]



#------- Check the LOC value on EXT record against the package file -------------

#
# The pad name does not exist in package file.
#
M LOC_EXT_PADNAME_ABSENT -e4544
> padname s
> locvalue s
> partname s
: The pad `[padname]' has an invalid LOC parameter value `[locvalue]'.[.br][.br]
:
: The location `[locvalue]' is not a valid I/O pad on the part `[partname]'.[.br]

#
# The LOC value on a bonded pad refers to an unbonded IOB.
#
M LOC_EXT_BONDED_PADNAME_UNBONDED -e4545
> padname s
> locvalue s
> partname s
: The bonded pad `[padname]' has an invalid LOC parameter value `[locvalue]'.
: This location refers to an UNBONDED IOB on the part `[partname]'.[.br][.br]
:
: Either change the LOC value to correspond to a bonded IOB, or change the
: pad to an unbonded pad symbol.[.br]

# 
# The package pin does not exist in the package file.
#
M LOC_EXT_PKGPIN_ABSENT -e4546
> padname s
> locvalue s
> partname s
: The pad `[padname]' has an invalid LOC parameter value `[locvalue]'.[.br][.br]
:
: The location `[locvalue]' is not a valid I/O pin on the part `[partname]'.[.br]

#
# The LOC value on an unbonded pad refers to a bonded IOB.
#
M LOC_EXT_UNBONDED_PADNAME_BONDED -e4547
> padname s
> locvalue s
> partname s
: The unbonded pad `[padname]' has an invalid LOC parameter value `[locvalue]'.
: This location refers to a BONDED IOB on the part `[partname]'.[.br][.br]
:
: Either change the LOC value to correspond to an unbonded IOB, or change the
: pad to a bonded pad symbol.[.br]

#
# The LOC value on an unbonded pad has neither PADnn nor Unn format.
#
M LOC_EXT_UNBONDED_PADNAME_INVALID -e4548
> padname s
> locvalue s
: The unbonded pad `[padname]' has an invalid LOC parameter value `[locvalue]'.
: [.br][.br]
:
: The specified LOC value does not refer to an unbonded IOB.
: The LOC value for an unbonded pad should be of the form PADnn or Unn.[.br]



#---------------------- LOC Parameters on EXT Record, I/O Symbols ---------------

M PAD_EXT_LOC_RANGE -e4549
> padname s
> locvalue1 s
> locvalue2 s
: The pad `[padname]' has a LOC parameter with range:[.br]
: LOC parameter value = [locvalue1]:[locvalue2][.br][.br]
:
: The LOC parameters on pads and input/output symbols can not have
: range values.[.br]

M PAD_SYM_LOC_RANGE -e4550
> symtype s
> symname s
> outsig s
> locvalue1 s
> locvalue2 s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has a LOC parameter with range:[.br]
: LOC parameter value = [locvalue1]:[locvalue2][.br][.br]
:
: The LOC parameters on pads and input/output symbols can not have
: range values.[.br]

M PAD_EXT_LOC_CONFLICT -e4551
> padname s
> locvalue s
: The pad `[padname]' has conflicting LOC parameter values:[.br]
: LOC parameter values: [locvalue][.br]

M PAD_SYM_LOC_CONFLICT -e4552
> symtype s
> symname s
> outsig s
> locvalue s
: The symbol `[symname]' (type = [symtype], output signal = [outsig])
: has conflicting LOC parameter values:[.br]
: LOC parameter values: [locvalue][.br]



#---------------------- Parameters on EXT Record, I/O Symbols -------------------

M PAD_PARAM_VALUES_DIFF -e4553
> padname s
> paramname s
: The pad signal `[padname]' and input/output symbols connected to it have
: different [paramname] parameter values:[.br]

M PAD_PARAM_VALUES_EXT_LOOP
> padname s
> paramname s
> paramval s
: Pad Signal = [padname] ; [paramname] Value = [paramval]

M PAD_PARAM_VALUES_SYM_LOOP
> symtype s
> paramname s
> paramval s
: Symbol Type = [symtype] ; [paramname] Value = [paramval]

M PAD_PARAM_VALUES_EXPL
> paramname s
: [.br]
: A pad and the input/output symbols connected to it must have same
: [paramname] parameter values.[.br]


M PAD_PARAM_CONFLICT -e4554
> padname s
: The pad signal `[padname]' and input/output symbols connected to it
: have conflicting parameters:[.br]

M PAD_PARAM_CONFLICT_EXT_LOOP
> padname s
> paramname s
: Pad Signal = [padname] ; Parameter Name = [paramname]

M PAD_PARAM_CONFLICT_SYM_LOOP
> symtype s
> paramname s
: Symbol Type = [symtype] ; Parameter Name = [paramname]

M PAD_PARAM_CONFLICT_EXPL
: [.br]
: A pad and the input/output symbols connected to it must have consistent
: parameters.[.br]


M PAD_PARAM_CONFLICT_HYDRA -e4555
> padname s
: The pad signal `[padname]' and the input/output symbols connected to it
: have an invalid combination of TTL and CMOS parameters:[.br]

M PAD_PARAM_CONFLICT_HYDRA_EXPL
: [.br]
: In XC4000H designs, it is invalid to have CMOS parameter on input symbol
: and TTL parameter on output symbol. Though, it is valid to have TTL on input
: symbol and CMOS on output symbol.[.br]



#-------------------- Errors on Carry Chain Connections ------------------------

M CARRY_CHAIN_CIN_COUT_0 -e4556
> symname s
> signame s
: The carry signal `[signame]' (on CIN pin of CY4 symbol `[symname]')
: is not sourced by an adjacent COUT pin.[.br][.br]
:
: The CIN pin of a CY4 symbol may be sourced only by an adjacent COUT pin.
: If this signal represents the start of a carry chain, use an additional
: CY4 symbol with one of the FORCE carry modes to drive the CIN pin.[.br]

M CARRY_CHAIN_COUT_CIN_0 -e4557
> symname s
> signame s
: The carry signal `[signame]' (on COUT pin of CY4 symbol `[symname]') is not
: connected to a CIN pin but sources non-carry inputs.[.br][.br]
:
: The COUT signal can drive non-carry inputs only if it is also connected to
: the CIN pin of an adjacent CY4 symbol. If this COUT signal represents the
: most significant carry output, connect it to the CIN pin of a CY4 symbol
: with the mode EXAMINE-CI.[.br]

M CARRY_CHAIN_COUT_CIN_GT_1 -e4558
> symname s
> signame s
: The carry signal `[signame]' (on COUT pin of CY4 symbol `[symname]') is
: connected to the CIN pins of more than one CY4 symbols.[.br][.br]
:
: The COUT pin of a CY4 symbol (except for the first CY4 in chain) can be
: connected to the CIN pin of only one adjacent CY4 symbol.[.br]

M CARRY_CHAIN_COUT_CIN_GT_2 -e4559
> symname s
> signame s
: The carry signal `[signame]' (on COUT pin of CY4 symbol `[symname]') is
: connected to the CIN pins of more than two CY4 symbols.[.br][.br]
:
: The COUT pin of the first CY4 symbol in the chain can be connected to the
: CIN pins of at most two CY4 symbols.[.br]

M CARRY_ADD_SIGS_DIFF -w4560
> symname s
> outsig s
: The ADD pins of the carry chain beginning with CY4 symbol `[symname]'
: (output signal = [outsig]) are sourced by different signals:[.br]
: [.br]
: Signal Name[.br]
: -----------

M SIG_NAMES_LOOP
> signame s
: [signame]

M CARRY_CYMODE_PARAM_ABSENT -e4561
> symname s
> outsig s
: The CY4 symbol `[symname]' (output signal = [outsig]) does not have
: CYMODE parameter.[.br]

M CARRY_CYMODE_PARAM_INVALID -e4562
> symname s
> outsig s
> paramvalue s
: The CY4 symbol `[symname]' (output signal = [outsig]) has an invalid
: CYMODE parameter value `[paramvalue]'.[.br]

M CARRY_CYMODE_PREFIX_DIFF -w4563
> symname s
> outsig s
: The carry chain beginning with CY4 symbol `[symname]'
: (output signal = [outsig]) has mixed carry mode parameters:[.br]

M CARRY_CYMODE_PREFIX_LOOP
> symname s
> outsig s
> paramvalue s
: Symbol Name = [symname] ; Mode Parameter = [paramvalue] ;[.br]
: Output Signal = [outsig][.br]

M CARRY_CYMODE_PREFIX_EXPL
: Note: The FORCE and EXAMINE modes can be mixed with any other carry modes,
: but care must be taken if carry modes other than FORCE and EXAMINE are mixed
: in the same carry chain.[.br]



#---------------------------- Errors on Carry LOC/RLOC Parameters ----------------

M CARRY_LOC_RLOC_NONE -e4564
> symname s
> outsig s
: The CY4 symbol `[symname]' (output signal = [outsig]) has neither LOC nor
: RLOC parameter.[.br]

M CARRY_LOC_MIXED -e4565
> symname s
> outsig s
: The carry chain beginning with CY4 symbol `[symname]' (output signal = [outsig])
: has mixed location parameters (both LOC= and RLOC=):[.br]

M CARRY_LOC_LOOP
> symtype s
> symname s
> loctype s
: Symbol Type = [symtype] ; Location Param Type = [loctype] ;
: Symbol Name = [symname]

M CARRY_LOC_MULTIPLE_VALUES -e4566
> symname s
> outsig s
> loccount d
: The CY4 symbol `[symname]' (output signal = [outsig]) has `[loccount]'
: LOC parameter values.[.br][.br]
:
: A CY4 symbol can have only one LOC parameter with one explicit value.
: Range, wild-card, and prohibit forms of the LOC parameter on this symbol
: are not valid.[.br]

M CARRY_LOC_HAS_PROHIBIT -e4567
> symname s
> outsig s
> paramvalue s
: The CY4 symbol `[symname]' (output signal = [outsig]) has a LOC parameter
: with prohibit flag.[.br]
: LOC<>`[paramvalue]'.[.br][.br]
:
: A CY4 symbol can have only one LOC parameter with one explicit value.
: Range, wild-card, and prohibit forms of the LOC parameter on this symbol
: are not valid.[.br]

M CARRY_LOC_HAS_RANGE -e4568
> symname s
> outsig s
> locvalue1 s
> locvalue2 s
: The CY4 symbol `[symname]' (output signal = [outsig]) has
: a LOC parameter with range.[.br]
: LOC Value1 = `[locvalue1]'.[.br]
: LOC Value2 = `[locvalue2]'.[.br][.br]
:
: A CY4 symbol can have only one LOC parameter with one explicit value.
: Range, wild-card, and prohibit forms of the LOC parameter on this symbol
: are not valid.[.br]

M CARRY_LOC_HAS_WILD_CARD -e4569
> symname s
> outsig s
> locvalue s
: The CY4 symbol `[symname]' (output signal = [outsig]) has a LOC parameter
: with wild-cards.[.br]
: LOC Value = `[locvalue]'.[.br][.br]
:
: A CY4 symbol can have only one LOC parameter with one explicit value.
: Range, wild-card, and prohibit forms of the LOC parameter on this symbol
: are not valid.[.br]

M CARRY_LOC_MIXED_VALUES -e4570
> symname s
> outsig s
: The carry chain beginning with CY4 symbol `[symname]' (output signal = [outsig])
: has mixed LOC values. Some symbols in chain have alphabetic LOC values while
: others in chain have numeric LOC values.[.br]

M CARRY_LOC_VAL_LOOP
> symname s
> locval s
> locvaltype s
: Symbol Name = [symname] ; LocVal = [locval] ; LocVal Type = [locvaltype]

M CARRY_RLOC_HAS_WILD_CARD -e4571
> symname s
> outsig s
> rlocvalue s
: The CY4 symbol `[symname]' (output signal = [outsig]) has a RLOC parameter
: with wild-cards.[.br]
: RLOC Value = `[rlocvalue]'.[.br][.br]
:
: A CY4 symbol can have only one RLOC parameter, without range, and wild-cards.[.br]



#---------------------------- Errors on Carry Chain Placement --------------------

M CARRY_SYMS_SAME_LOCS -e4572
> CurrCarrySym s
> CurrOutSig s
> NextCarrySym s
> NextOutSig s
> LocType s
: The following CY4 symbols of a carry chain have same [LocType]
: parameter values.[.br][.br]
:
: Symbol Name = [CurrCarrySym]; Output Signal = [CurrOutSig].[.br]
: Symbol Name = [NextCarrySym]; Output Signal = [NextOutSig].[.br][.br]
:
: A carry chain must flow either up or down in a column.
: It can also move to the right between CLBs in the top
: or bottom row of the device.[.br]

M CARRY_CHAIN_WRONG_DIR -e4573
> symname s
> outsig s
> dir s
: A carry chain has [dir] directionality. The CY4 symbol [symname]
: (output signal = [outsig]) violates this directionality.[.br][.br]
:
: A carry chain must flow either up or down in a column.
: It can also move to the right between CLBs in the top
: or bottom row of the device.[.br]

M CARRY_CHAIN_NOT_CONTIGUOUS -e4574
> CurrCarrySym s
> CurrOutSig s
> NextCarrySym s
> NextOutSig s
: A carry chain is not contiguous. The following CY4 symbols of the carry
: chain are not adjacent.[.br][.br]
:
: Symbol Name = [CurrCarrySym]; Output Signal = [CurrOutSig].[.br]
: Symbol Name = [NextCarrySym]; Output Signal = [NextOutSig].[.br][.br]
:
: A carry chain must flow either up or down in a column.
: It can also move to the right between CLBs in the top
: or bottom row of the device.[.br]

M CARRY_LEFT_TURN -e4575
> CurrCarrySym s
> CurrOutSig s
> NextCarrySym s
> NextOutSig s
> indent s
: A carry chain is moving to left from CY4 symbol[.br]
: [indent]`[CurrCarrySym]' (output signal = [CurrOutSig]) to[.br]
: [indent]`[NextCarrySym]' (output signal = [NextOutSig]).[.br][.br]
:
: A carry chain must flow either up or down in a column.
: It can also move to the right between CLBs in the top
: or bottom row of the device.[.br]

M CARRY_RIGHT_TURN_LOC -e4576
> NextCarrySym s
> NextOutSig s
> coldir s
: [coldir] column of carry chain is turning right in the middle of the device.[.br]
: CY4 Symbol Name = [NextCarrySym]; Output Signal = [NextOutSig].[.br][.br]
:
: A carry chain can move to the right between CLBs only in
: the top or bottom row of the device.[.br]

M CARRY_RIGHT_TURN_RLOC -w4577
> CurrCarrySym s
> CurrOutSig s
> NextCarrySym s
> NextOutSig s
> indent s
: A carry chain with RLOC parameters is moving to right from CY4 symbol
: [indent]`[CurrCarrySym]' (output signal = [CurrOutSig]) to[.br]
: [indent]`[NextCarrySym]' (output signal = [NextOutSig]).[.br][.br]
:
: The only possible placement for this type of structure
: is coincident with the top or bottom edge of the device.[.br]

M CARRY_HORIZONTAL_SEGMENT_LOC -e4578
> CurrCarrySym s
> CurrOutSig s
: The horizontal carry chain beginning with `[CurrCarrySym]'
: (output signal = [CurrOutSig]) has LOC parameters that reference
: neither the top nor bottom row of the device.[.br]

M CARRY_HORIZONTAL_SEGMENT_RLOC -w4579
> CurrCarrySym s
> CurrOutSig s
: The horizontal carry chain beginning with `[CurrCarrySym]'
: (output signal = [CurrOutSig]) has RLOC parameters.[.br][.br]
:
: The only possible placement for this type of structure
: is coincident with the top or bottom edge of the device.[.br]



#---------------------------- Carry RLOC Set ----------------------------------

M CARRY_RLOC_SET -e4580
: The following CY4 symbols are in the same carry chain but are assigned to
: different RLOC sets:[.br]

M CARRY_RLOC_SET_LOOP
> symname s
> settype s
> setname s
> outsig s
: Symbol Name = [symname][.br]
: Belongs to Set [settype] = [setname][.br]
: Output Signal = [outsig][.br]

M CARRY_RLOC_SET_EXPL
: Every CY4 symbol in a carry chain must belong to the same RLOC set.[.br]



#---------------------------- Count IO Pins -----------------------------------

M TOOMANY_UIOPINS -e4581
> num d
> max d
> parttype s
: The design requires [num] unbonded pads.[.br]
: There are only [max] unbonded pads available in part [parttype].[.br]

M TOOMANY_BIOPINS -e4582
> num d
> max d
> parttype s
: The design requires [num] bonded pads.[.br]
: There are only [max] bonded pads available in part [parttype].[.br]



#---------------------------- Count CLB Flip-flops ------------------------------

M TOOMANY_CLBFFS -e4583
> num d
> max d
> parttype s
: The design requires [num] CLB flipflops.[.br]
: There are only [max] CLB flipflops available in part [parttype].[.br]



#---------------------------- Count CLBs Required By Carry Logic ----------------

M TOOMANY_CARRY_CLBS -e4584
> numclbs d
> maxclbs d
> parttype s
: The carry logic used in the design requires [numclbs] CLBs.[.br]
: There are only [maxclbs] CLBs available in part [parttype].[.br]



#---------------------------- Count CLBs Required By CLBMAPs --------------------

M TOOMANY_CLBMAPS -e4585
> num d
> max d
> parttype s
: At this stage of processing it appears that CLBMAPs used require [num] CLBs.[.br]
: There are only [max] CLBs available in part [parttype].[.br]



#---------------------------- Count CLBs Required By FMAPs and HMAPs ------------

M TOOMANY_FMAPS -e4586
> num d
> max d
> parttype s
: At this stage of processing it appears that FMAPs used require [num] CLBs.[.br]
: There are only [max] CLBs available in part [parttype].[.br]

M TOOMANY_HMAPS -e4587
> num d
> max d
> parttype s
: At this stage of processing it appears that HMAPs used require [num] CLBs.[.br]
: There are only [max] CLBs available in part [parttype].[.br]



#---------------------------- Count CLBs Required By BLKNMs/HBLKNMs --------------

M TOOMANY_BLKNMS -e4588
> num d
> max d
> parttype s
: At this stage of processing it appears that BLKNMs and HBLKNMs used require
: [num] CLBs.[.br]
: There are only [max] CLBs available in part [parttype].[.br]



#---------------------------- 3K Horizontal Long Lines --------------------------

M HORI_LINE_3K -e4589
> signame s
: The signal `[signame]' is driven by the following non three-state symbols:[.br]

M SYM_LOOP
> symtype s
> symname s
: Symbol Type = [symtype] ; Symbol Name = [symname]

M HORI_3K_EXPL
: [.br]
: This signal can be driven only by TBUF, TRISTATE, BIDIR_IO (with IE pin
: connected) and PULLUP symbols.[.br]


M TOOMANY_TBUFS -e4590
> signame s
> numtbufs d
> maxtbufs d
> parttype s
: The signal `[signame]' is driven by [numtbufs] TBUF, TRISTATE, or BIDIR_IO
: (with IE pin connected) symbols. In the part [parttype], at most [maxtbufs]
: TBUF, TRISTATE, or BIDIR_IO symbols can drive a single net.[.br]

M TOOMANY_3KHORI_LINES -e4591
> num d
> max d
> parttype s
: The design uses [num] TBUF, TRISTATE, or BIDIR_IO (with IE pin connected)
: driven signals. There can at most be [max] TBUF, TRISTATE, or BIDIR_IO
: driven signals in the part [parttype].[.br]



#---------------------------- 4K Horizontal Long Lines --------------------------

M HORI_LINE_4K -e4592
> signame s
: The signal `[signame]' is driven by the following non three-state symbols:[.br]

M HORI_4K_EXPL
: [.br]
: This signal can be driven only by TBUF, WORAND, WAND (without the DECODE
: parameter), TRISTATE, BIDIR_IO, (with IE pin connected), and PULLUP symbols.[.br]


M TOOMANY_ELEMS -e4593
> signame s
> numelems d
> maxelems d
> parttype s
: The signal `[signame]' is driven by [numelems] TBUF, TRISTATE, WAND, WORAND,
: or BIDIR_IO (with IE pin connected) symbols. In the part [parttype], at most
: [maxelems] TBUF, TRISTATE, WAND, WORAND, or BIDIR_IO can drive a single net.[.br]

M TOOMANY_4KHORI_LINES -e4594
> num d
> max d
> parttype s
: The design uses [num] TBUF, TRISTATE, WAND, WORAND, or BIDIR_IO (with IE
: pin connected) driven signals. There can at most be [max] TBUF, TRISTATE,
: WAND, WORAND, or BIDIR_IO driven signals in the part [parttype].[.br]



#---------------------------- 4K Decoder Long Lines -----------------------------

M DECODER_SIG_INVALID_SYMS -e4595
> signame s
: The DECODER output signal `[signame]' is driven by the following invalid
: symbols. A DECODER output signal can be driven only by WANDs with the DECODE
: parameter, and PULLUPs.[.br][.br]

M DECODER_SIG_MISSING_PARAM -e4596
> signame s
> symtype s
> symname s
: The [symtype] `[symname]' driving the DECODER output signal `[signame]'
: does not have the DECODE parameter.[.br]

M DECODER_SIG_MISSING_PULLUP -e4597
> signame s
: The DECODER output signal `[signame]' does not have any PULLUP connected
: to it.[.br][.br]
:
: A DECODER output signal must have a PULLUP.[.br]

M TOOMANY_DECODERS_IOB -e4598
> signame s
> numiobs d
> maxiobs d
> parttype s
: The DECODER output signal `[signame]' has [numiobs] decoders driven from
: input symbols. In the part [parttype], at most [maxiobs] decoders on a signal
: can be driven from input symbols.[.br]

M TOOMANY_DECODERS_LC -e4599
> signame s
> numlc d
> maxlc d
> parttype s
: The DECODER output signal `[signame]' has [numlc] decoders driven from
: local interconnect. In the part [parttype], at most [maxlc] decoders can
: be driven from local interconnect.[.br]

M TOOMANY_DECODERS -e4600
> signame s
> numdec d
> maxdec d
> parttype s
: The DECODER output signal `[signame]' is driven by [numdec] decoders.
: In the part [parttype], at most [maxdec] decoders can drive a DECODER
: output signal.[.br]

M TOOMANY_DECODER_LINES -e4601
> num d
> max d
> parttype s
: The design uses [num] DECODER long lines. There are only [max] DECODER long
: lines available in the part [parttype].[.br]



#---------------------------- Count 2K IO Clock Signals ------------------------

M CLKSIGCNT_2K -e4602
: More than 4 I/O clock signals are used to drive INFFs:[.br]
: [.br]
: IO Clock Signal Name[.br]
: --------------------

M CLKSIGCNT_LOOP
> signame s
> text s
: [signame] [text]

M CLKSIGCNT_2K_EXPL
: [.br]
: In XC2000 parts, there is only one I/O clock line per edge.
: Therefore, at most four I/O clock signals can be used to drive
: the clock pins of INFFs.[.br]


M CLKSIG_2K -e4603
: 2K I/O clock signals drive too many INFFs.[.br]

M CLKSIG_LOOP
> signame s
> number d
> text m
: I/O clock signal [signame] drives [number] [text].



#---------------------------- 2K IO Clock Signal Requirements ------------------

M CLKSIG_2K_SIGS_4
: [.br]
: Explanation:
:
: If the number of 2K unique clock signals is 4, then[.br][.br]
:
: 1. Two clock signals drive no more than (MAX_H_INFF) INFFs each,[.br]
:    while the other two signals drive no more than (MAX_V_INFF) INFFs
:    each.[.br][.br]


M CLKSIG_2K_SIGS_3
: [.br]
: Explanation:
:
: If the number of 2K unique clock signals is 3, then[.br][.br]
:
: 1. One signal drives no more than (MAX_H_INFF + MAX_V_INFF) INFFs,[.br]
:    while another signal drives no more than (MAX_H_INFF) INFFs,[.br]
:    and the third signal drives no more than (MAX_V_INFF) INFFs.[.br][.br]


M CLKSIG_2K_SIGS_2
: [.br]
: Explanation:
:
: If the number of unique clock signals is 2,
: then one of the following three requirements should be met:[.br][.br]
:
: 1. One signal drives no more than (MAX_H_INFF * 2 + MAX_V_INFF) INFFs,[.br]
:    while the other signal drives no more than (MAX_V_INFF) INFFs.[.br][.br]
:
: 2. One signal drives no more than (MAX_H_INFF + MAX_V_INFF * 2) INFFs,[.br]
:    while the other signal drives no more than (MAX_H_INFF) INFFs.[.br][.br]
:
: 3. Two signals drive no more than (MAX_H_INFF + MAX_V_INFF) INFFs each.[.br][.br]


M CLKSIG_2K_SIGS_1
: [.br]
: Explanation:
:
: If the number of unique clock signals is 1, then[.br]
:
: this clock signal should drive no more than (MAX_H_INFF * 2 + MAX_V_INFF * 2)
: INFFs.[.br][.br]



#---------------------------- Count 3K IO Clock Signals ------------------------

M CLKSIGCNT_3K -e4604
: More than 8 I/O clock lines are used to drive I/O storage symbols:[.br]

M CLKSIGCNT_3K_EXPL
: [.br]
: In XC3000 parts, there are only two I/O clock lines per edge.
: Therefore, at most eight I/O clock signals can be used to drive
: the clock pins of INFF/INLAT/OUTFF/OUTFFT symbols.[.br]


M CLKSIG_3K -e4605
: 3K I/O clock signals drive too many I/O storage symbols.[.br]



#---------------------------- 3K IO Clock Signal Requirements ------------------

M CLKSIG_3K_SIGS_8
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 8, then[.br][.br]
:
: 1. Four clock signals drive no more than (MAX_H_IO) IO symbols each,[.br]
:    while the other four signals drive no more than (MAX_V_IO) IO symbols
:    each.[.br][.br]


M CLKSIG_3K_SIGS_7
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 7, then the following requirement
: should be satisfied.[.br][.br]
:
: 1. One signal drives no more than (MAX_H_IO + MAX_V_IO) IO symbols.[.br]
:    Other three signals drive no more than (MAX_H_IO) IO symbols each.[.br]
:    Remaining three signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]


M CLKSIG_3K_SIGS_6
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 6, then one of the following
: three requirements should be met.[.br][.br]
:
: 1. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO) IO symbols.[.br]
:    Other two signals drive no more than (MAX_H_IO) IO symbols each.[.br]
:    Remaining three signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]
:
: 2. One signal drives no more than (MAX_H_IO + MAX_V_IO * 2) IO symbols.[.br]
:    Other three signals drive no more than (MAX_H_IO) IO symbols each.[.br]
:    Remaining two signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]
:
: 3. Two signals drive no more than (MAX_H_IO + MAX_V_IO) IO symbols each.[.br]
:    Other two signals drive no more than (MAX_H_IO) IO symbols each.[.br]
:    Remaining two signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]


M CLKSIG_3K_SIGS_5
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 5, then one of the following
: four requirements should be met.[.br][.br]
:
: 1. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO * 2) IO symbols.[.br]
:    Other two signals drive no more than (MAX_H_IO) IO symbols each.[.br]
:    Remaining two signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]
:
: 2. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO + MAX_V_IO) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO) IO symbols.[.br]
:    Remaining two signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]
:
: 3. One signal drives no more than (MAX_H_IO + MAX_V_IO * 2) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO + MAX_V_IO) IO symbols.[.br]
:    Another signal drives no more than (MAX_V_IO) IO symbols.[.br]
:    Remaining two signals drive no more than (MAX_H_IO) IO symbols each.[.br][.br]
:
: 4. Three signals drive no more than (MAX_H_IO + MAX_V_IO) IO symbols each.[.br]
:    Another signal drives no more than (MAX_H_IO) IO symbols each.[.br]
:    Remaining signal drives no more than (MAX_V_IO) IO symbols each.[.br][.br]


M CLKSIG_3K_SIGS_4
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 4, then one of the following
: five requirements should be met.[.br][.br]
:
: 1. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO * 2) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO + MAX_V_IO) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO) IO symbols.[.br]
:    Remaining signal drives no more than (MAX_V_IO) IO symbols.[.br][.br]
:
: 2. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO + MAX_V_IO * 2) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO) IO symbols.[.br]
:    Remaining signal drives no more than (MAX_V_IO) IO symbols.[.br][.br]
:
: 3. Two signals drive no more than (MAX_H_IO * 2 + MAX_V_IO) IO symbols each.[.br]
:    Remaining two signals drive no more than (MAX_V_IO) IO symbols each.[.br][.br]
:
: 4. Two signals drive no more than (MAX_H_IO + MAX_V_IO * 2) IO symbols each.[.br]
:    Remaining two signals drive no more than (MAX_H_IO) IO symbols each.[.br][.br]
:
: 5. Four signals drive no more than (MAX_H_IO + MAX_V_IO) IO symbols each.[.br][.br]


M CLKSIG_3K_SIGS_3
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 3, then one of the following
: three requirements should be met.[.br][.br]
:
: 1. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO * 2) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO * 2 + MAX_V_IO) IO symbols.[.br]
:    Remaining signal drives no more than (MAX_V_IO) IO symbols.[.br][.br]
:
: 2. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO * 2) IO symbols.[.br]
:    Another signal drives no more than (MAX_H_IO + MAX_V_IO * 2) IO symbols.[.br]
:    Remaining signal drives no more than (MAX_H_IO) IO symbols.[.br][.br]
:
: 3. One signal drives no more than (MAX_H_IO * 2 + MAX_V_IO * 2) IO symbols.[.br]
:    Two signals drive no more than (MAX_H_IO + MAX_V_IO) IO symbols each.[.br][.br]


M CLKSIG_3K_SIGS_2
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 2, then[.br]
:
: these clock signals should drive no more than (MAX_H_IO * 2 + MAX_V_IO * 2)
: IO symbols each.[.br][.br]


M CLKSIG_3K_SIGS_1
: [.br]
: Explanation:
:
: If the number of 3K unique clock signals is 1, then[.br]
:
: this clock signal should drive no more than (MAX_H_INFF * 2 + MAX_V_INFF * 2)
: IO symbols.[.br][.br]



#---------------------------- XBLOX Input Pin Connections --------------------

M XBLOX_INPIN_CONN -e4606
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signal
: connected to the [pinname] input pin. The [pinname] pin of [symtype] must
: be connected.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]

M XBLOX_ALL_INPIN_CONNS -e4607
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signals
: connected to the following pins:[.br]
:
: Pin Name[.br]
: --------

M XBLOX_ALL_INPIN_CONNS_LOOP
> pinname s
: [pinname]

M XBLOX_ALL_INPIN_CONNS_EXPL
> symtype s
: [.br]
: The above pin(s) of the symbol [symtype] must be connected.
: Check the Logic Trimming chapter of this report file to see
: if the required signals were trimmed.[.br]



#---------------------------- XBLOX Output Pin Connections -------------------

M XBLOX_OUTPIN_CONN -e4608
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signal
: connected to the [pinname] output pin. The [pinname] pin of [symtype]
: must be connected.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]

M XBLOX_ALL_OUTPIN_CONNS -e4609
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has none of its output
: pins connected. At least one of the output pins of [symtype] must be
: connected.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]



#---------------------------- XBLOX Pin Connections --------------------------

M XBLOX_ONEPIN_CONN -e4610
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) does not have any signal
: connected to the [pinname] pin. The [pinname] pin of [symtype] must be
: connected.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]



#---------------------------- XBLOX Two Pins ---------------------------------

M XBLOX_TWO_PINS -e4611
> symtype s
> symname s
> signame s
> pinname1 s
> pinname2 s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal `[signame]'
: connected to the [pinname1] pin, but there is no signal
: connected to the [pinname2] pin. To use the [pinname1] pin, the [pinname2]
: pin must be connected.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]



#---------------------------- User Param Value Missing -----------------------

M XBLOX_UPARAM_VALUE_MISSING -e4612
> symtype s
> symname s
> paramname s
: The `[paramname]' parameter on XBLOX symbol `[symname]' (type = [symtype])
: does not have any value assigned to it.[.br]



#---------------------------- XBLOX SHIFT Loading ----------------------------

M XBLOX_SHIFT_ASYNC_VAL -e4613
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has an ASYNC_VAL of zero,
: and no other way of loading the SHIFT register. Either specify a non-zero
: ASYNC_VAL, or specify a non-zero SYNC_VAL and connect the SYNC_CTRL pin,
: or connect one of the PAR_IN, MS_IN, or LS_IN pins.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]

M XBLOX_SHIFT_SYNC_VAL -e4614
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has a SYNC_VAL of zero,
: and no other way of loading the SHIFT register. Either specify a non-zero
: SYNC_VAL, or specify a non-zero ASYNC_VAL, or connect one of the PAR_IN,
: MS_IN, or LS_IN pins.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]

M XBLOX_SHIFT_LOADING -e4615
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has no way of loading the
: SHIFT register. Either specify a non-zero ASYNC_VAL, or specify a non-zero
: SYNC_VAL and connect the SYNC_CTRL pin, or connect one of the PAR_IN, MS_IN,
: or LS_IN pins.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]



#---------------------------- XBLOX SHIFT Direction --------------------------

M XBLOX_SHIFT_DIRECTION -e4616
> symtype s
> symname s
> signame1 s
> signame2 s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal `[signame1]'
: connected to its LS_IN pin, and a signal `[signame2]' connected to its
: MS_IN pin, but there is no signal connected to the
: RIGHT_LEFT pin. The RIGHT_LEFT pin must be connected in order to indicate
: the direction of the shift.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the required
: signals were trimmed.[.br]



#---------------------------- XBLOX SHIFT Style -------------------------------

M XBLOX_SHIFT_CIRCULAR -e4617
> symtype s
> symname s
> pinname s
> signame s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal [signame]
: connected to the [pinname] pin. This pin may not be used in a CIRCULAR
: style of shift register.[.br]

M XBLOX_SHIFT_ARITH -w4618
> symtype s
> symname s
> pinname s
> signame s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal [signame]
: connected to the [pinname] pin, and a right shift may occur. Therefore,
: the sign bit may change.[.br]



#---------------------------- DECODE EN Pin Connections -----------------------

M XBLOX_DECODE_EN_PIN -e4619
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) has the [pinname] pin tied low.
: This disables the DECODE symbol.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the logic
: sourcing the EN pin was reduced to GND.[.br]



#---------------------------- XBLOX COUNTER Style -----------------------------

M XBLOX_COUNTER_LFSR_UP_DN -e4620
> symtype s
> symname s
> pinname s
> signame s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal [signame]
: connected to the [pinname] pin. This pin may not be connected in an LFSR
: style counter.[.br]

M XBLOX_COUNTER_LFSR_LOAD -w4621
> symtype s
> symname s
> pinname s
> signame s
: The XBLOX symbol `[symname]' (type = [symtype]) has a signal [signame]
: connected to the [pinname] pin. The only input that can validly be loaded
: into the LFSR is the data that has been latched from the LFSR Q_OUT pin.
: Any other input will cause the LFSR behavior to be unpredictable.[.br]



#---------------------------- DATA_REG STYLE and CLK_EN Pin ---------------------

M XBLOX_DATA_REG_CLK_EN_PIN -e4622
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in IOBs. However,
: this can not be done since the DATA_REG has its clock-enable pin connected.
: The IOB flip-flops and latches do not have a clock-enable pin.[.br]



#---------------------------- DATA_REG STYLE and ASYNC_CTRL/SYNC_CTRL Pin -------

M XBLOX_DATA_REG_SYNC_PIN -e4623
> symtype s
> symname s
> pinname s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in IOBs. However,
: this can not be done since the DATA_REG has its [pinname] pin connected.[.br]



#---------------------------- DATA_REG STYLE and D_IN Pin ----------------------

M XBLOX_DATA_REG_INPUT -e4624
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However, this can not
: be done since the [pinname] pin of [symtype] is unconnected.

M XBLOX_DATA_REG_INPUT_EXPL
: [.br]
: If the DATA_REG symbol has a STYLE parameter with value IFD or ILD,
: then its data input pin (D_IN) must be connected only to the output pin
: of an INPUTS, BIDIR_IO, or IBUF symbol. This may be through an ELEMENT,
: SLICE, or CAST symbol. When ELEMENT, SLICE, and CAST symbols are removed,
: each signal in the data input bus of the DATA_REG must be connected to the
: output pin of exactly one input symbol.[.br]

M XBLOX_DATA_REG_NON_INPUT_SYM -e4625
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However, this can not
: be done since the [pinname] pin of [symtype] is connected to the following
: non-input symbol pin(s):[.br]

M XBLOX_DATA_REG_INPUT_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M XBLOX_DATA_REG_NO_INPUT_SYM -e4626
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However, this can not
: be done since the [pinname] pin of [symtype] is not connected
: to the output pin of any input symbol.

M XBLOX_DATA_REG_MORE_INPUT_SYM -e4627
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However, this can not
: be done since the [pinname] pin of [symtype] is connected to
: more than one input symbols:[.br]

M XBLOX_DATA_REG_SEC_INPUT_SYM -e4628
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However,
: this can not be done since the [pinname] pin of [symtype] is connected to
: the following SLICE/ELEMENT/CAST symbol(s) and input symbol(s):[.br]

M XBLOX_DATA_REG_X_L_PARAM -e4629
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However,
: the following signals connected to the [pinname] pin have X and/or L parameters,
: which prevents the [symtype] from being merged into an IOB.[.br]

M XBLOX_DATA_REG_X_L_PARAM_LOOP
> signame s
> paramnames s
: Signal Name = [signame] ; Parameters = [paramnames]



#---------------------------- DATA_REG STYLE and Q_OUT Pin ---------------------

M XBLOX_DATA_REG_OUTPUT -e4630
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text].
: However, this can not be done since the [pinname] pin of [symtype] is unconnected.

M XBLOX_DATA_REG_OUTPUT_EXPL
: [.br]
: If the DATA_REG symbol has a STYLE parameter with value OFD
: then its data output pin (Q_OUT) must be connected only to the input pin
: of an OUTPUTS, BIDIR_IO, or OBUF symbol. This may be through an ELEMENT,
: SLICE, or CAST symbol. When ELEMENT, SLICE, and CAST symbols are removed,
: each signal in the data output bus of the DATA_REG must be connected to the
: input pin of exactly one output symbol.[.br]

M XBLOX_DATA_REG_NON_OUTPUT_SYM -e4631
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text].
: However, this can not be done since the [pinname] pin of [symtype] is connected
: to the following non-output symbol pin(s):[.br]

M XBLOX_DATA_REG_OUTPUT_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M XBLOX_DATA_REG_NO_OUTPUT_SYM -e4632
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text].
: However, this can not be done since the [pinname] pin of [symtype] is not connected
: to the input pin of any output symbol.

M XBLOX_DATA_REG_MORE_OUTPUT_SYM -e4633
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text].
: However, this can not be done since the [pinname] pin of [symtype] is connected
: to more than one output symbols:[.br]

M XBLOX_DATA_REG_SEC_OUTPUT_SYM -e4634
> symtype s
> symname s
> pinname s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has parameters, which
: indicate that it should be implemented in [text]. However,
: this can not be done since the [pinname] pin of [symtype] is connected to
: the following SLICE/ELEMENT/CAST symbol(s) and output symbol(s):[.br]



#---------------------------- DATA_REG STYLE=IOB -------------------------------

M XBLOX_DATA_REG_IOB -e4635
> symtype s
> symname s
> paramname s
> paramvalue s
> text s
: The XBLOX symbol `[symname]' (type = [symtype]) has
: the [paramname] = [paramvalue] parameter, which indicates that it should
: be implemented in [text]. However, the [symtype] can not be moved into the
: input IOBs nor the output IOBs, because neither the D_IN pin nor the Q_OUT
: pin of [symtype] is properly connected to I/O symbols. At least one of the
: pins must be properly connected to the I/O symbols for this [symtype] to be
: implemented in input IOBs or output IOBs. The potential connectivity errors
: of D_IN and Q_OUT pins are described below:[.br]

M XBLOX_DATA_REG_IOB_UNCONNECTED_PIN
> pinname s
: The [pinname] pin is unconnected.[.br]

M XBLOX_DATA_REG_IOB_NO_IO_SYM
> pinname s
> pintext s
> symtext s
: The [pinname] pin is not connected to the [pintext] pin of any [symtext] symbol.[.br]

M XBLOX_DATA_REG_IOB_MORE_IO_SYM
> pinname s
> symtext s
: The [pinname] pin is connected to more than one [symtext] symbols:[.br]

M XBLOX_DATA_REG_IOB_SEC_IO_SYM
> pinname s
> symtext s
: The [pinname] pin is connected to the following SLICE/ELEMENT/CAST symbol(s)
: and [symtext] symbol(s):[.br]

M XBLOX_DATA_REG_IOB_NON_IO_SYM
> pinname s
> symtext s
: The [pinname] pin is connected to the following non-[symtext] symbols:[.br]

M XBLOX_DATA_REG_IOB_X_L_PARAM
> pinname s
: The following signals connected to the [pinname] pin have X and/or L
: parameters. These parameters prevent the DATA_REG from being merged
: into an IOB.[.br]

M XBLOX_DATA_REG_IOB_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M XBLOX_DATA_REG_IOB_X_L_PARAM_LOOP
> signame s
> paramnames s
: Signal Name = [signame] ; Parameters = [paramnames]

M XBLOX_DATA_REG_IOB_EXPL
> indent s
: If the DATA_REG symbol has a STYLE parameter with value IOB, then at least
: one of the following conditions must be true:[.br][.br]
:
: (1) The data input (D_IN) pin of the DATA_REG must be connected[.br]
: [indent]  only to the output pin of an INPUTS, BIDIR_IO, or IBUF symbol.[.br]
: [indent]  This may be through an ELEMENT, SLICE, or CAST symbol.[.br]
: [indent]  Also the signal between the data input pin and the input[.br]
: [indent]  symbol must not have the X or L parameters.[.br][.br]
:
: (2) The output (Q_OUT) pin of the DATA_REG must be connected only[.br]
: [indent]  to the input pin of an OUTPUTS, BIDIR_IO, or OBUF symbol.[.br]
: [indent]  This may be through an ELEMENT, SLICE, or CAST symbol.[.br]
: [indent]  Also the signal between the data output pin and the output[.br]
: [indent]  symbol must not have the X or L parameters.[.br]



#---------------------------- XBLOX ELEMENT Pins --------------------------------

M XBLOX_TWO_SOURCES -e4636
> symtype s
> symname s
: The XBLOX symbol `[symname]' (type = [symtype]) has neither of its pins being
: driven. One of the connected busses must be driven.[.br][.br]
:
: Check the Logic Trimming chapter of this report file to see if the driving
: logic has been trimmed.[.br]



#---------------------------- TBUF Errors ---------------------------------------

M TBUF_OTPINS_SAME_SIG -e4637
> symtype s
> symname s
> signame s
: The signal `[signame]' is connected to both the 3-state and output pins of
: [symtype] symbol `[symname]'. Please check the design for misnamed or
: misconnected signals.[.br]

M TBUFS_TPINS_SAME_SIG -e4638
> Osigname s
> Tsigname s
: The following TBUFs drive the same output signal `[Osigname]', and are enabled
: by the same 3-state signal `[Tsigname]':[.br]
: [.br]
: TBUF Symbol Name[.br]
: ----------------

M TBUFS_TPINS_SAME_SIG_LOOP
> symname s
: [symname]



#---------------------------- WAND Errors ---------------------------------------

M WAND_OIPINS_SAME_SIG -e4639
> symtype s
> symname s
> signame s
: The signal `[signame]' is connected to both the input and output pins of
: [symtype] symbol `[symname]'. Please check the design for misnamed or
: misconnected signals.[.br]



#---------------------------- Single WORAND ---------------------------------------

M WORAND_WITHOUT_PULLUP -e4640
> symname s
> signame s
: The signal `[signame]', driven by a single WORAND `[symname]',
: does not have any PULLUP connected to it.[.br][.br]
:
: A signal driven by WANDs or WORANDs must have a PULLUP.[.br][.br]
:
: Moreover, since there is only one WORAND, this function can be
: implemented in a function generator.[.br]

M WORAND_SINGLE -w4641
> symname s
> signame s
: The signal `[signame]' is driven by a single WORAND `[symname]'.
: This function can be implemented in a function generator.[.br]



#---------------------------- Check Parameters of FMAPs & HMAPs -------------------

M INCONSISTENT_BLKNM_PARAMS -w4642
> hmapname s
> hmapvalue s
> fmap1name s
> fmap1value s
> fmap2name s
> fmap2value s
: Different BLKNM parameters found on 2 FMAPs and 1 HMAP which are connected
: together:[.br][.br]
:
: HMAP Name = [hmapname] ; BLKNM = [hmapvalue][.br]
: FMAP Name = [fmap1name] ; BLKNM = [fmap1value][.br]
: FMAP Name = [fmap2name] ; BLKNM = [fmap2value][.br][.br]
:
: These parameters may cause inefficient partitioning.[.br]
: Please review these parameters.[.br][.br]

M INCONSISTENT_LOC_PARAMS -w4643
> hmapname s
> hmapvalue s
> fmap1name s
> fmap1value s
> fmap2name s
> fmap2value s
: Different LOC parameters found on 2 FMAPs and 1 HMAP which are connected
: together:[.br][.br]
:
: HMAP Name = [hmapname] ; LOC = [hmapvalue][.br]
: FMAP Name = [fmap1name] ; LOC = [fmap1value][.br]
: FMAP Name = [fmap2name] ; LOC = [fmap2value][.br][.br]
:
: These parameters may cause inefficient partitioning.[.br]
: Please review these parameters.[.br][.br]



#---------------------------- 2K OSC Connections ------------------------------

M OSC_DRIVES -e4644
> symtype s
> symname s
> outsig s
: The oscillator symbol `[symname]' (type = [symtype], output signal = [outsig])
: is connected to the following invalid symbol pin(s):[.br]

M OSC_DRIVES_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M OSC_DRIVES_EXPL
: [.br]
: In XC2000 family, the oscillator can ONLY be used to drive the input of
: ACLK. No other connections are allowed.[.br]



#---------------------------- Count Input Symbols on a Pad ------------------------

M IOSIG_MULTIPLE_INPINS -e4645
> padname s
: The pad `[padname]' is connected to multiple input symbols:[.br]

M IOSIG_MULTIPLE_INPINS_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M IOSIG_MULTIPLE_INPINS_EXPL
: [.br]
: A pad can normally be connected to only one input symbol. A few exceptions to
: this rule are described below.[.br][.br]
:
: For an XC3000 or XC4000 design, an IBUF may be connected in parallel
: with an input flip-flop or an input latch in order to access both the
: registered and non-registered input signals. In addition, for an 
: XC4000 design, an input flip-flop and input latch may be connected
: in parallel to access both the level-sensitive and edge-triggered 
: register outputs.[.br]



#---------------------------- Count Output Symbols on a Pad -------------------

M IOSIG_MULTIPLE_OUTPINS -e4646
> padname s
: The pad `[padname]' is connected to multiple output symbols:[.br]

M IOSIG_MULTIPLE_OUTPINS_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M IOSIG_MULTIPLE_OUTPINS_EXPL
: [.br]
: A pad can be connected to only one output symbol.[.br]



#---------------------------- PULLUP/PULLDOWN on Pad Signals -----------------

M PAD_PULLUP_NO_GTS -w4647
> outsymtype s
> outsymname s
> pullsymtype s
> padname s
: The pad `[padname]' is attached to a [pullsymtype] symbol, but will always
: be driven by the output symbol `[outsymname]' (type = [outsymtype]).[.br][.br]
:
: This situation is legal, but the [pullsymtype] will perform no logical
: function and will increase power consumption. If this is unintended,
: consult the Logic Trimming chapter of this report file to determine if
: the 3-state control of this output symbol was reduced to be permanently
: enabled.[.br]

M PAD_PULLUP_GTS -w4648
> outsymtype s
> outsymname s
> pullsymtype s
> padname s
: The pad `[padname]' is attached to a [pullsymtype] symbol, but will be
: driven by the output symbol `[outsymname]' (type = [outsymtype]) at all
: times, except when the global 3-state (GTS) function is used.[.br][.br]
:
: The [pullsymtype] will affect the logical level of the pad only when the
: GTS is used. Make certain that this behavior is desired, since the
: [pullsymtype] will increase power consumption. If this is unintended,
: consult the Logic Trimming chapter of this report file to determine if
: the 3-state control of this output symbol was reduced to be permanently
: enabled.[.br]



#---------------------------- Multiply Sourced Signals -----------------------

M MULTSRC -e4649
> signame s
: The signal `[signame]' has multiple sources:[.br]

M MULTSRC_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M MULTSRC_EXPL
: [.br]
: Please check the schematic for duplicate signal names.[.br][.br]
:
: If the signal is connected to the INPUTS pin of BIDIR_IO symbol, then
: please ensure that its IE pin is connected.[.br]

M DELETION_TRI_SYMS
: [.br]
: This may have been caused by the deletion of one or more three-state symbols
: by the XNF trimming program. Please check the XNFPREP trimming report.[.br]



#---------------------------- Map Output Pin Connections -----------------------

M MAP_OUTPIN_CONN -e4650
> signame s
: The signal `[signame]' is mapped by more than one map symbol:[.br]

M MAP_OUTPIN_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ;[.br]
: Symbol Name = [symname][.br]

M MAP_OUTPIN_EXPL
: Please check the schematic for duplicate signal names.[.br]



#---------------------------- Check unbonded pads ----------------------------

M UNBONDED_PAD_OUTPUT -w4651
: The following unbonded pads only have an output symbol connected to them.[.br]
: [.br]
: Unbonded Pad Name[.br]
: -----------------

M UNBONDED_PAD_LOOP
> padname s
: [padname]

M UNBONDED_PAD_OUTPUT_EXPL
: [.br]
: The IOB configuration will be implemented, but the signal generated by the
: output driver will not be observable.[.br]

M UNBONDED_PAD_INPUT -e4652
: The following unbonded pads only have an input symbol connected to them.[.br]

M UNBONDED_PAD_INPUT_EXPL
: [.br]
: The input(s) will be undefined.[.br]



#---------------------------- Check for Overloaded Signals ------------------

M OVERLOADED_SIGNALS -w4653
: Each of the following signals drives a large number of load pins:[.br]
: [.br]
: # of Loads   Signal Name[.br]
: ----------   -----------

M OVERLOADED_SIGNALS_LOOP
> signame s
> load d
> spaces s
> indent s
: [indent][indent][load][spaces][signame]

M OVERLOADED_SIGNALS_EXPL
: [.br]
: There is nothing logically wrong with this situation. However, after the
: design has been partitioned, placed and routed, you may find that the delays
: on these signals are unacceptable. If this proves to be the case, you might
: consider replicating the logic used to generate these signals so that the
: loading (and therefore the routing delay) is reduced.[.br]



#-------------------- Count Pads with LOC Parameters --------------------------

M PAD_LOC_COUNT_GT_5 -w4654
: More than five I/O locations are locked in this design using the
: LOC parameter.[.br][.br]
:
: Locking down I/O locations without regard for logic placement can degrade
: performance of the design. And it could even result in the design being
: unable to be routed.[.br]



#---------------------------- Clock Symbol Input Connections --------------------

M CLKSYM_INPUT_VCC_GND -e4655
> clksymtype s
> clksymname s
> outsig s
> vddorgnd s
: The clock symbol `[clksymname]' (type = [clksymtype], output signal = [outsig])
: is sourced from [vddorgnd]. If the output signal is not being used, leave the
: input of clock symbol sourceless, and the corresponding logic will be trimmed.
: Otherwise, tie the input to an active signal.[.br][.br]

M CLKSYM_INPUT_CONNS_2K -e4656
> clksymtype s
> clksymname s
> padname s
: The clock symbol `[clksymname]' (type = [clksymtype]) is driven directly by
: the pad `[padname]'.[.br][.br]
:
: An IBUF must be between a pad and 2K [clksymtype].[.br]

M CLKSYM_INPUT_CONNS_3K_OSC -e4657
: The design includes both an XTAL oscillator and an ACLK buffer sourced
: directly from a pad symbol. When the XTAL oscillator is being used, the
: direct input to ACLK (BCLKIN) is used to connect the external oscillator
: circuitry, and cannot be used as an ACLK input.[.br][.br]
:
: The ACLK buffer can be used if it is driven from an IBUF, as this allows
: a different package pin to be used.[.br]

M CLKSYM_INPUT_CONNS_3K_4K -w4658
> clksymtype s
> clksymname s
> padname s
: The clock symbol `[clksymname]' (type = [clksymtype]) is driven from an
: internal source through the pad `[padname]'.[.br][.br]
:
: Please ensure that this pad is not driven by any external source.[.br]

M BUFGP_BUFGS_INPUT_CONNS -w4659
> clksymtype s
> clksymname s
> symname s
> signame s
: The signal `[signame]' drives the [clksymtype] symbol `[clksymname]' from
: the IBUF symbol `[symname]'. This signal cannot be routed through the
: dedicated input path and will incur an unpredictable routing delay.[.br][.br]
:
: To use the dedicated input path, remove the IBUF symbol and connect the
: clock symbol directly to the pad symbol.[.br]

M BUFGP_INPUT_CONNS -w4660
> clksymtype s
> clksymname s
> symtype s
> symname s
> outsig s
: The clock symbol `[clksymname]' (type = [clksymtype]) is driven from an
: internal source `[symname]' (type = [symtype], output signal = [outsig]).
: [.br][.br]
:
: In order to drive this [clksymtype], the internal signal must be brought
: through the dedicated IOB for the [clksymtype].[.br][.br]
:
: This additional I/O pad will be driven internally and must not be driven
: by any external source.[.br][.br]
:
: Note that an internal signal may source a BUFGS without requiring the use of
: the dedicated IOB.[.br]

M CLKSYM_INPUT_SIG_DRIVES -e4661
> symtype s
> symname s
> signame s
: The input signal `[signame]' to clock symbol `[symname]' (type = [symtype])
: is directly connected to a pad, and is also driving the following symbol
: pins:[.br]


M CLKSYM_INPUT_SIG_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]


M CLKSYM_INPUT_SIG_EXPL
> signame s
: [.br]
: An IBUF must be connected between the input signal `[signame]' and
: these pins.[.br]



#----------------------- 2K Clock Symbol Output Connections ---------------------

M GCLK_DRIVES_OUTSYMS_2K -e4662
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: drives the `I' pin of more than one output symbol:[.br]

M GCLK_DRIVES_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M GCLK_DRIVES_OUTSYMS_2K_EXPL
: [.br]
: The XC2000 global clock buffer (GCLK) can drive at most one output symbol
: (PAD1). You may use the input signal to the GCLK buffer to drive extra
: output symbols.[.br]


M ACLK_DRIVES_OUTSYMS_2K -w4663
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: drives the `I' pin of more than one output symbol:[.br]

M ACLK_DRIVES_LOOP
> symtype s
> symname s
> pinname s
: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]

M ACLK_DRIVES_OUTSYMS_2K_EXPL
: [.br]
: In XC2000 parts, the ACLK buffer can directly drive at most one output
: symbol (PAD38 in XC2018, and PAD30 in XC2064). The ACLK buffer can drive
: other output symbols via the general interconnect. Though, this may make
: your design more difficult to route.[.br][.br]
:
: You may want to remove the extra output symbols from the output signal
: of ACLK and reconnect them to the input signal of the ACLK buffer.[.br][.br]
:
: If the ACLK input signal is directly connected to a pad, and is needed
: to drive other pins, then IBUFs must be connected between the ACLK
: input signal and these pins.[.br]



#----------------------- 3K Clock Symbol Output Connections ---------------------

M GCLK_DRIVES_NON_CLK_PINS_3K -e4664
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: drives the following non-clock pin(s):[.br]

M GCLK_DRIVES_NON_CLK_PINS_3K_EXPL
: [.br]
: The XC3000 global clock buffer (GCLK) can drive only clock pins of the
: CLB/IOB flip-flops and at most two output symbols. You may use the input
: signal to the GCLK buffer to drive non-clock pins.[.br][.br]
:
: If the GCLK input signal is directly connected to a pad, and is needed
: to drive other pins, then IBUFs must be connected between the GCLK input
: signal and these pins.[.br]


M GCLK_DRIVES_INV_CLBMAP_3K -e4665
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: is driving a non-clock pin:[.br]

M GCLK_DRIVES_INV_CLBMAP_3K_EXPL
: [.br]
: Apparently, you are attempting to invert the output signal of the GCLK buffer
: before sourcing clock pins of flip-flops associated with CLBMAP symbols.
: In this case, do not connect the K pin of the CLBMAP symbol to the output
: of the inverter. Instead, connect the K pin of the CLBMAP symbol to the
: input signal of the inverter symbol. The inversion of the clock signal will
: then be implemented in the CLB.[.br]


M GCLK_DRIVES_OUTSYMS_3K -e4666
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: drives the `I' or `D' pins of more than two output symbols:[.br]

M GCLK_DRIVES_OUTSYMS_3K_EXPL
: [.br]
: The XC3000 global clock buffer (GCLK) can drive at most two output symbols.
: You may use the input signal to the GCLK buffer to drive extra output symbols.
: [.br][.br]
:
: If the GCLK input signal is directly connected to a pad, and is needed
: to drive other pins, then IBUFs must be connected between the GCLK input
: signal and these pins.[.br]


M ACLK_DRIVES_NON_CLK_PINS_3K -w4667
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: drives the following non-clock pin(s):[.br]

M ACLK_DRIVES_NON_CLK_PINS_3K_EXPL
: [.br]
: This may make your design more difficult to route. You may want to remove
: the indicated symbols from the output signal of ACLK and reconnect them
: to the input signal of the ACLK buffer.[.br][.br]
:
: If the ACLK input signal is directly connected to a pad, and is needed
: to drive other pins, then IBUFs must be connected between the ACLK
: input signal and these pins.[.br]


M ACLK_DRIVES_OUTSYMS_3K -w4668
> symtype s
> symname s
> outsig s
: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
: drives the `I' or `D' pins of more than two output symbols:[.br]

M ACLK_DRIVES_OUTSYMS_3K_EXPL
: [.br]
: In XC3000 parts, the ACLK buffer can directly drive at most two output symbols.
: The ACLK buffer can drive other output symbols via the general interconnect.
: Though, this may make your design more difficult to route. You may want to
: remove the extra output symbols from the output signal of ACLK and reconnect
: them to the input signal of the ACLK buffer.[.br][.br]
:
: If the ACLK input signal is directly connected to a pad, and is needed
: to drive other pins, then IBUFs must be connected between the ACLK
: input signal and these pins.[.br]



#----------------------- 4K Clock Symbol Output Connections ---------------------
#
#M BUFGP_BUFGS_DRIVES_NON_CLK_PINS_4K -w
#> symtype s
#> symname s
#> outsig s
#: The clock symbol `[symname]' (type = [symtype], output signal = [outsig])
#: drives the following non-clock pin(s):[.br]
#
#M BUFGP_BUFGS_DRIVES_LOOP
#> symtype s
#> symname s
#> pinname s
#: Symbol Type = [symtype] ; Pin Name = [pinname] ; Symbol Name = [symname]
#
#M BUFGP_BUFGS_CAN_DRIVE_4K
#> symtype s
#: [.br]
#: Although a global buffer is able to connect to some non-clock pins, these
#: connections are much more limited than those to clock pins. See the [symtype]
#: entry in the Libraries Guide for more information about the capabilities and
#: limitations of global buffers.[.br]



#-------------------------- GCLK and ACLK Usage --------------------------------

M GCLK_ACLK_NOT_USED -w4669
: The following signal(s) drive clock pins, and are driven by non-clock driver
: symbols. However, none of the clock drivers (BUFG or GCLK/ACLK) are used.[.br]

M CLKSYM_USAGE_LOOP
> signame s
> driver s
> fanout d
: Driver = [driver] ; Fan Out = [fanout] ; Signal Name = [signame]

M GCLK_ACLK_NOT_USED_EXPL
: [.br]
: Consider sourcing one of the above clock signals (one with higher fanout)
: from GCLK. Other lower fanout clock signals can be sourced by ACLK.[.br]


M GCLK_NOT_USED -w4670
: The global clock buffer (GCLK) is not used and the following signal(s)
: are used to drive clock pins:[.br]

M GCLK_NOT_USED_EXPL
: [.br]
: Consider sourcing one of the above clock signals from GCLK.[.br][.br]


M ACLK_NOT_USED -w4671
: The alternate clock buffer (ACLK) is not used and the following signal(s)
: are used to drive clock pins:[.br]

M ACLK_NOT_USED_EXPL
: [.br]
: Consider sourcing one of the above clock signals from ACLK.[.br][.br]



#-------------------------- BUFGP and BUFGS Usage --------------------------------
#
#M BUFGP_BUFGS_NOT_USED -w
#: The following signal(s) drive clock pins, and are driven by non-clock
#: buffer symbols. However, none of the clock buffer symbols (BUFG or BUFGP/BUFGS)
#: are used.[.br]
#
#M BUFGP_BUFGS_NOT_USED_EXPL
#: [.br]
#: Consider sourcing above clock signals from clock buffers (BUFG or BUFGP/BUFGS).[.br]
#
#
#M BUFGP_BUFGS_AVAILABLE -w
#> used d
#> avail d
#: The following signal(s) drive clock pins, and are driven by non-clock
#: buffer symbols. However, only [used] of the available [avail] clock buffer
#: symbols (BUFG or BUFGP/BUFGS) are used.[.br]
#
#M BUFGP_BUFGS_AVAIL_EXPL
#: [.br]
#: Consider sourcing above clock signals from the available clock buffers
#: (BUFG or BUFGP/BUFGS).[.br]



#---------------------------- Check for Unstable Clock Signals -----------------

M CLK_SIG_UNSTABLE -w4672
: The following signals drive flip-flop clock pins (or latch enable pins) and
: are sourced by combinational logic.[.br]
: [.br]
: Signal Name[.br]
: -----------

M CLK_SIG_UNSTABLE_LOOP
> signame s
: [signame]
 
M CLK_SIG_UNSTABLE_EXPL
: [.br]
: In the LCA, combinational logic is implemented in function generators.
: If a function generator has more than one input signal, the output signal
: may glitch to an intermediate value when the inputs are changed. This is
: due to differences in routing delays between the input pins.[.br][.br]
:
: For this reason, it is preferrable to gate the flip-flop data input rather
: than the clock. Alternatively, the clock-enable pin on CLB flip-flops can
: be used to control the loading of data.[.br]



#---------------------------- Check for Unstable Clock Signals -----------------

M PAD_CLKSYM_CONN -w4673
> padname s
: The pad `[padname]' is connected to the following clock symbols:[.br]

M PAD_CLKSYM_CONN_LOOP
> symtype s
> symname s
: Symbol Type = [symtype] ; Symbol Name = [symname]
 
M PAD_CLKSYM_CONN_EXPL
: [.br]
: A single pad should not be used to source more than one clock symbol,
: since this signal may not be routable. To drive multiple clock symbols
: with the same signal with minimum skew, consider using separate pads
: and connecting them externally.[.br]



#-------------------------- Clock Signals Report -------------------------------

M CLKSIGRPT
: [.br]
: The following clock signals were found in the design:[.br]

M CLKSIGRPT_LOOP
> signame s
> driver s
> fanout d
: Driver = [driver] ; Fan Out = [fanout] ; Signal Name = [signame]

M CLKSIGRPT_EXPL
: [.br]

M CLKSIGRPT_EMPTY
: [.br]
: No clocked elements were found in the design.[.br]



#-------------------------- Clock Signals Report for 4K ------------------------

M CLKSIGRPT_4K_XBLOX
: [.br]
: This report will be generated when XNFPREP is run on the design expanded by
: X-BLOX.[.br]


M CLKSIGRPT_4K
> spaces s
: [.br]
: The table below summarizes the clock signals and/or global buffers
: contained in your design. The purpose of this information is to assist
: you in determining how to best use the XC4000 family global buffers.
: The interpretation of this information is given below, along with
: some guidelines to follow when assigning signals to global buffers.[.br]
: [.br][.br]
: -------------------------------------------------------------------[.br]
: [spaces]            Number of Load Pins[.br]
: Driver      ------------------------  Signal Name[.br]
: [spaces]          Clock  Cntl  Gate  Other[.br]
: ----------  -----  ----  ----  -----  -----------------------------

M CLKSIGRPT_4K_LOOP
> signame s
> driver s-10
> clkcnt d5
> cntlcnt d4
> gatecnt d4
> othercnt d5
> spaces s
: [driver][spaces][clkcnt][spaces][cntlcnt][spaces][gatecnt][spaces][othercnt][spaces][signame]

M CLKSIGRPT_4K_EXPL
> indent s
: ----------  -----  ----  ----  -----  -----------------------------[.br]
: [.br][.br]
: The columns of this table are interpreted as follows:[.br][.br]
:
: Driver  The type of symbol that sources the signal. This shows which[.br]
: [indent]      signals are already routed through global buffers, and which[.br]
: [indent]      are driven directly from the source.[.br][.br]
:
: Clock   The number of flip-flop clock pins (and input latch enable[.br]
: [indent]      pins) that the signal drives. These pins can be reached[.br]
: [indent]      directly from any of the 8 global buffers (however, see[.br]
: [indent]      item (1) below about using more than 4 global buffers).[.br][.br]
:
: Cntl    The number of control pins (CE, CLR/RD, PRE/SD and WE) that[.br]
: [indent]      the signal drives. These can be accessed through the C1 or[.br]
: [indent]      C3 CLB inputs, which can be reached directly from 2 primary[.br]
: [indent]      global buffers (in the top-right corner for C1 or the[.br]
: [indent]      bottom-right corner for C3) or from any secondary global[.br]
: [indent]      buffer. (Control pins can also connect through C2 and C4,[.br]
: [indent]      but these are not directly accessible from any global[.br]
: [indent]      buffer.)[.br][.br]
:
: Gate    The number of gate inputs that the signal drives. After[.br]
: [indent]      being mapped, gates will be placed in F, G or H function[.br]
: [indent]      generators. One primary global buffer (in the top-left[.br]
: [indent]      corner) can directly connect to the F function, and another[.br]
: [indent]      (in the bottom-left corner) can directly connect to the G[.br]
: [indent]      function. The H1 function generator input can be accessed[.br]
: [indent]      through the C1 or C3 CLB input, as with control pins[.br]
: [indent]      (described above).[.br][.br]
:
: Other   The number of load pins not included in any of the above[.br]
: [indent]      categories. With two exceptions, none of these other pins[.br]
: [indent]      can be reached directly from global buffers. One exception[.br]
: [indent]      is the D input on a CLB flip-flop, which can be accessed[.br]
: [indent]      through the C1 or C3 CLB inputs (as with control pins),[.br]
: [indent]      or through an empty function generator (as with gates).[.br]
: [indent]      The other exception is the T pin of an IOB: see item (6)[.br]
: [indent]      below.[.br][.br]
:
: In the above descriptions, a pin is said to be directly connectable
: if that connection can be made without leaving the dedicated global
: buffer network. In fact, any pin can be reached from a global buffer
: by routing through another block, but this introduces skew and uses
: additional routing resources.[.br][.br]
:
: Following are some general guidelines to consider when assigning
: signals to global buffers. Depending on the timing requirements of
: your design, you may need to use a different set of priorities.[.br][.br]
:
: (1) Avoid using more than 4 global buffers TOTAL, unless you have[.br]
: [indent]  mapped and floorplanned your design. Although there are 8 global[.br]
: [indent]  buffers, they share 4 global vertical longlines in each column.[.br]
: [indent]  If any given column contains load pins for more than 4 different[.br]
: [indent]  global buffers, some signals will not be routed via the[.br]
: [indent]  dedicated connections. The only guaranteed way to avoid this[.br]
: [indent]  problem is to floorplan the design so that no more than 4 global[.br]
: [indent]  buffer outputs have loads in the same column.[.br][.br]
:
: (2) Choose a secondary global buffer over a primary global buffer,[.br]
: [indent]  unless you have floorplanned the global buffer and its loads[.br]
: [indent]  to ensure direct connections. Secondary global buffers are[.br]
: [indent]  more flexible than primary global buffers, and incur only 1-2ns[.br]
: [indent]  of additional delay.[.br][.br]
:
: (3) Give high-fanout clock signals first priority for global[.br]
: [indent]  buffers. This is the best way to assure low-skew clock[.br]
: [indent]  distribution. If your design has many low-fanout clock[.br]
: [indent]  signals which are divided versions of a fast clock, consider[.br]
: [indent]  clocking the flip-flops from the fast clock and using clock[.br]
: [indent]  enables to control loading: this will be less sensitive to skew.[.br][.br]
:
: (4) If a clock signal also sources some CLB control pins, you should[.br]
: [indent]  use either a BUFGP locked to the top-right or bottom-right[.br]
: [indent]  corner (use LOC=TR or LOC=BR on the symbol), or any BUFGS.[.br]
: [indent]  Alternatively, consider sourcing the non-clock pins from the[.br]
: [indent]  input side of the global buffer.[.br][.br]
:
: (5) If a clock signal also sources some gate inputs, consider[.br]
: [indent]  sourcing these pins from the input side of the global buffer.[.br]
: [indent]  Unless you have mapped and floorplanned the design, you will[.br]
: [indent]  not be able to control which function generator is used for[.br]
: [indent]  a particular gate, and there is little chance that any single[.br]
: [indent]  global buffer will be able to reach ALL of the correct function[.br]
: [indent]  generator inputs directly.[.br][.br]
:
: (6) If a clock signal also sources non-control or non-gate inputs,[.br]
: [indent]  you should source these pins from the input side of the[.br]
: [indent]  global buffer, with two possible exceptions. Since the D pin[.br]
: [indent]  on a CLB flip-flop can normally be accessed from any global[.br]
: [indent]  buffer, one or two such pins should be easily connectible.[.br]
: [indent]  Also, the T pins on IOBs can be reached by the BUFGP in the[.br]
: [indent]  top-left corner (use LOC=TL on the symbol) or any BUFGS.[.br][.br]
:
: (7) After clock signals, CLB control pins should be given next[.br]
: [indent]  priority, subject to the restrictions in item (1) above.[.br]
: [indent]  Use either a BUFGP locked to the top-right or bottom-right[.br]
: [indent]  corner (use LOC=TR or LOC=BR on the symbol), or any BUFGS.[.br][.br]
:
: (8) For the reasons discussed in item (4), signals driving gate[.br]
: [indent]  inputs should be assigned to global buffers only if the[.br]
: [indent]  design has been mapped and floorplanned.[.br][.br]
:
: The connectivity of specific global buffers is summarized below:[.br][.br]
:
: ----------------   -----------------  --------------------------[.br]
: Corner of Device   BUFGP Connects To  BUFGS Connects To[.br]
: ----------------   -----------------  --------------------------[.br]
: TL (top-left)      CLK, F3, IOB-T     CLK, F3, G1, C3, C1, IOB-T[.br]
: BL (bottom-left)   CLK, G1            CLK, F3, G1, C3, C1, IOB-T[.br]
: BR (bottom-right)  CLK, C3            CLK, F3, G1, C3, C1, IOB-T[.br]
: TR (top-right)     CLK, C1            CLK, F3, G1, C3, C1, IOB-T[.br]
: ----------------   -----------------  --------------------------[.br][.br]
:
: NOTE: CLK includes both CLB and IOB clock pins (K, IK and OK).[.br]
: [indent]    IOB-T is the 3-state control pin on the IOB output buffer.[.br][.br]
:
: For more information on XC4000 global buffers, refer to the application
: note "Improving XC4000 Design Performance" (XAPP 043) in the Programmable
: Logic Data Book.[.br]





######################

M NCLBROWS_TEXT
: NCLBROWS

M NCLBCOLS_TEXT
: NCLBCOLS

M EDGE_DECODERS_TEXT
: EDGE_DECODERS

M INFF_TEXT
: INFFs

M IOSYM_TEXT
: IO symbols

M XNFERR_BREAK
: [.br]

E XNFERR2
#
# ------------------ xnf.m ------------------ 
#
# @(#)xnf.m	6.13  1/14/94


B XNF -start1301 -end1350 -current1315
: Xnf Data Handler

#
# These are message phrases used for syntax errors
#
M SYNTAX_UNK
: Unknown error found 
M SYNTAX_PRN
: A program name is required
M SYNTAX_PAT
: A parttype is required
M SYNTAX_SYN
: A symbol name is required
M SYNTAX_STN
: A symbol type name is required
M SYNTAX_PIN
: A pin name is required
M SYNTAX_PID
: A pin direction character is required
M SYNTAX_SIN
: A signal name is required
M SYNTAX_IPN
: An input pin name is required
M SYNTAX_CPN
: A clock pin name is required
M SYNTAX_CLE
: A clock edge character is required
M SYNTAX_CLP
: A clock polarity character is required
M SYNTAX_PUW
: A pulse width value is required
M SYNTAX_BUN
: A bus name is required
M SYNTAX_PWP
: A power polarity character is required
M SYNTAX_ESD
: An external record signal direction character is required
M SYNTAX_PPN
: Package pin name is required
M SYNTAX_SET
: A setup up time value is required
M SYNTAX_HLD
: A hold time value is required
M SYNTAX_MLR
: The LCANET record is required
M SYNTAX_BRT
: Unrecognized record type found
M SYNTAX_V4R
: Lcanet version 4 is required (Run xnfupd to convert your design)
M SYNTAX_ILV
: Illegal LOC value found
M SYNTAX_LSV
: No value is specified for LOC parameter
M SYNTAX_INT
: An integer is required
M SYNTAX_CHR
: Character is required
M SYNTAX_STR
: A character string is required
M SYNTAX_FLT
: A floating point number is required
M SYNTAX_DLY
: Delay numbers are required
M SYNTAX_BDN
: Illegal delay number specification found
M SYNTAX_COM
: A comma is required
M SYNTAX_EOL
: End of line is required
M SYNTAX_EOF
: End of File is required
M SYNTAX_ERROR 
> errorname m
> linenumber d
> filename s
: [errorname]
: on line [linenumber] of file [filename]:

# 
# These are message phrases used for semantic errors
#
M BADPARTTYPE
> parttype s
: Unrecognized parttype '[parttype]'
M MULTIPLESYM
> symname s
: Multiple symbols exist with the name '[symname]'
M MULTIPLEPIN
> symname s
> pinname s
: The symbol '[symname]' contains multiple pins with the name '[pinname]'
M MULTIPLEBUS
> busname s
: Multiple busses exist with the name '[busname]'
M MULTIPLEEXT
> pinnum s
> signame s
: Multiple Ext-records exist with the same signal '[signame]' or package
: pin name '[pinnum]'
M MULTIPLEEXT2
> signame s
: Multiple Ext-records exist with the same signal '[signame]'
M MULTIPLEHIERG
> hier_id d
> sym_name s
: Multiple Hierg-records exist for hier_id '[hier_id]', sym_name '[sym_name]'
M INSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal between SYM and END records
M RECORD_OUT_OF_PLACE
> record s
: The '[record]' record is illegal outside of SYM and END records
M NOSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal outside of SYM and END records
M BADSETUPEDGE
> inname s
> clkname s
> edge s
: The 'SETUP, [inname], [clkname]' record has an illegal clock edge value '[edge]'
M MULTIPLEPOLARITY
> signame s
: The signal '[signame]' is both GND and VCC
M BADPOWERPOLARITY
> signame s
> polarity s
: The PWR record for signal '[signame]' has an illegal polarity value '[polarity]'
M BADPULSEPOLARITY
> symname s
> pinname s
> polarity s
: The 'PULSE,[pinname]' record in symbol [symname] has an illegal polarity
: value '[polarity]'
M BADEXTDIR
> signame s
> dir s
: The 'EXT, [signame]' record has an illegal direction value '[dir]'
M BADPINDIR
> symname s
> pinname s
> dir s
: The pin [pinname] in symbol '[symname]' has an illegal direction value '[dir]'
M NO_PARAM_VALUE
> rectype s
> recname s
> namevalue s
: The [rectype] '[recname]' contains a parameter '[namevalue]' with no value
: specified
M MULTIPLEPARAM
> rectype s
> recname s
> name s
: The [rectype] '[recname]' contains multiple '[name]' parameters 
M INVALID_SYMBOL_PIN
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' is not a legal pin for this type of
: symbol
M INVALID_PIN_INV
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' cannot be legally inverted
M INVALID_EXT_PARAM
> ext  s
> param s
: The PAD '[ext]' has an illegal parameter with the name '[param]'
M CONFLICT_EXT_PARAM
> ext  s
> param s
> conflict_param s
: PAD '[ext]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SIG_PARAM
> sig  s
> param s
: The signal '[sig]' has an illegal parameter with the name '[param]'
M CONFLICT_SYM_PARAM
> symbol  s
> param s
> conflict_param s
: Symbol '[symbol]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SYM_PARAM
> symbol  s
> param s
: The symbol '[symbol]' has an illegal parameter with the name '[param]'
M INVALID_PIN_PARAM
> pinname s
> symbol  s
> param s
: The '[pinname]' pin on symbol '[symbol]' has an illegal parameter with
: the name '[param]'
M MULTPARTTYPES
> part1 s
> part2 s
: The design network contains multiple parttypes - [part1] and [part2]
M UNKNOWNPIN
> rectype s
> pinname s
: The [rectype] record refers to an undefined pin '[pinname]'
M ILLEGAL_BOOLEAN
> sym s
> numpins d
> numarchpins d
: The symbol '[sym]' has [numpins] input pins specified; only
: [numarchpins] input pins are allowed on this type Boolean gate. 
M MODEL
> rectype s
: The [rectype] record is illegal record outside of MODEL and ENDMOD records
M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write to file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.
M MISSINGPARAM
> symname s
> symtype s
> paramname s
: The [symtype] symbol '[symname]' is missing the required [paramname] parameter

M INVALID_SIG_NAMES
> siglist s
: The following signals have illegal names:[.br]
: [siglist]
M INVALID_SYM_NAMES
> symlist s
: The following symbols have illegal names:[.br]
: [symlist]
M TOOMANY
> errlimit d
: The number of errors exceeds [errlimit], bailing out prematurely
M WOOPS
> namevalue s
> rectype s
: [namevalue] specified without an active [rectype]
M SEMANTIC_ERROR
> error z
: [error][.br]
M SEMANTIC_ERROR_LOCATION
> error z
> linenum d
> filename s
: [error][.br]
: near line [linenum] of file [filename].

M VALIDITY_NO_ARCH
: The Design Validity Check cannot be implemented because no archfile or
: parttype can be found.

M ERROR_LIST -e1303 -w1304
> filename s
> details z
: The following problem(s) were found in the [filename] file; 
: the file could not be processed successfully.[.br]
: [.br][details]

M VALIDITY_ERRORS -e1305 -w1306
> details z
: [details]

#
# These errors are used for loading xnf archtype data files
#
M CHECKS_PARTTYPE -e1307 -w1308
> designname s
: The parttype for the [designname] design is missing so we cannot perform
: the checks related to legal symbols, pins, parameters, etc.

M CHECKS_UNKNOWN_DATAFILE -e1309 -w1310
> designname s
> parttype s
: The [designname] design is for a parttype called "[parttype]".  We do not
: know which archtype data file we should read for that parttype.  We have
: to read an archtype data file so that we can perform the checks 
: related to legal symbols, pins, parameters, etc.  We are unable, therefore,
: to perform these types of checks.

M CHECKS_NO_DATAFILE -e1311 -w1312
> designname s
> datafilename s
: The [datafilename] data file (which we need to read so that we can perform the
: checks related to legal symbols, pins, parameters, etc. on the [designname]
: design) does not exist in the $XACT/data directory.  We therefore cannot
: perform these types of checks.

M CHECKS_DATAFILE_ERROR -e1313 -w1314
> designname s
> datafilename s
: We encountered problems while reading the [datafilename] data file.  We
: have to read this file so that we can perform the checks related to legal 
: symbols, pins, parameters, etc. in the [designname] design.  We therefore
: cannot perform these types of checks.

E XNF
#
# ------------------ lca.m ------------------ 
#
# @(#)lca.m	6.15  1/4/94


B LCA -start1576 -end1600 -current1586

: LCA Data Handler
# NOTE: If new messages are added to this file, MAX_ERROR (in lcap.h) must 
#       be changed to reflect the new number of messages.


# LCA file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown internal error number
M ILLEGAL_KEYWORD
: Illegal LCA keyword
M EARLY_EOF
: End of File reached prematurely
M POSITIVE_INT_REQD
: Positive integer required
M SIGNED_INT_REQD
: Signed integer required
M DATA_REQD
: Data required
M STRING_REQD
: String of characters required
M FLOAT_REQD
: Floating point number required
M NO_SPEED_LINE
: Speed statement not found
M PROGORDER_NOT_ON
: Programorder not ON
M VERSION_POSITION_ERROR
: Version statement must be the first non-comment statement of file
M INTNET_ERROR
: Block in Intnet statement is not previously defined, or the statement does not contain one of the following: {F, G, H, PAD, M, QY, QX}
M NPROGRAM_NET_ERROR
: Netname does not match previous ADDNET netname
M NPROG_NET_ERR2
: Netname is required in NProgram statement
M MISSING_HALF
: Second half of PIP or switch matrix pair required
M PIP_SYNTAX_ERROR
: Only the directionality is allowed after the pip pair
M NO_BASE_LINE
: Base statement missing from Editblk group
M NO_CONFIG_LINE
: Config statement missing from Editblk group
M NO_ENDBLK
: Endblk statement required
M NO_ENDPATH
: Endpath statement required
M NO_PATHNET_LINE
: Pathnet statement missing from Beginpath group
M MULT_PATHSPEC
: This net was used in multiple Beginpath statements
M ILLEGAL_TAG
: Illegal Config statement tag

M FILE_SYNTAX_ERROR -e1576 -w1577
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in LCA file:  [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]
: [.br]This is an internal error; please contact Xilinx support personnel.

# LCA memory error messages
M MEM_READER_ERR
: Error in reading LCA structure from memory
M MEM_WRITER_ERR
: Error in writing LCA structure to memory
M NETNAME_EXISTS
: Netname already exists in memory
M BLK_ERROR
: Block does not exist in memory
M UNKNOWN_BLOCK
: Unknown block type
M CONFIG_SYNTAX_ERROR
: Error in Config statement syntax
M PINNAME_EXISTS
: Pin already exists in memory
M NET_ERROR
: Net does not exist in memory
M PINNAME_ERROR
: Pin does not exist in memory
M ILLEGAL_RAMCFG
: Illegal Ramconfig statement data 
M ILLEGAL_NETNAME
: Illegal netname
M ILLEGAL_EQUATION
: Illegal Equation statement data
M CONFIG_MEM_WRITE_ERROR
: Error writing Config statement data 
M BASE_MEM_WRITE_ERROR
: Error writing Base statement data for this block 
M INTNET_BLK_ERROR
: Block specified in INTNET statement does not exist

M LCA_FILE_ERROR -e1578 -w1579
> errorname m
: [errorname] [.br]
: This statement must be present in LCA files older than version 2.  To
: eliminate this problem, open and save the file in XACT; this will
: update the file to version 2.

M NO_PROGORDER_LINE
: Programorder statement not found.

M MEM_ERROR -e1580 -w1581
> errorname m
: [errorname]
: [.br]This is an internal error; please contact Xilinx support personnel.

M MEM_WRITE_ERROR -e1582 -w1583
> errorname m
> name s
: Error in writing LCA data to memory: [.br]
: [errorname] [.br]
: Data: "[name]" 
: [.br]This is an internal error; please contact Xilinx support personnel.

M CANNOT_WRITE_TO_FILE -e1584 -w1585
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E LCA
#
# ------------------ mxcst.m ------------------ 
#
# @(#)mxcst.m	6.8  3/24/94
 
 
B MXCST -start1551 -end1575 -current1555
: constraint data handler
 
# Tool description (for program help)
M SYNTAX_ERROR -e1551
>token s
>lineno d
>filename s
>appendage m
: error on "[token]" at line [lineno] in file [filename]
: : [appendage]

M ADDITIONAL_MSG
>msg m
:   ----[msg]

M GIVE_UP
: Giving up - too many errors.
M BAD_LOC
: illegal location name
M BAD_MGC_NAME
: illegal magic box name
M NO_SEMICOLON
: possibly a missing ';'
M NO_COLON
: illegal name or possibly a missing ':'
M BAD_BEL_NAME
: illegal sub-location name  
M BEL_OPTIONS
: bel name must be one of : F G H ARITH FFX FFY 
M NO_WILD_CARD
: Improper use of wild card
M UNEXPECTED_SYM
: Unexpected symbol
M BAD_BOX_PAIR
: illegally specified magic box pair
M BAD_BLK_LIST
: illegally specified logic block list
M BAD_CONS
: unknown constraint type
M BAD_FILE
: illegal file name
M NO_I_OR_N
: expected "INSTANCE", "NET" or "BLOCK"
M NO_N
: expected "NET"
M BAD_FLAG_TYPE
: expected "CRITICAL" "UNCRITICAL" or "SKEW_CRITICAL"
M NO_NET_NAME
: expected net name
M NO_INS_NAME
: expected instance name
M NO_PIP
: expected pip name
M BAD_SIZE
: invalid instance size specification
M BAD_DIR
: invalid direction - expected "VERTICAL" or "HORIZONTAL"
M BAD_WEIGHT
: expected net weight : between 0 and 99
M UNEXP_END -e1552
: Unexpected end of file
M MISMATCH_LOC
: location pair must consist matching location types
M BAD_RANGE
: illegal location range specification
M NO_SUFFIX_ON_3K_BLOCK
: illegal suffix for clb block location
M SHOW_FILE_PATH
> file z
> ext s
: Reading constraints from file [file].[ext] [.br] [.br]
M EMPTY_WARNING -w1553
> file s
: file [file] does not contain any constraints
M MXCST_ERROR_LIST -e1554
> list z
: The following errors were detected in the constraints file:[.br][list]

E MXCST
#
# ------------------ mxtrans.m ------------------ 
#
# @(#)mxtrans.m	6.2  9/17/93
 
 
B MXTRANS -start1626 -end1635 -current1628

: MX translator data handler

# Error and Warning Messages
M BAD_OPEN_FILE -e1626
> fname s
: The file [fname] could not be opened.

M BAD_INIT_FILE -e1627
> fname s
: The mxtrans initialization file, [fname], is in the wrong format.

E MXTRANS
#
# ------------------ tif.m ------------------ 
#
# @(#)tif.m	6.4 12/8/93
##############################################################################
# Message file for Technology Interface
##############################################################################
 
 
B TIF -start1401 -end1450 -current1410
: Technology Interface
 
M NO_SUCH_DEVICE -e1401
> basename s
> extension s
: Cannot find the technology description file '[basename].[extension]'.
M TD_FILE_TROUBLE
> filename s
: Encountered a problem opening file '[filename]'.
M SYNTAX_ERROR
> file s
> line d
> type s
> text s
: [file]([line]): [type] near '[text]'.
M SEMANTIC_ERROR -e1402
> location s
> text s
: [location]: [text]
M EXTRA_LOC -w1403
> location s
: Extra Location statement '[location]' ignored.
M BUILD_ERROR
> text s
: Model building failed: [text]
M CHECK_FAILED
> text s
: Consistency check failed: [text].
M TEXT
> text s
: [text]
M NO_SUCH_FILE -e1404 -w1405
> filename s
: Unable to find file '[filename]',[.br]
: no package bonding info in the TIF model.
M NO_PKG_INFO -e1406 -w1407
> modelname s
> filename s
: No info for package [modelname] in file '[filename]'.
: [.br]Package and bonding info are missing from technology description.
M SPEED_GRADE_ERROR -e1408
> modelname s
> spdgrade s 
: '[spdgrade]' is not a valid speed grade for part '[modelname]' [.br]
: Please check the data book for the correct speed grades.
M SPEED_FILE_TROUBLE -e1409
: Encountered a problem opening speed file .

E TIF
#
# ------------------ prim.m ------------------ 
#
# @(#)prim.m	6.2  9/17/93


B PRIM -start1376 -end1400 -current1382

: Prim Data Handler

# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown Internal Error Number
M PUNC_REQD
: Punctuation Required
M INT_REQD
: Integer Required
M STRING_REQD
: String Of Characters Required
M BAD_COMBINATORIAL
: Combinatorial field must be either "Y" or "N".
M QSTRING_REQD
: Quoted String Of Characters Required
M BAD_PIN_DIRECTION
: The pin direction must be "I", "O", or "B".
M BAD_GATETYPE
: The gate type specified is illegal.

M FILE_SYNTAX_ERROR -e1376 -w1377
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in Prim file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]

M WRITE2FILE -e1378 -w1379
: Cannot write a PRIM cell to a file.  PRIM cells can only be read from a file 
: or memory.

M PRIMLIB_OPEN_FAILED -e1380 -w1381
: The `primlib.prm` data file could not be opened.  Check and make sure it
: has been installed in the proper directory.
E Cellib
#
# ------------------ carry.m ------------------ 
#
# @(#)carry.m	6.4 9/17/93


B CARRY -start1451 -end1475 -current1453

: CARRY Data Reader

# Carry4k.xct file reader error messages
M CANT_OPEN_FILE
: Cannot open carry4k.xct file.[.br]

M EMPTY_FILE
: No data lines found in carry4k.xct file.[.br]

M NO_VERSION
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: Required Version line not found at beginning of carry4k.xct file.[.br]
: Instead found line: 
: [.br]   [line][.br]

M VERS_NOT_SUPPORTED
> version s
: The syntax version [version] is not supported by the Carry Reader.[.br]

M END_MISSING
> mode s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: The End statement was not found for carrymode '[mode]'[.br]

M NO_DRC_TAG
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: Required drc_tag statement not found; instead found line:
: [.br]   [line][.br]

M SYNTAX_ERROR
> line s
> linenum d
: Syntax Error found on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]

M MULT_LINE
> line s
> linenum d
> keyword s
: Error on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]
: [keyword] statement already read in for this carrymode.[.br]

M CARRY_ERRORS -e1451 -w1452
> details z
: [details]

M DRC_TAG_ERROR
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]
: This drc_flags statement has more responses than tag:settings (as defined
: in drc_tags statement).[.br]

M DRC_TABLE_OVERFLOW
: Internal error:  DRC table overflow; increase DRC_INDEX_SIZE constant.[.br]

E CARRY
#
# ------------------ fgguide.m ------------------ 
#
# @(#)fgguide.m	6.5  1/25/94 


B FGGUIDE -start1601 -end1625 -current1603

: FGGUIDE Data Handler

# FGGUIDE file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M ILLEGAL_KEYWORD
: Illegal FGGUIDE keyword
M POSITIVE_INT_REQD
: Positive integer required
M STRING_REQD
: String of characters required
M NET_REQD
: Field specifying net name required
M OUTPUT_NET_REQD
: Field specifying output net name required
M PARENT_NET_REQD
: Field specifying parent net name required
M NO_DUPDATA_LINE
: Additional Dup data statement required
M NOT_DUP_LINE
: Only Dupdata or Dupend line is valid after Dup statement
M NOT_DCM_LINE
: Only Dcmdata or Dcmend line is valid after Dcm statement
M NO_DCMDATA_LINE
: Additional Dcm data statement required
M NO_DCM_END
: Dcm end statement required
M NO_DUP_END
: Dup end statement required
M SYNTAX_ERROR
: Illegal syntax
M BANG_REQD
: Bang (!) required to end statement
M TEXT_AFTER_BANG
: Text is not allowed after the Bang (!) end character
M DUP_OUT_OF_ORDER
: This statement must follow a Dup statement
M DCM_OUT_OF_ORDER
: This statement must follow a Dcm statement


M FILE_SYNTAX_ERROR
> errorname m
> linenumber d
> filename s
: Error -- [errorname][.br]
: on line [linenumber] of file [filename]

M LCA_FILE_SYNTAX_ERROR
> errorname m
> linenumber d
> filename s
: Error -- [errorname][.br]
: in System record FGG [linenumber] of file [filename]

M MEM_ERROR
> errorname m
: [errorname]


# FGGUIDE memory error messages
M MEM_READER_ERR
: Error in reading FGGUIDE structure from memory
M MEM_WRITER_ERR
: Error in writing FGGUIDE structure to memory
M DCM_ONET_EXISTS
: Dcm output netname already exists in memory
M DUP_ONET_EXISTS
: Dup output netname already exists in memory
M NO_DCMDATA_ACTIVE
: Dcmdata structure does not exist in memory
M NO_DCM_ACTIVE
: Dcm structure does not exist in memory
M NO_DUP_ACTIVE
: Dup structure does not exist in memory
M NO_DECODE_ACTIVE
: Decode structure does not exist in memory
M NO_IGNORE_ACTIVE
: Ignore structure does not exist in memory
M NO_DCM_INETS
: No Dcm input nets specified
M NO_DUP_INETS
: No Dup input nets specified
M NO_DCM_NUM
: No Dcm dcm_num specified
M NO_DUP_NUM
: No Dup dup_num specified
M INVALID_DECODE_SIDE
: Invalid Decode side number specified; must be 0-3
M PREV_DECODE_STILL_ACTIVE
: Previous Decode end statement never found; must finish previous Decode
M PREV_DUP_STILL_ACTIVE
: Previous Dup end statement never found; must finish previous Dup
M PREV_DCM_STILL_ACTIVE
: Previous Dcm end statement never found; must finish previous Dcm

M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ERROR_LIST -e1601 -w1602
> details z
: [details]

E FGGUIDE
#
# ------------------ mxtool.m ------------------ 
#
#@(#)mxtool.m	6.8  1/13/94


B MXTOOL -start1726 -end1800 -current1744
: Tool Interface

# These message texts are used in other messages
M TEXT_PARAMFILE
: parameter file
M TEXT_CMDLINE
: command line
M TEXT_ILLBOOLVAL
: Illegal boolean value must be {TRUE,FALSE}: 
M TEXT_ILLINTVAL
: Illegal integer value: 
M TEXT_ILLOPTVAL
: Illegal option name must be 
M TEXT_ILLFLTVAL
: Illegal floating point value: 
M TEXT_UNKPARAM
: Unknown parameter name: 
M TEXT_UNSETPARAM
: Parameter was not assigned a value: 
M TEXT_BADVALUE
: Parameter was assigned an illegal value: 
M TEXT_BADRANGE
: Parameter value is outside valid range: 
M TEXT_PARAMHEAP
: Param
M TEXT_RESULTHEAP
: Result
M TEXT_INTERNALHEAP
: Intern
M TEXT_OTHERHEAP
: Other
M TEXT_BLANK
:

# There messages are used to produce help text for the root tool
M LOGFILE
: The program log file name
M HLOGFILE
: You can use this parameter to specify an alternate name for the program
: log file.  The default value of the log file name is the program name 
: with a .log extension
M PARAMFILE
: The parameter file name
M HPARAMFILE
: You can use this parameter to specify a file name which contains
: program parameters.  Each program parameter should appear on a line
: by itself with its value separated by an equals sign,
: E.g., "logfile=foobar.log".  If a program parameter is specified
: on the command line as well as in the parameter file, the value from
: the command line will be used.  If you do not specify a parameter file, 
: all of the programs parameters are taken from the command line.
M HELPALL
: Show all help information
M HHELPALL
: You can type "-helpall" to this tool to get help for ALL its parameters.
: The default is not to show help for all parameters.  
M HELP_NOVICE
> programname s
: For help on how to use this program, type "[programname] -help"
M HELP_TITLE
> programname s
: [.br]HELP FOR [programname][.br]
M HELP_PARAMS
: [.br]PARAMETERS:[.br]
M HELP_PARAMNAME
> param_internal_name s
> param_external_name s
: [param_internal_name][param_external_name]
M HELP_PARAMHELP
> param_help_text s
: [param_help_text]
M HELP_BITS
> leftmargin s
: [leftmargin]This parameter may be assigned one or more of these bit values:
: [.br]
M HELP_VALUES
> leftmargin s
: [leftmargin]This parameter may be assigned one of these values:
: [.br]
M HELP_STRVALUE
> leftmargin s
: [leftmargin]This parameter takes a character string value.
M HELP_FLTVALUE
> leftmargin s
> lo g.6
> hi g.6
: [leftmargin]Takes a real value between [lo] and [hi], inclusive.
M HELP_BOOLVALUE
> leftmargin s
: [leftmargin]This parameter takes a boolean value {TRUE,FALSE}
M HELP_INTVALUE
> leftmargin s
> lo d
> hi d
: [leftmargin]Takes an integer value between [lo] and [hi], inclusive.
M HELP_PINTVALUE
> leftmargin s
: [leftmargin]Takes a positive integer value.
M HELP_NNINTVALUE
> leftmargin s
: [leftmargin]Takes a non-negative integer value.
M HELP_DEFVALUE
> leftmargin s
> default    z
: [leftmargin]The default value is [default].
M HELP_DEFNONE
> leftmargin s
: [leftmargin]You must specify a value; there is no default.

# ---------------------------------------------------------------------------
# These messages are written to the plog at program startup
M LOG_BANNER
> prog_name    s
> prog_version s
> prod_name    m
> year         s
: [prog_name] [[[prog_version]]  --  [prod_name][.br]
: Copyright (c) [year] Xilinx Inc.  All Rights Reserved.

M LOG_CONFIDENTIAL
: XILINX CONFIDENTIAL

M LOG_XACT
: Xilinx Automatic CAE Tools

M PROGRAM_ENV
: Program Envelope Parameters

M PROGRAM_ENVENTRY
> name  s-20
> value s
: [name] = [value]

# ---------------------------------------------------------------------------
# These messages are written to the plog at tool startup
M TOOL_NEW_SECTION
> toolname s
: [toolname]
M TOOL_PARAMETERS
: Parameters
M TOOL_USED_EXPERT_PARAMS
: Additional Specified or Non-Default Parameters 
M TOOL_PARAMVALUE
> paramname  s
> paramvalue s
: [paramname][paramvalue]
M TOOL_TRUE
: TRUE
M TOOL_FALSE
: FALSE
M TOOL_PARAMBAR
: -----------------------

# ---------------------------------------------------------------------------
# These messages are used by the debug routine mxtool_dump_tool_table
M TOOLDEF_TITLE
: Tool Definition Table
M TOOLDEF_HEADER
# ALIGN COLUMN HEADERS WITH OPEN BRACKET
# V         V            V    V        V
# [toolname][toolversion][off][partype][parametername]
: Toolname  Version      Off  Type     Parameter[.br]
: --------  -----------  ---  -------  ---------
M TOOLDEF_ENTRY
> toolname      s-10.10
> toolversion   s-13.10
> off           s3
> partype       s-9.9
> parametername s
# DONT MESS WITH THIS MESSAGE TEXT!
: [toolname][toolversion][off]  [partype][parametername]
M TOOLINST_TITLE
: Tool Instances Remaining
M TOOLINST_HEADER
# ALIGN HEADERS WITH OPEN BRACKETS
# V     V         V
# [in]  [toolname][toolcreator]
: ---------------------------[.br]
: Inst  Toolname  Toolcreator[.br]
: ----  --------  -----------
M TOOLINST_ENTRY
> in          d4
> toolname    s-10
> toolcreator s
: [in]  [toolname][toolcreator]
M TOOLINST_FOOTER
: ---------------------------

# ---------------------------------------------------------------------------
# These messages are used to create the memory usage table for debug purposes
M MEMUSAGE_TITLE1
> name s
: Memory Usage For Tool [name]
M MEMUSAGE_TITLE2
> name s
: Memory Usage For Program [name]
M MEMUSAGE_HEADER
# [heap]      [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
: --------------------------------------------------------------------------[.br]
: Heap         Total   Total  Static   Alloc   Guard  Unused    Free   Alloc[.br]
: Name       Nsegmts  Nbytes  Overhd  Overhd  Overhd  Nbytes  Nbytes  Nbytes[.br]
: ---------- ------- ------- ------- ------- ------- ------- ------- -------
M MEMUSAGE_ENTRY
> heap s-10.10
> nseg d4
> size d6
> sohd d6
> aohd d6
> gohd d6
> unnb d6
> frnb d6
> alnb d6
: [heap]    [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
M MEMUSAGE_FOOTER
: --------------------------------------------------------------------------
M MEMUSAGE_MAX
> pgmname s
> nkbytes f.3
: [pgmname] required [[[nkbytes]] Kbytes of dynamic/allocated memory

# ---------------------------------------------------------------------------
# These are WARNING messages of various sorts
M PARAM_OBSOLETE_NEXT_RELEASE -w1726
: The "param=" syntax you used on the command line will become obsolete
: next release.  You should replace it with "paramfile="

M PARAM_IGNORED -w1727
: The "param=" syntax on the command line is being ignored since you
: have also specified the parameter file name using the "paramfile=" syntax

M PLOG_OBSOLETE_NEXT_RELEASE -w1728
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" syntax from the [paramsource] will become obsolete
: next release.  You should replace it with "logfile="

M PLOG_IGNORED -w1729
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" specification from the [paramsource] is being ignored since
: you have also specified the log file name using the "logfile=" syntax

# ---------------------------------------------------------------------------
# These are ERROR messages of various sorts
M PARAM_DECL_OFFSET -e1730
> toolname  s
> paramname s
> offset    d
> paramsize d
: Tool parameter declaration offset is illegal[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, but the parameter structure size[.br]
: is only [paramsize] bytes.  Something must be very, very wrong.

M PARAM_DECL_OVERLAP -e1731
> toolname  s
> paramname s
> offset    d
> index     d
: Tool parameter declaration overlaps another[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, which overlaps another parameter[.br]
: at an offset of [index] bytes.  Check your calls to tool_decl_* in[.br]
: the husk module of [toolname].  You have probably have the same parameter[.br]
: name in more than one of the tool_decl_* routine.

M PARAM_ERROR -e1732
> paramsource s # the TEXT_CMDLINE or TEXT_PARAMFILE message text
> theErrors   s
: The [paramsource] contains parameter assignment errors:[theErrors]

M PARAM_ERROR_MAINTOOL -e1733
> theTool   s
> theErrors s
: The [theTool] program detected parameter value errors:[theErrors]

M PARAM_ERROR_SUBTOOL -e1734
> currenttool s
> parenttool  s
> theErrors   s
: The [currenttool] tool, invoked from [parenttool],
: detected parameter value errors:[theErrors]

M PARAM_TOOMANY -e1735
> nspecified d
> ndefined   d
: The command line contains [nspecified] positional parameters,[.br]
: but the program only needs [ndefined] parameters.

M BAD_DASH_PARAM -e1736
> param z
: The command line parameter, '[param]', is a non-boolean '-' parameter.  Only
: boolean parameter can be specified using the '-' feature, where 
: '-<parameter>' is the equivalent of TRUE and '-NO<parameter>' is the 
: equivalent of FALSE.

M INSTANCE_MISMATCH -e1737
> instancenumber d
> instancename   s
> tooldefname    s
: Tool instance - tool definition mismatch[.br]
: Tool instance #[instancenumber] is not an instance of "[tooldefname]"[.br]
: but rather an instance of "[instancename]"

M INSTANCE_ILLEGAL -e1738
> instancenumber d
: Illegal tool instance number[.br]
: Tool instance #[instancenumber] does not refer to a valid tool

M PFILE_OPEN_FAILED -e1739
> filename s
: The parameter file "[filename]" could not be opened for input

M MISSING_VALUE -e1740
> paramname s
: The command line parameter named "[paramname]"[.br]
: must be followed by an equals sign and a value

M ILLEGAL_PARAMNAME -e1741
> paramname s
: An illegal program parameter name "[paramname]"[.br]
: is used on the command line

M PLOG_OPEN_FAILED -e1742
> filename s
: The program log file "[filename]"[.br]
: could not be opened for output

M ILLEGAL_OPTIONNAME -e1743
> optionname s
: An illegal option parameter name "[optionname]"[.br]
: is used on the command line

E MXTOOL
#
# ------------------ dm.m ------------------ 
#
# @(#)dm.m	6.5  2/2/94


B DM -start1161 -end1200 -current1187
: Data Manager 

M CANNOT_WRITE_TO_FILE -e1161 -w1162
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ADDHISTORY_FAILED -e1163 -w1164
> cellname z
> celltype s
: A history description could not be appended to the [celltype] cell
: "[cellname]" because it is a READONLY cell

M CLRHISTORY_FAILED -e1165 -w1166
> cellname z
> celltype s
: The history descriptions of the [celltype] cell "[cellname]" could not be
: cleared because it is a READONLY cell

M CLEAR_FAILED_RDONLY -e1167 -w1168
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be cleared because it is a
: READONLY cell

#M CLEAR_FAILED -e -w
#> cellname z
#> celltype s
#: The [celltype] cell "[cellname]" could not be cleared because it is
#: locked in memory

M DELETE_FAILED -e1169 -w1170
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be deleted because it is
: locked in memory

M FILE_ACCESS -e1171 -w1172
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: exists, but could not be opened

M FILE_MISSING -e1173 -w1174
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be found.

M FILE_OPEN_FAILED -e1175 -w1176
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be opened

M HEADER_CELLTYPENAME -e1177 -w1178
> cellname z
> filename z
> celltype s
: The type of the cell "[cellname]" associated with the file "[filename]"
: does not correspond to the expected "[celltype]" type.

M HEADER_ERROR -e1179 -w1180
> cellname z
> filename z
> celltype s
: The file "[filename]" for the [celltype] cell "[cellname]" contains an
: illegal header

M NAME_FAILED -e1181 -w1182
> cellname z
> newname  s
> celltype s
: The [celltype] cell "[cellname]" could not be renamed to "[newname]"
: because a [celltype] cell named "[newname]" already exists

M TYPE_FAILED -e1183 -w1184
> typename s
> cellname z
: The type of cell "[cellname]" could not be changed to "[typename]"
: because a cell of that name/type already exists

M NEWCELL_FAILED -e1185 -w1186
> cellname s
> celltype s
: The [celltype] cell "[cellname]" could not be created because a cell of
: that type and name already exists

#
# Data Manager Messages
#
M SAVECELL_SECTION
: Data Manager Auto Save

M SAVECELL
> cellname z
> typename s
: Saving [typename] cell "[cellname]"

M LOCKCOUNT_SECTION
: Data Manager Cell Lock Counts

M LOCKCOUNT
> cellname z-10
> typename s-10
> lockcount d2
: [cellname] [typename] [lockcount]

E DM




#
# ------------------ mxpart.m ------------------ 
#
#@(#)mxpart.m	6.2 9/3/93

B MXPART -start1131 -end1160 -current1148
: File reader for partlist.xct file and <package>.pkg files

M CANT_OPEN_FILE -e1131 -w1132
> filename s
: Cannot open file '[filename]' for reading.

M NO_PKG -e1133 -w1134
> part s
> filename s
: The part '[part]' could not be found in the file '[filename]'.

M BAD_ATTRIB_VALUE -e1135 -w1136
> partname s
> filename s
: The attribute list (name=value entries) for the part '[partname]' in the
: file '[filename]' has the wrong format.

M ILLEGAL_PKG_KEYWORD -e1137 -w1138
> value s
: Illegal keyword '[value]' exists in the .pkg file.
 
M DUP_PAD_DEF_IN_PKG -e1139
> pad s
: Duplicate definition of PAD '[pad]'.

M DUP_PIN_DEF_IN_PKG -e1140
> pin s
: Duplicate definition of PIN '[pin]'.

M PAD_NUM_OUT_OF_RANGE -e1141
> pad s
: Pad number '[pad]' is out of range.

M BAD_PAD_NUM -e1142
> pad s
: Bad pad number '[pad]'. Should be in the form: PAD<number>.

M WRONG_ATTR_VALUE -e1143
> value s
> chk_value s
: Attribute value '[value]' does not match check value '[chk_value]'.

M ILLEGAL_FAMILY -e1144
> family d
: Not a legal family '[family]'.

M ILLEGAL_FAMILY_ATTR -e1145
> attrib s
> family d 
: Not a legal attribute '[attrib]' for this family '[family]'.

M BAD_ROWCOL -e1146
: Not and integer value for clb row|cols number.

M CLK_BUF -e1147
> pad s
> padn d
: Clock Buffer using '[pad]' should use 'PAD[padn]'.

E MXPART
#
# ------------------ speed.m ------------------ 
#
#@(#)speed.m	6.4  9/3/93

B SPEED -start 1101 -end1130 -current14
: File reader for speeds.xct file 

M CANT_OPEN_FILE -e0 -w1
> filename s
: Cannot open file '[filename]' for reading.

M FILE_CORRUPTED -e2 -w3
> filename s
: The speeds file '[filename]' has been corrupted and cannot be read.

M CANT_READ_FILE -e4 -w5
> filename s
: The unencrypted speeds file '[filename]' cannot be read.

M BAD_PARTLIST_FILE -e6 -w7
: The partlist.xct file does not contain the correct information.

M UNKNOWN_SPEED_AND_PART -e8 -w9
> speed s
> part s
: The speed '[speed]' is unavailable for part '[part]'.

M BAD_VERSION -e10 -w11
> filename s
> badversion s
> version s
: The '[filename]' file has a bad version, '[badversion]'.
: The version of file must be '[version]'.

M SYNTAX_ERROR -e12 -w13
> filename s
: There is a syntax error in the '[filename]' speeds file.

E SPEED
