# inf2xnf.ml created 1994/05/12 16:39:49
# 
# DO NOT EDIT THIS FILE!  It is derived from other files.
#
# ------------------ alert.m ------------------ 
#
#@(#)alert.m	6.1  12/2/92


B ALERT
: Error condition alert system

#
# These messages are used as alert pre/postfixes
#
M CANNOT_CONTINUE
: Execution cannot continue until this error is fixed
M TERMINATE
> theProgram s
> theStatus s
: [theProgram] was terminated with a [theStatus] status

E ALERT
#
# ------------------ feature.m ------------------ 
#
# @(#)feature.m	6.3 9/3/93


B FEATURE -start1051 -end1100 -current1082
: Feature License Manager

#
# Nasty Low-Level Error Messages
#
M UNKNOWN_ERROR -e1051
> feature s
: License checkout for feature "[feature]" failed[.br]
: because of some, unknown error condition.  
: Please contact your system administrator for help.
M OS_ERROR -e1052
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level or operating system error ([errtext]).
: Please contact your system administrator for help.
M BAD_SERVER_DATA_ERROR -e1053
> feature s
: License checkout for feature "[feature]" failed[.br]
: because invalid data was returned from the license server .
: Please contact your system administrator for help.
M READ_SERVER_ERROR -e1054
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot read from the servers listed in the license data 
: file.  Please contact your system adminstrator for help.
M WRITE_SERVER_ERROR -e1055
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot write to the servers listed in the license data 
: file.  Please contact your system adminsitrator for help.
M SELECT_ROUTINE_ERROR -e1056
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] a call to an internal select routine failed.
: Please contact your system adminsitrator for help.
M BUSY_SERVER_ERROR -e1057
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] failed to connect to a majority of the servers listed in the
: license data file.  Please contact your system adminsitrator for help.
M CHECKIN_FEATURE_ERROR -e1058
> feature s
: License checkin for feature "[feature]" failed[.br]
: Don't worry, be happy.

#
# Possible User Errors
#
M NO_LICENSE_FILE_ERROR -e1059
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the license data file.
: The default location for this file is usually
: /usr/local/data/license.dat.  It may be placed elsewhere at your site, in 
: which case you must define the environmental variable LM_LICENSE_FILE to
: point to it.  Make sure you can access the file from the same shell you are
: trying to run the program.
M NO_FEATURE_ERROR -e1060
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the feature in the license data
: file.  If you have not yet called customer
: service to obtain the authorization codes for this feature please do so.  If
: you have obtained the codes, please make sure that you have added the codes
: to the license data file.
M LICENSES_EXHAUSTED_ERROR -e1061
> feature s
: License checkout for feature "[feature]" failed[.br]
: because all the valid licenses for the feature are currently in use.  
: Try again later.
M EXPIRED_AUTHCODE_ERROR -e1062
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the required license has expired.  
: Please call customer service to obtain a new license.
M UNSUPPORTED_VERSION_ERROR -e1063
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the license data file does not contain a feature of the required
: version number.  Please call custommer service to obtain a license for 
: the new version of the feature.
M NO_KEY_ERROR -e1064
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program could not find a valid Xilinx protection key
: on the parallel port of your computer.  
: Please make sure that the key is attached securely to the parallel port.
M TAMPERED_KEY_ERROR -e1065
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program detected an invalid Xilinx protection key
: on the parallel port of your computer.  
: The key's memory has been corrupted.  Please call customer service to
: obtain a new key.
M DEMO_EXPIRED_ERROR -e1066
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because your demo version of the [program] program has expired.
: Please contact customer service
: or your sales representative to purchase the software you have been
: using.
M TAMPERED_DATE_ERROR -e1067
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the current date on your computer is set to a time which is
: before the date when you last ran this program.   
: Please reset your computer's date to the current
: date and rerun the program.
M XACT_VARIABLE_ERROR -e1068
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the XACT environmental variable has not been defined.
: Use the SET XACT=value dos command 
: to define the location of the XACT software.
M INVALID_DATE_ERROR -e1069
> feature s
: License checkout for feature "[feature]" failed[.br]
: because line in the license data file line which describes the feature
: contains an invalid date.  See the file XACT\data\license.dat.  
: All dates must be of the form 
: DD-MMM-YYYY, where DD is an integer 0-31; MMM is the first three 
: letters of the (English) month name: JAN, FEB, MAR, APR, MAY, JUN, JUL,
: AUG, SEP, OCT, NOV, or DEC; and YYYY is an integer 1990-2118.
M LOLEVEL_ERROR -e1070
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level error ([errtext]).

#
# Possible Installation Errors
#
M MULT_FEATURE_ERROR -e1071
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected multiple occurences of FEATURE lines for the 
: feature in the license file.  A feature
: may appear only once in the license file for it to be valid.  Please remove
: one of the feature lines from the license file.
M LICENSE_FILE_SYNTAX_ERROR -e1072
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected a syntax error in the license date
: file.  Please make sure that you have 
: correctly entered the authorization codes which you obtained from customer 
: service.
M NO_SERVER_ERROR -e1073
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect to the network license server.  
: Please make sure that the lmgrd program is 
: currently running on the computers described as servers in the license data 
: file.
M NO_SERVICE_ERROR -e1074
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the program [program] could not find the TCP "license" service. 
: Make sure that the /etc/services file has
: the license service number defined in it, or add a socket number to the the
: SERVER line of the license data file.
M BAD_AUTHCODE_ERROR -e1075
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected an inconsistency in the authorization code on the
: feature line of the license data file.  
: Please make sure that you have correctly entered the authorization codes
: which you obtained from customer service.
M WRONG_HOST_ERROR -e1076
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the host listed in one of the
: server lines of the license data file.  
: Please make sure that the server information in the license data file is 
: correct.
M BAD_DATE_ERROR -e1077
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] found an invalid date in the license data file.  
: Please make sure that the date information in the
: license data file is correct.  The correct date format is DD-MMM-YY (for
: example 30-JUN-91).  In previous versions of the program, dates of the form
: DD-MMM-YYYY were acceptable, but they are no longer.  To make the correction,
: stop the license server, edit the license.dat file to remove the '19' from
: the year number of all features, restart the license server and rerun the 
: program.
M NO_SERVER_LINES_ERROR -e1078
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find and server lines in the license data file.  
: Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M BAD_SERVER_NAME_ERROR -e1079
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] encountered an illegal server name in the license 
: data file.  Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M CONNECT_SERVER_ERROR -e1080
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect over the network to the license server
: program.  Please make sure that the lmgrd 
: program is currently running on the computers described as servers in the
: license data file.

#
# Error due to PC key
#
M PC_KEY_ERROR -e1081
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: [errtext]

E FEATURE
#
# ------------------ msg.m ------------------ 
#
#@(#)msg.m	6.3 9/3/93


B MSG -start1011 -end1030 -current1016
: The Message System Messages

#
# Message fragments for the MSGFILE error
M MSGIO_EOLJUNK
: Extra characters at the end of a valid line
M MSGIO_UNKNOWN_LINE
: Unknown message file line type
M MSGIO_MSGSET_NAME
: Message set name is required
M MSGIO_MSGDEF_NAME
: Message definition name is required
M MSGIO_MSGARG_NAME
: Message definition argument name is required
M MSGIO_MSGARG_TYPE
: Message definition argument type is required
M MSGIO_UNKNOWN
: Unknown error number

#
# These messages are used by the message system when something goes
# wrong while reading a message file, or instantiating a message
#

M MSGFILE_ERROR -e1011
> theErrorName  m
> theLineNumber d
> theFileName   s
> theLine       s
> thePosition   z
: [theErrorName][.br]
: The error is on Line [theLineNumber] of "[theFileName]"[.br]
: The line is "[theLine]"[.br]
: -------------[thePosition]
M MSGSET_MISSING -e1012
> theCompName s
: The message set for "[theCompName]" does not exist [.br]
: in any of the standard message files.
M MSGSET_NULL
> theCompNumber d
> theCompName s
: The message set pointer for component [theCompNumber], "[theCompName]"[.br]
: does not point to a valid message set.
M MSGSET_NDEFS -e1013
> theMsgnum d
> theMsgname s
> theNumberOfDefs d
> theCompName s
: An attempt was made to invoke message "[theMsgname]",[.br]
: with a message number of [theMsgnum].  However, the message set for[.br]
: component "[theCompName]" has only [theNumberOfDefs] messages.
M MSGSET_MSGNAMES -e1014
> theMsgnum d
> theMsgname s
> theRealMsgname s
> theCompName s
: Message #[theMsgnum] of the message set for component "[theCompName]"[.br]
: was invoked with a name of "[theMsgname]".  Its name in the message[.br]
: file is "[theRealMsgname]".
M MSGSET_NPARAMS -e1015
> theMsgname s
> theNparams d
> theRealNum d
> theCompName s
: Message "[theMsgname]" of the message set for component "[theCompName]"[.br]
: was invoked with [theNparams] parameters.  It is defined with [theRealNum]
: in the message file.

#
# Message id severity names
# These are used in the creation of errors to describe how severe the
# error really is.  THE ORDER OF THESE NAMES IS VERY, VERY IMPORTANT.
# SEE MSGINST_SEVERITY IN MSGINST.C IF YOU DON'T BELIEVE ME.
#

M MSGSEV_INFO
: Information
M MSGSEV_WARNING
: WARNING
M MSGSEV_ERROR
: ERROR
M MSGSEV_FATAL
: Fatal Error
M MSGSEV_INTERNAL
: Internal Error

E MSG
#
# ------------------ mxcomm.m ------------------ 
#
# @(#)mxcomm.m	6.2  9/3/93


B MXCOMM -start1001 -end1010 -current1003
: Mx Program Communications

# Boolean values
M TRUE_VALUES
: Y YES T TRUE ON
M FALSE_VALUES
: N NO F FALSE OFF

# These two messages are used in rwdict error messages
M STARTUP_NAME
: startup file

# These error messages are used by mxaccs directly
M STARTUP_OPEN_FAILED -e1001
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: exists, but could not be opened for some reason

M NO_STARTUP_FILE -e1002
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: does not exist, so it could not be opened

E MXCOMM
#
# ------------------ report.m ------------------ 
#
#@(#)report.m	6.1  12/2/92
 
 
B REPORT
: Report Generator Messages
 
M PAGE
: Page
M CONTINUED
: (continued)
M XILINX
: Xilinx, Inc.
M COPYRIGHT
> year d
: (c) Copyright [year].  All Rights Reserved.
M TABLE_OF_CONTENTS
: Table of Contents[.br]
: -----------------[.br]
M TOC_ENTRY
> entry s
: [entry]
E REPORT
#
# ------------------ rwdict.m ------------------ 
#
#TMF 1.0
# @(#)rwdict.m	6.2  9/3/93


B RWDICT -start1031 -end1050 -current1035
: Dictionary File Reader/Writer

M MISSING_EQUALSIGN -e1031 -w1032
> linenumber d
> filename   s
> dicttype   s
> line       s
: Missing equal sign in the name-value assignment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[line]"

M ILLEGAL_NAME -e1033 -w1034
> linenumber d
> filename   s
> dicttype   s
> name       s
: Illegal name used in the name-value assigment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[name]"


E RWDICT
#
# ------------------ inf2xnf.m ------------------ 
#
#@(#)inf2xnf.m	6.17 11/8/93
 
 
############################################################################
# 01/10/1994	improved warning message 013 (BITA# 12937)
############################################################################

 
B INF2XNF
: INF to XNF Translator

#234567890123456789012345678901234567890123456789012345678901234567890123456 
############################################################################
# Tool description (for program help)
############################################################################
M DESCRIPTION
: This program translates the OrCAD INF files into the Xilinx XNF files 
: which can be processed by the Xilinx FPGA Development System.[.br][.br]
: USAGE:  inf2xnf inffile[[.inf] [[xnffile[[.xnf]] [[<parameter>=<value>][.br][.br]
: EXAMPE: inf2xnf demo p=4005pc84 s=c:\xact\xc4000 u=c:\user;d:\;..\user;user 
 
############################################################################
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
############################################################################
M INFFILE
: Input INF File.

M XNFFILE
: Output XNF File.

M PARTTYPE
: Part type used. 

M XSP
: Search path for Xilinx-defined INF files.

M USP
: Search path for user-defined INF files.

M OD
: Output directory for XNF files.

M OL
: Old library option.

M M
: Macro option.

M VERBOSE
: Verbose option. 

#234567890123456789012345678901234567890123456789012345678901234567890123456 
############################################################################
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
############################################################################
M HINFFILE
: Specifies the name of the INF file to be translated. The file 
: extension is optional, if not specified, ".inf" is assumed.
 
M HXNFFILE
: Specifies the name of the XNF file to be written to. This argument
: is optional, if not specified, inffile is assumed. The file
: extension is optional, if not specified, ".xnf" is assumed.
 
M HPARTTYPE
: Specifies the Xilinx part type used in the translation. This
: argument must be specified if you havn't set or want to override
: the part type in inffile (i.e. in the schematic).

M HXSP
: Specifies the path SDT2XNF uses to search for Xilinx-defined INF
: files which include the Xilinx softmacros and smartmacros. If this 
: argument is not specified, it will be set to the appropriate 
: Xilinx-library path.

M HUSP
: Specifies the path SDT2XNF uses to search for user-defined INF files
: which include the child-sheets and link-sheets. If this argument 
: is not specified, it will be set to the current directory.

M HOD
: Specifies the directory where the XNF files are placed. If this
: argument is not specified, it will be set to the current directory.

M HM
: If TRUE, inf2xnf treats all symbols in the design as macros which[.br]
: means inf2xnf will search for the INF file corresponding to each[.br]
: symbol. If found, it is read and a XNF file is generated for it.

M HOL
: This option must be set to TRUE if you are using the old SDT library
: v4.20 instead of the new unified SDT library from Xilinx.

M HVERBOSE
: If TRUE, inf2xnf displays additional information on the screen [.br]
: and creates a longer report file inf2xnf.log.

############################################################################
# Warning  Messages
############################################################################
M USE_DEFAULT_PARTTYPE_WARNING
> defaultpart s
:DS35-SDT-WARNING-001:[.br]
: The part type was either not specified on the command line or in [.br]
: the schematic or it conflicts with the SDT library used in the[.br]
: design, the default part type '[defaultpart]' is being used.

M PARAM_SPEC_SYNTAX_ERROR_WARNING
> specification z
:DS35-SDT-WARNING-002:[.br]
: Syntax error in the parameter specification; it will be ignored.
: '[specification]'.

M UNKNOWN_PRIMITIVE_OR_MACRO
> symbolname z
:DS35-SDT-WARNING-003:[.br]
: An unknown primitive or macro '[symbolname]' was found.[.br]
: If this is a user-created macro, make sure that a[.br]
: corresponding INF file exists.

M ILLEGAL_PARAMETER_WARNING
> param_spec z
> linenum d
> filename z
:DS35-SDT-WARNING-005:[.br]
: Illegal parameter specification '[param_spec]' at line number[.br]
: '[linenum]' in the INF file '[filename]'.

M FAIL_TO_ADD_EXT_LOC_WARNING
> locparam s
:DS35-SDT-WARNING-006:[.br]
: Failed to add loc parameter '[locparam]' to the external I/O.

M FAIL_TO_ADD_EXT_PARAM_WARNING
> paramname s
> paramvalue s
:DS35-SDT-WARNING-007:[.br]
: Failed to add parameter '[paramname]' of value '[paramvalue]' to the [.br]
: external I/O.

M FAIL_TO_ADD_EXT_USERPARAM_WARNING
> paramname s
> paramvalue s
:DS35-SDT-WARNING-008:[.br]
: Failed to add user parameter '[paramname]' of value '[paramvalue]' to the [.br]
: external I/O.

M FAIL_TO_ADD_PIN_PARAM_WARNING
> paramname s
> pinname s
> pintype s
> symname s
:DS35-SDT-WARNING-009:[.br]
: Failed to add the parameter '[paramname]' to pin '[pinname]' of type [.br]
: '[pintype]' on symbol '[symname]'.

M VECTOR_STATEMENT_NOT_SUPPORTED_WARNING
:DS35-SDT-WARNING-010:[.br]
: The INF vector statement is not supported; therefore, it will be ignored.[.br]

M ALL_PINS_ON_SYMBOL_UNCONNECTED
> symname s
> symtypename s
:DS35-SDT-WARNING-011:[.br]
: All pins on symbol '[symname]' of type '[symtypename]' are unconnected,[.br]
: and the symbol will be removed.

M STIMULUS_ON_BUS_WARNING
> busname s
:DS35-SDT-WARNING-012:[.br]
: The stimulus specified on the BUS '[busname]' is not supported;[.br]
: therefore, it will be ignored.
 
M STIMULUS_ON_PIN_WARNING
> pinname s
> symname s
:DS35-SDT-WARNING-013:[.br]
: The stimulus specified on the pin '[pinname]' of symbol '[symname]'[.br]
: will be ignored.[.br]
: Please make sure that the net to which the stimulus was [.br]
: attached is labelled.
 
M PARTTYPE_NOT_SPECIFIED_WARNING
> filename s
:DS35-SDT-WARNING-014:[.br]
: The parttype was not specified either from the command line or in the root[.br]
: INF file '[filename]'.
 
M TRC_ON_BUS_WARNING
> busname s
:DS35-SDT-WARNING-015:[.br]
: The trace specified on the BUS '[busname]' is not supported; therefore,[.br]
: it will be ignored.
 
M TRC_ON_PIN_WARNING
> pinname s
> symname s
:DS35-SDT-WARNING-016:[.br]
: The trace specified on the pin '[pinname]' of symbol '[symname]'[.br]
: will be ignored.[.br]
: Please make sure that the net to which the trace was [.br]
: attached is labelled.
 
M CONTROL_PIN_UNCONNECTED_WARNING
> pinname s
> symname s
> symtypename s
: DS35-SDT-WARNING-017:[.br]
: The pin '[pinname]' on symbol '[symname]' of type '[symtypename]'[.br]
: is unconnected, you may need to connect it for simulation.

############################################################################
# Error  Messages
############################################################################
M INTERNAL_PROGRAM_ERROR
> code d
:DS35-SDT-ERROR-001:[.br]
: An internal program error occurred, code '[code]'.

M ROOT_INF_FILE_UNSPECIFIED_ERROR
:DS35-SDT-ERROR-002:[.br]
: The root INF file was not specified from the command line.

M INVALID_FILE_EXT_ERROR 
> filename s
:DS35-SDT-ERROR-003:[.br]
: An invalid file extension was specified with the file '[filename]'.

M NONEXISTENT_FILE_ERROR
> filename s
:DS35-SDT-ERROR-004:[.br]
: A non-existent file '[filename]' was specified.

M NONREADABLE_FILE_ERROR
> filename s
:DS35-SDT-ERROR-005:[.br]
: A non-readable file '[filename]' was specified. 

M NONWRITEABLE_FILE_ERROR
> filename s
:DS35-SDT-ERROR-006:[.br]
: A non-writeable file '[filename]' was specified.

M NONEXISTENT_DIRECTORY_ERROR
> dirname s
:DS35-SDT-ERROR-007:[.br]
: A non-existent directory '[dirname]' was specified.

M SYNTAX_ERROR_IN_INF_FILE
> command s
> filename s
> linenum d
> line z
:DS35-SDT-ERROR-008:[.br]
: A '[command]' syntax error was detected at line number '[linenum]' of INF file [.br]
: '[filename]'. [.br]
: '[line]'
 
M INF_INVALID_PARTTYPE_ERROR
> parttype s
> filename s
:DS35-SDT-ERROR-009:[.br]
: An invalid parttype '[parttype]' was specified in the root INF file '[filename]'.

M CL_INVALID_PARTTYPE_ERROR
> parttype s
:DS35-SDT-ERROR-010:[.br]
: An invalid parttype '[parttype]' was specified from the command line.

M PARTTYPE_SYNTAX_ERROR
> parttypespec z
:DS35-SDT-ERROR-011:[.br]
: A syntax error in the parttype specification was detected.
: '[parttypespec]' 

M FAIL_TO_ADD_USER_WARNING
> username s
> uservalue s
:DS35-SDT-ERROR-012:[.br]
: Failed to add the user record '[username]' of value '[uservalue]'.
 
M XACT_ENV_VAR_UNSET_ERROR
:DS35-SDT-ERROR-013:[.br]
: The XACT environment variable is not set.

M DS35_ENV_ERROR
:DS35-SDT-ERROR-014:[.br]
: The Xilinx DS35 OrCAD interface is not installed or the XACT path is not set up
: properly.

M NO_DEFAULT_XILINX_LIB_PATH_ERROR
> family s
> xactpath s
:DS35-SDT-ERROR-015:[.br]
: No default Xilinx OrCAD '[family]' library was found under the path '[xactpath]'.

M OPEN_FILE_FOR_READ_ERROR
> filename s
:DS35-SDT-ERROR-016:[.br]
: Failed to open the file '[filename]' for reading.

M FAIL_TO_CREATE_XNF_CELL_ERROR
> xnfcellname s
:DS35-SDT-ERROR-017:[.br]
: Failed to create the xnf cell '[xnfcellname]'.

M FAIL_TO_GET_NEXT_INF_COMMAND_ERROR
> linenum d
> filename s
:DS35-SDT-ERROR-018:[.br]
: Failed to get next INF command at linenum '[linenum]' in the INF file [.br]
: '[filename]'.

M FAIL_TO_ADD_SIG_ERROR
> signame s
> linenum d
> filename z
:DS35-SDT-ERROR-019:[.br]
: Failed to add the signal '[signame]' at linenum '[linenum]' in the INF [.br]
: file '[filename]'.

M FAIL_TO_FIND_SIG_ERROR
> signame s
:DS35-SDT-ERROR-020:[.br]
: Failed to find the signal '[signame]'.

M FAIL_TO_ADD_SYM_ERROR
> symname s
> symtype s
> linenum d
> filename z
:DS35-SDT-ERROR-021:[.br]
: Failed to add the symbol '[symname]' of type '[symtype]' at linenum '[linenum]'[.br]
: in the INF file '[filename]'.

M FAIL_TO_ADD_PARAM_SYM_ERROR
> paramname s
> symname s
> linenum d
> filename z
:DS35-SDT-ERROR-022:[.br]
: Failed to add parameter '[paramname]' to symbol '[symname]' at linenum [.br]
: '[linenum]' in the INF file '[filename]'.

M FAIL_TO_ADD_USERPARAM_SYM_ERROR
> userparamname s
> symname s
> linenum d
> filename z
:DS35-SDT-ERROR-023:[.br]
: Failed to add user-parameter '[userparamname]' to symbol '[symname]' at [.br]
: linenum '[linenum]' in the INF file '[filename]'.

M FAIL_TO_ADD_SYM_LOC_PARAM_ERROR
> loc_spec z
> symname s
:DS35-SDT-ERROR-024:[.br]
: Failed to add the loc specification '[loc_spec]' on symbol '[symname]'.

M FAIL_TO_ADD_SIG
> signame s
> linenum d
> filename z
:DS35-SDT-ERROR-025:[.br]
: Failed to add the signal '[signame]' to the XNF network structure at [.br]
: linenum '[linenum]' in the INF file '[filename]'.

M FAIL_TO_ADD_EXT_ERROR
> signame s
> type s
> linenum d
> filename z
:DS35-SDT-ERROR-026:[.br]
: Failed to add the external I/O for the signal '[signame]' of type [.br] 
: '[type]' to the XNF network structure at linenum '[linenum]' in the INF file [.br]
: '[filename]'.

M PROGRAM_PARSE_ERROR
> line s
> linenum d
:DS35-SDT-ERROR-027:[.br]
: Program internal parsing error at linenum '[linenum]'.
: [.br]
: '[line]' 

M INALID_INF_COMMAND
> linenum d
> filename z
> line s 
:DS35-SDT-ERROR-028:[.br]
: An invalid INF command line was detected at '[linenum]' of the file '[filename]'.[.br]
: '[line]'

M NO_SOURCE_NET_ERROR
> netspec z
> linenum d
> filename z
:DS35-SDT-ERROR-029:[.br]
: No source was found on the joint statement at linenum '[linenum]' in the[.br]
: INF file '[filename]'.[.br]
: '[netspec]'
 
M MULTIPLE_SOURCE_NET_ERROR
> netspec z
> linenum d
> filename z
:DS35-SDT-ERROR-030:[.br]
: Multiple sources were found on the joint statement at linenum '[linenum]' in [.br]
: the INF file '[filename]'.[.br]
: '[netspec]'
 
M SYMBOL_NOT_FOUND_ERROR
> symname s
> command s
:DS35-SDT-ERROR-031:[.br]
: The symbol '[symname]' was not found in XNF network struecture when processing [.br]
: the joint command '[command]'.

M FAIL_ADD_PIN_SYMBOL_ERROR
> pinname z
> pintype z
> signame s
> symname s
:DS35-SDT-ERROR-032:[.br]
: Failed to add pin '[pinname]' of type '[pintype]' on signal '[signame]' to [.br]
: the symbol '[symname]'.

M NO_XILINX_SDT_LIBARY_USED_ERROR
> filename z
:DS35-SDT-ERROR-033:[.br]
: No standard Xilinx XC2000/XC3000/XC4000 SDT libraries were used in the[.br]
: INF file '[filename]'. 

M MIXED_LIBRARY_ERROR
:DS35-SDT-ERROR-034:[.br]
: You may have mixed the old and new SDT libraries together which is [.br]
: not allowed. 

############################################################################
# Information Messages
#########################################################################
M XNF_CELL_EXISTS
> xnfcellname s
: The XNF cell '[xnfcellname]' already exists.

M XNF_SIG_EXISTS
> signame s
: The signal '[signame]' already exists.

M XNF_SYM_PARAM_EXISTS
> paramname s
> symname s
: The parameter '[paramname]' already exists on symbol '[symname]'.

M CURRENT_INF_COMMAND
> line s
: Current INF command being processed is: [.br]
: '[line]'

M READ_ROOT_INF_FILE
> filename s
: [.br]
: Reading the root INF file '[filename]' .....

M READ_LINK_INF_FILE
> filename s
: Reading the link INF file '[filename]' .....

M READ_XMACRO_INF_FILE
> filename s
: Reading the xilinx macro INF file '[filename]' .....

M READ_UMACRO_INF_FILE
> filename s
: Reading the user-defined macro INF file '[filename]' .....

M READ_CHILD_SHEET_INF_FILE
> filename s
: Reading the child-sheet INF file '[filename]' .....

M READ_UNKNOWN_TYPE_INF_FILE
> filename s 
: [.br]
: Reading the child-sheet INF file '[filename]' .....

M XNF_FILE_OUTPUT
> xnffilename s
: Writing the XNF file '[xnffilename]' .....

M XNF_CELL_OUTPUT
> xnfcellname z
: Writing the XNF cell '[xnfcellname]' .....

M WRITE_XNF_FILE
> xnffilename s
: Writing the XNF file '[xnffilename].xnf' .....

M READING_INF_H_COMMAND
: Reading a INF Hierarchical Header command.
 
M READING_INF_F_COMMAND
: Reading a INF Flat Header command.
 
M READING_INF_B_COMMAND
: Reading a INF Title Block command.
 
M READING_INF_L_COMMAND
: Reading a INF Link command.
 
M READING_INF_P_COMMAND
: Reading a INF Port command.
 
M READING_INF_S_COMMAND
: Reading a INF Signal command.
 
M READING_INF_E_COMMAND
: Reading a INF Externalcommand.
 
M READING_INF_I_COMMAND
: Reading a INF Instance command.
 
M READING_INF_J_COMMAND
: Reading a INF Joined command.
 
M READING_INF_T_COMMAND
: Reading a INF Trace command.
 
M READING_INF_V_COMMAND
: Reading a INF Vector command.
 
M READING_INF_W_COMMAND
: Reading a INF Stimulus command.
 
M READING_INF_Pi_COMMAND
: Reading a INF Pipe command.

M XILINX_SYMBOL_FOUND
> symbolname s
> index d
: Symbol '[symbolname]' is found in Xilinx symbol table with index '[index]'.

M SYM_EXISTS_ALREADY 
> symname s
> symtype s
: Symbol '[symname]' of type '[symtype]' already exists, ignored.

M SYMBOL_ADD_PIN
> pinname z
> pintype z
> signame s
> symname s
: The pin '[pinname]' of type '[pintype]' on signal '[signame]' has been added
: to the symbol '[symname]'.
 
E INF2XNF
#
# ------------------ xnf.m ------------------ 
#
# @(#)xnf.m	6.13  1/14/94


B XNF -start1301 -end1350 -current1315
: Xnf Data Handler

#
# These are message phrases used for syntax errors
#
M SYNTAX_UNK
: Unknown error found 
M SYNTAX_PRN
: A program name is required
M SYNTAX_PAT
: A parttype is required
M SYNTAX_SYN
: A symbol name is required
M SYNTAX_STN
: A symbol type name is required
M SYNTAX_PIN
: A pin name is required
M SYNTAX_PID
: A pin direction character is required
M SYNTAX_SIN
: A signal name is required
M SYNTAX_IPN
: An input pin name is required
M SYNTAX_CPN
: A clock pin name is required
M SYNTAX_CLE
: A clock edge character is required
M SYNTAX_CLP
: A clock polarity character is required
M SYNTAX_PUW
: A pulse width value is required
M SYNTAX_BUN
: A bus name is required
M SYNTAX_PWP
: A power polarity character is required
M SYNTAX_ESD
: An external record signal direction character is required
M SYNTAX_PPN
: Package pin name is required
M SYNTAX_SET
: A setup up time value is required
M SYNTAX_HLD
: A hold time value is required
M SYNTAX_MLR
: The LCANET record is required
M SYNTAX_BRT
: Unrecognized record type found
M SYNTAX_V4R
: Lcanet version 4 is required (Run xnfupd to convert your design)
M SYNTAX_ILV
: Illegal LOC value found
M SYNTAX_LSV
: No value is specified for LOC parameter
M SYNTAX_INT
: An integer is required
M SYNTAX_CHR
: Character is required
M SYNTAX_STR
: A character string is required
M SYNTAX_FLT
: A floating point number is required
M SYNTAX_DLY
: Delay numbers are required
M SYNTAX_BDN
: Illegal delay number specification found
M SYNTAX_COM
: A comma is required
M SYNTAX_EOL
: End of line is required
M SYNTAX_EOF
: End of File is required
M SYNTAX_ERROR 
> errorname m
> linenumber d
> filename s
: [errorname]
: on line [linenumber] of file [filename]:

# 
# These are message phrases used for semantic errors
#
M BADPARTTYPE
> parttype s
: Unrecognized parttype '[parttype]'
M MULTIPLESYM
> symname s
: Multiple symbols exist with the name '[symname]'
M MULTIPLEPIN
> symname s
> pinname s
: The symbol '[symname]' contains multiple pins with the name '[pinname]'
M MULTIPLEBUS
> busname s
: Multiple busses exist with the name '[busname]'
M MULTIPLEEXT
> pinnum s
> signame s
: Multiple Ext-records exist with the same signal '[signame]' or package
: pin name '[pinnum]'
M MULTIPLEEXT2
> signame s
: Multiple Ext-records exist with the same signal '[signame]'
M MULTIPLEHIERG
> hier_id d
> sym_name s
: Multiple Hierg-records exist for hier_id '[hier_id]', sym_name '[sym_name]'
M INSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal between SYM and END records
M RECORD_OUT_OF_PLACE
> record s
: The '[record]' record is illegal outside of SYM and END records
M NOSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal outside of SYM and END records
M BADSETUPEDGE
> inname s
> clkname s
> edge s
: The 'SETUP, [inname], [clkname]' record has an illegal clock edge value '[edge]'
M MULTIPLEPOLARITY
> signame s
: The signal '[signame]' is both GND and VCC
M BADPOWERPOLARITY
> signame s
> polarity s
: The PWR record for signal '[signame]' has an illegal polarity value '[polarity]'
M BADPULSEPOLARITY
> symname s
> pinname s
> polarity s
: The 'PULSE,[pinname]' record in symbol [symname] has an illegal polarity
: value '[polarity]'
M BADEXTDIR
> signame s
> dir s
: The 'EXT, [signame]' record has an illegal direction value '[dir]'
M BADPINDIR
> symname s
> pinname s
> dir s
: The pin [pinname] in symbol '[symname]' has an illegal direction value '[dir]'
M NO_PARAM_VALUE
> rectype s
> recname s
> namevalue s
: The [rectype] '[recname]' contains a parameter '[namevalue]' with no value
: specified
M MULTIPLEPARAM
> rectype s
> recname s
> name s
: The [rectype] '[recname]' contains multiple '[name]' parameters 
M INVALID_SYMBOL_PIN
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' is not a legal pin for this type of
: symbol
M INVALID_PIN_INV
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' cannot be legally inverted
M INVALID_EXT_PARAM
> ext  s
> param s
: The PAD '[ext]' has an illegal parameter with the name '[param]'
M CONFLICT_EXT_PARAM
> ext  s
> param s
> conflict_param s
: PAD '[ext]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SIG_PARAM
> sig  s
> param s
: The signal '[sig]' has an illegal parameter with the name '[param]'
M CONFLICT_SYM_PARAM
> symbol  s
> param s
> conflict_param s
: Symbol '[symbol]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SYM_PARAM
> symbol  s
> param s
: The symbol '[symbol]' has an illegal parameter with the name '[param]'
M INVALID_PIN_PARAM
> pinname s
> symbol  s
> param s
: The '[pinname]' pin on symbol '[symbol]' has an illegal parameter with
: the name '[param]'
M MULTPARTTYPES
> part1 s
> part2 s
: The design network contains multiple parttypes - [part1] and [part2]
M UNKNOWNPIN
> rectype s
> pinname s
: The [rectype] record refers to an undefined pin '[pinname]'
M ILLEGAL_BOOLEAN
> sym s
> numpins d
> numarchpins d
: The symbol '[sym]' has [numpins] input pins specified; only
: [numarchpins] input pins are allowed on this type Boolean gate. 
M MODEL
> rectype s
: The [rectype] record is illegal record outside of MODEL and ENDMOD records
M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write to file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.
M MISSINGPARAM
> symname s
> symtype s
> paramname s
: The [symtype] symbol '[symname]' is missing the required [paramname] parameter

M INVALID_SIG_NAMES
> siglist s
: The following signals have illegal names:[.br]
: [siglist]
M INVALID_SYM_NAMES
> symlist s
: The following symbols have illegal names:[.br]
: [symlist]
M TOOMANY
> errlimit d
: The number of errors exceeds [errlimit], bailing out prematurely
M WOOPS
> namevalue s
> rectype s
: [namevalue] specified without an active [rectype]
M SEMANTIC_ERROR
> error z
: [error][.br]
M SEMANTIC_ERROR_LOCATION
> error z
> linenum d
> filename s
: [error][.br]
: near line [linenum] of file [filename].

M VALIDITY_NO_ARCH
: The Design Validity Check cannot be implemented because no archfile or
: parttype can be found.

M ERROR_LIST -e1303 -w1304
> filename s
> details z
: The following problem(s) were found in the [filename] file; 
: the file could not be processed successfully.[.br]
: [.br][details]

M VALIDITY_ERRORS -e1305 -w1306
> details z
: [details]

#
# These errors are used for loading xnf archtype data files
#
M CHECKS_PARTTYPE -e1307 -w1308
> designname s
: The parttype for the [designname] design is missing so we cannot perform
: the checks related to legal symbols, pins, parameters, etc.

M CHECKS_UNKNOWN_DATAFILE -e1309 -w1310
> designname s
> parttype s
: The [designname] design is for a parttype called "[parttype]".  We do not
: know which archtype data file we should read for that parttype.  We have
: to read an archtype data file so that we can perform the checks 
: related to legal symbols, pins, parameters, etc.  We are unable, therefore,
: to perform these types of checks.

M CHECKS_NO_DATAFILE -e1311 -w1312
> designname s
> datafilename s
: The [datafilename] data file (which we need to read so that we can perform the
: checks related to legal symbols, pins, parameters, etc. on the [designname]
: design) does not exist in the $XACT/data directory.  We therefore cannot
: perform these types of checks.

M CHECKS_DATAFILE_ERROR -e1313 -w1314
> designname s
> datafilename s
: We encountered problems while reading the [datafilename] data file.  We
: have to read this file so that we can perform the checks related to legal 
: symbols, pins, parameters, etc. in the [designname] design.  We therefore
: cannot perform these types of checks.

E XNF
#
# ------------------ mxtool.m ------------------ 
#
#@(#)mxtool.m	6.8  1/13/94


B MXTOOL -start1726 -end1800 -current1744
: Tool Interface

# These message texts are used in other messages
M TEXT_PARAMFILE
: parameter file
M TEXT_CMDLINE
: command line
M TEXT_ILLBOOLVAL
: Illegal boolean value must be {TRUE,FALSE}: 
M TEXT_ILLINTVAL
: Illegal integer value: 
M TEXT_ILLOPTVAL
: Illegal option name must be 
M TEXT_ILLFLTVAL
: Illegal floating point value: 
M TEXT_UNKPARAM
: Unknown parameter name: 
M TEXT_UNSETPARAM
: Parameter was not assigned a value: 
M TEXT_BADVALUE
: Parameter was assigned an illegal value: 
M TEXT_BADRANGE
: Parameter value is outside valid range: 
M TEXT_PARAMHEAP
: Param
M TEXT_RESULTHEAP
: Result
M TEXT_INTERNALHEAP
: Intern
M TEXT_OTHERHEAP
: Other
M TEXT_BLANK
:

# There messages are used to produce help text for the root tool
M LOGFILE
: The program log file name
M HLOGFILE
: You can use this parameter to specify an alternate name for the program
: log file.  The default value of the log file name is the program name 
: with a .log extension
M PARAMFILE
: The parameter file name
M HPARAMFILE
: You can use this parameter to specify a file name which contains
: program parameters.  Each program parameter should appear on a line
: by itself with its value separated by an equals sign,
: E.g., "logfile=foobar.log".  If a program parameter is specified
: on the command line as well as in the parameter file, the value from
: the command line will be used.  If you do not specify a parameter file, 
: all of the programs parameters are taken from the command line.
M HELPALL
: Show all help information
M HHELPALL
: You can type "-helpall" to this tool to get help for ALL its parameters.
: The default is not to show help for all parameters.  
M HELP_NOVICE
> programname s
: For help on how to use this program, type "[programname] -help"
M HELP_TITLE
> programname s
: [.br]HELP FOR [programname][.br]
M HELP_PARAMS
: [.br]PARAMETERS:[.br]
M HELP_PARAMNAME
> param_internal_name s
> param_external_name s
: [param_internal_name][param_external_name]
M HELP_PARAMHELP
> param_help_text s
: [param_help_text]
M HELP_BITS
> leftmargin s
: [leftmargin]This parameter may be assigned one or more of these bit values:
: [.br]
M HELP_VALUES
> leftmargin s
: [leftmargin]This parameter may be assigned one of these values:
: [.br]
M HELP_STRVALUE
> leftmargin s
: [leftmargin]This parameter takes a character string value.
M HELP_FLTVALUE
> leftmargin s
> lo g.6
> hi g.6
: [leftmargin]Takes a real value between [lo] and [hi], inclusive.
M HELP_BOOLVALUE
> leftmargin s
: [leftmargin]This parameter takes a boolean value {TRUE,FALSE}
M HELP_INTVALUE
> leftmargin s
> lo d
> hi d
: [leftmargin]Takes an integer value between [lo] and [hi], inclusive.
M HELP_PINTVALUE
> leftmargin s
: [leftmargin]Takes a positive integer value.
M HELP_NNINTVALUE
> leftmargin s
: [leftmargin]Takes a non-negative integer value.
M HELP_DEFVALUE
> leftmargin s
> default    z
: [leftmargin]The default value is [default].
M HELP_DEFNONE
> leftmargin s
: [leftmargin]You must specify a value; there is no default.

# ---------------------------------------------------------------------------
# These messages are written to the plog at program startup
M LOG_BANNER
> prog_name    s
> prog_version s
> prod_name    m
> year         s
: [prog_name] [[[prog_version]]  --  [prod_name][.br]
: Copyright (c) [year] Xilinx Inc.  All Rights Reserved.

M LOG_CONFIDENTIAL
: XILINX CONFIDENTIAL

M LOG_XACT
: Xilinx Automatic CAE Tools

M PROGRAM_ENV
: Program Envelope Parameters

M PROGRAM_ENVENTRY
> name  s-20
> value s
: [name] = [value]

# ---------------------------------------------------------------------------
# These messages are written to the plog at tool startup
M TOOL_NEW_SECTION
> toolname s
: [toolname]
M TOOL_PARAMETERS
: Parameters
M TOOL_USED_EXPERT_PARAMS
: Additional Specified or Non-Default Parameters 
M TOOL_PARAMVALUE
> paramname  s
> paramvalue s
: [paramname][paramvalue]
M TOOL_TRUE
: TRUE
M TOOL_FALSE
: FALSE
M TOOL_PARAMBAR
: -----------------------

# ---------------------------------------------------------------------------
# These messages are used by the debug routine mxtool_dump_tool_table
M TOOLDEF_TITLE
: Tool Definition Table
M TOOLDEF_HEADER
# ALIGN COLUMN HEADERS WITH OPEN BRACKET
# V         V            V    V        V
# [toolname][toolversion][off][partype][parametername]
: Toolname  Version      Off  Type     Parameter[.br]
: --------  -----------  ---  -------  ---------
M TOOLDEF_ENTRY
> toolname      s-10.10
> toolversion   s-13.10
> off           s3
> partype       s-9.9
> parametername s
# DONT MESS WITH THIS MESSAGE TEXT!
: [toolname][toolversion][off]  [partype][parametername]
M TOOLINST_TITLE
: Tool Instances Remaining
M TOOLINST_HEADER
# ALIGN HEADERS WITH OPEN BRACKETS
# V     V         V
# [in]  [toolname][toolcreator]
: ---------------------------[.br]
: Inst  Toolname  Toolcreator[.br]
: ----  --------  -----------
M TOOLINST_ENTRY
> in          d4
> toolname    s-10
> toolcreator s
: [in]  [toolname][toolcreator]
M TOOLINST_FOOTER
: ---------------------------

# ---------------------------------------------------------------------------
# These messages are used to create the memory usage table for debug purposes
M MEMUSAGE_TITLE1
> name s
: Memory Usage For Tool [name]
M MEMUSAGE_TITLE2
> name s
: Memory Usage For Program [name]
M MEMUSAGE_HEADER
# [heap]      [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
: --------------------------------------------------------------------------[.br]
: Heap         Total   Total  Static   Alloc   Guard  Unused    Free   Alloc[.br]
: Name       Nsegmts  Nbytes  Overhd  Overhd  Overhd  Nbytes  Nbytes  Nbytes[.br]
: ---------- ------- ------- ------- ------- ------- ------- ------- -------
M MEMUSAGE_ENTRY
> heap s-10.10
> nseg d4
> size d6
> sohd d6
> aohd d6
> gohd d6
> unnb d6
> frnb d6
> alnb d6
: [heap]    [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
M MEMUSAGE_FOOTER
: --------------------------------------------------------------------------
M MEMUSAGE_MAX
> pgmname s
> nkbytes f.3
: [pgmname] required [[[nkbytes]] Kbytes of dynamic/allocated memory

# ---------------------------------------------------------------------------
# These are WARNING messages of various sorts
M PARAM_OBSOLETE_NEXT_RELEASE -w1726
: The "param=" syntax you used on the command line will become obsolete
: next release.  You should replace it with "paramfile="

M PARAM_IGNORED -w1727
: The "param=" syntax on the command line is being ignored since you
: have also specified the parameter file name using the "paramfile=" syntax

M PLOG_OBSOLETE_NEXT_RELEASE -w1728
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" syntax from the [paramsource] will become obsolete
: next release.  You should replace it with "logfile="

M PLOG_IGNORED -w1729
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" specification from the [paramsource] is being ignored since
: you have also specified the log file name using the "logfile=" syntax

# ---------------------------------------------------------------------------
# These are ERROR messages of various sorts
M PARAM_DECL_OFFSET -e1730
> toolname  s
> paramname s
> offset    d
> paramsize d
: Tool parameter declaration offset is illegal[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, but the parameter structure size[.br]
: is only [paramsize] bytes.  Something must be very, very wrong.

M PARAM_DECL_OVERLAP -e1731
> toolname  s
> paramname s
> offset    d
> index     d
: Tool parameter declaration overlaps another[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, which overlaps another parameter[.br]
: at an offset of [index] bytes.  Check your calls to tool_decl_* in[.br]
: the husk module of [toolname].  You have probably have the same parameter[.br]
: name in more than one of the tool_decl_* routine.

M PARAM_ERROR -e1732
> paramsource s # the TEXT_CMDLINE or TEXT_PARAMFILE message text
> theErrors   s
: The [paramsource] contains parameter assignment errors:[theErrors]

M PARAM_ERROR_MAINTOOL -e1733
> theTool   s
> theErrors s
: The [theTool] program detected parameter value errors:[theErrors]

M PARAM_ERROR_SUBTOOL -e1734
> currenttool s
> parenttool  s
> theErrors   s
: The [currenttool] tool, invoked from [parenttool],
: detected parameter value errors:[theErrors]

M PARAM_TOOMANY -e1735
> nspecified d
> ndefined   d
: The command line contains [nspecified] positional parameters,[.br]
: but the program only needs [ndefined] parameters.

M BAD_DASH_PARAM -e1736
> param z
: The command line parameter, '[param]', is a non-boolean '-' parameter.  Only
: boolean parameter can be specified using the '-' feature, where 
: '-<parameter>' is the equivalent of TRUE and '-NO<parameter>' is the 
: equivalent of FALSE.

M INSTANCE_MISMATCH -e1737
> instancenumber d
> instancename   s
> tooldefname    s
: Tool instance - tool definition mismatch[.br]
: Tool instance #[instancenumber] is not an instance of "[tooldefname]"[.br]
: but rather an instance of "[instancename]"

M INSTANCE_ILLEGAL -e1738
> instancenumber d
: Illegal tool instance number[.br]
: Tool instance #[instancenumber] does not refer to a valid tool

M PFILE_OPEN_FAILED -e1739
> filename s
: The parameter file "[filename]" could not be opened for input

M MISSING_VALUE -e1740
> paramname s
: The command line parameter named "[paramname]"[.br]
: must be followed by an equals sign and a value

M ILLEGAL_PARAMNAME -e1741
> paramname s
: An illegal program parameter name "[paramname]"[.br]
: is used on the command line

M PLOG_OPEN_FAILED -e1742
> filename s
: The program log file "[filename]"[.br]
: could not be opened for output

M ILLEGAL_OPTIONNAME -e1743
> optionname s
: An illegal option parameter name "[optionname]"[.br]
: is used on the command line

E MXTOOL
#
# ------------------ dm.m ------------------ 
#
# @(#)dm.m	6.5  2/2/94


B DM -start1161 -end1200 -current1187
: Data Manager 

M CANNOT_WRITE_TO_FILE -e1161 -w1162
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ADDHISTORY_FAILED -e1163 -w1164
> cellname z
> celltype s
: A history description could not be appended to the [celltype] cell
: "[cellname]" because it is a READONLY cell

M CLRHISTORY_FAILED -e1165 -w1166
> cellname z
> celltype s
: The history descriptions of the [celltype] cell "[cellname]" could not be
: cleared because it is a READONLY cell

M CLEAR_FAILED_RDONLY -e1167 -w1168
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be cleared because it is a
: READONLY cell

#M CLEAR_FAILED -e -w
#> cellname z
#> celltype s
#: The [celltype] cell "[cellname]" could not be cleared because it is
#: locked in memory

M DELETE_FAILED -e1169 -w1170
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be deleted because it is
: locked in memory

M FILE_ACCESS -e1171 -w1172
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: exists, but could not be opened

M FILE_MISSING -e1173 -w1174
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be found.

M FILE_OPEN_FAILED -e1175 -w1176
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be opened

M HEADER_CELLTYPENAME -e1177 -w1178
> cellname z
> filename z
> celltype s
: The type of the cell "[cellname]" associated with the file "[filename]"
: does not correspond to the expected "[celltype]" type.

M HEADER_ERROR -e1179 -w1180
> cellname z
> filename z
> celltype s
: The file "[filename]" for the [celltype] cell "[cellname]" contains an
: illegal header

M NAME_FAILED -e1181 -w1182
> cellname z
> newname  s
> celltype s
: The [celltype] cell "[cellname]" could not be renamed to "[newname]"
: because a [celltype] cell named "[newname]" already exists

M TYPE_FAILED -e1183 -w1184
> typename s
> cellname z
: The type of cell "[cellname]" could not be changed to "[typename]"
: because a cell of that name/type already exists

M NEWCELL_FAILED -e1185 -w1186
> cellname s
> celltype s
: The [celltype] cell "[cellname]" could not be created because a cell of
: that type and name already exists

#
# Data Manager Messages
#
M SAVECELL_SECTION
: Data Manager Auto Save

M SAVECELL
> cellname z
> typename s
: Saving [typename] cell "[cellname]"

M LOCKCOUNT_SECTION
: Data Manager Cell Lock Counts

M LOCKCOUNT
> cellname z-10
> typename s-10
> lockcount d2
: [cellname] [typename] [lockcount]

E DM




#
# ------------------ mxpart.m ------------------ 
#
#@(#)mxpart.m	6.2 9/3/93

B MXPART -start1131 -end1160 -current1148
: File reader for partlist.xct file and <package>.pkg files

M CANT_OPEN_FILE -e1131 -w1132
> filename s
: Cannot open file '[filename]' for reading.

M NO_PKG -e1133 -w1134
> part s
> filename s
: The part '[part]' could not be found in the file '[filename]'.

M BAD_ATTRIB_VALUE -e1135 -w1136
> partname s
> filename s
: The attribute list (name=value entries) for the part '[partname]' in the
: file '[filename]' has the wrong format.

M ILLEGAL_PKG_KEYWORD -e1137 -w1138
> value s
: Illegal keyword '[value]' exists in the .pkg file.
 
M DUP_PAD_DEF_IN_PKG -e1139
> pad s
: Duplicate definition of PAD '[pad]'.

M DUP_PIN_DEF_IN_PKG -e1140
> pin s
: Duplicate definition of PIN '[pin]'.

M PAD_NUM_OUT_OF_RANGE -e1141
> pad s
: Pad number '[pad]' is out of range.

M BAD_PAD_NUM -e1142
> pad s
: Bad pad number '[pad]'. Should be in the form: PAD<number>.

M WRONG_ATTR_VALUE -e1143
> value s
> chk_value s
: Attribute value '[value]' does not match check value '[chk_value]'.

M ILLEGAL_FAMILY -e1144
> family d
: Not a legal family '[family]'.

M ILLEGAL_FAMILY_ATTR -e1145
> attrib s
> family d 
: Not a legal attribute '[attrib]' for this family '[family]'.

M BAD_ROWCOL -e1146
: Not and integer value for clb row|cols number.

M CLK_BUF -e1147
> pad s
> padn d
: Clock Buffer using '[pad]' should use 'PAD[padn]'.

E MXPART
#
# ------------------ speed.m ------------------ 
#
#@(#)speed.m	6.4  9/3/93

B SPEED -start 1101 -end1130 -current14
: File reader for speeds.xct file 

M CANT_OPEN_FILE -e0 -w1
> filename s
: Cannot open file '[filename]' for reading.

M FILE_CORRUPTED -e2 -w3
> filename s
: The speeds file '[filename]' has been corrupted and cannot be read.

M CANT_READ_FILE -e4 -w5
> filename s
: The unencrypted speeds file '[filename]' cannot be read.

M BAD_PARTLIST_FILE -e6 -w7
: The partlist.xct file does not contain the correct information.

M UNKNOWN_SPEED_AND_PART -e8 -w9
> speed s
> part s
: The speed '[speed]' is unavailable for part '[part]'.

M BAD_VERSION -e10 -w11
> filename s
> badversion s
> version s
: The '[filename]' file has a bad version, '[badversion]'.
: The version of file must be '[version]'.

M SYNTAX_ERROR -e12 -w13
> filename s
: There is a syntax error in the '[filename]' speeds file.

E SPEED
