# hm2rpm.ml created 1994/05/06 20:00:46
# 
# DO NOT EDIT THIS FILE!  It is derived from other files.
#
# ------------------ alert.m ------------------ 
#
#@(#)alert.m	6.1  12/2/92


B ALERT
: Error condition alert system

#
# These messages are used as alert pre/postfixes
#
M CANNOT_CONTINUE
: Execution cannot continue until this error is fixed
M TERMINATE
> theProgram s
> theStatus s
: [theProgram] was terminated with a [theStatus] status

E ALERT
#
# ------------------ feature.m ------------------ 
#
# @(#)feature.m	6.3 9/3/93


B FEATURE -start1051 -end1100 -current1082
: Feature License Manager

#
# Nasty Low-Level Error Messages
#
M UNKNOWN_ERROR -e1051
> feature s
: License checkout for feature "[feature]" failed[.br]
: because of some, unknown error condition.  
: Please contact your system administrator for help.
M OS_ERROR -e1052
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level or operating system error ([errtext]).
: Please contact your system administrator for help.
M BAD_SERVER_DATA_ERROR -e1053
> feature s
: License checkout for feature "[feature]" failed[.br]
: because invalid data was returned from the license server .
: Please contact your system administrator for help.
M READ_SERVER_ERROR -e1054
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot read from the servers listed in the license data 
: file.  Please contact your system adminstrator for help.
M WRITE_SERVER_ERROR -e1055
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot write to the servers listed in the license data 
: file.  Please contact your system adminsitrator for help.
M SELECT_ROUTINE_ERROR -e1056
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] a call to an internal select routine failed.
: Please contact your system adminsitrator for help.
M BUSY_SERVER_ERROR -e1057
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] failed to connect to a majority of the servers listed in the
: license data file.  Please contact your system adminsitrator for help.
M CHECKIN_FEATURE_ERROR -e1058
> feature s
: License checkin for feature "[feature]" failed[.br]
: Don't worry, be happy.

#
# Possible User Errors
#
M NO_LICENSE_FILE_ERROR -e1059
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the license data file.
: The default location for this file is usually
: /usr/local/data/license.dat.  It may be placed elsewhere at your site, in 
: which case you must define the environmental variable LM_LICENSE_FILE to
: point to it.  Make sure you can access the file from the same shell you are
: trying to run the program.
M NO_FEATURE_ERROR -e1060
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the feature in the license data
: file.  If you have not yet called customer
: service to obtain the authorization codes for this feature please do so.  If
: you have obtained the codes, please make sure that you have added the codes
: to the license data file.
M LICENSES_EXHAUSTED_ERROR -e1061
> feature s
: License checkout for feature "[feature]" failed[.br]
: because all the valid licenses for the feature are currently in use.  
: Try again later.
M EXPIRED_AUTHCODE_ERROR -e1062
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the required license has expired.  
: Please call customer service to obtain a new license.
M UNSUPPORTED_VERSION_ERROR -e1063
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the license data file does not contain a feature of the required
: version number.  Please call custommer service to obtain a license for 
: the new version of the feature.
M NO_KEY_ERROR -e1064
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program could not find a valid Xilinx protection key
: on the parallel port of your computer.  
: Please make sure that the key is attached securely to the parallel port.
M TAMPERED_KEY_ERROR -e1065
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program detected an invalid Xilinx protection key
: on the parallel port of your computer.  
: The key's memory has been corrupted.  Please call customer service to
: obtain a new key.
M DEMO_EXPIRED_ERROR -e1066
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because your demo version of the [program] program has expired.
: Please contact customer service
: or your sales representative to purchase the software you have been
: using.
M TAMPERED_DATE_ERROR -e1067
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the current date on your computer is set to a time which is
: before the date when you last ran this program.   
: Please reset your computer's date to the current
: date and rerun the program.
M XACT_VARIABLE_ERROR -e1068
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the XACT environmental variable has not been defined.
: Use the SET XACT=value dos command 
: to define the location of the XACT software.
M INVALID_DATE_ERROR -e1069
> feature s
: License checkout for feature "[feature]" failed[.br]
: because line in the license data file line which describes the feature
: contains an invalid date.  See the file XACT\data\license.dat.  
: All dates must be of the form 
: DD-MMM-YYYY, where DD is an integer 0-31; MMM is the first three 
: letters of the (English) month name: JAN, FEB, MAR, APR, MAY, JUN, JUL,
: AUG, SEP, OCT, NOV, or DEC; and YYYY is an integer 1990-2118.
M LOLEVEL_ERROR -e1070
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level error ([errtext]).

#
# Possible Installation Errors
#
M MULT_FEATURE_ERROR -e1071
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected multiple occurences of FEATURE lines for the 
: feature in the license file.  A feature
: may appear only once in the license file for it to be valid.  Please remove
: one of the feature lines from the license file.
M LICENSE_FILE_SYNTAX_ERROR -e1072
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected a syntax error in the license date
: file.  Please make sure that you have 
: correctly entered the authorization codes which you obtained from customer 
: service.
M NO_SERVER_ERROR -e1073
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect to the network license server.  
: Please make sure that the lmgrd program is 
: currently running on the computers described as servers in the license data 
: file.
M NO_SERVICE_ERROR -e1074
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the program [program] could not find the TCP "license" service. 
: Make sure that the /etc/services file has
: the license service number defined in it, or add a socket number to the the
: SERVER line of the license data file.
M BAD_AUTHCODE_ERROR -e1075
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected an inconsistency in the authorization code on the
: feature line of the license data file.  
: Please make sure that you have correctly entered the authorization codes
: which you obtained from customer service.
M WRONG_HOST_ERROR -e1076
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the host listed in one of the
: server lines of the license data file.  
: Please make sure that the server information in the license data file is 
: correct.
M BAD_DATE_ERROR -e1077
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] found an invalid date in the license data file.  
: Please make sure that the date information in the
: license data file is correct.  The correct date format is DD-MMM-YY (for
: example 30-JUN-91).  In previous versions of the program, dates of the form
: DD-MMM-YYYY were acceptable, but they are no longer.  To make the correction,
: stop the license server, edit the license.dat file to remove the '19' from
: the year number of all features, restart the license server and rerun the 
: program.
M NO_SERVER_LINES_ERROR -e1078
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find and server lines in the license data file.  
: Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M BAD_SERVER_NAME_ERROR -e1079
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] encountered an illegal server name in the license 
: data file.  Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M CONNECT_SERVER_ERROR -e1080
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect over the network to the license server
: program.  Please make sure that the lmgrd 
: program is currently running on the computers described as servers in the
: license data file.

#
# Error due to PC key
#
M PC_KEY_ERROR -e1081
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: [errtext]

E FEATURE
#
# ------------------ msg.m ------------------ 
#
#@(#)msg.m	6.3 9/3/93


B MSG -start1011 -end1030 -current1016
: The Message System Messages

#
# Message fragments for the MSGFILE error
M MSGIO_EOLJUNK
: Extra characters at the end of a valid line
M MSGIO_UNKNOWN_LINE
: Unknown message file line type
M MSGIO_MSGSET_NAME
: Message set name is required
M MSGIO_MSGDEF_NAME
: Message definition name is required
M MSGIO_MSGARG_NAME
: Message definition argument name is required
M MSGIO_MSGARG_TYPE
: Message definition argument type is required
M MSGIO_UNKNOWN
: Unknown error number

#
# These messages are used by the message system when something goes
# wrong while reading a message file, or instantiating a message
#

M MSGFILE_ERROR -e1011
> theErrorName  m
> theLineNumber d
> theFileName   s
> theLine       s
> thePosition   z
: [theErrorName][.br]
: The error is on Line [theLineNumber] of "[theFileName]"[.br]
: The line is "[theLine]"[.br]
: -------------[thePosition]
M MSGSET_MISSING -e1012
> theCompName s
: The message set for "[theCompName]" does not exist [.br]
: in any of the standard message files.
M MSGSET_NULL
> theCompNumber d
> theCompName s
: The message set pointer for component [theCompNumber], "[theCompName]"[.br]
: does not point to a valid message set.
M MSGSET_NDEFS -e1013
> theMsgnum d
> theMsgname s
> theNumberOfDefs d
> theCompName s
: An attempt was made to invoke message "[theMsgname]",[.br]
: with a message number of [theMsgnum].  However, the message set for[.br]
: component "[theCompName]" has only [theNumberOfDefs] messages.
M MSGSET_MSGNAMES -e1014
> theMsgnum d
> theMsgname s
> theRealMsgname s
> theCompName s
: Message #[theMsgnum] of the message set for component "[theCompName]"[.br]
: was invoked with a name of "[theMsgname]".  Its name in the message[.br]
: file is "[theRealMsgname]".
M MSGSET_NPARAMS -e1015
> theMsgname s
> theNparams d
> theRealNum d
> theCompName s
: Message "[theMsgname]" of the message set for component "[theCompName]"[.br]
: was invoked with [theNparams] parameters.  It is defined with [theRealNum]
: in the message file.

#
# Message id severity names
# These are used in the creation of errors to describe how severe the
# error really is.  THE ORDER OF THESE NAMES IS VERY, VERY IMPORTANT.
# SEE MSGINST_SEVERITY IN MSGINST.C IF YOU DON'T BELIEVE ME.
#

M MSGSEV_INFO
: Information
M MSGSEV_WARNING
: WARNING
M MSGSEV_ERROR
: ERROR
M MSGSEV_FATAL
: Fatal Error
M MSGSEV_INTERNAL
: Internal Error

E MSG
#
# ------------------ mxcomm.m ------------------ 
#
# @(#)mxcomm.m	6.2  9/3/93


B MXCOMM -start1001 -end1010 -current1003
: Mx Program Communications

# Boolean values
M TRUE_VALUES
: Y YES T TRUE ON
M FALSE_VALUES
: N NO F FALSE OFF

# These two messages are used in rwdict error messages
M STARTUP_NAME
: startup file

# These error messages are used by mxaccs directly
M STARTUP_OPEN_FAILED -e1001
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: exists, but could not be opened for some reason

M NO_STARTUP_FILE -e1002
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: does not exist, so it could not be opened

E MXCOMM
#
# ------------------ report.m ------------------ 
#
#@(#)report.m	6.1  12/2/92
 
 
B REPORT
: Report Generator Messages
 
M PAGE
: Page
M CONTINUED
: (continued)
M XILINX
: Xilinx, Inc.
M COPYRIGHT
> year d
: (c) Copyright [year].  All Rights Reserved.
M TABLE_OF_CONTENTS
: Table of Contents[.br]
: -----------------[.br]
M TOC_ENTRY
> entry s
: [entry]
E REPORT
#
# ------------------ rwdict.m ------------------ 
#
#TMF 1.0
# @(#)rwdict.m	6.2  9/3/93


B RWDICT -start1031 -end1050 -current1035
: Dictionary File Reader/Writer

M MISSING_EQUALSIGN -e1031 -w1032
> linenumber d
> filename   s
> dicttype   s
> line       s
: Missing equal sign in the name-value assignment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[line]"

M ILLEGAL_NAME -e1033 -w1034
> linenumber d
> filename   s
> dicttype   s
> name       s
: Illegal name used in the name-value assigment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[name]"


E RWDICT
#
# ------------------ hm2rpm.m ------------------ 
#
#@(#)hm2rpm.m	6.15  3/25/94
 
 
B HM2RPM -start12601 -end12900 -current12608
: Hard Macro to Relationally Placed Macro translator
 
# Tool description (for program help)
M DESCRIPTION
: This program translates hard macros (*.hm files) to RPMs (*.xnf 
: files).
: [.br]USAGE: HM2RPM <infile> [[<outfile>] dflt_logic=<value> [[<parameter>=<value> ...]
: [.br]
: [.br]EXAMPLE
: [.br]The following command translates the hard macro file "test.hm"
: to the relationally placed macro "new.xnf":
: [.br]     hm2rpm test new r=true dflt_logic=true [.br]
: The RPM file "new.xnf" is compatible with the Xilinx Unified Libraries.
: Additional logic is added to set each floating input to the defined
: default level.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M INFILE
: Input file name

M OUTFILE
: Output file name

M OLD_XNF_FORMAT
: Output a xnf file that works with Xilinx Unified Libraries

M DFLT_LOGIC
: Allow default logic generation for RPMs

M SAVE_PICFILE
: Tells if we should save the picfile

M SAVE_LCAFILE
: Tells if we should save the lcafile

M DL_FALSE
: Suppress additional logic for floating inputs

M DL_TRUE
: Add additional logic for floating inputs

M DL_NOT_SET
: The dflt_logic parameter has not been set

M HINFILE
: This parameter is required and the program will not work if it isn't 
: specified.  If no extension is specified on the input file name, a '.hm' 
: extension is assumed.

M HOUTFILE
: If no extension is specified on the output file name, a '.xnf' extension 
: is assumed.

M HOLD_XNF_FORMAT
: By default, HM2RPM will generate an xnf file that is compatible with 
: designs from the schematic libraries that existed prior to the release
: of the Xilinx Unified libraries.  If this parameter is set to TRUE, an
: XNF file will be generated that will be compatible with the new Xilinx
: Unified schematic libraries.  

M HDFLT_LOGIC
: This parameter is required and the program will not work if it isn't 
: specified.  If TRUE, HM2RPM will add additional logic so that
: unconnected HM inputs are set to the defined default level. If FALSE,
: no additional logic is added.

M HSAVE_PICFILE
: This paramter tells whether or not to save the created pic file.  If it
: is TRUE the pic file is saved, otherwise it is removed.

M HSAVE_LCAFILE
: This paramter tells whether or not to save the created lca file.  If it
: is TRUE the lca file is saved, otherwise it is removed.
 
M HDL_FALSE
: Use this value to suppress additional logic generation to set each
: floating input to the defined default level.

M HDL_TRUE
: Use this value to have HM2RPM add additional logic to set each
: floating input to the defined default level.

M HDL_NOT_SET
: Do not use this value; it indicates that the dflt_logic parameter
: has not been set.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
 
# Error and Warning Messages
 
M CANT_FIND_FILE -e12601
> filename s
: Cannot find file '[filename]'.

M CANT_OPEN_FILE -e12602
> filename s
: Cannot open file '[filename]'.
 
M CORRUPTED_HM_FILE -e12603
> filename s
: The hard macro file '[filename]' has been corrupted and cannot be properly
: translated.

M LCA2XNF_ERR -e12604
: An error occurred attempting to execute the program LCA2XNF, used by HM2RPM.
: Verify that this program has been installed and is in the search path.

M CANT_COPY_FILE -e12605
> filename s
> tempfile s
: Cannot copy '[filename]' file to a temporary '[tempfile]' file.

M TEMP_FNAME_ERR -e12606
: Cannot create a needed temporary file.  This may indicate that the
: directory used for temporary files does not exist or that this program
: does not have write permission for that directory.

# Informational and Other Messages

M ECHO_LINE
> echo_line z
: [echo_line]

M DEFAULT_LOGIC_TRUE
: [.br]NOTE: The RPM created by HM2RPM will contain additional logic to ensure
: [.br]      that the default values of unconnected hard macro inputs are
: [.br]      handled properly. For hard macro inputs which are connected, this
: [.br]      additional logic will be completely removed by XNFPREP. For hard
: [.br]      macro inputs which are unconnected, this additional logic will be
: [.br]      removed when XNFPREP trims the unused logic in the RPM. 
: [.br]
: [.br]      The XNFPREP report file will show the removal of this additional
: [.br]      logic. For this reason, the trimming of symbols and signals with
: [.br]      the string `FLOAT_HMINPUT' in the name can be safely ignored.
: [.br]
: [.br]      To inhibit the generation of this additional logic, set the
: [.br]      dlft_logic option to FALSE. All hard macro inputs must be
: [.br]      connected if this option is used.

M DEFAULT_LOGIC_FALSE
: [.br]NOTE: The default state of unused hard macro inputs will not be
: [.br]      respected when the hard macro is converted to an RPM. This
: [.br]      means that unconnected hard macro inputs may cause logic to
: [.br]      be trimmed incorrectly in XNFPREP.
: [.br]
: [.br]      To ensure that converted hard macros are translated properly,
: [.br]      all input pins which do not have an active source should be
: [.br]      tied to VCC or ground as appropriate. XNFPREP will then trim
: [.br]      the associated logic correctly.

M R_FALSE_INFO
> outfile z
: [.br]HM2RPM: INFO: The RPM "[outfile]" is compatible with the old schematic
: [.br]        libraries (that is, those before the unified libraries). If this
: [.br]        RPM is to be included in a design done with unified libraries,
: [.br]        you should rerun HM2RPM with r=true.


M R_TRUE_INFO
> outfile z
: [.br]HM2RPM: INFO: The RPM "[outfile]" is compatible with the unified
: [.br]        libraries and not with earlier library versions. If this RPM is
: [.br]        to be included in a design done with an earlier library, you
: [.br]        should rerun HM2RPM with r=false.

M DEFAULT_LOGIC_UNSET -e12607
: The HM2RPM program cannot continue because no value has been set for the 
: dflt_logic option. The dflt_logic option determines how HM2RPM handles 
: default values on hard macro inputs. A hard macro created by the HMGEN
: program will contain a default value of 0 or 1 (GND or VCC) on every HM 
: input. If an input were left unconnected, PPR would route GND or VCC to 
: that input to ensure the correct functionality.
: [.br][.br]
: If any hard macro inputs in your design are left unconnected, you can
: set dflt_logic to TRUE. If you do so, HM2RPM will add additional logic to
: each RPM to ensure that unconnected HM inputs float to the correct level.
: For HM inputs which are connected, the extra logic will be removed by the 
: XNFPREP program. If you choose dflt_logic=TRUE and encounter FMAP and/or 
: HMAP errors in XNFPREP or PPR, you may need to return to dflt_logic=FALSE 
: and modify your design to tie all HM inputs to known values.
: [.br][.br]
: If all inputs to the hard macros in your design are fully connected (either
: to active signals or explicitly to VCC or GND), you should set the dflt_logic
: option to FALSE. This will prevent any additional logic from being generated.
: [.br][.br]
: (To permanently set the value of dflt_logic for all future runs of HM2RPM,
: add the line `/hm2rpm/dflt_logic=<value>' to the xactinit.dat file in the 
: current directory.)[.br]

 
E HM2RPM
#
# ------------------ pic2lca.m ------------------ 
#
#@(#)pic2lca.m	6.8  5/2/94
 
 
B PIC2LCA -start10601 -end10900 -current10611
: PIC to LCA translator
 
# Tool description (for program help)
M DESCRIPTION
: Translates a pic cell to an lca file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Name of input pic cell

M LCAFILE
: Name of output lca file
 
M JUSTFLATTEN
: Routes all the nets to clb pins.
 
M TIMEGROUPS
: Should timegroups and timespecs be written to lca file?

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: The name of the pic cell that is to be translated into a lca file.  This 
: name must either exist in the current working directory or at the location 
: specified in the file's pathname.

M HLCAFILE
: The name of the lca file to which the pic information is written.  If no file 
: name is specified the name of the file will be the name of the input pic
: cell with a .lca extension.

M HJUSTFLATTEN
: Routes all the nets to clb pins.
: Used to generate an unrouted LCA file for unit-delay simulation.  Pic2lca 
: generates an lca file with all the instances placed in clbs and the nets
: routed to CLB pins.

M HTIMEGROUPS
: If timegroups is TRUE, pic2lca will call the path analyzer to get
: information on the user's timing constraints, and write timegroup and
: timespec records for these into the lca file.

M UNROUTED_CONNECTIONS -w10610
> value s
: [.br]Number of unrouted connections: [value] [.br]

# Error and Warning Messages
M BLKNM_EXISTS -w10601
> instname s
> blkname s
> newblkname s
: The block name '[blkname]' associated with the instance '[instname]'
: has already been used to name another block.  The new block name 
: '[newblkname]' is created for this block.'
 
M ILLEGAL_BLKNM -w10602
> instname s
: The names associated with the following blocks are not legal in XACT.  Block
: names can contain only the characters:[.br]
: A-Z a-z 0-9 $ _ - < > /[.br]
: and must contain at least one non-digit character.
: New block names will be created for these blocks.
: [.br]                     block name                     instance name 
: [.br]                     ----------                     ------------- 
: [.br][instname]

M PKG_PIN_NAME -w10603
> instname s
> blkname s
> newblkname s
: The block name '[blkname]' associated with the instance '[instname]' could
: not be used because it is a reserved name for the package pins in XACT.  
: The new block name '[newblkname]' is created for this block.

M EXISTING_LCA_FILE -w10604
> fname s 
: A .LCA file already exists.  The old .LCA file will be saved as '[fname]'.

M BAD_OPEN_FILE -e10605
> fname s
: The file [fname] could not be opened.

M BAD_INIT_FILE -e10606
> fname s
: The LCA2HM initialization file, [fname], is in the wrong format.

M NO_LCA_FILE -e10607
> fname s
: Unable to open the file '[fname]' for writing. 
 
# Informational and Other Messages
M READING_PIC
: Loading the PIC netlist

M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ILLEGAL_PAD_ATTR -w10608
> attr s
> partname s
: The pad attr '[attr]' is not defined for the '[partname]' part.

M NEW_BLKNM -w10609
> instname s
> blkname s
: The new block name '[blkname]' is assigned to the instance '[instname]'.

E PIC2LCA
#
# ------------------ pa.m ------------------ 
#
#@(#)pa.m	6.55  5/5/94
 
 
B PA -start7000 -end7699 -current7042
: path analyzer
 
# Tool description (for program help)
M DESCRIPTION
:    Tool pa runs the path analyzer.
: [.br]INPUTS:
: [.br]<design>.*.  The design should
: have a file <design>.na, <design>.nb, <design>.p, <design>.pm, or <design>.pf.
: These are produced by running the
: ppr tools xnfupd if appropriate, xnf2mxn, mxnflat, mxnprep, fgmake, mincut,
: blkmake, picflat, mxmazer, or simply ppr.
: [.br]OUTPUTS:
: [.br]  pa.log.  General information about the slow paths in the design.
 
# External Parameter Names and Help Messages
# What is this parameter?  This is the...(a short & pithy 1-liner)
# What does this parameter do?  This parameter...(verbose multi-liner)

M MXNCELL
: Name of the design.

M HMXNCELL
: A .na extension is assumed.
 
M PARTTYPE
: Target LCA device and package.

M HPARTTYPE
: Speed data depend on the parttype.

M MSTOP_IF
: Should PA stop if a timespec is sure to be missed?

M HSTOP_IF
: Tests feature that PPR needs.

M MREPORT_PATHS
: When a spec is missed, should PA report details on paths?

M HREPORT_PATHS
: In 'trouble' situations, controls whether path details are displayed.

M MMAX_ENDPINS
: Maximum paths to report, on a miss.

M HMAX_ENDPINS
: Limits number of detailed paths displayed, under 'report_paths' control.

M NET_DELAY
: Value to use for estimated delay between external CLB pins.

M HNET_DELAY
: Without real data from a place+route tool, pa will normally assume that every
: connection consumes zero time.  This parameter allows something slightly more
: reasonable - a fixed delay for every CLB-to-CLB connection.  Further
: adjustments are made, e.g., known delay increments that must be incurred to
: get out of blocks; or reductions for load pins that are likely to be driven
: from within a block.

M NPINS_SHOW
: Number of pins with worst slacks to display.

M HNPINS_SHOW
: How many of the worst pins should be displayed?

M PICTYPE
: Flavor of pic to use.

M HPICTYPE
: The pic netlist changes depending on the stage of design processing.
: This parameter selects the stage to use.

M P_MSG
: PIC

M HP_MSG
: generic pic cells (.p)

M P_FGMAPS_MSG
: PIC_FGMAPS

M HP_FGMAPS_MSG
: after fgmap.  FMAPs and HMAPs replaced by function generators (.pp)

M P_FGS_MSG
: PIC_FGS

M HP_FGS_MSG
: after fgmake.  Primitives replaced by function generators (.pb)

M P_MAP_MSG
: PICMAP

M HP_MAP_MSG
: after mdmake - picmap cells (.pm)

M MIGNORE_TIMESPECS
: Ignore timespecs in MXN?

M HIGNORE_TIMESPECS
: When this parameter is True, timespecs in the mxn netlist are ignored.

M MUSE_FASTER_C2S
: Control paths between ffs with different specs?

M HUSE_FASTER_C2S
: When this parameter is False, a path between two flip-flops to which
: different specs have been attached is not controlled.  When True, such
: a path IS controlled, and is required to meet the faster of the two specs.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
 
# Error Messages
M NODE_REVISIT -e7000
> newlabel d4
> newname z
> label d4
> name z
: Tried to revisit [newname] ([newlabel]) from [name] ([label]).
 
# Warning Messages

# Informational and Other Messages
M GRAPH_SIZE
> nodes d
> arcs d
> clocked d
: Graph has [nodes] nodes ([clocked] clocked), [arcs] arcs.

M NUM_SLACK_STRUCTS
> allocated d
> total_pins d
: Allocated slack structures for [allocated] (load) pins, of [total_pins] pins.

M LOAD_TIF_MODEL
: Loading the tif model

M NO_ACTUAL_ARRIVAL -e7001
> pinname z
> direction s
: [direction] wave never reached pin [pinname] - something is bogus!

M MISSED_DEADLINES
> misses d
> total_over f7.1
: Deadline missed at [misses] pins.
: Total overflow = [total_over] nS.

M SLACK_TABLE_HEADING
> filler s
: [filler] (ns)  to pin on

M A_TARDY_PIN
> actual f5.1
> pin z
> archname s
> drives s
> driven_net z
: [actual](ns) to pin on [archname] [drives] net [driven_net]  ([pin])

M MISSING_SPEED_DATA -e7002
: No speed data are available.  This indicates either that your installation
: was not properly completed (e.g., a speeds.xct was left over from a previous
: install), or that a bad value of the datafile_search_path in some xactinit.dat
: file is being used.

M NEGATIVE_DELAYS -w7003
> count d
> pins z
: The following [count] pins were given negative delays (unrouted?),
: changed to 0: [.br]
: [pins]

M NO_DELAYS_SET
: None of the estimated connection delays that pa will use were set.

M COUNT_PINS_SET
> pins_reset d
> pins_changed d
: Delays set at [pins_reset]  load pins, [pins_changed] of which were changed.

M COUNT_ARCS_SET
> arcs_reset d
> arcs_changed d
> arcs_unchanged d
: This affected [arcs_reset] arcs in pa.  [arcs_changed] changed,
: [arcs_unchanged] didn't.

M REASONABLE_ZEROS
> count d5
> type s
: [count] [type] pins were given delay zero.

M STRANGE_ZEROS
> count d
> pins z
: [count] pins, not in listed cases, got zero delay: [.br]
: [pins]

M STRANGE_NONZEROS
> count d
: [count] pins got nonzero delay when zero was expected:

M PIN_LIST
> pins z
: [pins]

M MAX_WEIGHT_PATH
> weight d
: Total connection weight in maximum-weight path = [weight].

M BAD_STEP -e7004
> step d
> worst f6.1
> worst_pin z
: Problem during step [step]: [worst], at [worst_pin].

M STEP_REPORT
> step d2
> total f6.1
> ratio f6.3
> smallest f4.1
> biggest f4.1
: Step [step].  Total [total] = [ratio]*orig.  Min=
: [smallest].  Max=[biggest].

M STEPS
> small f5.1
> steps d2
: [steps] steps: [small].

M SLACK_STRUCT
> pin_name z
> delay d4
> lowBound d4
> actual d4
> required d4
> limit d4
> fc2s f5.2
> fp2s f5.2
> fc2p f5.2
> fp2p f5.2
> max_upper d4
: Pin [pin_name]: dly [delay], lowB [lowBound], act [actual], req [required],
: lim [limit], f [fc2s] [fp2s] [fc2p] [fp2p], upr [max_upper]

M A_STRING
> string z
: [string]

M FANOUT
: Use total source fanout.

M LENGTH
: Use path length.

M INITIAL_GOAL
> ratio f5.2
: If period is not specified, initial goal=[ratio] * smallest conceivable.

M DONE_PUSHING
: Have eliminated negative slacks.

M XY_LOWER_BOUNDS
: Lower bounds on delay as a function of (|dx|, |dy|):

M XY_ESTIMATES
: Estimated delay as a function of (|dx|, |dy|):

M GET_DELAY_TIMES
> time_opt d4
> time_real d4
: Got optimal delays in [time_opt] secs.,
: realistic delays in [time_real] secs.

M GLOBAL_ESTIMATE
> global_delay f4.1
: Delay to load of global buffer = [global_delay] ns.

M DLY_TAB
: Getting delays as a function of delta_x and delta_y

M UNSPECIFIED_PART -w7005
> default s
: No part was specified to the path analyzer by its caller or in the netlist:
: use default [default].

M PIN_WITH_INDEX
> pinname z
> index d
: Pin [pinname] has index [index].

M CORRUPTED_PIN_INDICES -e7006
> badpin d
: Internal pin index error; multiple pins with index [badpin].
: Path analysis cannot run!

M INVALID_CLOCK_RELATED_SPEC -e7007
> spec_label s
> spec_type s
: This design has no clocked elements.  The timing specification
: [spec_label] of type [spec_type] is therefore invalid.

M MULTI_SPECS_ARRIVE -w7008
> count d
> spec_type s
> type_desc s
: More than one [spec_type] unqualified spec arrived at [type_desc] of
: [count] clocked elements.  In each case, the unqualified spec with the
: tightest specification will be used.
: These clocked elements (identified by the nets they source), the unqualified spec,
: and the specification are listed below:[.br]
:  ELEMENT          NET WITH SPEC            SPECIFICATION

M A_MULTI_ARRIVAL
> net_driven z-24
> net_name s-24
> delay s
: [net_driven] [net_name] [delay]

M SPEC_REPORT_HEADER
> path_type_name s
: [.br]
: Summary of controlling spec for [path_type_name] specifications:

M A_SPEC_THAT_CONTROLS_SOME
> specname s
> count d
: Spec [specname] specification controls [count] clocked elements.

M SUB_HEADER
: These elements are identified below by nets that they drive.

M AN_INST
> inst_name z
: [inst_name]

M ARC_SIZE
> pa_arcs d
> g_arcs d4
> noncomb_loads d
:  Of [g_arcs] arcs,  PA will use [pa_arcs] ([noncomb_loads] into
: non-combinational nodes).

M NO_USER_SPECS
: No timing requirements have been specified.  Target values will be set
: automatically.

M CHECK_FEASIBILITY
: Check if timing can be met for specs with fixed path delay requirements
: (suppose connection delays equaled their lower bounds)
: and determine reasonable delay targets for other specs.[.br]

M BLANK_LINE
: 

M REPEATED_DEFAULT -w7011
> spec_type z
> value f5.1
: Encountered multiple specifications of [spec_type].  The tightest one
: will be used.  So far, that is [value] ns.

M SPEC_DOES_NOT_APPLY -w7013
> spec z
: Specification [spec]
: [.br]does not apply to any paths.

M CMDLINE_OVERRIDE
> spec_type s
> value z
: Default [spec_type] specification from command line ([value])
: is overriding value from the schematic.

M NO_PATHS_TO_ANALYZE -w7014
: There are no specified or default paths to analyze.  Path analysis
: will not be used.  Please check the setting of default specifications.
: A design without clock elements might benefit from a from:pads:to:pads
: or equivalently a dp2p specification.

M PATH_INTRO
> start_arch s
> start_driven_net s
> end_arch s
> drives s
> end_driven_net s
: [.br]Path from [start_arch] driving net [start_driven_net] to
: [end_arch] [drives] net [end_driven_net]

M WOULD_MISS_SO_PICK_NEW_TARGET -w7015
> info z
> new_target f5.1
> miss d
> total d
: For the specification '[info]', at least [miss] of [total] path endpoints will
: apparently not meet the specified delay.  The allowable delay for all paths
: covered by this specification will be increased to [new_target] ns.  Although
: PPR will miss your original specification, it is likely to produce a result
: significantly better than the new, relaxed specification.[.br][.br]
: If some paths in this specification need not run at the speed originally
: specified, you could exclude these from the above specification
: and add a new specification to control these slower paths.

M MISSED_TIMESPEC_INEVITABLE -e7016
> info z
> miss d
> total d
: For the specification '[info]', at least [miss] of [total] path endpoints would
: not meet the specified delay, even
: if every connection were routed with the mimimum delay consistent with the
: current implementation.  These endpoints are listed below, along with
: total path delays, estimated using the MINIMUM delays for every connection.  
: The connections have not yet been routed!  Because different connections
: may want the same wiring resources, it is unlikely that all will
: simultaneously achieve their minimum delay values in a finished routing.  
: The expected path delays are therefore greater than the values below.[.br]

M TIMESPEC_MISSED -w7017
> miss d
> total d
: [miss] of [total] path endpoints have apparently missed this timespec.
: These endpoints are listed below, along with estimated total path delays
: after routing.

M INTRO_PIN_DETAILS
> pins d
> paths d
: Slowest estimated paths: [pins] worst endpoints, [paths] with path details

M INTRO_TO_PATHS
> num_endpoints d
: Details on all slowest paths to the first [num_endpoints] endpoints above:

M WORST_INTRO
> blank_or_not s
> slack f5.1
> total f5.1
> path_length d
: There are [blank_or_not]rigid specs.  Slack=[slack] ns, total=[total] ns,
: [path_length] pins:

M A_PIN_IN_PATH
> net z-30
> cumu f5.1
: Through net [net]: [cumu] ns.

M MAX_NPATHS
> max_endpins d
: Maximum number of paths through any connection = [max_endpins].

M NPATH_STATS
> nonzero_npath_pins d
> total_pins d
> min_npaths d
> max_npaths d
> average f-10.1
: [nonzero_npath_pins] of [total_pins] pins are on some paths.
: [.br]Range is from [min_npaths] to [max_npaths]; average is [average]

M INVALID_CLOCK_RELATED_PARAMETER -e7018
> statement_type s
: This design has no clocked elements.  Hence all clock-related default
: specifications would be ignored.  The [statement_type] parameter
: is therefore invalid.  Non-clock related paths are not controlled by
: default.  These paths can be controlled by specifying a
: from:pads:to:pads or a dp2p specification.

M NO_MATCHING_PAD -e7019
> pattern s
> direction s
> spec_type s
: Qualifier "[pattern]" on [spec_type] spec
: doesn't match any [direction] pad.

M PATH_TIMING_CANNOT_RUN -e7020
: Earlier errors prevent path analysis from running.  Please
: review messages above, and correct problems that may have
: resulted from your input, e.g.,
: specifications that do not control any paths,
: or incorrectly entered pad or signal name patterns.  If you cannot resolve
: the problem, please contact Xilinx technical support.  In
: the meanwhile, you can implement your design by running
: PPR with the command line parameter "path_timing=False".

M TIMESPECS_BUT_NO_PATHS -e7021
: You provided one or more timing specifications, but none that apply
: to any paths in this design.

M SPEC_STATS
> info z
> starts d4
> stops d4
> conns d4
> actives d4
: Spec [info][.br]
: has [starts] starts, [stops] ends, [conns] connections;
: [actives] active nodes.[.br]

M INTRO_SUMMARY1
: -----------------------------------------------------------------[.br]
: Timing analysis summary[.br]
: -----------------------------------------------------------------[.br]

M INTRO_SUMMARY2
> blanks s
: [blanks]Deadline  Actual(*)  Specification

M INTRO_SUMMARY3
> blanks s
: [blanks]--------  ---------  -------------

M A_SUMMARY_LINE
> flag s4
> deadline s
> actual s
> qualifier z
: [flag] [deadline]  [actual]    [qualifier]

M NO_SPECS_NOTE
: [.br]
: (*) Note: please use the -FailedSpec and/or -TSMaxpaths options of the
: Xdelay-TimeSpec command, accessible through the XDE or XDelay program,
: to confirm the actual path delays computed by PPR.

M GOOD_NOTE
: [.br]
: (*) Note: the actual path delays computed by PPR indicate that ALL timing
: specifications you provided have been met.  Please use the -FailedSpec
: and/or -TSMaxpaths options of the Xdelay-TimeSpec command, accessible
: through the XDE or XDelay program,
: as a final confirmation of the performance of your design.

M MISS_NOTE
> missed d
> rigids d
> be_verb s
: [.br]
: (*) Note: the actual path delays computed by PPR indicate that
: [missed] of [rigids] timing specifications you provided
: [be_verb] not met.  To confirm this result, please use the -FailedSpec
: and/or -TSMaxpaths options of the Xdelay-TimeSpec command, accessible
: through the XDE or XDelay program.

M CMDLINE_SAYS_IGNORE_SPEC -w7022
> spectype s
: Because your ppr command included "[spectype]=ignore", the [spectype]
: specification in the netlist will be ignored.

M IGNORE_DEFAULT_PATHS
> dpath_type s
> path_type s
: The schematic specifies "[dpath_type]:ignore", so [path_type] paths 
: without explicit specifications will not be controlled.

M PATH_LINE_INTERNAL
> rpt_line z-55
> delay f5.1
> cumulative f5.1
: [rpt_line]:[delay] ([cumulative]ns)

M REDEFINITION_OF_TNM -e7023
> tnm s
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Encountered redefinition of tnm [tnm].

M TNM_USED_NOT_DEFINED -e7024
> tnm s
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Encountered use of tnm [tnm] that is not defined.

M SYNTAX_ERROR_IN_FROM_TO -e7025
> label s
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Encountered error while parsing [label] timespec.

M A_SLACK
> label d4
> slack f5.1
> pinname z
: Slack on node [label] = [slack] ns ([pinname]).

M SYNTAX_TYPES_MIX -w7026
> spec_type s
: Encountered [spec_type] specification(s) as well as From-To
: specification(s) of a similar kind.  Mixing the two kinds of
: specifications is not an error.  However, use of From-To syntax only
: gives you better control over path specifications.

M TS_GROUP_IS_EMPTY -e7027
> spec_label s
> group_label s
: The specification `[spec_label]' refers to the group `[group_label]',
: which does not contain any valid path endpoints.[.br] 
: If `[group_label]' is defined by a TNM parameter on a signal or load
: pin, it must eventually reach a flip-flop or input latch when traced
: forward. Check that the TNM does reach a flip-flop or latch, and check
: the XNFPREP report file to verify that the target symbols were not
: trimmed. (Note that TNM parameters on signals or pins will NOT be
: traced forward to tag I/O pads or RAMs. For these types of endpoints,
: attach a TNM parameter directly to the symbol. For an I/O pad, the TNM
: may also be connected to the signal DIRECTLY connected to the pad
: symbol.)[.br]
: If `[group_label]' is defined by a TIMEGRP statement, check that the
: newly-created group does actually contain one or more elements. 

M NO_TRACE_THRU_ASYNCHRONOUS_FF_INPUTS -w7028
: The design has flip-flops with asynchronous set/reset controls (PRE/SD or
: CLR/RD pins).  When PPR analyzes design timing, it does not trace paths
: through the asynchronous set/reset input and on through the Q output.[.br][.br]
: If you want PPR to control the delay on paths through asynchronous set/reset
: pins, you must split the delay requirement into two segments:
: one ending at the set/reset input, and the other beginning at the flip-flop
: output.[.br]
: If you want PPR not to analyze paths that lead to asynchronous set/reset pins,
: attach an IGNORE specification to the pin(s) or signal(s).[.br][.br]
: By default, XDelay reports all paths through asynchronous set/reset pins.
: To prevent XDelay from showing these paths, use FlagBlk CLB_Disable_SR_Q
: on the appropriate flip-flops.

M NO_TRACE_THRU_RAM_WE_OR_DATA_INPUTS -w7029
: The design has RAM elements.  When PPR analyzes design timing, it does
: not trace paths through the data or write-enable inputs and on through 
: the RAM output.  Such paths are normally of interest only when the RAM is
: being read during a write operation.[.br][.br]
: If you want PPR to control the delay on paths through the D or WE inputs,
: you must split the delay requirement into two segments: one ending
: at the RAM input pin, and the other beginning at the RAM output.[.br][.br]
: By default, XDelay does not report paths through D or WE pins either.
: To allow XDelay to show these paths, use FlagBlk CLB_Enable_WE and/or
: FlagBlk CLB_Enable_DIN on the appropriate RAMs.

M SPECD_PATHS_AND_CONTROL -w7030
> uncontrolled_specd_paths d
> multiply_controlled_specd_paths d
> design z
: In categories of paths with one or more timing specifications, the
: design has [uncontrolled_specd_paths] path end-point pairs that are
: not controlled by any timing specification and
: [multiply_controlled_specd_paths] that are controlled by more than one
: timing specification.  The end-point pairs are listed in file
: [design].tsi.  Note that there may be multiple paths between any
: listed pair of end-points.  To limit the number of paths reported in
: each category, set PPR parameter show_tsi_paths = <value>. 

M EXTRA_SLACK_STRUCTS
> num_extras d
: Extra structures allocated for "don't care" equivalent pins: [num_extras].

M LOW_LIMIT
> limit f4.1
> lowbound f4.1
> pinname z
: Recommend [limit] ns, < [lowbound] ns, for pin [pinname]

M A_CHARSTR
> charstr s
: [charstr]

M EQUIVALENCE_MISMATCHES
> count d
: In [count] pairs of pins that are "equivalent" to the router, path timing
: is irrelevant to one but not the other.

M BAD_SYNTAX -e6801
> spec_label s
> spec_type s
: Encountered bad syntax for timing specification [spec_label] of type
: [spec_type].
: [.br]

M UNSPECD_PATHS_AND_CONTROL -w7034
> uncontrolled_unspecd_paths d
: In categories of paths that have NO timing specifications, the design
: has [uncontrolled_unspecd_paths] path end-point pairs.  Note that
: there may be multiple paths between any listed pair of end-points.  To
: limit the number of paths reported in each category, set PPR parameter
: show_tsi_paths = <value>. 
: [.br]

M SUPPRESS_UNSPECD_UNCONTROLLED_PATHS
> design z
: The end-point pairs are listed in file [design].tsi.
: To suppress the listing of paths for categories with no timing
: specifications, set PPR parameter tsi_show_all=FALSE. 

M SEE_UNSPECD_UNCONTROLLED_PATHS
: To see the listing of paths for categories with no timing
: specifications, set PPR parameter tsi_show_all=TRUE.

M NA_NOTE
: [.br]
: (x) These specifications did not apply to any paths in the design.


M TSI_FILE_OPEN_ERROR -e7036
> design z
: The file "[design].tsi" could not be opened for writing.

M WARN_RISING_FALLING
: [.br]
: Note: The design contains flip-flops clocked by opposite edges of the same
: signal.  Default specs generated automatically by PPR will not properly
: control paths between opposite-edge flip-flops.  The delays on such paths
: will be properly controlled ONLY if:
: [.br]
: (1) the flip-flops are grouped by clock
: edge using RISING and FALLING TIMEGRP statements, and these subgroups
: are used in TIMESPEC statements with the appropriate High and Low clock
: times; or
: [.br]
: (2) a C2S-style TIMESPEC statement with the appropriate High
: clock time is attached to the clock signal.

M MULTIPLE_CLOCK_NETS
> clock_nets_list z
: [.br]
: Note: The design contains more than one clock signal
: ([clock_nets_list]). Default specs generated automatically by PPR will
: not control each clock at its own best possible frequency; clocks which
: could run faster may be controlled at a slower frequency. If you have
: specified no TIMESPEC requirements (or only a generic `FROM:FFS:TO:FFS'
: requirement), the design performance may not have been optimized by PPR.
: For best results, supply individual TIMESPECs for the flip-flops on
: each clock signal that you care about.

M CLOCKED_SPEC_BUT_NO_CLOCKED_INSTS -e7040
> spec_id s
> spec_type s
: Since there are no clocked instances in the design, the timing
: specification [spec_id] of type [spec_type] is invalid.

M TAGLESS_FF_NETS -w7041
: Some paths included in the Timing Analysis Summary above may not be
: included in the reports you generate with the XDelay-TimeSpec command
: (within the XDE or XDelay program).  The XACT-Performance Summary chapter
: of the PPR report file details which specifications may not be analyzed
: completely by XDelay-TimeSpec, and explains how the results of these
: specifications can be properly determined.

M BURIED_FF_DETAILS
: [.br]*** PPR: WARNING 7041:[.br][.br]
: For the specifications listed below, the reports you generate with the
: XDelay-TimeSpec command (within the XDE or XDelay program) may be
: incomplete.  The flip-flops shown below are path endpoints for these
: specifications, but will not be recognized as such by XDelay.  Although
: the XACT-Performance Summary shown above does include paths with these
: endpoints, the XDelay-TimeSpec report will not.[.br][.br]
: Each flip-flop listed below sources only the other flip-flop in the
: same CLB (and possibly its own D pin) using the dedicated feedback path.
: The specs that control paths ENDING at the flip-flop are shown; those
: that control paths starting at the flip-flop are not shown, since the
: internal feedback delay is fixed.  Where no specs are listed, the flip-flop
: is included in TIMESPECs only as a path starting point.[.br][.br]
: For each flip-flop listed below, use the specified CLB location in the
: -To option of the XDelay command.  This will produce a report of all paths
: that end at that CLB, including those ending at the flip-flop.  XDelay
: does not identify these flip-flops directly by their output name, but by
: the adjacent flip-flops they drive.  For example, `Target FFY drives D
: input to FFX driving net <name>.'[.br][.br]
: As always, timing simulation may be used to verify design performance.
: All paths associated with these flip-flops will be modeled correctly
: in simulation.[.br]

E PA
#
# ------------------ tspec.m ------------------ 
#
#@(#)tspec.m	6.13  4/7/94
 
 
B TSPEC -start6801 -end6999 -current6812
: Timing spec generator
 
# ============================================================
# Tool description (for program help)
# ============================================================

M DESCRIPTION
:    Tool tspec is the Xilinx timing spec generator.
: It analyzes a design and creates a list of all the timing constraints
: (primarily setup, clock-to-out, combinational, and transfer paths)
: that the designer should specify to ensure acceptable performance
: from the final layout.
: [.br]INPUTS:
: [.br] The design should
: have a file <design>.p, <design>.pp, <design>.pb, or <design>.pm, which are
: produced by running ppr.
: [.br]  <design>.tsi.  ("timing spec input").  This input file is optional -
: it will be read if it exists in the current directory.  It allows 
: the user to enter "pingroup" and "origin" statements.
: [.br]OUTPUTS:
: [.br]  tspec.log.  General information about the design, questionable design
: practices that may need correction or clarification, and summary of timing
: constraints identified.
: [.br]  <design>.tim.  This file serves both as a report to the user and an
: input to path analysis tools and ppr.
: It identifies the paths found, and inserts the placeholder 'x'
: wherever the designer should supply time constraints in nanoseconds.
: [.br] ========================================
: [.br]  For more information, see the files fsp.language and language,
: which describe the Xilinx user timing language.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M MXNCELL
: Name of the design.

M HMXNCELL
: A .pm extension is assumed.
 
M PICTYPE
: Flavor of pic to use.

M HPICTYPE
: The pic netlist changes depending on the stage of design processing.
: This parameter selects the stage to use.

M P_MSG
: PIC

M HP_MSG
: generic pic cells (.p)

M P_FGMAPS_MSG
: PIC_FGMAPS

M HP_FGMAPS_MSG
: after fgmap.  FMAPs and HMAPs replaced by function generators (.pp)

M P_FGS_MSG
: PIC_FGS

M HP_FGS_MSG
: after fgmake.  Primitives replaced by function generators (.pb)

M P_MAP_MSG
: PICMAP

M HP_MAP_MSG
: after mdmake - picmap cells (.pm)

M SHOWGRAPH
: Display whole graph?

M HSHOWGRAPH
: When TRUE, exhaustive information on the netlist, as it appears in "graph"
: form, is printed to the terminal and log file.  The graph is displayed by
: node, with each outgoing arc of each node on its own line.

M MTEST
: Produce .tst file?

M HTEST
: Set this TRUE when running tests of the tspec package.  An extra log file,
: like tspec.log, is then produced, but without the material
: at the beginning (e.g., startup messages) and end (e.g., memory usage).
: That material can vary when the development system changes,
: even when the tspec functionality does not change.

# ============================================================
# "Alert" Messages (program stops).
# ============================================================

M UNKNOWN_PTYPE -e6803
> ptype d
> instance z
: Instance [instance] has unrecognized type ([ptype]).

M BAD_ARC_DIRECTION_TO_REPORT
> direction s
: Bad direction ([direction]) passed to function delete_bad_pad_arc.

M LABEL_NEQ_UNLABELED
> label d
> unlabeled d
: Count became inconsistent during labeling.  Final label = [label].
: Count of unlabeled nodes = [unlabeled].

M BAD_TOPOLOGICAL_SORT
: Topological sort failed; quit!

M BAD_PADS
: Bogus io pads; quit!

# ============================================================
# Error Messages
# ============================================================

M INPUT_WITH_TRISTATE
> name z
> net z
: Input pad [name] has its T pin driven, by net [net].
 
M NO_IO_PINS -e6804
> name z
: --- Neither I pin nor O pin was used on pad [name].

M ALREADY_VISITED
> instance z
: Instance [instance] has already been visited.  Will not run top_level topo.

M INCONSISTENT_ARRAY_INDEX -e6805
> index d
> type s
: Inconsistent array index (= [index]) for [type].

M BADLY_SORTED_ARC -e6806
> from_inst z
> from_label d
> to_inst z
> to_label d
: Bad arc direction: from [from_inst] (label [from_label]) to
: [to_inst] (label [to_label]).

M UNUSED_CLOCKPINS -w6807
: No net is attached to the clock pins of some clockable elements.  These elements
: are indicated below by the nets that they drive:

M UNUSED_CLOCKPIN
> driven_net z
: [driven_net]

# ============================================================
# Warning Messages
# ============================================================

M BOGUS_INTERNAL_REALLY_INPUT -w6808
> name z
: Pad [name]
: --- Though marked "internal", the pad is the only source for the net
: it is in.  Will treat it as INPUT. 

M IGNORING_NET_INTO_BOGUS_PAD
> net_name z
: Net [net_name] drives a badly configured pad.  Path analysis will ignore
: that connection.

M IGNORING_NET_FROM_BOGUS_PAD
> net_name z
: Net [net_name] is driven by a badly configured pad.  Path analysis will ignore
: that connection.

M UNVISITED_NODE
> instance z
: Instance [instance] was not reached from any input.

M COUNT_UNVISITED_NODES
> count d
> plural s
: Total of [count] node[plural] not reached.  Check design!

M PADPIN_NAME_COLLISION -w6810
> user_pinname z
> nonpad_arch z
: Pin name [user_pinname] matches both a pad and a pin on a [nonpad_arch]
: instance.  By default, using the pad.

# ============================================================
# Informational and Other Messages
# ============================================================
M COMPUTE_SECTION
: (computing)

M MXN_SIZE
> ninsts  d3
> nffs    d3
> npads   d3
> nbidis  d3
> npins   d5
: Design contains
: [.br]   [ninsts] instances
: [.br]   [npads] pads, including [nbidis] bidirectionals.
: [.br]   [nffs] flip-flops
: [.br]   [npins] total pins

M GRAPH_SIZE
> nodes d
> arcs d
> clocked d
: Graph has [nodes] nodes ([clocked] clocked), [arcs] arcs.

M AN_INTERNAL_PAD
> padname z
: Pad [padname] is INTERNAL.

M FOUND_LOOP
> num_arcs d
: A loop of [num_arcs] source-to-load connections:

M ONE_ARC
> from_arch z5
> gate_name z-20
> netname z
: [from_arch] [gate_name] (Net [netname]) to

M HOME_AGAIN
: first gate again.[.br]

M INS_AND_OUTS
> inputs d
> outputs d
: [inputs] input pads, [outputs] outputs.

M NODE_DATA_HEADER
: ============================================================
: [.br] label type  name

M PRINT_NODE
> label d4
> arch_name  z
> inst_name z
> drivers z
> id    d
: [.br]([label]) [arch_name] [inst_name] [drivers]     (id=[id])

M PRINT_NODE_OUTARC
> pin_and_net  z30
> to_inst_label d4
> to_inst_name  z
> pinname	z
: [pin_and_net]   ([to_inst_label])
: [to_inst_name].[pinname]

M POWER_DRIVEN_NODES
> power_type s
> count d
: Symbols reachable only from [power_type] (ignored by path analysis): [count].

M POWER_LOAD_PINS
> load_pins d
> power_type s
: Load pins driven by [power_type]: [load_pins].

M POWER_PIN
> power_type s
> pinname z
: Pin [pinname] is driven by [power_type].

M PULLUP_NODES
> count d
: [count] nodes are pullups.

M CLOCK_OUT_ARCS
> c_arcs d
: Graph has [c_arcs] arcs out from clockable nodes.

M IGNORE_ARCS
> ignored d
: [ignored] source-to-load connections are ignored since they are either
: in purely combinational loops, or because of a timespec request.

M COMBINATIONAL_LOOPS -w6811
> number d
> loop_word s
: This design has [number] purely combinational [loop_word].  Such loops should
: be avoided.  If at all possible, please modify the design to eliminate
: all unclocked feedback paths.
:[.br][.br]To permit path analysis during design implementation, all
: loops will be broken by cutting out the last source-to-load connection.
: A consequence is that the analyzer will not account for ANY paths through
: that connection.  This may cause the final performance of your design
: to be sub-optimal.
:[.br][.br]You can instruct the path analyzer to cut out connections
: of your choice, by using timespec "ignore" attributes.  For details,
: consult the PPR documentation.
: [.br]

M NOT_ALL_LOOP_DETAILS_SHOWN
> total_arcs d
> max_arcs d
: A full report on all combinational loops would include [total_arcs]
: connections.  Since this exceeds the default maximum ([max_arcs]),
: only the number of source-to-load connections and the final connection
: in each loop will be reported.[.br]
: If you want all the details reported, add a line[.br]
: loop_report_max = L[.br]
: (where L is a number greater than [total_arcs]) to your xactinit.dat file.[.br]
: If instead you don't want ANY details reported, add the line:[.br]
: suppress_loop_details = true[.br]

M LAST_ARC
> from_arch z5
> gate_name z-20
> netname z
: [from_arch] [gate_name] (Net [netname])

M SHORT_LOOP_INTRO
> num_arcs d
: [num_arcs] connections:

M LOOP_SUMMARY
> total_arcs d
: The total of all source-to-load connections involved in all
: combinational loops is [total_arcs].

M MULTI_SOURCE_LOOPS
> multi_source_loops d
: [multi_source_loops] of the loops include connections on nets with multiple
: sources.  Details on these loops will not be displayed or counted.  If you
: want information about these loops, add the following line to your
: xactinit.dat file:[.br]
: show_multi_source_loops = true

M LOOP_HEADER
: The combinatorial loops found in this design are listed below.
: [.br]


E TSPEC
#
# ------------------ dly_tab.m ------------------ 
#
#@(#)dly_tab.m	6.4  1/22/94
 
 
B DLY_TAB
: Create delay tables
 
# Tool description (for program help)
M DESCRIPTION
: Create delay tables to be used by path delay driven tools
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
# and
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M PARTTYPE
: The parttype to be tested

M HPARTTYPE
: Specifies the die and the speed grade (for example, 4003pc84-5).

M DLY_TYPE
: Type of delay table to produce.

M HDLY_TYPE
: Specify 0 for optimistic delay table.(Default)[.br]
: Specify 1 for realistic delay table.

M SBLOCK
: The name of a clb block to use as net source.

M HSBLOCK
: E.g.: c3_7  specifies the name of a clb to be used as net source.

M SPIN
: List of clb source pin names.

M HSPIN
: The pin names are to be separated by comma.[.br]
: E.g.: X,Y    specify pin X and Y to be used as net source pins.

M LPIN1
: List of clb input pin names defining load pinset 1.

M HLPIN1
: The pin names are to be separated by comma.[.br]
: E.g.: F1,F2,F3,F4   specify pin F1,F2,F3,F4 as load pinset 1. 

M LPIN2
: List of clb input pin names defining load pinset 2.
 
M HLPIN2
: The pin names are to be separated by comma.[.br]
: E.g.: C1,C2,C3,C4   specify pin C1,C2,C3,C4 as load pinset 2. 
 
M OUT_STYLE
: In what format would you like the output presented?

M HOUT_STYLE
: The output can be presented in one or both of two forms - an (x,y) table
: of delays, in tenths of ns, displaying the arrival times at each block;
: a listing by belnode of the router's internal data at each block reached;
: or both.  The internal data are presented on the screen only - not
: in the log file.  This parameter is inactive (NO output is shown) when
: the "subtool" parameter is set to TRUE.

M TABLE
: tabular format

M HTABLE
: show (x,y) table of arrival delays.

M BELNODE
: belnode format

M HBELNODE
: show internal data.

M BOTH
: show both

M HBOTH
: both
: show both (x,y) table AND internal data. 

M WHICH_TABLES
: Print tables for which load pin sets?

M HWHICH_TABLES
: If out_style is not "belnode", a tabular output of delays is produced.
: Depending on the setting of which_tables, this will be done for the
: first load set, the second load set, or both.  Select 1 to show results
: for first set only, 2 for second set only, 3 for both.

M SUBTOOL
: Is dly_tab being called by a higher-level tool?

M HSUBTOOL
: If TRUE, dly_tab allocates two arrays for its delay results, and
: returns them to the calling tool.  If FALSE, it writes results
: to the screen instead.

# Error and Warning Messages

M E_BAD_TD
> funcname  s
> msg  s
: Unexpected TD ERROR detected by:"[funcname]"
: [.br]   "[msg]"[.br]
 
# Informational and Other Messages

M LAST_UPDATE
> date s
: [.br] Last update to dly_tab: [date]. [.br]
 
M A_Z_LINE
> message z
: [message]

M PIN_SET
> setnum d
: Delays, in tenths of ns, for load pin set [setnum]:

E DLY_TAB
#
# ------------------ mxtrans.m ------------------ 
#
# @(#)mxtrans.m	6.2  9/17/93
 
 
B MXTRANS -start1626 -end1635 -current1628

: MX translator data handler

# Error and Warning Messages
M BAD_OPEN_FILE -e1626
> fname s
: The file [fname] could not be opened.

M BAD_INIT_FILE -e1627
> fname s
: The mxtrans initialization file, [fname], is in the wrong format.

E MXTRANS
#
# ------------------ hm.m ------------------ 
#
# @(#)hm.m	6.1  12/2/92


B HM
: Hard Macro Data Handler

M FILE_NOT_FOUND
> filetype s
> filename s
: The [filetype] file "[filename]" was not
: found in any of the standard data file directories.

M FILE_OPEN_FAILED
> filetype s
> filename s
: The [filetype] file "[filename]" exists but could not
: be opened for some unknown reason.

M MWRITER_MXN_NOT_DEFINED
> cellname z
: The HM cell "[cellname]" cannot be written to yet because the related
: MXN cell has not yet been defined.

M MWRITER_MXN_ALREADY_DEFINED
> cellname z
: An attempt was made to define the MXN cell to be associated with the HM
: cell "[cellname]", but the HM cell already has an associated MXN cell.

M MWRITER_OBJECT_NOT_FOUND
> cellname   z
> objecttype s
> objectname s
: An attempt was made to reference the [objecttype] "[objectname]"
: which is not defined for the HM cell "[cellname]".

M MWRITER_ILLEGAL_EXTPIN
> cellname z
> pinname  s
> netnum   d
: The HM cell "[cellname]" contains an external pin definition
: ([pinname]=[netnum]) which is illegal.  Net [netnum] does not
: connect to belpin or pip which can be reached from outside the
: hard macro.

M MWRITER_NO_POSDATA
> cellname z
: The HM cell "[cellname]" contains no position information for
: the MXN instances and nets.


E HM
#
# ------------------ fgguide.m ------------------ 
#
# @(#)fgguide.m	6.5  1/25/94 


B FGGUIDE -start1601 -end1625 -current1603

: FGGUIDE Data Handler

# FGGUIDE file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M ILLEGAL_KEYWORD
: Illegal FGGUIDE keyword
M POSITIVE_INT_REQD
: Positive integer required
M STRING_REQD
: String of characters required
M NET_REQD
: Field specifying net name required
M OUTPUT_NET_REQD
: Field specifying output net name required
M PARENT_NET_REQD
: Field specifying parent net name required
M NO_DUPDATA_LINE
: Additional Dup data statement required
M NOT_DUP_LINE
: Only Dupdata or Dupend line is valid after Dup statement
M NOT_DCM_LINE
: Only Dcmdata or Dcmend line is valid after Dcm statement
M NO_DCMDATA_LINE
: Additional Dcm data statement required
M NO_DCM_END
: Dcm end statement required
M NO_DUP_END
: Dup end statement required
M SYNTAX_ERROR
: Illegal syntax
M BANG_REQD
: Bang (!) required to end statement
M TEXT_AFTER_BANG
: Text is not allowed after the Bang (!) end character
M DUP_OUT_OF_ORDER
: This statement must follow a Dup statement
M DCM_OUT_OF_ORDER
: This statement must follow a Dcm statement


M FILE_SYNTAX_ERROR
> errorname m
> linenumber d
> filename s
: Error -- [errorname][.br]
: on line [linenumber] of file [filename]

M LCA_FILE_SYNTAX_ERROR
> errorname m
> linenumber d
> filename s
: Error -- [errorname][.br]
: in System record FGG [linenumber] of file [filename]

M MEM_ERROR
> errorname m
: [errorname]


# FGGUIDE memory error messages
M MEM_READER_ERR
: Error in reading FGGUIDE structure from memory
M MEM_WRITER_ERR
: Error in writing FGGUIDE structure to memory
M DCM_ONET_EXISTS
: Dcm output netname already exists in memory
M DUP_ONET_EXISTS
: Dup output netname already exists in memory
M NO_DCMDATA_ACTIVE
: Dcmdata structure does not exist in memory
M NO_DCM_ACTIVE
: Dcm structure does not exist in memory
M NO_DUP_ACTIVE
: Dup structure does not exist in memory
M NO_DECODE_ACTIVE
: Decode structure does not exist in memory
M NO_IGNORE_ACTIVE
: Ignore structure does not exist in memory
M NO_DCM_INETS
: No Dcm input nets specified
M NO_DUP_INETS
: No Dup input nets specified
M NO_DCM_NUM
: No Dcm dcm_num specified
M NO_DUP_NUM
: No Dup dup_num specified
M INVALID_DECODE_SIDE
: Invalid Decode side number specified; must be 0-3
M PREV_DECODE_STILL_ACTIVE
: Previous Decode end statement never found; must finish previous Decode
M PREV_DUP_STILL_ACTIVE
: Previous Dup end statement never found; must finish previous Dup
M PREV_DCM_STILL_ACTIVE
: Previous Dcm end statement never found; must finish previous Dcm

M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ERROR_LIST -e1601 -w1602
> details z
: [details]

E FGGUIDE
#
# ------------------ lca.m ------------------ 
#
# @(#)lca.m	6.15  1/4/94


B LCA -start1576 -end1600 -current1586

: LCA Data Handler
# NOTE: If new messages are added to this file, MAX_ERROR (in lcap.h) must 
#       be changed to reflect the new number of messages.


# LCA file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown internal error number
M ILLEGAL_KEYWORD
: Illegal LCA keyword
M EARLY_EOF
: End of File reached prematurely
M POSITIVE_INT_REQD
: Positive integer required
M SIGNED_INT_REQD
: Signed integer required
M DATA_REQD
: Data required
M STRING_REQD
: String of characters required
M FLOAT_REQD
: Floating point number required
M NO_SPEED_LINE
: Speed statement not found
M PROGORDER_NOT_ON
: Programorder not ON
M VERSION_POSITION_ERROR
: Version statement must be the first non-comment statement of file
M INTNET_ERROR
: Block in Intnet statement is not previously defined, or the statement does not contain one of the following: {F, G, H, PAD, M, QY, QX}
M NPROGRAM_NET_ERROR
: Netname does not match previous ADDNET netname
M NPROG_NET_ERR2
: Netname is required in NProgram statement
M MISSING_HALF
: Second half of PIP or switch matrix pair required
M PIP_SYNTAX_ERROR
: Only the directionality is allowed after the pip pair
M NO_BASE_LINE
: Base statement missing from Editblk group
M NO_CONFIG_LINE
: Config statement missing from Editblk group
M NO_ENDBLK
: Endblk statement required
M NO_ENDPATH
: Endpath statement required
M NO_PATHNET_LINE
: Pathnet statement missing from Beginpath group
M MULT_PATHSPEC
: This net was used in multiple Beginpath statements
M ILLEGAL_TAG
: Illegal Config statement tag

M FILE_SYNTAX_ERROR -e1576 -w1577
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in LCA file:  [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]
: [.br]This is an internal error; please contact Xilinx support personnel.

# LCA memory error messages
M MEM_READER_ERR
: Error in reading LCA structure from memory
M MEM_WRITER_ERR
: Error in writing LCA structure to memory
M NETNAME_EXISTS
: Netname already exists in memory
M BLK_ERROR
: Block does not exist in memory
M UNKNOWN_BLOCK
: Unknown block type
M CONFIG_SYNTAX_ERROR
: Error in Config statement syntax
M PINNAME_EXISTS
: Pin already exists in memory
M NET_ERROR
: Net does not exist in memory
M PINNAME_ERROR
: Pin does not exist in memory
M ILLEGAL_RAMCFG
: Illegal Ramconfig statement data 
M ILLEGAL_NETNAME
: Illegal netname
M ILLEGAL_EQUATION
: Illegal Equation statement data
M CONFIG_MEM_WRITE_ERROR
: Error writing Config statement data 
M BASE_MEM_WRITE_ERROR
: Error writing Base statement data for this block 
M INTNET_BLK_ERROR
: Block specified in INTNET statement does not exist

M LCA_FILE_ERROR -e1578 -w1579
> errorname m
: [errorname] [.br]
: This statement must be present in LCA files older than version 2.  To
: eliminate this problem, open and save the file in XACT; this will
: update the file to version 2.

M NO_PROGORDER_LINE
: Programorder statement not found.

M MEM_ERROR -e1580 -w1581
> errorname m
: [errorname]
: [.br]This is an internal error; please contact Xilinx support personnel.

M MEM_WRITE_ERROR -e1582 -w1583
> errorname m
> name s
: Error in writing LCA data to memory: [.br]
: [errorname] [.br]
: Data: "[name]" 
: [.br]This is an internal error; please contact Xilinx support personnel.

M CANNOT_WRITE_TO_FILE -e1584 -w1585
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E LCA
#
# ------------------ artslib.m ------------------ 
#
#@(#)artslib.m	6.1  5/10/93
 
 
B ARTSLIB
: Architecture Specific Library Routines
 
# Tool description (for program help)
M DESCRIPTION
: Architecture Specific Library Routines
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M CELL
: The input filename containing a design to be routed.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HCELL
: Expected is a filename to be a PIC MAP file with Mxn information.

M LAST_UPDATE
> date s
: [.br] Last update to artslib: [date]. [.br]

M TECHNOLOGY_INFO
> blocks d
> nodes  d
> arcs   d
: # of tifblocks: [blocks]. [.br]
: # of mazenodes: [nodes]. [.br]
: # of  mazearcs: [arcs]. [.br]

M E_BAD_TD
> funcname  s
> msg  s
: Unexpected TD ERROR detected by:"[funcname]"
: [.br]   "[msg]"[.br]

E ARTSLIB
#
# ------------------ pic.m ------------------ 
#
# @(#)pic.m	6.3  4/7/94


B PIC -start1501 -end1550 -current1523
: Physical Implementation and Control File

# These message texts are used in the FILE_SYNTAX_ERROR message
M OPTIONAL
: Optional
M REQUIRED
: Required
M KEYWORD_REQUIRED
: Keyword Required
M COMMAND_REQUIRED
: Command Required
M SEMICOLON_REQUIRED
: Semicolon Required
M MODELNAME_REQUIRED
: Tif Model Name Required
M MODELVERSION_REQUIRED
: Tif Model Version Required
M INSTNAME_REQUIRED
: Mxn Instance Name Required
M NETNUMBER_REQUIRED
: Mxn Net Number Required
M BLOCKNUMBER_REQUIRED
: Block Number Required
M BLOCKNAME_REQUIRED
: Block Name Required
M BELINDEX_REQUIRED
: Bel Index Required
M BELDEFNAME_REQUIRED
: Beldef Name Required
M ARCINDEX_REQUIRED
: Belarc Index Required
M BELNODENAME_REQUIRED
: Belnode Name Required
M PIPINDEX_REQUIRED
: Pip Index Required
M SEGNAME_REQUIRED
: Segment Name Required

M FILE_SYNTAX_ERROR -e1501 -w1502
> errorname z
> filename  s
> linenum   d
> fileline  s
> lineptr   z
: Error in PIC file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_MXN_NOT_DEFINED -e1503 -w1504
> cellname z
: The PIC cell "[cellname]" cannot be written to because the related
: MXN cell has not been defined.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_TIF_NOT_DEFINED -e1505 -w1506
> cellname z
: The PIC cell "[cellname]" cannot be written to because the related
: Tif model has not been defined.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_MXN_ALREADY_DEFINED -e1507 -w1508
> cellname z
: An attempt was made to define the MXN cell associated with the PIC 
: cell "[cellname]", but the PIC cell already has an associated MXN cell.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_TIF_ALREADY_DEFINED -e1509 -w1510
> cellname z
: An attempt was made to define the Tif model associated with the PIC 
: cell "[cellname]", but PIC cell already has an associated Tif model.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_OBJECT_NOT_FOUND -e1511 -w1512
> cellname   z
> objecttype s
> objectname s
> objectid   s
: An attempt was made to reference a [objecttype] named "[objectname]"
: [objectid] which is not defined for the PIC cell "[cellname]".
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_OBJECT_USED -e1513 -w1514
> cellname  z
> conttype  s
> contname  s
> newfiller s
> oldfiller s
: An attempt was made to add [newfiller] to the [conttype] named "[contname]"
: in the PIC cell "[cellname]".  This [conttype] already contains 
: "[oldfiller]".
: [.br]This is an internal error; please contact Xilinx support personnel.

M FWRITER_MXN_NOT_DEFINED -e1515 -w1516
> filename z
: The PIC part of the PIC file "[filename]" cannot be written to 
: because the related MXN cell has not been defined.
: [.br]This is an internal error; please contact Xilinx support personnel.

M FWRITER_MXN_ALREADY_DEFINED -e1517 -w1518
> filename z
: An attempt was made to define the MXN cell associated with the PIC 
: file "[filename]", but the MXN part of the file has already been written.
: [.br]This is an internal error; please contact Xilinx support personnel.

M FWRITER_TIF_TOO_LATE -e1519 -w1520
> filename z
: An attempt was made to define the TIF model in the PIC file "[filename]",
: but the portion of the PIC file that contains the TIF MODEL has already been 
: written.
: [.br]This is an internal error; please contact Xilinx support personnel.

M CANNOT_WRITE_TO_FILE -e1521 -w1522
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E PIC
#
# ------------------ carry.m ------------------ 
#
# @(#)carry.m	6.4 9/17/93


B CARRY -start1451 -end1475 -current1453

: CARRY Data Reader

# Carry4k.xct file reader error messages
M CANT_OPEN_FILE
: Cannot open carry4k.xct file.[.br]

M EMPTY_FILE
: No data lines found in carry4k.xct file.[.br]

M NO_VERSION
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: Required Version line not found at beginning of carry4k.xct file.[.br]
: Instead found line: 
: [.br]   [line][.br]

M VERS_NOT_SUPPORTED
> version s
: The syntax version [version] is not supported by the Carry Reader.[.br]

M END_MISSING
> mode s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: The End statement was not found for carrymode '[mode]'[.br]

M NO_DRC_TAG
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: Required drc_tag statement not found; instead found line:
: [.br]   [line][.br]

M SYNTAX_ERROR
> line s
> linenum d
: Syntax Error found on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]

M MULT_LINE
> line s
> linenum d
> keyword s
: Error on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]
: [keyword] statement already read in for this carrymode.[.br]

M CARRY_ERRORS -e1451 -w1452
> details z
: [details]

M DRC_TAG_ERROR
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]
: This drc_flags statement has more responses than tag:settings (as defined
: in drc_tags statement).[.br]

M DRC_TABLE_OVERFLOW
: Internal error:  DRC table overflow; increase DRC_INDEX_SIZE constant.[.br]

E CARRY
#
# ------------------ mxn.m ------------------ 
#
# @(#)mxn.m	6.2  9/17/93


B MXN -start1476 -end1500 -current1484

: MXN Data Handler

# MXN file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown Internal Error Number
M ILLEGAL_KEYWORD
: Illegal MXN Keyword
M SEMICOLON_REQD
: Semicolon Required
M POSITIVE_INT_REQD
: Positive Integer Required
M INT_REQD
: Integer Required
M STRING_REQD
: String Of Characters Required
M QSTRING_REQD
: Quoted string of Characters Required
M ATTRIB_REQD
: Attribute String Of Characters Required
M ILLEGAL_MXN_NAME
: Illegal MXN name
M EQUAL_REQD
: Equal sign '=' required after this attribute
M ILLEGAL_GLOBAL
: Illegal global signal name must be VCC, GND, or RESET

M FILE_SYNTAX_ERROR -e1476 -w1477
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in MXN file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]

# MXN memory error messages
M MEM_READER_ERR
: Error in reading MXN structure from memory
M MEM_WRITER_ERR
: Error in writing MXN structure to memory

M MEM_ERROR -e1478 -w1479
> errorname m
: [errorname]

# MXN memory writer error message that deal with potential error in MXN file
M PRIM_DNE
: primitive cell library does not exist.
M NO_PRIM_ARCH
: primitive archetype is not in the primitive cell library.
M NETNAME_EXISTS
: net name has already been used, must use a unique net name.
M INST_EXISTS
: Instance has been previously defined.
M EXTPIN_EXISTS
: external pin reference has been previously defined.
M ARCH_EXISTS
: Archetype has been previously defined.
M TOOMANY_APINS
: Archetype has too many pins for its Cell library definition.
M TOOMANY_IPINS
: Instance has too many pins for its Archetype definition.

M MEM_FILE_CONFLICT -e1480 -w1481
> errorname m
> name s
: Error in writing MXN structure to memory: [.br]
: The "[name]" [errorname]

M CANNOT_WRITE_TO_FILE -e1482 -w1483
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E MXN
#
# ------------------ xnf.m ------------------ 
#
# @(#)xnf.m	6.13  1/14/94


B XNF -start1301 -end1350 -current1315
: Xnf Data Handler

#
# These are message phrases used for syntax errors
#
M SYNTAX_UNK
: Unknown error found 
M SYNTAX_PRN
: A program name is required
M SYNTAX_PAT
: A parttype is required
M SYNTAX_SYN
: A symbol name is required
M SYNTAX_STN
: A symbol type name is required
M SYNTAX_PIN
: A pin name is required
M SYNTAX_PID
: A pin direction character is required
M SYNTAX_SIN
: A signal name is required
M SYNTAX_IPN
: An input pin name is required
M SYNTAX_CPN
: A clock pin name is required
M SYNTAX_CLE
: A clock edge character is required
M SYNTAX_CLP
: A clock polarity character is required
M SYNTAX_PUW
: A pulse width value is required
M SYNTAX_BUN
: A bus name is required
M SYNTAX_PWP
: A power polarity character is required
M SYNTAX_ESD
: An external record signal direction character is required
M SYNTAX_PPN
: Package pin name is required
M SYNTAX_SET
: A setup up time value is required
M SYNTAX_HLD
: A hold time value is required
M SYNTAX_MLR
: The LCANET record is required
M SYNTAX_BRT
: Unrecognized record type found
M SYNTAX_V4R
: Lcanet version 4 is required (Run xnfupd to convert your design)
M SYNTAX_ILV
: Illegal LOC value found
M SYNTAX_LSV
: No value is specified for LOC parameter
M SYNTAX_INT
: An integer is required
M SYNTAX_CHR
: Character is required
M SYNTAX_STR
: A character string is required
M SYNTAX_FLT
: A floating point number is required
M SYNTAX_DLY
: Delay numbers are required
M SYNTAX_BDN
: Illegal delay number specification found
M SYNTAX_COM
: A comma is required
M SYNTAX_EOL
: End of line is required
M SYNTAX_EOF
: End of File is required
M SYNTAX_ERROR 
> errorname m
> linenumber d
> filename s
: [errorname]
: on line [linenumber] of file [filename]:

# 
# These are message phrases used for semantic errors
#
M BADPARTTYPE
> parttype s
: Unrecognized parttype '[parttype]'
M MULTIPLESYM
> symname s
: Multiple symbols exist with the name '[symname]'
M MULTIPLEPIN
> symname s
> pinname s
: The symbol '[symname]' contains multiple pins with the name '[pinname]'
M MULTIPLEBUS
> busname s
: Multiple busses exist with the name '[busname]'
M MULTIPLEEXT
> pinnum s
> signame s
: Multiple Ext-records exist with the same signal '[signame]' or package
: pin name '[pinnum]'
M MULTIPLEEXT2
> signame s
: Multiple Ext-records exist with the same signal '[signame]'
M MULTIPLEHIERG
> hier_id d
> sym_name s
: Multiple Hierg-records exist for hier_id '[hier_id]', sym_name '[sym_name]'
M INSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal between SYM and END records
M RECORD_OUT_OF_PLACE
> record s
: The '[record]' record is illegal outside of SYM and END records
M NOSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal outside of SYM and END records
M BADSETUPEDGE
> inname s
> clkname s
> edge s
: The 'SETUP, [inname], [clkname]' record has an illegal clock edge value '[edge]'
M MULTIPLEPOLARITY
> signame s
: The signal '[signame]' is both GND and VCC
M BADPOWERPOLARITY
> signame s
> polarity s
: The PWR record for signal '[signame]' has an illegal polarity value '[polarity]'
M BADPULSEPOLARITY
> symname s
> pinname s
> polarity s
: The 'PULSE,[pinname]' record in symbol [symname] has an illegal polarity
: value '[polarity]'
M BADEXTDIR
> signame s
> dir s
: The 'EXT, [signame]' record has an illegal direction value '[dir]'
M BADPINDIR
> symname s
> pinname s
> dir s
: The pin [pinname] in symbol '[symname]' has an illegal direction value '[dir]'
M NO_PARAM_VALUE
> rectype s
> recname s
> namevalue s
: The [rectype] '[recname]' contains a parameter '[namevalue]' with no value
: specified
M MULTIPLEPARAM
> rectype s
> recname s
> name s
: The [rectype] '[recname]' contains multiple '[name]' parameters 
M INVALID_SYMBOL_PIN
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' is not a legal pin for this type of
: symbol
M INVALID_PIN_INV
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' cannot be legally inverted
M INVALID_EXT_PARAM
> ext  s
> param s
: The PAD '[ext]' has an illegal parameter with the name '[param]'
M CONFLICT_EXT_PARAM
> ext  s
> param s
> conflict_param s
: PAD '[ext]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SIG_PARAM
> sig  s
> param s
: The signal '[sig]' has an illegal parameter with the name '[param]'
M CONFLICT_SYM_PARAM
> symbol  s
> param s
> conflict_param s
: Symbol '[symbol]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SYM_PARAM
> symbol  s
> param s
: The symbol '[symbol]' has an illegal parameter with the name '[param]'
M INVALID_PIN_PARAM
> pinname s
> symbol  s
> param s
: The '[pinname]' pin on symbol '[symbol]' has an illegal parameter with
: the name '[param]'
M MULTPARTTYPES
> part1 s
> part2 s
: The design network contains multiple parttypes - [part1] and [part2]
M UNKNOWNPIN
> rectype s
> pinname s
: The [rectype] record refers to an undefined pin '[pinname]'
M ILLEGAL_BOOLEAN
> sym s
> numpins d
> numarchpins d
: The symbol '[sym]' has [numpins] input pins specified; only
: [numarchpins] input pins are allowed on this type Boolean gate. 
M MODEL
> rectype s
: The [rectype] record is illegal record outside of MODEL and ENDMOD records
M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write to file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.
M MISSINGPARAM
> symname s
> symtype s
> paramname s
: The [symtype] symbol '[symname]' is missing the required [paramname] parameter

M INVALID_SIG_NAMES
> siglist s
: The following signals have illegal names:[.br]
: [siglist]
M INVALID_SYM_NAMES
> symlist s
: The following symbols have illegal names:[.br]
: [symlist]
M TOOMANY
> errlimit d
: The number of errors exceeds [errlimit], bailing out prematurely
M WOOPS
> namevalue s
> rectype s
: [namevalue] specified without an active [rectype]
M SEMANTIC_ERROR
> error z
: [error][.br]
M SEMANTIC_ERROR_LOCATION
> error z
> linenum d
> filename s
: [error][.br]
: near line [linenum] of file [filename].

M VALIDITY_NO_ARCH
: The Design Validity Check cannot be implemented because no archfile or
: parttype can be found.

M ERROR_LIST -e1303 -w1304
> filename s
> details z
: The following problem(s) were found in the [filename] file; 
: the file could not be processed successfully.[.br]
: [.br][details]

M VALIDITY_ERRORS -e1305 -w1306
> details z
: [details]

#
# These errors are used for loading xnf archtype data files
#
M CHECKS_PARTTYPE -e1307 -w1308
> designname s
: The parttype for the [designname] design is missing so we cannot perform
: the checks related to legal symbols, pins, parameters, etc.

M CHECKS_UNKNOWN_DATAFILE -e1309 -w1310
> designname s
> parttype s
: The [designname] design is for a parttype called "[parttype]".  We do not
: know which archtype data file we should read for that parttype.  We have
: to read an archtype data file so that we can perform the checks 
: related to legal symbols, pins, parameters, etc.  We are unable, therefore,
: to perform these types of checks.

M CHECKS_NO_DATAFILE -e1311 -w1312
> designname s
> datafilename s
: The [datafilename] data file (which we need to read so that we can perform the
: checks related to legal symbols, pins, parameters, etc. on the [designname]
: design) does not exist in the $XACT/data directory.  We therefore cannot
: perform these types of checks.

M CHECKS_DATAFILE_ERROR -e1313 -w1314
> designname s
> datafilename s
: We encountered problems while reading the [datafilename] data file.  We
: have to read this file so that we can perform the checks related to legal 
: symbols, pins, parameters, etc. in the [designname] design.  We therefore
: cannot perform these types of checks.

E XNF
#
# ------------------ tif.m ------------------ 
#
# @(#)tif.m	6.4 12/8/93
##############################################################################
# Message file for Technology Interface
##############################################################################
 
 
B TIF -start1401 -end1450 -current1410
: Technology Interface
 
M NO_SUCH_DEVICE -e1401
> basename s
> extension s
: Cannot find the technology description file '[basename].[extension]'.
M TD_FILE_TROUBLE
> filename s
: Encountered a problem opening file '[filename]'.
M SYNTAX_ERROR
> file s
> line d
> type s
> text s
: [file]([line]): [type] near '[text]'.
M SEMANTIC_ERROR -e1402
> location s
> text s
: [location]: [text]
M EXTRA_LOC -w1403
> location s
: Extra Location statement '[location]' ignored.
M BUILD_ERROR
> text s
: Model building failed: [text]
M CHECK_FAILED
> text s
: Consistency check failed: [text].
M TEXT
> text s
: [text]
M NO_SUCH_FILE -e1404 -w1405
> filename s
: Unable to find file '[filename]',[.br]
: no package bonding info in the TIF model.
M NO_PKG_INFO -e1406 -w1407
> modelname s
> filename s
: No info for package [modelname] in file '[filename]'.
: [.br]Package and bonding info are missing from technology description.
M SPEED_GRADE_ERROR -e1408
> modelname s
> spdgrade s 
: '[spdgrade]' is not a valid speed grade for part '[modelname]' [.br]
: Please check the data book for the correct speed grades.
M SPEED_FILE_TROUBLE -e1409
: Encountered a problem opening speed file .

E TIF
#
# ------------------ prim.m ------------------ 
#
# @(#)prim.m	6.2  9/17/93


B PRIM -start1376 -end1400 -current1382

: Prim Data Handler

# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown Internal Error Number
M PUNC_REQD
: Punctuation Required
M INT_REQD
: Integer Required
M STRING_REQD
: String Of Characters Required
M BAD_COMBINATORIAL
: Combinatorial field must be either "Y" or "N".
M QSTRING_REQD
: Quoted String Of Characters Required
M BAD_PIN_DIRECTION
: The pin direction must be "I", "O", or "B".
M BAD_GATETYPE
: The gate type specified is illegal.

M FILE_SYNTAX_ERROR -e1376 -w1377
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in Prim file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]

M WRITE2FILE -e1378 -w1379
: Cannot write a PRIM cell to a file.  PRIM cells can only be read from a file 
: or memory.

M PRIMLIB_OPEN_FAILED -e1380 -w1381
: The `primlib.prm` data file could not be opened.  Check and make sure it
: has been installed in the proper directory.
E Cellib
#
# ------------------ mxtool.m ------------------ 
#
#@(#)mxtool.m	6.8  1/13/94


B MXTOOL -start1726 -end1800 -current1744
: Tool Interface

# These message texts are used in other messages
M TEXT_PARAMFILE
: parameter file
M TEXT_CMDLINE
: command line
M TEXT_ILLBOOLVAL
: Illegal boolean value must be {TRUE,FALSE}: 
M TEXT_ILLINTVAL
: Illegal integer value: 
M TEXT_ILLOPTVAL
: Illegal option name must be 
M TEXT_ILLFLTVAL
: Illegal floating point value: 
M TEXT_UNKPARAM
: Unknown parameter name: 
M TEXT_UNSETPARAM
: Parameter was not assigned a value: 
M TEXT_BADVALUE
: Parameter was assigned an illegal value: 
M TEXT_BADRANGE
: Parameter value is outside valid range: 
M TEXT_PARAMHEAP
: Param
M TEXT_RESULTHEAP
: Result
M TEXT_INTERNALHEAP
: Intern
M TEXT_OTHERHEAP
: Other
M TEXT_BLANK
:

# There messages are used to produce help text for the root tool
M LOGFILE
: The program log file name
M HLOGFILE
: You can use this parameter to specify an alternate name for the program
: log file.  The default value of the log file name is the program name 
: with a .log extension
M PARAMFILE
: The parameter file name
M HPARAMFILE
: You can use this parameter to specify a file name which contains
: program parameters.  Each program parameter should appear on a line
: by itself with its value separated by an equals sign,
: E.g., "logfile=foobar.log".  If a program parameter is specified
: on the command line as well as in the parameter file, the value from
: the command line will be used.  If you do not specify a parameter file, 
: all of the programs parameters are taken from the command line.
M HELPALL
: Show all help information
M HHELPALL
: You can type "-helpall" to this tool to get help for ALL its parameters.
: The default is not to show help for all parameters.  
M HELP_NOVICE
> programname s
: For help on how to use this program, type "[programname] -help"
M HELP_TITLE
> programname s
: [.br]HELP FOR [programname][.br]
M HELP_PARAMS
: [.br]PARAMETERS:[.br]
M HELP_PARAMNAME
> param_internal_name s
> param_external_name s
: [param_internal_name][param_external_name]
M HELP_PARAMHELP
> param_help_text s
: [param_help_text]
M HELP_BITS
> leftmargin s
: [leftmargin]This parameter may be assigned one or more of these bit values:
: [.br]
M HELP_VALUES
> leftmargin s
: [leftmargin]This parameter may be assigned one of these values:
: [.br]
M HELP_STRVALUE
> leftmargin s
: [leftmargin]This parameter takes a character string value.
M HELP_FLTVALUE
> leftmargin s
> lo g.6
> hi g.6
: [leftmargin]Takes a real value between [lo] and [hi], inclusive.
M HELP_BOOLVALUE
> leftmargin s
: [leftmargin]This parameter takes a boolean value {TRUE,FALSE}
M HELP_INTVALUE
> leftmargin s
> lo d
> hi d
: [leftmargin]Takes an integer value between [lo] and [hi], inclusive.
M HELP_PINTVALUE
> leftmargin s
: [leftmargin]Takes a positive integer value.
M HELP_NNINTVALUE
> leftmargin s
: [leftmargin]Takes a non-negative integer value.
M HELP_DEFVALUE
> leftmargin s
> default    z
: [leftmargin]The default value is [default].
M HELP_DEFNONE
> leftmargin s
: [leftmargin]You must specify a value; there is no default.

# ---------------------------------------------------------------------------
# These messages are written to the plog at program startup
M LOG_BANNER
> prog_name    s
> prog_version s
> prod_name    m
> year         s
: [prog_name] [[[prog_version]]  --  [prod_name][.br]
: Copyright (c) [year] Xilinx Inc.  All Rights Reserved.

M LOG_CONFIDENTIAL
: XILINX CONFIDENTIAL

M LOG_XACT
: Xilinx Automatic CAE Tools

M PROGRAM_ENV
: Program Envelope Parameters

M PROGRAM_ENVENTRY
> name  s-20
> value s
: [name] = [value]

# ---------------------------------------------------------------------------
# These messages are written to the plog at tool startup
M TOOL_NEW_SECTION
> toolname s
: [toolname]
M TOOL_PARAMETERS
: Parameters
M TOOL_USED_EXPERT_PARAMS
: Additional Specified or Non-Default Parameters 
M TOOL_PARAMVALUE
> paramname  s
> paramvalue s
: [paramname][paramvalue]
M TOOL_TRUE
: TRUE
M TOOL_FALSE
: FALSE
M TOOL_PARAMBAR
: -----------------------

# ---------------------------------------------------------------------------
# These messages are used by the debug routine mxtool_dump_tool_table
M TOOLDEF_TITLE
: Tool Definition Table
M TOOLDEF_HEADER
# ALIGN COLUMN HEADERS WITH OPEN BRACKET
# V         V            V    V        V
# [toolname][toolversion][off][partype][parametername]
: Toolname  Version      Off  Type     Parameter[.br]
: --------  -----------  ---  -------  ---------
M TOOLDEF_ENTRY
> toolname      s-10.10
> toolversion   s-13.10
> off           s3
> partype       s-9.9
> parametername s
# DONT MESS WITH THIS MESSAGE TEXT!
: [toolname][toolversion][off]  [partype][parametername]
M TOOLINST_TITLE
: Tool Instances Remaining
M TOOLINST_HEADER
# ALIGN HEADERS WITH OPEN BRACKETS
# V     V         V
# [in]  [toolname][toolcreator]
: ---------------------------[.br]
: Inst  Toolname  Toolcreator[.br]
: ----  --------  -----------
M TOOLINST_ENTRY
> in          d4
> toolname    s-10
> toolcreator s
: [in]  [toolname][toolcreator]
M TOOLINST_FOOTER
: ---------------------------

# ---------------------------------------------------------------------------
# These messages are used to create the memory usage table for debug purposes
M MEMUSAGE_TITLE1
> name s
: Memory Usage For Tool [name]
M MEMUSAGE_TITLE2
> name s
: Memory Usage For Program [name]
M MEMUSAGE_HEADER
# [heap]      [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
: --------------------------------------------------------------------------[.br]
: Heap         Total   Total  Static   Alloc   Guard  Unused    Free   Alloc[.br]
: Name       Nsegmts  Nbytes  Overhd  Overhd  Overhd  Nbytes  Nbytes  Nbytes[.br]
: ---------- ------- ------- ------- ------- ------- ------- ------- -------
M MEMUSAGE_ENTRY
> heap s-10.10
> nseg d4
> size d6
> sohd d6
> aohd d6
> gohd d6
> unnb d6
> frnb d6
> alnb d6
: [heap]    [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
M MEMUSAGE_FOOTER
: --------------------------------------------------------------------------
M MEMUSAGE_MAX
> pgmname s
> nkbytes f.3
: [pgmname] required [[[nkbytes]] Kbytes of dynamic/allocated memory

# ---------------------------------------------------------------------------
# These are WARNING messages of various sorts
M PARAM_OBSOLETE_NEXT_RELEASE -w1726
: The "param=" syntax you used on the command line will become obsolete
: next release.  You should replace it with "paramfile="

M PARAM_IGNORED -w1727
: The "param=" syntax on the command line is being ignored since you
: have also specified the parameter file name using the "paramfile=" syntax

M PLOG_OBSOLETE_NEXT_RELEASE -w1728
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" syntax from the [paramsource] will become obsolete
: next release.  You should replace it with "logfile="

M PLOG_IGNORED -w1729
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" specification from the [paramsource] is being ignored since
: you have also specified the log file name using the "logfile=" syntax

# ---------------------------------------------------------------------------
# These are ERROR messages of various sorts
M PARAM_DECL_OFFSET -e1730
> toolname  s
> paramname s
> offset    d
> paramsize d
: Tool parameter declaration offset is illegal[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, but the parameter structure size[.br]
: is only [paramsize] bytes.  Something must be very, very wrong.

M PARAM_DECL_OVERLAP -e1731
> toolname  s
> paramname s
> offset    d
> index     d
: Tool parameter declaration overlaps another[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, which overlaps another parameter[.br]
: at an offset of [index] bytes.  Check your calls to tool_decl_* in[.br]
: the husk module of [toolname].  You have probably have the same parameter[.br]
: name in more than one of the tool_decl_* routine.

M PARAM_ERROR -e1732
> paramsource s # the TEXT_CMDLINE or TEXT_PARAMFILE message text
> theErrors   s
: The [paramsource] contains parameter assignment errors:[theErrors]

M PARAM_ERROR_MAINTOOL -e1733
> theTool   s
> theErrors s
: The [theTool] program detected parameter value errors:[theErrors]

M PARAM_ERROR_SUBTOOL -e1734
> currenttool s
> parenttool  s
> theErrors   s
: The [currenttool] tool, invoked from [parenttool],
: detected parameter value errors:[theErrors]

M PARAM_TOOMANY -e1735
> nspecified d
> ndefined   d
: The command line contains [nspecified] positional parameters,[.br]
: but the program only needs [ndefined] parameters.

M BAD_DASH_PARAM -e1736
> param z
: The command line parameter, '[param]', is a non-boolean '-' parameter.  Only
: boolean parameter can be specified using the '-' feature, where 
: '-<parameter>' is the equivalent of TRUE and '-NO<parameter>' is the 
: equivalent of FALSE.

M INSTANCE_MISMATCH -e1737
> instancenumber d
> instancename   s
> tooldefname    s
: Tool instance - tool definition mismatch[.br]
: Tool instance #[instancenumber] is not an instance of "[tooldefname]"[.br]
: but rather an instance of "[instancename]"

M INSTANCE_ILLEGAL -e1738
> instancenumber d
: Illegal tool instance number[.br]
: Tool instance #[instancenumber] does not refer to a valid tool

M PFILE_OPEN_FAILED -e1739
> filename s
: The parameter file "[filename]" could not be opened for input

M MISSING_VALUE -e1740
> paramname s
: The command line parameter named "[paramname]"[.br]
: must be followed by an equals sign and a value

M ILLEGAL_PARAMNAME -e1741
> paramname s
: An illegal program parameter name "[paramname]"[.br]
: is used on the command line

M PLOG_OPEN_FAILED -e1742
> filename s
: The program log file "[filename]"[.br]
: could not be opened for output

M ILLEGAL_OPTIONNAME -e1743
> optionname s
: An illegal option parameter name "[optionname]"[.br]
: is used on the command line

E MXTOOL
#
# ------------------ dm.m ------------------ 
#
# @(#)dm.m	6.5  2/2/94


B DM -start1161 -end1200 -current1187
: Data Manager 

M CANNOT_WRITE_TO_FILE -e1161 -w1162
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ADDHISTORY_FAILED -e1163 -w1164
> cellname z
> celltype s
: A history description could not be appended to the [celltype] cell
: "[cellname]" because it is a READONLY cell

M CLRHISTORY_FAILED -e1165 -w1166
> cellname z
> celltype s
: The history descriptions of the [celltype] cell "[cellname]" could not be
: cleared because it is a READONLY cell

M CLEAR_FAILED_RDONLY -e1167 -w1168
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be cleared because it is a
: READONLY cell

#M CLEAR_FAILED -e -w
#> cellname z
#> celltype s
#: The [celltype] cell "[cellname]" could not be cleared because it is
#: locked in memory

M DELETE_FAILED -e1169 -w1170
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be deleted because it is
: locked in memory

M FILE_ACCESS -e1171 -w1172
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: exists, but could not be opened

M FILE_MISSING -e1173 -w1174
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be found.

M FILE_OPEN_FAILED -e1175 -w1176
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be opened

M HEADER_CELLTYPENAME -e1177 -w1178
> cellname z
> filename z
> celltype s
: The type of the cell "[cellname]" associated with the file "[filename]"
: does not correspond to the expected "[celltype]" type.

M HEADER_ERROR -e1179 -w1180
> cellname z
> filename z
> celltype s
: The file "[filename]" for the [celltype] cell "[cellname]" contains an
: illegal header

M NAME_FAILED -e1181 -w1182
> cellname z
> newname  s
> celltype s
: The [celltype] cell "[cellname]" could not be renamed to "[newname]"
: because a [celltype] cell named "[newname]" already exists

M TYPE_FAILED -e1183 -w1184
> typename s
> cellname z
: The type of cell "[cellname]" could not be changed to "[typename]"
: because a cell of that name/type already exists

M NEWCELL_FAILED -e1185 -w1186
> cellname s
> celltype s
: The [celltype] cell "[cellname]" could not be created because a cell of
: that type and name already exists

#
# Data Manager Messages
#
M SAVECELL_SECTION
: Data Manager Auto Save

M SAVECELL
> cellname z
> typename s
: Saving [typename] cell "[cellname]"

M LOCKCOUNT_SECTION
: Data Manager Cell Lock Counts

M LOCKCOUNT
> cellname z-10
> typename s-10
> lockcount d2
: [cellname] [typename] [lockcount]

E DM




#
# ------------------ mxpart.m ------------------ 
#
#@(#)mxpart.m	6.2 9/3/93

B MXPART -start1131 -end1160 -current1148
: File reader for partlist.xct file and <package>.pkg files

M CANT_OPEN_FILE -e1131 -w1132
> filename s
: Cannot open file '[filename]' for reading.

M NO_PKG -e1133 -w1134
> part s
> filename s
: The part '[part]' could not be found in the file '[filename]'.

M BAD_ATTRIB_VALUE -e1135 -w1136
> partname s
> filename s
: The attribute list (name=value entries) for the part '[partname]' in the
: file '[filename]' has the wrong format.

M ILLEGAL_PKG_KEYWORD -e1137 -w1138
> value s
: Illegal keyword '[value]' exists in the .pkg file.
 
M DUP_PAD_DEF_IN_PKG -e1139
> pad s
: Duplicate definition of PAD '[pad]'.

M DUP_PIN_DEF_IN_PKG -e1140
> pin s
: Duplicate definition of PIN '[pin]'.

M PAD_NUM_OUT_OF_RANGE -e1141
> pad s
: Pad number '[pad]' is out of range.

M BAD_PAD_NUM -e1142
> pad s
: Bad pad number '[pad]'. Should be in the form: PAD<number>.

M WRONG_ATTR_VALUE -e1143
> value s
> chk_value s
: Attribute value '[value]' does not match check value '[chk_value]'.

M ILLEGAL_FAMILY -e1144
> family d
: Not a legal family '[family]'.

M ILLEGAL_FAMILY_ATTR -e1145
> attrib s
> family d 
: Not a legal attribute '[attrib]' for this family '[family]'.

M BAD_ROWCOL -e1146
: Not and integer value for clb row|cols number.

M CLK_BUF -e1147
> pad s
> padn d
: Clock Buffer using '[pad]' should use 'PAD[padn]'.

E MXPART
#
# ------------------ speed.m ------------------ 
#
#@(#)speed.m	6.4  9/3/93

B SPEED -start 1101 -end1130 -current14
: File reader for speeds.xct file 

M CANT_OPEN_FILE -e0 -w1
> filename s
: Cannot open file '[filename]' for reading.

M FILE_CORRUPTED -e2 -w3
> filename s
: The speeds file '[filename]' has been corrupted and cannot be read.

M CANT_READ_FILE -e4 -w5
> filename s
: The unencrypted speeds file '[filename]' cannot be read.

M BAD_PARTLIST_FILE -e6 -w7
: The partlist.xct file does not contain the correct information.

M UNKNOWN_SPEED_AND_PART -e8 -w9
> speed s
> part s
: The speed '[speed]' is unavailable for part '[part]'.

M BAD_VERSION -e10 -w11
> filename s
> badversion s
> version s
: The '[filename]' file has a bad version, '[badversion]'.
: The version of file must be '[version]'.

M SYNTAX_ERROR -e12 -w13
> filename s
: There is a syntax error in the '[filename]' speeds file.

E SPEED
