------------------------------------------------------------------------
------------------------------------------------------------------------
--                                                                    --
--                       package standard                             --
--                                                                    --
-- Contents:             Standard type and subprogram declarations.   --
--                       See the VHDL reference manual for a complete --
--                       explanation of these types and functions.    --
--                                                                    --
-- Exported types:       boolean                                      --
--                       vlbit                                        --
--                       character                                    --
--                       boolean_1d                                   --
--                       boolean_2d                                   --
--                       vlbit_1d                                     --
--                       vlbit_2d                                     --
--                       character_1d                                 --
--                       character_2d                                 --
--                       integer_1d                                   --
--                       integer_2d                                   --
--                       time_1d                                      --
--                       time_2d                                      --
--                       string                                       --
--                       vlbit_vector                                 --
--                                                                    --
-- Exported functions:   addum                                        --
--                       add2c                                        --
--                       comp2c                                       --
--                       divum                                        --
--                       div2c                                        --
--                       extendum                                     --
--                       extend2c                                     --
--                       mulum                                        --
--                       mul2c                                        --
--                       shiftlum                                     --
--                       shiftl2c                                     --
--                       shiftrum                                     --
--                       shiftr2c                                     --
--                       subum                                        --
--                       sub2c                                        --
--                       int2vlb                                      --
--                       boo2vlb                                      --
--                       vlb2boo                                      --
--                       int2boo                                      --
--                       vlb2int                                      --
--                       boo2int                                      --
--                       int2v1d                                      --
--                       int2v1d                                      --
--                       v1d2int                                      --
--                                                                    --
-- Revision:             1.0                                          --
--                                                                    --
-- Copyright (C) 1988, 1989 Viewlogic Systems, Inc.                   --
--                                                                    --
------------------------------------------------------------------------
------------------------------------------------------------------------

package standard is

   type boolean      is (false, true);
   type vlbit        is ('X', 'Z', '0', '1');
   type character    is (
        NUL,   SOH,   STX,   ETX,   EOT,   ENQ,   ACK,   BEL,
        BS,    HT,    LF,    VT,    FF,    CR,    SO,    SI,
        DLE,   DC1,   DC2,   DC3,   DC4,   NAK,   SYN,   ETB,
        CAN,   EM,    SUB,   ESC,   FSP,   GSP,   RSP,   USP,
        ' ',   '!',   '"',   '#',   '$',   '%',   '&',   ''',
        '(',   ')',   '*',   '+',   ',',   '-',   '.',   '/',
        '0',   '1',   '2',   '3',   '4',   '5',   '6',   '7',
        '8',   '9',   ':',   ';',   '<',   '=',   '>',   '?',
        '@',   'A',   'B',   'C',   'D',   'E',   'F',   'G',
        'H',   'I',   'J',   'K',   'L',   'M',   'N',   'O',
        'P',   'Q',   'R',   'S',   'T',   'U',   'V',   'W',
        'X',   'Y',   'Z',   '[',   '\',   ']',   '^',   '_',
        '`',   'a',   'b',   'c',   'd',   'e',   'f',   'g',
        'h',   'i',   'j',   'k',   'l',   'm',   'n',   'o',
        'p',   'q',   'r',   's',   't',   'u',   'v',   'w',
        'x',   'y',   'z',   '{',   '|',   '}',   '~',   DEL);

   type boolean_1d   is array (integer range <>)
                     of boolean;
   type boolean_2d   is array (integer range <>, integer range <>)
                     of boolean;
   type vlbit_1d     is array (integer range <>)
                     of vlbit;
   type vlbit_2d     is array (integer range <>, integer range <>)
                     of vlbit;
   type character_1d is array (integer range <>)
                     of character;
   type character_2d is array (integer range <>, integer range <>)
                     of character;
   type integer_1d   is array (integer range <>)
                     of integer;
   type integer_2d   is array (integer range <>, integer range <>)
                     of integer;
   type time_1d      is array (integer range <>)
                     of time;
   type time_2d      is array (integer range <>, integer range <>)
                     of time;
   type string       is array (integer range <>)
                     of character;
   type vlbit_vector is array (integer range <>)
                     of vlbit;

   function addum             (v1, v2: vlbit_1d)             return vlbit_1d;
   function add2c             (v1, v2: vlbit_1d)             return vlbit_1d;
   function comp2c            (v:      vlbit_1d)             return vlbit_1d;
   function divum             (v1, v2: vlbit_1d)             return vlbit_1d;
   function div2c             (v1, v2: vlbit_1d)             return vlbit_1d;
   function extendum          (v: vlbit_1d; i: integer)      return vlbit_1d;
   function extend2c          (v: vlbit_1d; i: integer)      return vlbit_1d;
   function mulum             (v1, v2: vlbit_1d)             return vlbit_1d;
   function mul2c             (v1, v2: vlbit_1d)             return vlbit_1d;
   function shiftlum          (v:      vlbit_1d; i: integer) return vlbit_1d;
   function shiftl2c          (v:      vlbit_1d; i: integer) return vlbit_1d;
   function shiftrum          (v:      vlbit_1d; i: integer) return vlbit_1d;
   function shiftr2c          (v:      vlbit_1d; i: integer) return vlbit_1d;
   function subum             (v1, v2: vlbit_1d)             return vlbit_1d;
   function sub2c             (v1, v2: vlbit_1d)             return vlbit_1d;

   function int2vlb           (i: integer) return vlbit;
   function boo2vlb           (b: boolean) return vlbit;
   function vlb2boo           (v: vlbit)   return boolean;
   function int2boo           (i: integer) return boolean;
   function vlb2int           (v: vlbit)   return integer;
   function boo2int           (b: boolean) return integer;

   function int2vec           (i: integer)  return vlbit_vector;
   function int2v1d           (i: integer)  return vlbit_1d;
   function v1d2int           (v: vlbit_1d) return integer;

end standard;

package body standard is

   function int2vlb           (i: integer) return vlbit is
      begin return vlbit(i); end;
   function boo2vlb           (b: boolean) return vlbit is
      begin return vlbit(b); end;
   function vlb2boo           (v: vlbit)   return boolean is
      begin return boolean(v); end;
   function int2boo           (i: integer) return boolean is
      begin return boolean(i); end;
   function vlb2int           (v: vlbit)   return integer is
      begin return integer(v); end;
   function boo2int           (b: boolean) return integer is
      begin return integer(b); end;

   function int2vec           (i: integer)  return vlbit_vector is
      begin return vlbit_vector(i); end;
   function int2v1d           (i: integer)  return vlbit_1d is
      begin return vlbit_1d(i); end;
   function v1d2int           (v: vlbit_1d) return integer is
      begin return integer(v); end;

end standard;

------------------------------------------------------------------------
------------------------------------------------------------------------
