/*  File:       rsff.h


    Function:   RS Flip-Flop Functions.

                1.  Automatic programming of logic LOW to unused RS inputs.
                    This means that if you don't use an RS, or if you only
                    write an assignment for one of the inputs, this header
                    file creates one for you.

                    Example (A105B):  If you don't use buried register P0,
                    this header creates

                        p0.r=0;
                        p0.s=0;

                2.  State Machine Variable Assignments.  This part is required
                    if your program has a state_diagram.


    Omission:   This header file is required if your program has a
                state_diagram whose state variables are implemented on
                RS Flip-Flops.


    Related headers:

                dff.h is used for D Flip-flops.


    Method:     The Device Description Header applies the '_rsff' attribute to
                those output signal names which are clocked RS flip-flops.  It
                applies the '_qf' to flip-flops with internal feedback.
                Synthesize sum-of-products expressions from the compiler-
                generated excitation transition equations.


    Revision:   89.4.10 */


_Attribute _qf(_Any);


_Attribute _rsff(_Any) {
/*  Supply RS.r=0 and RS.s=0 expressions unused inputs to prevent both
    R and S logic HIGH simultaneously. */
if (_Final) {
    if (_Vsignal.s _Size==0)
        _Dfunction _Vsignal.s=0;
    if (_Vsignal.r _Size==0)
        _Dfunction _Vsignal.r=0;
    }
}





_Attribute _StateVar(_None) {
/* Assign Q extensions to State Machine Variables.  All state variable literals
   are given the '_StateVar' attribute by the compiler.  Assure that these
   literals have '.q' extensions. */
if (_Vext=="q")
    _Vref*=_StateVar _Var;
  else {
    if (_Vext!="") {
        _StateVar _Var*=_StateVar _Var;
        _Exit "This state variable has an improper signal extension.";
        }
    _Vref*=_StateVar _Vsignal.q;
    }
}





_Attribute _Tran00(_Tlist) {
/*  Synthesize sum-of-products expressions from the compiler-generated
    excitation transition equations. */
if (_Vsignal _rsff _qf _Size!=0) {
    _Dfunction _Minimize _Vsignal.s= (!_Vsignal.q & (_Value _Var _Tran01)) |
                                (_Value _Var _Tran1);
    _Dfunction _Minimize _Vsignal.r= ( _Vsignal.q & (_Value _Var _Tran10)) |
                                (_Value _Var _Tran0);
    _Var _Tran00*=_Free _Tran00 _Var;
    _Var _Tran01*=_Free _Tran01 _Var;
    _Var _Tran10*=_Free _Tran10 _Var;
    _Var _Tran11*=_Free _Tran11 _Var;
    _Var _Tran0*=_Free _Tran0 _Var;
    _Var _Tran1*=_Free _Tran1 _Var;
    }
  else
    if (_Final)
        _Text "This state variable does not map to a flip-flop with "\
              "internal feedback.";
}
