/*  File:       poe.h

    Function:   Automatic Tri-State Buffer Enable for P16L8-type Devices


    Example:    On the p16l8, if you write an assignment for

                    ! pin19 = ... ;

                but don't write one for

                    pin19.oe = ... ;

                this header file creates an automatic

                    pin19.oe = 1 ;

    Omission:   If you don't include this header file, you'll need to write
                output enable signals for all the tri-state buffers because
                the signal specification defaults to unprogrammed.

    Related headers:

                moe.h is used for p22v10-type macrocells.

    Method:     The Device Description Header applies the '_poe' attribute
                to output signal names which have a programmable output
                enable of the form <signal>.oe.

    Revision:   88.4.10 */

_Attribute _poe {
if (_Vsignal.oe _Dfunction _Size==0) {
    /* there is no assignment to <signal>.oe */
    if (_Vsignal _Dfunction _Size!=0)
        /* there is a user assignment to the <signal> */
        _Vsignal.oe=1;
    _Vref*=_poe _Var;
    }
}
