/*  File:       minfpla.h


    Function:   Logic Minimization for PAL type devices.


    Omission:   If you don't include this header, no functions are
                minimized.


    Example:    Statements conditioned by an if-else statement are
                minimized.  Thus the statement

                        if (1) a= expression;

                  yields

                        a = minimized expression;

                  and

                        MINIMIZE {
                            x=...;
                            y=...;
                        }

                  yields minimized expressions for all statements
                  within the block.


    Method:     The '_Minimize' attribute is applied by the user, the compiler
                or by other attribute blocks to those functions which require
                minimization.  Perform FPLA minimization on these functions.


    Revision:   89.6.7 */


define MINIMIZE = if (1);


_Attribute _Minimize(_Any) {
if (_Final)
    /* Wait until all '_Minimize' are applied.  An FPLA cannot be minimized
	piecemeal. */
    _Vref*=_Mpla _Minimize _Var;
}





_Attribute _platerm(_Any) {
/* All product terms in an FPLA are given this attribute by the Device
   Description Header.  This block removes that attribute.  If the product
   term is unused by an assignment, it applies the _MplaFree attribute,
   making the product term available for allocation during _Mpla
   minimization.  By convention these Device Description Headers use the
   default assignment form which requires _Nvalue removal also. */
if ((_Function _Var _Size)==1)
    /* there is only one function (the one created by the Device Description
	Header. */
    _Function _Var*=_platerm _MplaFree _Nvalue _Var;
  else
    /* this product term is in use */
    _Vref*=_Free _Var;
}





_Attribute _MplaFunction(_Any) {
/* When _Mpla minimization uses an _MplaFree, it replaces that attribute
   with the _MplaFunction attribute.  These must be directed to the device. */
_Vref*=_Dfunction _MplaFunction _Var;
}
