/*  File:       else.h


    Function:   if-else default.  When a variable is given a value
                in the then part but not in the else part (or vice versa),
                supply its default.


    Example 1:  D flip-flop with internal feedback:

                        if (c1) x.d=a;
                            else HOLD;

    Example 2:  All other:

                        This attribute block is a NOP.  I.e., no
                        expressions are synthesized for false cases.


    Omission:   If you don't include this header, no HOLD will be synthesized.


    Method:     if (c1) x=a;

                is compiled to

                    _Dfunction _Minimize _If x = a & (c1);
                    _Else x = !(c1);


    Revision:   89.4.10  */


_Attribute _dff(_Any);
_Attribute _qf(_Any);


_Attribute _Else(_Any) {
/* Combine all of the _Else terms for this variable into their product */
if (_Var _else _Size==0)
    _Vref*=_else _Else _Var;
  else {
    _Var _else _Value *= (_Var _else _Value) & (_Vref _Value);
    _Vref*=_Free _Var;
    }
} /* '_Else' */


_Attribute _else(_Any) {
if (_Var _Else _Size==0) {
    /* All of the _Else terms for this variable have been combined by the
       _Else attribute block above */
    if (_Vsignal _dff _qf _Size!=0 &&
        /* the signal can be a D Flip-flop with internal feedback */
        _Vsignal.d==_Vref)
            /* the usage is to a D Flip-flop (think p22v10) */
            _Dfunction _If _Vsignal.d= _Vsignal.q & (_Value _Vref);
    _Vref*=_Free _Var;
    } /* all _Else terms are combined */
} /* '_else' */
