/*  File:       dff.h


    Function:   State Machine Variable Assignments for D Flip-Flops


    Omission:   This header file is required if your program has a
                state_diagram whose state variables are implemented on
                D Flip-Flops.


    Related headers:

                rsff.h is used for RS Flip-flops.


    Method:     The Device Description Header applies the '_dff' attribute to
                those output signal names which are D flip-flops.  It applies
                the '_qf' to flip-flops with internal feedback.  Synthesize
                sum-of-products expressions from the compiler-generated
                excitation transition equations.


    Revision:   89.5.12 */

_Attribute _dff(_Any);
_Attribute _qf(_Any);





_Attribute _Tran00(_Tlist) {
if (_Vsignal _dff _qf _Size!=0) {
    _Dfunction _Minimize _Vsignal.d=
        (!_Vsignal.q & (_Value _Var _Tran01)) |
        ( _Vsignal.q & (_Value _Var _Tran11)) |
        (_Value _Var _Tran1);
    _Var _Tran00*=_Free _Tran00 _Var;
    _Var _Tran01*=_Free _Tran01 _Var;
    _Var _Tran10*=_Free _Tran10 _Var;
    _Var _Tran11*=_Free _Tran11 _Var;
    _Var _Tran0*=_Free _Tran0 _Var;
    _Var _Tran1*=_Free _Tran1 _Var;
    }
  else
    if (_Final)
        _Text   "This state variable does not map to a flip-flop with "\
                "internal feedback.";
}





_Attribute _StateVar(_None) {
/* Assign Q extensions to State Machine Variables.  All state variable
   _Literals are given the '_StateVar' attribute by the compiler.  Assure that
   these _Literals have '.q' extensions. */
if (_Vext=="q")
    _Vref*=_StateVar _Var;
  else {
    if (_Vext!="") {
        _StateVar _Var*=_StateVar _Var;
        _Exit "This state variable has an improper signal extension.";
        }
    _Vref*=_StateVar _Vsignal.q;
    }
}
