/*  File:       rsoc.h

    Function:   Texas Instruments Output Cell Functions.

                Devices A506 and A506.  This header does nothing if the
                Output Cell is programmed for Combinatorial Operation.
                If programmed for Registered Operation, or unused, this
                header enables the RS Flip-Flop mode so that the other
                header files recognize it as an RS Flip-Flop.

    Omission:   You need this header if you want the RS inputs of unused
                Output Cells set to logic low. 

                You also need it if you only write an assignment for the
                R input of an Output Cell and want S to be low and vice
                versa.


    Method:     The Device Description Header applies the '_rsoc' attribute
                to those output signal names which are Output Cells.

    Revision:   89.4.10 */

_Attribute _rsff(_Any);


_Attribute _rsoc(_Any) {
if (_Final) {
    if ( _Dfunction _Vsignal _Size==0 ||
                              _Vsignal.s _Size!=0 || _Vsignal.r _Size!=0)
        _Vref*=_rsff _rsoc _Var;
    }
}
