;
; Support routines for C programs
;
	.global _getstr,_getconst16,_getconst32,_initaic,_getcpdg
	.mmregs

;
; Revisions:
;
;   11/02/95: swapped upper/lower 16-bits for getconst32
;   11/04/95: Added support for AIC initialization
;

;
; Buffer in RAM will hold copy of string
;

	.bss    strbuff,80      ;Allow 80 character max string size

	.text

;
; Given pointer to string in PROGRAM space, copy to a buffer in DATA space
;

_getstr popd    *+              ;Move return address to C stack
	sar     ar0,*+          ;Save Frame Pointer
	sar     ar1,*           ;Save stack pointer
	lark    ar0,1           ;Size of frame (1 argument)
	lar     ar0,*0+,ar2     ;Set up FP and SP

	lark    ar2,-3          ;Offset to argument
	mar     *0+             ;Point to argument
	lacl    *,ar0           ;Get argument - pointer to string in Program
	ldp     #0              ;Pointer to data page 0
	lar     ar3,#strbuff    ;Point to string buffer
	larp    ar3             ;Use ar3 as pointer to destination

getstr0 tblr    *               ;Get next string character
	add     #1              ;Update source string pointer
	lar     ar4,*+,ar4      ;Get character just transfered in ar4
	banz    getstr0,ar3     ;Go back for next char until char is zero
	lacc    #strbuff        ;Return pointer to string buffer

	larp    ar1             ;Pop off frame
	sbrk    2
	lar     ar0,*-          ;Restore frame pointer
	pshd    *               ;Move return addr to C stack
	ret

;
; Given pointer to 16-bit word in PROGRAM space, return value in accl
;

_getconst16
	popd    *+              ;Move return address to C stack
	sar     ar0,*+          ;Save Frame Pointer
	sar     ar1,*           ;Save stack pointer
	lark    ar0,1           ;Size of frame (1 argument)
	lar     ar0,*0+,ar2     ;Set up FP and SP

	lark    ar2,-3          ;Offset to argument
	mar     *0+             ;Point to argument
	lacl    *,ar0           ;Get argument - pointer to string in Program
	ldp     #0              ;Pointer to data page 0
	lar     ar3,#strbuff    ;Point to string buffer
	larp    ar3             ;Use ar3 as pointer to destination

	tblr    *               ;Get 16-bit word from FLASH memory
	lacl    *               ;Move this value to accumulator l

	larp    ar1             ;Pop off frame
	sbrk    2
	lar     ar0,*-          ;Restore frame pointer
	pshd    *               ;Move return addr to C stack
	ret

;
; Given pointer to 32-bit word in PROGRAM space, return value in acc
;

_getconst32
	popd    *+              ;Move return address to C stack
	sar     ar0,*+          ;Save Frame Pointer
	sar     ar1,*           ;Save stack pointer
	lark    ar0,1           ;Size of frame (1 argument)
	lar     ar0,*0+,ar2     ;Set up FP and SP

	lark    ar2,-3          ;Offset to argument
	mar     *0+             ;Point to argument
	lacl    *,ar0           ;Get argument - pointer to string in Program
	ldp     #0              ;Pointer to data page 0
	lar     ar3,#strbuff    ;Point to string buffer
	larp    ar3             ;Use ar3 as pointer to destination

	tblr    *               ;Get next 16-bit word
	add     #1              ;Point to next source value
	mar     *+              ;Point to next destination
	tblr    *               ;Get next 16-bit word
	lacc    *-,16           ;Load accumulator high
	or      *               ;or in accumulator LSW

	larp    ar1             ;Pop off frame
	sbrk    2
	lar     ar0,*-          ;Restore frame pointer
	pshd    *               ;Move return addr to C stack
	ret

*
******************************************************************
*  DESCRIPTION: This routine initializes the TLC320C46 for       *
*               a 8Khz sample rate with a gain setting of 1      *
*
* Portions copyright(C) 1992, Texas Instruments Inc.
*
*  (Modified from BBS code for use with Logitech Camera)
*
******************************************************************
* aic initialization data
*
*       master clock = 10.368 MHz (6.13635MHz for Logitech Camera)
*       scf clock = 288 Khz.      (278.92 KHz for Logitech)
*       sample rate = 8 Khz.      (16.407 KHz for Logitech)
*
aiccfg  .set $
	.word           0000h                   ; first two silent padding
	.word           0000h
;
;                         d12
;                          |d10 d6  d2
;                       d14| |d8 |d4 |d0
;                        | | | | | | | |
;                        v v v v v v v v
;
	.word           0000000000000011b    ; initialize TA & RA
;
;                       xx|TA |xx|RA |
;       .word		0010010001001000b    ; TA=RA=18 for divide by 18
 	.word           0001011000101100b    ; TA=RA=18 for divide by 18
;                                            ; of 10.368 Mhz clock (>2448
                                             ; (Logitech: TA=RA=11 ->
                                             ;    279.27 KHz @ 6.136 MHz)
;                  bits FEDCBA9876543210     ;
	.word           0000000000000011b    ; initialize TB & RB
;
;                       x| TB |x| RB |
;	.word		0100100010010010b    ; TB=RB=36 for 8Khz sampling
	.word           0010001001000110b    ; TB=RB=36 for 8Khz sampling
;                                            ;  >4892 (17 for Logitech)
;                       FEDCBA9876543210     bit definitions
	.word           0000000000000011b    ; init control flags
;                       xxxxxx| ctrl |
	.word           0000001001100111b    ;
;                             | ||||||
;                             | \|||| \_______ d2 = A/D highpass filter
;                             |  ||| \________ d3 = loopback function
;                             |  || \_________ d4 = Aux input pins
;                             |  | \__________ d5 = synchronization of RX & TX
;                             |   \___________ d6 & d7 = Gain; 0 & 0 = 1
;                             |                                0 & 1 = 4
;                             |                                1 & 0 = 2
;                             |                                1 & 1 = 1
;                             |                d8 = don't care
;                              \______________ d9 = second order sin x/x filter
;
	.word           0000h
	.word           0000h
	.word           0000h
cfgend  .word           0000h                   ; some more silent padding

;
; Initialize AIC
;

aicinit

;
; initalize and reset serial port
;
	lacc	#0000000000001000b	; set FSM bit for FSX/FSR per frame
	sacl	spc			; Configure for 16 bit mode with
	lacc	#0000000011001000b	; external CLKX, reset tx and rx
	sacl	spc

	lacc	#0
	sacl	dxr	           	; clear first int
	sacl	drr		        ; clear first int

	mar     *,ar3                   ; load arp
	lar     ar3,#strbuff            ; point to (end of buffer - 16)
	lacc    #aiccfg                 ; load control word table start address
	rpt     #10                     ; move 10 configuration word to end of
	tblr    *+                      ; FIFO so it will be send first to AIC.
;
	splk    #strbuff+10,arcr        ; load end of table
	splk    #strbuff,ar3            ; and begining of table
aicwait bit     SPC, 4                  ; wait for xmit ready
	bcnd    aicwait,NTC             ; wait until xrdy goes high
				        ; (1991 C5X U.G. is incorrect)
	lacc    *+                      ; read next control word
	sacl    DXR                     ; and send to dxr
	cmpr    0                       ; check for end of table
	bcnd    aicwait,NTC             ; if pointer<>end, wait
;
done    splk    #010000b,IMR            ; Turn on recieve interupts only
	CLRC    INTM                    ; Enable all interrupts
	splk    #0,dxr
	ret

;
; Create C call to AICINIT routine
;

_initaic
	popd    *+                      ;Move return address to C stack
	sar     ar0,*+                  ;Save Frame Pointer
	sar     ar1,*                   ;Save stack pointer
	lark    ar0,0                   ;Size of frame (0 arguments)
	lar     ar0,*0+,ar2             ;Set up FP and SP

        ldpk    #0                      ;Clear data pointer
	call    aicinit                 ;Go call assembly routine

	larp    ar1                     ;Pop off frame
	sbrk    1
	lar     ar0,*-                  ;Restore frame pointer
	pshd    *                       ;Move return addr to C stack
	ret

;
; Return TRUE if RS232 character pending
;

_getcpdg
        popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,0           ;Size of Frame is zero
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lacl    #1              ;Set up for return TRUE
        bcnd    getcp0,bio      ;Is bit received?
        lacl    #0              ;No....Return FALSE

getcp0  larp    ar1             ;Pop off frame
        sbrk    1
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; End of file
;

	.end
