;
; Loads ON-chip RAM resident programs from ROM space to RAM space
;

        .global _loader,loadstart,scratch,scratch2
        .text
        .mmregs


_loader popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,0           ;Size of Frame is zero
        lar     ar0,*0+,ar2     ;Set up FP and SP

        ldp     #0              ;Point to page 0
        lar     ar4,#loadstart  ;Source address
        lar     ar5,#0fe00h     ;Destination address
        lark    ar3,#1ffh       ;Will be loop counter

loader1 sar     ar4,scratch
        lacl    scratch         ;Get source address
        tblr    scratch         ;Get program data as pointed to by acc
        sar     ar5,scratch2
        lacl    scratch2        ;Get destination address
        tblw    scratch         ;Save data in destination program memory
        mar     *,ar4
        mar     *+,ar5
        mar     *+,ar3           ;Update pointers
        banz    loader1          ;Decr AR3 and loop if non-zero

        larp    ar1             ;Pop off frame
        sbrk    1
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; End of file
;
        .end