/* Test program to see if c works */

/* This program will increment a memory location to 100 */
/* Reset it and increment it again.  */

extern char getc();
extern void putc();
extern void burn();
extern void erase();

extern int bitlen;
extern int bitlen2;

char chksum;

/* Send string to RS232 port */

void putstring(const char *s)
{
  int i = 0;

  while (s[i] != 0)
  {
    putc(s[i++]);
  }
}

/* Get next character & echo back to screen */

char getcecho()
{
  char c;
  do
  {
    c = getc();
    putc(c);
    if (c == '\r') putstring("\n\r");
  } while (c <= ' ');
  return(c);
}

/* Convert Ascii Hex character string to binary equivalent */

int cvtbin(char c)
{
  if ((c >= 'A') && (c <= 'F'))
    return(c - 'A' + 10);
  else
    return(c - '0');
}

/* Get next 2-digit Hex from RS232 ..... Return as integer type */

int getbyte()
{
  int a;
  a = cvtbin(getcecho());
  a = (a << 4) | cvtbin(getcecho());
  chksum += a;
  return(a);
}

int getword()
{
  int a;
  a = getbyte();
  return((a << 8) | getbyte());
}

main()
{
  char c;
  int record_type;
  int record_length;
  int  record_addr;
  int i,j;
  char buffer[50];

  bitlen = 866;
  bitlen2 = 433;  /* Set for 16.666 MHz clock */

  erase();

  for (;;)
  {
    putstring("Send ASCII Now...\r\n");

    record_type = 0xff;

    while (record_type != 0x01)
    {
      while (getcecho() != ':') putstring("Missing ':' Character\r\n");
      chksum = 0;
      record_length = getbyte();
      record_addr = getword();
      record_type = getbyte();
      for (i = 1; i <= record_length + 1; i++)
        buffer[i] = getbyte();
      if ((chksum & 0x00FF) != 0)
        putstring("\r\n -- > Checksum Error");
      else
        if (record_type == 0)
          for (i = 1; i <= record_length; i += 2)
            burn(record_addr++,(buffer[i] << 8) | buffer[i+1]);
    }

  }
}
