	 .version 50
	 .mmregs

;
; Define C-callable global variables
;

         .global _burn,scratch,_erase;

;
; Write AAAA/5555 to program memory - command in accl
;

setup   splk    #05555h,BMAR    ;Set up BMAR
        splk    #0aaaah,scratch ;Temp register
        bldp    scratch
        splk    #02aaah,BMAR
        splk    #05555h,scratch
        bldp    scratch
        splk    #05555h,BMAR
        sacl    scratch
        bldp    scratch
        ret

wait    blpd    BMAR,scratch    ;Read Toggle bit
        lacl    scratch
        blpd    BMAR,scratch    ;Get toggle bit again
        xor     scratch
        and     #0040h          ;Mask all but D6
        bnz     wait            ;Wait until no more toggle
        ret

;----------------------------------------------------------------------
;  BURN: Burn FLASH location
;----------------------------------------------------------------------

_burn   popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,2           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lark    ar2,-3          ;Offset of arguments
        mar     *0+             ;Point to argument

        lar     ar4,*-          ;Load address from C stack (ar4 is prog addr)
        ldp     #0              ;Point to pg 0
        lacl    #00a0h          ;Load program command
        call    setup           ;Write command to FLASH memory
        sar     ar4,BMAR        ;Store FLASH program address in BMAR
        lacc    *-,ar4          ;Load data from C stack (acc is data)
        sacl    scratch         ;Save in scratch memory
        bldp    scratch         ;Write programming data
        call    wait            ;Wait for program cycle complete

        mar     *,ar0
        larp    ar1             ;Pop off frame
        sbrk    3
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; Erase entire flash contents
;

_erase  popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,0           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lacl    #0080h          ;Load chip erase command
        call    setup
        lacl    #0010h
        call    setup
        call    wait            ;Wait for erase complete

        mar     *,ar0
        larp    ar1             ;Pop off frame
        sbrk    1
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; End of file
;

	 .end
