/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                      TIGA DEMO FRAME                                     */
/*                                                                          */
/* Blit a portion of the screen to various other parts of the screen        */
/*                                                                          */
/*    8/19/87...Original version written..................J. Van Aken       */
/*   10/10/88...Converted to TIGA.........................Graham Short      */
/*    2/08/89...Mods to make more resolution independent..J. Van Aken       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Microsoft-c insert file */
#include <time.h>
            
#include <typedefs.h>
#include <tiga.h>
#include <extend.h>

#include "tigademo.h"
#include "colors.h"

#define NO_WINDOW_CLIP  0

#define N               32

/*--------------------------------------------------------------------------*/
/* picture defined for a 640 by 480 resolution display                      */
/*--------------------------------------------------------------------------*/
static short scene[2*N] = {
    170,70, 0,0, 170,40, 0,70,                       /* horizon */
    35,30, 100,35,                                   /* sun */
    94,12, 6,27, 68,10, 52,36, 18,6, 131,27, 15,5, 143,31,  /* clouds */
    23,77, 68,77, 58,82, 37,81, 23,77,               /* boat hull */
    41,55, 41,75, 27,75, 41,55,                      /* left sail */
    43,54, 68,75, 43,75, 43,54,                      /* right sail */
    170,110, 0,0, 5,5, 169,109, 0,0                  /* picture frame */
};

/*--------------------------------------------------------------------------*/
/* scale picure from 640 by 480 to the current screen dimensions            */
/*--------------------------------------------------------------------------*/
scale_picture(vertin, vertout, n)
short *vertin;
short *vertout;
short n;
{
    register int i;
    float xscale, yscale, xreal, yreal;

    /* Scale picture elements to screen dimensions. */
    xscale = HRES;
    xscale /= 480.0;
    yscale = VRES - 3*CHAR_HIGH;
    yscale /= 324.0;
    for (i = 0; i < n; i++)
    {
        xreal = *vertin++;
        *vertout++ = xreal * xscale + 0.5;
        yreal = *vertin++;
        *vertout++ = yreal * yscale + 0.5;
    }
}

/*--------------------------------------------------------------------------*/
/* draw_picture draws the initial picture which will be the source bitmap   */
/*--------------------------------------------------------------------------*/
draw_picture(vlist)
short *vlist;
{
    short w, h, x, y, i, dx, dy;

    set_draw_origin(0, 3*CHAR_HIGH);

    w = *vlist++;
    h = *vlist++;
    x = *vlist++;
    y = *vlist++;
    set_phys_fcolor(SKY);
    c_fill_rect(w, h, x, y);

    w = *vlist++;
    h = *vlist++;
    x = *vlist++;
    y = *vlist++;
    set_phys_fcolor(SEA);
    c_fill_rect(w, h, x, y);

    w = *vlist++;
    h = *vlist++;
    x = *vlist++;
    y = *vlist++;
    set_phys_fcolor(SUN);
    c_fill_oval(w, h, x, y);

    set_phys_fcolor(CLOUDS);
    for (i = 4; i > 0; --i)             /* draw four clouds */
    {
        w = *vlist++;
        h = *vlist++;
        x = *vlist++;
        y = *vlist++;
        c_fill_oval(w,h,x,y);
    }

    set_phys_fcolor(HULL);
    c_fill_convex(5, vlist);

    vlist = &vlist[2*5];
    set_phys_fcolor(SAILS);
    c_fill_convex(4, vlist);

    vlist = &vlist[2*4];
    c_fill_convex(4, vlist);

    vlist = &vlist[2*4];
    w = *vlist++;
    h = *vlist++;
    x = *vlist++;
    y = *vlist++;
    dx = *vlist++;
    dy = *vlist++;
    set_phys_fcolor(FRAME);
    c_frame_rect(w, h, x, y, dx, dy);

    w = *vlist++;
    h = *vlist++;
    x = *vlist++;
    y = *vlist++;
    if( iscolor )
        set_fcolor(_WHITE);
    draw_rect(w, h, x, y);
    /* tidy up */
    set_draw_origin(0, 0);
}

/*--------------------------------------------------------------------------*/
/* blit - animate the screen with a series of bitblts                                                                         */
/*--------------------------------------------------------------------------*/
blit(w, h, x, y)
short w, h, x, y;
{
    short xold, yold, dx, dy, xmin, ymin, xmax, ymax;
    short i, old_windowing, outcode;

    old_windowing = get_windowing();
    set_windowing(NO_WINDOW_CLIP);

    xmin = 0;
    ymin = 3*CHAR_HIGH;
    xmax = HRES - w;
    ymax = VRES - h;
    set_clip_rect(xmax-xmin, ymax-ymin, xmin, ymin);

    dx = 3*(xmax-xmin)/96;
    dy = 2+(ymax-ymin)/128;
    for (i = 0; i < ITERATION_COUNT; i++)
    {
        xold = x;
        yold = y;
        x += dx;
        y += dy;
        if ((outcode = cpw(x, y)) != 0)
        {
            if (outcode & 1)
            {
                /* Bounce off left wall. */
                x += 2*(xmin-x);
                dx = -dx;
            }
            else
                if (outcode & 2)
                {
                /* Bounce off right wall. */
                x -= 2*(x-xmax);
                dx = -dx;
                }
            if (outcode & 4)
            {
                /* Bounce off top wall. */
                y += 2*(ymin-y);
                dy = -dy;
            }
            else
                if (outcode & 8)
                {
                /* Bounce off bottom wall. */
                y -= 2*(y-ymax);
                dy = -dy;
                }
        }
        bitblt(w, h, xold, yold, x, y);
    }
    set_windowing(old_windowing);
}

/*--------------------------------------------------------------------------*/
/* frame6 - main subroutine                                                 */
/*--------------------------------------------------------------------------*/
void frame6()
{
    short    w, h, x, y, temp[2*N];
    time_t   tim1, tim2;

    scale_picture(scene, temp, N);
    draw_picture(temp);

    /* time delay */
    time(&tim1);
    do
        time(&tim2);
    while (difftime(tim2, tim1) < 1.0);

    w = temp[2*N-4];
    h = temp[2*N-3];
    x = temp[2*N-2];
    y = temp[2*N-1];
    blit(w+1, h+1, x, y+3*CHAR_HIGH);

    /* time delay */
    time(&tim1);
    do
        time(&tim2);
    while (difftime(tim2, tim1) < 1.0);
}
    
