;************************************************************************;
;   tigarlm.asm                                                          ;
;                                                                        ;
;   This file contains the definitions of the .TIGAEXT and .TIGAISR      ;
;   sections.                                                            ;
;************************************************************************;

;------------------------------------------------------------------------;
;   Interrupt Service Routines                                           ;
;------------------------------------------------------------------------;
    .globl  _di_isr, _wv_isr, _hi_isr, _swtrap_isr

;------------------------------------------------------------------------;
;   ISR utility functions                                                ;
;------------------------------------------------------------------------;
    .globl  _get_isr_service_count, _invoke_software_trap
    .globl  _get_last_scanline

;------------------------------------------------------------------------;
;   Define .TIGAEXT section                                              ;
;------------------------------------------------------------------------;
    .sect   ".TIGAEXT"
    .long   _get_isr_service_count      ;Function 0    
    .long   _invoke_software_trap       ;Function 1
    .long   _get_last_scanline          ;Function 2

;------------------------------------------------------------------------;
;   Define .TIGAISR section                                              ;
;------------------------------------------------------------------------;
    .sect   ".TIGAISR"
    .long   _di_isr                     ;ISR 0: Display Interrupt
    .word   10                          ;       Trap 10
    .long   _wv_isr                     ;ISR 1: Window Violation Interrupt
    .word   11                          ;       Trap 11
    .long   _hi_isr                     ;ISR 2: Host Interrupt
    .word   9                           ;       Trap 09
    .long   _swtrap_isr                 ;ISR 3: Example Software Trap Int
    .word   16                          ;       Trap 16

    .text
    .end
