/*----------------------------------------------------------------------*
 *                                    TIGA                              *
 *          Copyright (C) 1989-1990  Texas Instruments Incorporated.    *
 *                            All Rights Reserved                       *
 *----------------------------------------------------------------------*
 *  TiGA - Header file defining "user" extended functions for TIGA      *
 *         flight simulator.  The header files "tiga.h" and             *
 *         "flytypes.h" MUST be included before this header file.       *
 *----------------------------------------------------------------------*
 */

/*----------------------------------------------------------------------*
 *  Extended functions written for flight simulator                     *
 *----------------------------------------------------------------------*
 */
#define  COLLIDE           USER_CP(0)
#define  DRAW_FRAME        USER_CP(1)
#define  INIT_FLYGSP       USER_CP(2)
#define  TOGGLE_IPANEL     USER_CP(3)
#define  TOGGLE_MASHER     USER_CP(4)

/*----------------------------------------------------------------------*
 *  C-packet function definitions                                       *
 *----------------------------------------------------------------------*
 */
#define collide(a)                       \
        cp_ret(COLLIDE,1,_BYTE_PTR(sizeof(UNITVEC),(a)))
#define draw_frame(a,b,c,d)              \
        cp_cmd(DRAW_FRAME,4,_BYTE_PTR(sizeof(VIEWPOINT),(a)), \
                            _BYTE_PTR(sizeof(VIEWINFO),(b)),_DWORD(c),_WORD(d))
#define init_flygsp(a,b,c,d)             \
        cp_cmd(INIT_FLYGSP,4,_BYTE_PTR(sizeof(VIEWPORT),(a)), \
                             _BYTE_PTR(sizeof(VIEWPORT),(b)),_DWORD(c),_WORD(d))
#define toggle_ipanel()                  \
        cp_cmd(TOGGLE_IPANEL,0)
#define toggle_masher()                  \
        cp_cmd(TOGGLE_MASHER,0)

