        .width    132

*----------------------------------------------------------------------
*                                    TIGA
*          Copyright (C) 1988-1990  Texas Instruments Incorporated.
*                            All Rights Reserved
*----------------------------------------------------------------------
* bit_expand function
*
*    Expand bitmap to color pixel map on screen.  The 0s in the source
*    bitmap are expanded to the pixel value specified in the COLOR0
*    register; the 1s are expanded to the value specified in COLOR1.
*
*    The source bitmap is specified in terms of its starting address,
*    srcbits, and its memory pitch, srcpitch.  The source pitch can be
*    an arbitrary number.
*
*    The destination pixel map is a rectangular region of the screen.
*    the pixel map is specified in terms of its width w, height h, and
*    the coordinates at its top left corner, (xleft, ytop).
*
*    If any portion of the specified destination pixel map lies outside
*    the clipping window, it is automatically clipped to the window.
*----------------------------------------------------------------------
* Usage:  bit_expand(srcbits, srcpitch, w, h, xleft, ytop);
*
* Stack arguments:
*     short *srcbits;   /* pointer to source bitmap */
*     int srcpitch;     /* pitch of source bitmap */
*     int w, h;         /* width and height of dest'n pixel map */
*     int xleft, ytop;  /* coord's at top left corner of pixel map */
*----------------------------------------------------------------------
* Revision history:
*     08/30/88...Original version written...................J. Van Aken
*----------------------------------------------------------------------
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _bit_expand
;
;
;  DEFINE GLOBAL VARIABLE NAMES
;
        .globl    _xyorigin
;
;
;     ENTRY POINT
;
_bit_expand:

        MMTM      SP,B0,B1,B2,B7,B10,B11,B12,B13,B14
* Pop arguments off operand stack.
        MOVE      A14,B14             ;copy STK pointer to B file
        MOVE      *-B14,B0,1          ;get source address srcbits
        MOVE      *-B14,B1,1          ;get source pitch srcpitch
        MOVE      *-B14,B7,1          ;get dest'n width w
        MOVE      *-B14,B10,1         ;get dest'n height h
        MOVE      *-B14,B2,1          ;get x coordinate xleft
        MOVE      *-B14,B11,1         ;get y coordinate ytop
* Concatenate w and h, and xleft and ytop.
        SLL       16,B10              ;shift h to 16 MSBs
        MOVY      B10,B7              ;concatenate h with w
        SLL       16,B11              ;shift ytop to 16 MSBs
        MOVY      B11,B2              ;concatenate ytop with xleft
        MOVE      @_xyorigin,B11,1    ;get xy origin location on crt
        ADDXY     B11,B2              ;convert to screen coordinates
; Determine whether destination pixel map overlaps top of window.
        MOVY      B2,B10              ;copy ytop
        SUBXY     B5,B10              ;window y overlap = ytop - ystart
        JRYNN     INWINDOW            ;jump if ytop below top of window
* Need to clip destination array to top edge of clipping window.
        MOVY      B5,B2               ;clip ytop to top of window
        SRA       16,B10              ;shift y overlap to 16 LSBs
        MOVE      B1,B11              ;copy SPTCH
        MPYS      B10,B11             ;(y overlap) * SPTCH
        SUB       B11,B0              ;clip SADDR to top of window
        SLL       16,B10              ;shift y overlap to 16 MSBs
        ADDXY     B10,B7              ;clip DY to top of window
        JRLS      DONE                ;done if DY<=0 (100% above window)
* PIXBLT instruction will do any additional clipping required.
INWINDOW:
        PIXBLT    B,XY                ;color expand bitmap to screen
* Restore registers and return.
DONE:
        MMFM      SP,B0,B1,B2,B7,B10,B11,B12,B13,B14
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;done

        .end

