/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Draw text to the screen using the same typeface in a variety of
 *   font sizes.  Lincoln's Gettysburg Address is printed to the screen
 *   using the proportionally-spaced TI Roman type in font sizes 11, 14,
 *   16, 18, 20, 22, 26, 33, 38, 52 and 78.  Each frame shows a different
 *   font size.  A delay is inserted between successive frames.
 *----------------------------------------------------------------------
 *   03/27/90...Original version written..................J.R. Van Aken
 *   09/25/90...Cut no. of fonts from 12 to 10............J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define NLINES	  25	  /* number of lines of text */
#define NFONTS    10      /* number of fonts in TI Roman style */

extern FONT ti_rom11, ti_rom14, ti_rom16, ti_rom18, ti_rom20, ti_rom22,
            ti_rom26, ti_rom30, ti_rom33, ti_rom38;

static CONFIG cfg;
static FONTINFO fontinfo;

static FONT *p[NFONTS] = {
    &ti_rom11, &ti_rom14, &ti_rom16, &ti_rom18, &ti_rom20, &ti_rom22,
    &ti_rom26, &ti_rom30, &ti_rom33, &ti_rom38,
};

static short index[NFONTS];

static char *s[NLINES] =
{
    "Four score and seven years ago our fathers brought forth, upon this",
    "continent, a new nation, conceived in Liberty, and dedicated to the",
    "proposition that all men are created equal.",
    "",
    "Now we are engaged in a great civil war, testing whether that nation,",
    "or any nation so conceived, and so dedicated, can long endure.  We",
    "are met here on a great battlefield of that war.  We have come to",
    "dedicate a portion of it as a final resting place for those who here gave",
    "their lives that the nation might live.  It is altogether fitting and proper",
    "that we should do this.",
    "",
    "But in a larger sense we can not dedicate, we can not consecrate,",
    "we can not hallow this land.  The brave men, living and dead, who",
    "struggled here, have consecrated it far above our poor power to",
    "add or detract.  The world will little note, nor long remember, what",
    "we say here, but can never forget what they did here.  It is for us,",
    "the living, rather to be dedicated here to the unfinished work",
    "which they have, thus far, nobly carried on.  It is rather for us to",
    "be here dedicated to the great task remaining before us, that from",
    "these honored dead we take increased devotion to that cause for",
    "which they gave the last full measure of devotion, that we here",
    "highly resolve that these dead shall not have died in vain; that this",
    "nation shall have a new birth of freedom; and that this government",
    "of the people, by the people, for the people, shall not perish from",
    "the earth."
};


main()
{
    int hres, vres, nfonts, i, j, x, y, h;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Install as many ti_rom fonts as will fit in the font table. */
    for (nfonts = 0;
	   nfonts < NFONTS && (index[nfonts] = install_font(p[nfonts]));
	     nfonts++)
	;

    /* Each loop below draws text in one of the TI Roman fonts. */
    for (;;)
	for (i = 0; i < nfonts; i++) {
	    select_font(index[i]);
	    get_fontinfo(index[i], &fontinfo);
	    h = fontinfo.charhigh;
	    x = y = 0;
	    clear_screen(0);
	    for (j = 0; j < NLINES && y < vres; j++, y += h)
		text_out(x, y, s[j]);
	    for (j = 75; j; j--)	   /* 1.25-second delay */
		wait_scan(hres);
	}
}

