/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test the draw_oval, styled_oval, draw_ovalarc, styled_ovalarc,
 *   draw_piearc and styled_piearc functions.  Animated demo draws series
 *   of pie arcs as starting angle and extent of arc changes gradually.
 *   Dimensions of enclosing rectangle also change.  Both solid arcs and
 *   styled arcs are drawn.
 *----------------------------------------------------------------------
 * Revision History:
 *   08/19/87...Original version written...................J.R. Van Aken
 *   06/14/89...Modified for TIGA standalone library.......Al Sharp
 *   11/29/89...Modified for general portability...........JRV
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define  LINESTYLE  0x0FFF0FFF	 /* 32-bit arc line-style pattern mask */

static CONFIG cfg;


main()
{
    int hres, vres, disppage, drawpage, phase, draw, ts, ta, dts, dta;
    long x, y, z, xmax, ymax;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_frame_buffer(0);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    set_draw_origin(hres/2, vres/2);
    set_bcolor(RED);   /* color for 0s in line-style mask */

    /* Initialize loop parameters. */
    x = xmax = (hres/2 - hres/16) << 16;
    y = ymax = (vres/2 - vres/8) << 16;
    z = 0;
    ts = 90;
    ta = 360;
    dts = 1;
    dta = -2;
    draw = 0;
    phase = 0;
    disppage = 1;
    drawpage = 0;

    /* Infinite loop below draws arc or ellipse, and enclosing rect. */
    for (;;) {
	clear_screen(BLACK);
	set_fcolor(DARK_GRAY);
	frame_rect(x>>16-1, y>>16-1, -x>>16, -y>>16, 4, 4);

	/* Inscribe arc or ellipse inside enclosing rectangle. */
	set_fcolor(WHITE);
	switch (draw) { 	  /* 1 of 9 arc or ellipse functions */
	case 0:
	    draw_oval(x>>16-1, y>>16-1, -x>>16, -y>>16);
	    break;
	case 1:
	case 2:
	    styled_oval(x>>16-1, y>>16-1, -x>>16, -y>>16,
						      LINESTYLE, draw&1);
	    break;
	case 3:
	    draw_ovalarc(x>>16-1, y>>16-1, -x>>16, -y>>16, ts, ta);
	    break;
	case 4:
	case 5:
	    styled_ovalarc(x>>16-1, y>>16-1, -x>>16, -y>>16,
					      ts, ta, LINESTYLE, draw&1);
	    break;
	case 6:
	    draw_piearc(x>>16-1, y>>16-1, -x>>16, -y>>16, ts, ta);
	    break;
	case 7:
	case 8:
	    styled_piearc(x>>16-1, y>>16-1, -x>>16, -y>>16,
					      ts, ta, LINESTYLE, draw&1);
	    break;
	}

	/* Schedule page flip to occur at bottom of screen. */
	page_flip(disppage ^= 1, drawpage ^= 1);

	/* Update arc starting angle and arc extent. */
	if (abs(ts += dts) > 359 )
	    dts = -dts;
	if (abs(ta += dta) > 385)
	    dta = -dta;

	/* Update dimensions of rectangle enclosing ellipse or arc. */
	switch (phase) {
	case 0: 	      /* rectangle shrinking horizontally */
	    z += x >> 7;
	    x -= z >> 7;
	    if (x < 0) {
		x = 0;
		z = xmax;
		ts = (180 - ts) % 360;
		ta = -ta;
		dts = -dts;
		dta = -dta;
		phase = 1;
		if (++draw > 8)
		    draw = 0;
	    }
	    break;
	case 1: 	      /* rectangle growing horizontally */
	    x += z >> 7;
	    z -= x >> 7;
	    if (z < 0) {
		x = xmax;
		z = 0;
		phase = 2;
	    }
	    break;
	case 2: 	      /* rectangle shrinking vertically */
	    y -= z >> 7;
	    z += y >> 7;
	    if (y < 0) {
		y = 0;
		z = ymax;
		ts = -ts;
		ta = -ta;
		dts = -dts;
		dta = -dta;
		phase = 3;
	    }
	    break;
	case 3: 	      /* rectangle growing vertically */
	    y += z >> 7;
	    z -= y >> 7;
	    if (z < 0) {
		y = ymax;
		z = 0;
		phase = 0;
	    }
	    break;
	}

	/* Don't start drawing until scheduled page flip is done. */
	while (page_busy())
	    ;
    }
}

