;-----------------------------------------------------------------------;
;                                TIGA                                   ;
;          Copyright (c) 1990  Texas Instruments Incorporated.          ;
;                          All Rights Reserved                          ;
;-----------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                        ;
;-----------------------------------------------------------------------;
        .include gspreg.inc 
        .mlib    gspmac.lib 
;-----------------------------------------------------------------------;
;   Global defs                                                         ;
;-----------------------------------------------------------------------;
        .globl  _get_vector
        .globl  _set_vector
;-----------------------------------------------------------------------;
;   The following equate defines the GSP address of the RESET trap      ;
;   vector (Trap 0).  The addresses for traps 0-31 are assumed          ;
;   contiguous, with trap 0 being the highest memory address and trap   ;
;   31 the lowest.                                                      ;
;                                                                       ;
;   NOTE: If your trap addresses are not contiguous in memory, then     ;
;   you will have to construct an array of addresses and modify the     ;
;   following two routines to pull the correct address from this        ;
;   array.                                                              ;
;-----------------------------------------------------------------------;
Trap0Addr   .set    0FFFFFFE0h      ;Address of trap 0 in GSP memory 

;-----------------------------------------------------------------------;
;   name        get_vector  -  Get value at a trap vector               ;
;                                                                       ;
;   synopsis    v = get_vector(TrapNum)                                 ;
;               unsigned long v;    vector at specified trap            ;
;               short TrapNum;      requested trap number               ;
;                                                                       ;
;   description This function returns the vector contained in the trap  ;
;               specified by TrapNum.  This function should be used     ;
;               whenever trap vectors are read.                         ;
;-----------------------------------------------------------------------;
;   history                                                             ;
;                                                                       ;
;   03/30/89  Original version written                          W.S.Egr ;
;-----------------------------------------------------------------------;
_get_vector:
        Push    A0                  ;Save used registers
        Popc    A8                  ;Get trap number off program stack
        sll     5,A8                ;Convert to bit offset
        movi    Trap0Addr,A0        ;Get address of trap 0
        sub     A8,A0               ;A0 is now address of requested trap
        move    *A0,A8,1            ;Return the vector in this trap
        Pop     A0                  ;Restore used registers
        rets    2

;-----------------------------------------------------------------------;
;   name        set_vector  -  Put a vector in a trap                   ;
;                                                                       ;
;   synopsis    ov = set_vector(TrapNum,v)                              ;
;               unsigned long ov;   original trap vector value          ;
;               short TrapNum;      requested trap number               ;
;               unsigned long v;    requested trap vector value         ;
;                                                                       ;
;   description This function writes the specified 32-bit vector into   ;
;               the trap specified by TrapNum.  The vector orginally    ;
;               in this trap is returned.  This function should be      ;
;               used whenever a vector is written to a trap.            ;
;-----------------------------------------------------------------------;
;   history                                                             ;
;                                                                       ;
;   03/30/89  Original version written                          W.S.Egr ;
;-----------------------------------------------------------------------;
_set_vector:
        Push    A0                  ;Save used registers
        Push    A1
        Popc    A0                  ;Get trap number off program stack
        sll     5,A0                ;Convert to bit offset
        movi    Trap0Addr,A1        ;Get address of trap 0
        sub     A0,A1               ;A1 is now address of requested trap
        move    *A1,A8,1            ;Save current vector for return value
        Popc    A0                  ;Get vector to assign to trap
        move    A0,*A1,1            ;Save vector in trap
        Pop     A1
        Pop     A0                  ;Restore used registers
        rets    2

