/*-----------------------------------------------------------------------*/
/*                                  TIGA                                 */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Core                                         */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  void init_video_regs(monitorinfo)                                    */
/*                                                                       */
/*  This function initializes the video registers using the structure    */
/*  passed to it.                                                        */
/*-----------------------------------------------------------------------*/
/*  07/11/88  Original Version Written                      Graham Short */
/*  01/12/89  Changed to monitor info structure             Graham Short */
/*  10/20/89  Modified for 34020 SDB board                  Graham Short */
/*-----------------------------------------------------------------------*/

#include <gspreg.h>
#include <gsptypes.h>
#include <gspglobs.h>
#include "oem.h"

#define TRUE  1
#define FALSE 0

static int POWER_UP = TRUE;

extern OEMDATA *oemdata;

init_video_regs(monitorinfo)
register ushort *monitorinfo;
{
   register ushort  *io;
   unsigned int     hsval;
   register int     i;
   register int     screen_delay;
   register ushort  vcount_save;

#if SDB20
   /* current value of hardware space register has been read from the
      status register on the host side are transferred into the oemdata field */
   hsval = oemdata->status;

   /* dont bother to synchronize disable of video if VGA pass-through */
   if (!(hsval & VGA))
   {
#endif
      /* dont bother to synchronize disable of video if no video registers */
      /* have been loaded (which is the case at power-up)                  */
      if (!POWER_UP)
      {
         /* synchronize disable video by reading VCOUNT */
#if GSP_34010
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT10;
            while (vcount_save != *(ushort *) VCOUNT10);
         }
         while (vcount_save < *(ushort *) VSBLNK10);
#endif
#if GSP_34020
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT20;
            while (vcount_save != *(ushort *) VCOUNT20);
         }
         while (vcount_save < *(ushort *) VSBLNK20);
#endif
      }
      else
         POWER_UP = FALSE;
#if SDB20
   }
#endif

   /* disable video */
   * (ushort *) DPYCTL &= ~ENV_MASK;

   /* Base address of I/O register file */
   io = (ushort *) IO_BASE;
   /* load up to DPYCTL */
   for (i = 0; i < 8; i++)
      *io++ = *monitorinfo++;

   * (ushort *) DPYCTL = (*monitorinfo++) & (~ENV_MASK);

#if GSP_34020
   /* Load DINC */
   io = (ushort *) DINC20;
   *io++ = *monitorinfo++;
   *io++ = *monitorinfo++;

   /* Load HESERR */
   io = (ushort *) HESERR20;
   *io++ = *monitorinfo++;

   /* Load DPYMSK */
   io = (ushort *) DPYMASK20;
   *io++ = *monitorinfo++;
#endif

   /* get screen_delay value */
   screen_delay = *monitorinfo;

#if SDB20
   /* if not in VGA pass-through, synchronize the enabling of video */
   if (!(hsval & VGA))
   {   
      switch (config.mode.disp_psize)
      {
         case 8 : hsval |=  BIT8;
                  hsval &= ~BIT4;
                  break;
         case 4 : hsval |=  BIT4;
                  hsval &= ~BIT8;
                  break;
      }
      switch (config.mode.disp_hres)
      {
         case 640  : hsval |=  RATE;
                     break;
         case 1024 : hsval &= ~RATE;
                     break;
      }
      * ((unsigned char *) HARDWARE_SPACE) = hsval; /* set the new mode */
#endif

      delay(screen_delay);

      /* wait until vertical blanking starts */
#if GSP_34010
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT10;
            while (vcount_save != *(ushort *) VCOUNT10);
         }
         while (vcount_save < *(ushort *) VSBLNK10);
#endif
#if GSP_34020
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT20;
            while (vcount_save != *(ushort *) VCOUNT20);
         }
         while (vcount_save < *(ushort *) VSBLNK20);
#endif
      /* enable video */
      * (ushort *) DPYCTL |= ENV_MASK;
#if SDB20
   }
#endif
}














     
