/*-----------------------------------------------------------------------*/
/*                                 TiGA                                  */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TiGA - Graphics Manager                                              */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  void init_palet()                                                    */
/*                                                                       */
/*  This function initializes the first 16 entries in the palette to     */
/*  the EGA default colors.                                              */
/*-----------------------------------------------------------------------*/
/*  2 Mar 90  34020 SDB version                             Graham Short */
/*-----------------------------------------------------------------------*/

#include "gsptypes.h"
#include "gspglobs.h"
#include "oem.h"

#define  NUM_DEFAULT_ENTRIES (sizeof(DEFAULT_PALET)/sizeof(PALET))

extern void   set_palet();

dm_init_palet(dataptr)
short *dataptr;
{
   init_palet();
}

init_palet()
{
    PALET     temppalet[PALET_ENTRIES];
    register  int  i, j, default_size;

    /* replicate the default palet */
    for(i = 0; i < (sizeof(temppalet) / sizeof(DEFAULT_PALET)); i++)
         for (j = 0; j < NUM_DEFAULT_ENTRIES; j++)
         {
              temppalet[(i*NUM_DEFAULT_ENTRIES)+j].r = DEFAULT_PALET[j].r;
              temppalet[(i*NUM_DEFAULT_ENTRIES)+j].g = DEFAULT_PALET[j].g;
              temppalet[(i*NUM_DEFAULT_ENTRIES)+j].b = DEFAULT_PALET[j].b;
              temppalet[(i*NUM_DEFAULT_ENTRIES)+j].i = DEFAULT_PALET[j].i;
         }
    set_palet(PALET_ENTRIES, 0, temppalet);
}
