;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1987-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
;   ulong get_nearest_color(r, g, b, i)                                   ;
;                                                                         ;
;   This function will search the current palette and detect the closest  ;
;   color value to that specified in the parameters and return the        ;
;   index in A8.                                                          ;
;                                                                         ;
;   Note:- A8 is destroyed                                                ;
;-------------------------------------------------------------------------;
;            Original Version Written                      Gary Littleton ;
; 11/16/87   Modified for use with 8514 Emulation          Michael Denio  ;
;  7/11/88   Reworked for 8-bit RGB values and TIGA dm     Graham Short   ;
; 09/07/88   Access globals thru config struct             W.S.Egr        ;
; 12/21/88   Modified algorithm to return lowest number    Graham Short   ;
; 08/31/89   Added monochrome mode to check intensity      Graham Short   ;             
; 11/15/89   Added handling of 34020 MONITORINFO struc     Graham Short   ;
;-------------------------------------------------------------------------;
        .include oem.inc
        .include gsptypes.inc
        .include gspglobs.inc
;   Define Globals
        .globl   _get_nearest_color
        .globl   _dm_get_nearest_color

;   Register Definitions
Rred       .set  A0
Rgrn       .set  A1
Rblu       .set  A2
Rpalptr    .set  A3
Rlowest    .set  A4
Rindex     .set  A5
Rcount     .set  A6
Rsum_diffs .set  A7     ; Used in color_monitor only
Rint       .set  A7     ; Used in monochrome_monitor only
Rtmp       .set  A9
STK        .set  A14

COLOR_MONOCHROME_FLAG   .set    1
;
;   C-PACKET ENTRY POINT
;
_get_nearest_color:
        mmtm    SP,A0,A1,A2,A3,A4,A5,A6,A7,A9

        move    *-STK,Rred,1           ;get desired color...
        move    *-STK,Rgrn,1           ;
        move    *-STK,Rblu,1           ;
        move    *-STK,Rint,1           ;skip intensity
        jruc    common_ep
;
;   C-PACKET ENTRY POINT
;
_dm_get_nearest_color:
        mmtm    SP,A0,A1,A2,A3,A4,A5,A6,A7,A9
        move    *-STK,A8,1
        setf    16,0,0
        move    *A8+,Rred,0           ;get desired color...
        move    *A8+,Rgrn,0           ;
        move    *A8+,Rblu,0           ;
        move    *A8,Rint,0            ;
;
;   MAIN ALGORITHM
;
common_ep:

        setf    16,0,0
        move    @(_config+CONFIG_DISP_PSIZE),Rlowest    ;get Current Psize in a temporary
        setf    8,0,0
        movi    _palet,Rpalptr                          ;get ptr to palette register values
        clr     Rindex
        move    @(_config+CONFIG_PALET_SIZE),Rcount,1
        movk    1,Rtmp
        sll     Rlowest,Rtmp
        movi    -1,Rlowest                              ;initialize lowest value
        cmp     Rtmp,Rcount
        jrls    mono_color_check
        move    Rtmp,Rcount
mono_color_check:
        move    @_monitorinfo,Rtmp,1   
        .if     GSP_34010
        move    *Rtmp(MONITOR_FLAGS10),Rtmp,1         ; Get color/mono flag
        .endif
        .if     GSP_34020
        move    *Rtmp(MONITOR_FLAGS20),Rtmp,1         ; Get color/mono flag
        .endif
        andi    COLOR_MONOCHROME_FLAG,Rtmp
        jrz     color_monitor
monochrome_monitor:
        addi    24,Rpalptr
        move    *Rpalptr+,Rtmp,0       ;get intensity component
        sub     Rint,Rtmp
        abs     Rtmp                   ;find absolute delta
        cmp     Rtmp,Rlowest           ;if total delta is lowest delta yet,
        jrls    not_lowest_m           ;current palette value is closest so far
        move    Rindex,A8
        move    Rtmp,Rlowest
not_lowest_m:
        addk    1,Rindex
        dsjs    Rcount,monochrome_monitor
        jruc    exit
color_monitor:
        clr     Rsum_diffs
        move    *Rpalptr+,Rtmp,0       ;get red component
        sub     Rred,Rtmp
        abs     Rtmp                   ;find absolute delta
        add     Rtmp,Rsum_diffs        ;add to total delta
        move    *Rpalptr+,Rtmp,0       ;get green component
        sub     Rgrn,Rtmp
        abs     Rtmp                   ;find absolute delta
        add     Rtmp,Rsum_diffs        ;add to total delta
        move    *Rpalptr+,Rtmp,0       ;get blue component
        sub     Rblu,Rtmp
        abs     Rtmp                   ;find absolute delta
        add     Rtmp,Rsum_diffs        ;add to total delta
        move    *Rpalptr+,Rtmp,0       ;skip intensity component
        cmp     Rsum_diffs,Rlowest     ;if total delta is lowest delta yet,
        jrls    not_lowest_c           ;current palette value is closest so far
        move    Rindex,A8
        move    Rsum_diffs,Rlowest
not_lowest_c:
        addk    1,Rindex
        dsjs    Rcount,color_monitor
exit:
        mmfm    SP,A0,A1,A2,A3,A4,A5,A6,A7,A9
        rets    2
