;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;     Copyright (c) 1988-1990  Texas Instruments.  All Rights Reserved    ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   void clear_screen(c)                                                  ;
;   long  c;            /* clear screen to this pixel value */            ;
;                                                                         ;
;   This function clears the screen to the color corresponding to the     ;
;   specified color index.                                                ;
;                                                                         ;
;   Notes:- A8 is destroyed                                               ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  07/14/88...Original Version...........................Mike Denio       ;
;  07/16/88...Added TIGA direct mode.....................Graham Short     ;
;  09/07/88...Access globals thru env struct.............W.S.Egr          ;
;  01/10/89...Accept color parameter.....................W.S.Egr          ;
;  01/25/89...Modified clear CONTROL to not clear CD bit.Graham Short     ;
;  06/21/89...Modified for 34020 SDB.....................Graham Short     ;
;  10/02/90...Cleared plane mask prior to VFILL..........J. Van Aken      ;
;-------------------------------------------------------------------------;
;
        .title    'clear screen'
        .file     'clearscr.asm'
        .include  gspreg.inc
        .include  gsptypes.inc            
        .include  gspglobs.inc            
        .mlib     gspmac.lib
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _clear_screen
        .globl    _dm_clear_screen
;
;     GLOBAL REFERENCES
;
        .globl    _set_fcolor        
;
;   C-PACKET ENTRY POINT
;
_clear_screen:
        mmtm      SP,B2,B7,B9         ;
        Popc      A8                  ;get color index 
        jruc      common_ep           ;
;
;   DIRECT MODE ENTRY POINT
;
_dm_clear_screen:
        mmtm      SP,B2,B7,B9         ;
        Popc      A8                  ;get pointer to dm-data
        move      *A8,A8,1            ;get color index
;
;   COMMON ENTRY POINT
;
common_ep:
        move      A8,COLOR1           ;copy arg c (pixel value)
        jrz       color_is_set        ;jump if arg c == 0
        inc       A8                  ;was arg c specified as -1?
        jrz       use_color0          ;jump if c == -1
;-----------------------------------------------------------------------;
;   Replicate pixel to fill 32-bit COLOR1 register.                     ;
;-----------------------------------------------------------------------;
        rpix      COLOR1              ;
        jruc      color_is_set        ;
;-----------------------------------------------------------------------;
;   Screen will be cleared to background color in COLOR0.               ;
;-----------------------------------------------------------------------;
use_color0:
        move      COLOR0,COLOR1       ;
;-----------------------------------------------------------------------;
;   Set the plane mask to 0 (assume VEN bit in CONFIG register is set). ;
;-----------------------------------------------------------------------;
color_is_set: 
        move      @PMASK,A8,1         ;save original plane mask
        clr       DADDR               ;
        move      DADDR,@PMASK,1      ;enable all planes for VFILL
;-----------------------------------------------------------------------;
;   Clear the screen to the specified pixel value.                      ;
;-----------------------------------------------------------------------;
        move      @(_config+CONFIG_DISP_VRES),DYDX,1 ;get VRES, HRES
        rl        16,DYDX             ;set DX=HRES, DY=VRES
        move      OFFSET,DADDR        ;load base address of current page
        vlcol                         ;Copy COLOR1 into VRAM color latch
        vfill     L                   ;Clear screen to COLOR1 value
;-----------------------------------------------------------------------;
;   Restore registers and return                                        ;
;-----------------------------------------------------------------------;
        move      A8,@PMASK,1         ;restore original plane mask
        mmfm      SP,B2,B7,B9         ;restore B-file registers
        move      *SP(32),A14,1       ;restore C program stack pointer
        rets      2
        .end

