/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*  oem.h - 34010 SDB version                                            */
/*                                                                       */
/*  This file contains the hardware-specific constants                   */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/
/* Define GSP part number as either 34010 or 34020.			             */
/*-----------------------------------------------------------------------*/
#define GSP_34010  1	     /* Set to 1 if GSP part number is 34010 */
#define GSP_34020  0	     /* Set to 1 if GSP part number is 34020 */
/*-----------------------------------------------------------------------*/
/* Define board identifier						 */
/*-----------------------------------------------------------------------*/
#define SDB10	   1	     /* Set to 1 if board is 34010 SDB	*/
#define SDB20	   0	     /* Set to 1 if board is 34020 SDB	*/

#define VIDEO_MEMORY_START      0x00000000l 
#define VIDEO_MEMORY_END        0x001FFFFFl
#define PALET_ENTRIES           16
#define SHARED_MEM_SIZE         0
#define SHARED_HOST_ADDR        0
#define SHARED_GSP_ADDR         0

/*--------------------------------------------------------------------------*/
/*  SETUP structure definition                                              */
/*                                                                          */
/*      This structure contains all the mode-dependent information          */
/*      that will be downloaded from host to GSP when the current           */
/*      mode is changed.                                                    */
/*      All the information here is also duplicated on the host side.       */
/*      Changing the information below must be duplicated on the host side. */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#define MAX_PAGES               2     /* maximum number of display pages   */
#define MAX_OFFSCREEN           2     /* maximum number of offscreen areas */

typedef struct
{
   ushort         Monitor;
   ushort         Mode_Info_offset;
   ushort         Monitor_Info_offset;
   ushort         Page_Info_offset;
   ushort         Off_Screen_offset;
   ushort         OEM_Data_offset;                                       
   ushort         endsetup_offset;
} HEADER;

typedef struct
{
   ushort         status;
} OEMDATA;

typedef struct
{
   HEADER         header;
   MODEINFO       Mode_Info;
   MONITORINFO10  Monitor_Info;
   PAGE 	  Page_Info[MAX_PAGES];
   OFFSCREEN_AREA Off_Screen[MAX_OFFSCREEN];
   OEMDATA        OEM_Data;                                     
} SETUP;

/* Miscellaneous defs */
#define TIGA_VERSION_NUMBER	20


