/*-----------------------------------------------------------------------*/
/*                                  TIGA                                 */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Core                                         */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  void init_video_regs(monitorinfo)                                    */
/*                                                                       */
/*  This function initializes the video registers using the structure    */
/*  passed to it.                                                        */
/*-----------------------------------------------------------------------*/
/*  07/11/88  Original Version Written                      Graham Short */
/*  01/12/89  Changed to monitor info structure             Graham Short */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspreg.h>
#include "oem.h"

#define TRUE  1
#define FALSE 0

/* had to include this explicitly to get the routine to compile */
#define ENV_MASK  0x8000  /*  Mask for SRT bit in DPYCTL  */
static int POWER_UP = TRUE;

init_video_regs(monitorinfo)
register ushort *monitorinfo;
{
   register ushort  *io;
   register int     i;
   register int     screen_delay;
   register ushort  vcount_save;

   /* dont bother to synchronize disable of video if no video registers */
   /* have been loaded (which is the case at power-up)                  */
   if (!POWER_UP)
   {
      /* synchronize disable video by reading VCOUNT */
#if GSP_34010
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT10;
            while (vcount_save != *(ushort *) VCOUNT10);
         }
         while (vcount_save < *(ushort *) VSBLNK10);
#endif
#if GSP_34020
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT20;
            while (vcount_save != *(ushort *) VCOUNT20);
         }
         while (vcount_save < *(ushort *) VSBLNK20);
#endif
   }
   else
      POWER_UP = FALSE;

   /* disable video */
   * (ushort *) DPYCTL &= ~ENV_MASK;

   /* Base address of I/O register file */
   io = (ushort *) IO_BASE;
   /* load HESYNC through DPYCTL, ignore screen paras. */
   for (i = 0; i < 8; i++)
      *io++ = *monitorinfo++;
   /* ensure that DPYCTL value has video disabled */
   *io = *monitorinfo++ & ~ENV_MASK;

   /* get screen_delay value */
   screen_delay = *monitorinfo;
   delay(screen_delay);

   /* coming out of blanking, display interrupt cannot be used to */
   /* synchronize enable video so the slightly flakey practice of */
   /* reading VCOUNT is used.                                     */
#if GSP_34010
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT10;
            while (vcount_save != *(ushort *) VCOUNT10);
         }
         while (vcount_save < *(ushort *) VSBLNK10);
#endif
#if GSP_34020
         do
         {
            /* keep reading vcount until you get two values the same */
            do vcount_save = *(ushort *) VCOUNT20;
            while (vcount_save != *(ushort *) VCOUNT20);
         }
         while (vcount_save < *(ushort *) VSBLNK20);
#endif

   /* enable video */
   *io |= ENV_MASK;

   /*------------------------------------------------------------------*/
   /*  ADD ANY OEM-SPECIFIC VIDEO INITIALIZATION FOR A SPECIFIED MODE  */
   /*  IT MAY BE DESIRABLE FOR A GIVEN PORT TO DEFINE                  */
   /*  ITS OWN ARRAY OF STRUCTURES (ONE FOR EACH MODE) WHICH MAY BE    */
   /*  PASSED TO THIS FUNCTION.                                        */
   /*------------------------------------------------------------------*/
}














     

