/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test seed fill routines.  This program tests the seed_fill and
 *   seed_patnfill functions.  It draws a spiral shape on the screen,
 *   and then fills it--first with a solid color, and then with a
 *   pattern.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   04/12/90...Modified for general portability...........JRV
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static CONFIG cfg;


main()
{
    long x1, y1, x2, y2;
    int hres, vres, i, j, color0, color1, patn;
    int seedbuf[320];

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(0);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Infinite loop below seed fills areas on screen. */
    set_draw_origin(hres/2, vres/2);
    set_pensize(1+hres/256, 1+vres/256);
    color0 = 3;
    color1 = 8;
    patn = 0;
    for (j = 0; ; j++) {
	/* Clear screen and draw spiral pattern in gray. */
	clear_screen(0);
	set_fcolor(15);
	x1 = hres/16 << 16;
	y1 = vres/16 << 16;
	while (!cpw(x1>>16, y1>>16)) {
	    x2 = x1;
	    y2 = y1;
	    if (j & 1) {
		x1 -= y2 >> 3;
		y1 += x2 >> 4;
	    } else {
		y1 -= x2 >> 3;
		x1 += y2 >> 4;
	    }
	    pen_line(x1>>16, y1>>16, x2>>16, y2>>16);
	}

	/* Seed fill connected region with solid color. */
	--color1;
	set_fcolor(color1);
	seed_fill(0, 0, seedbuf, sizeof(seedbuf));
	for (i = 30; i; i--)	   /* 0.5-second delay */
	    wait_scan(hres);

	/* Seed fill connected region with two-color pattern. */
	while (++color0 == color1)
	    ;
	if (color0 == 14)
	    color0 = 1;
	set_bcolor(color0);
	while (--color1 == color0)
	    ;
	if (color1 <= 2)
	    color1 = 14;
	set_fcolor(color1);
	current_patn.data = (PTR)&patnbits[patn];  /* see patterns.h */
	set_patn(&current_patn);
	if (++patn == NUM_PATNS)
	    patn = 0;
	seed_patnfill(0, 0, seedbuf, sizeof(seedbuf));
	for (i = 90; i; i--)	   /* 1.5-second delay */
	    wait_scan(hres);
    }
}

