/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test pie arc functions.  This program tests the following arc
 *   functions:  fill_piearc, patnfill_piearc, pen_piearc and
 *   patnpen_piearc.  A series of pie charts of different sizes are
 *   drawn to various positions on the screen.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   12/03/87...Accommodated change in arc definition......J.R. Van Aken
 *   03/27/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static CONFIG cfg;

static short arc[] = { 22, 50, 16, 24, 60, 75, 55, 58 };
static short colors[] = {
    LIGHT_RED, YELLOW, LIGHT_GREEN, CYAN, MAGENTA, GREEN, RED, BLUE,
    RED, GREEN, MAGENTA, BLUE,
    CYAN, LIGHT_MAGENTA,  LIGHT_GRAY, BLUE,
    LIGHT_RED, YELLOW,	  LIGHT_BLUE, CYAN,
};
static short crosshatch_patn[] = {
    0x1111, 0xAAAA, 0x4444, 0xAAAA, 0x1111, 0xAAAA, 0x4444, 0xAAAA,
    0x1111, 0xAAAA, 0x4444, 0xAAAA, 0x1111, 0xAAAA, 0x4444, 0xAAAA
};
static PATTERN xhpatn = { 16, 16, 1, (PTR)crosshatch_patn };


main()
{
    short *p, *t;
    int hres, vres, ts, ta, x, y, w, h, i, d, patn;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(BLACK);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    d = (hres > vres) ? 1 + vres/96 : 1 + hres/96;  /* spacing */
    p = colors;

    /* Draw 16 pie charts in top left corner. */
    w = hres/8;
    h = vres/8;
    for (x = 0; x < 4*w; x += w+d)
	for (y = 0; y < 4*h; y += h+d) {
	    if (cfg.mode.disp_psize >= 4) {
		set_fcolor(CYAN);		  /* color */
		fill_rect(w, h, x, y);
	    } else {
		set_colors(1, 0);		  /* black and white */
		current_patn.data = (PTR)&patnbits[18];
		set_patn(&current_patn);
		patnfill_rect(w, h, x, y);
	    }
	    set_fcolor(BLUE);
	    fill_oval(w, h, x, y);
	}
    set_pensize(1+d/4, 1+d/4);
    x = y = 0;
    for (ts = -65, ta = 40; ts < 270; ts += 90, x += w+d) {
	set_fcolor(LIGHT_RED);
	fill_piearc(w, h, x, y, ts, ta);
	set_fcolor(WHITE);
	pen_piearc(w, h, x, y, ts, ta);
    }
    x = 0;
    y += h + d;
    for (ts = -65, ta = 40; ts < 270; ts += 90, x += w+d) {
	set_fcolor(LIGHT_RED);
	fill_piearc(w, h, x, y, ts, ta-360);
	set_fcolor(WHITE);
	pen_piearc(w, h, x, y, ts, ta-360);
    }
    x = 0;
    y += h + d;
    for (ts = -90, ta = 90; ts < 270; ts += 90, x += w+d) {
	set_fcolor(LIGHT_RED);
	fill_piearc(w, h, x, y, ts, ta);
	set_fcolor(WHITE);
	pen_piearc(w, h, x, y, ts, ta);
    }
    x = 0;
    y += h + d;
    for (ts = -90, ta = 90; ts < 270; ts += 90, x += w+d) {
	set_fcolor(LIGHT_RED);
	fill_piearc(w, h, x, y, ts, ta-360);
	set_fcolor(WHITE);
	pen_piearc(w, h, x, y, ts, ta-360);
    }

    /* Draw pie chart at bottom left of screen. */
    set_patn(&xhpatn);
    x = 0;
    y = 4*(vres/8 + d) + d;
    w = hres/2 - d;
    h = vres - y - 2*d;
    set_pensize(1+d/2, 1+d/2);
    ts = 33;
    t = arc;
    if (cfg.mode.disp_psize >= 4)
	for (i = 1; i <= 8; i++, ts += ta) {
	    x = (i == 8) ? w/8 : 0;
	    set_fcolor(*p++);			   /* color */
	    fill_piearc(w-w/8, h, x, y, ts, ta = *t++);
	    set_colors(BLACK, WHITE);
	    patnpen_piearc(w-w/8, h, x, y, ts, ta);
	}
    else {
	set_colors(1, 0);			   /* B&W */
	patn = 15;
	for (i = 1; i <= 8; i++, ts += ta) {
	    x = (i == 8) ? w/8 : 0;
	    current_patn.data = (PTR)&patnbits[patn++];
	    set_patn(&current_patn);
	    patnfill_piearc(w-w/8, h, x, y, ts, ta = *t++);
	    pen_piearc(w-w/8, h, x, y, ts, ta);
	}
    }

    /* Draw four 90-degree quadrants of ellipse at top right corner. */
    x = 4*(hres/8 + d) + d;
    y = 0;
    w = hres - x - 2*d;
    h = 4*(vres/8) + 2*d;
    set_pensize(1+d/4, 1+d/4);
    if (cfg.mode.disp_psize >= 4) {
	set_fcolor(DARK_GRAY);
	fill_rect(w, h, x, y);
	for (ts = 0; ts <= 270; ts += 90) {
	    set_fcolor(*p++);			   /* color */
	    fill_piearc(w, h, x, y, ts, 90);
	    set_fcolor(WHITE);
	    pen_piearc(w, h, x, y, ts, 90);
	}
    } else {
	set_colors(1, 0);			   /* B&W */
	draw_rect(w, h, x, y);
	patn = 15;
	for (ts = 0; ts <= 270; ts += 90) {
	    current_patn.data = (PTR)&patnbits[patn++];
	    set_patn(&current_patn);
	    patnfill_piearc(w, h, x, y, ts, 90);
	    pen_piearc(w, h, x, y, ts, 90);
	}
    }

    /* Pattern-filled pie chart at bottom right of screen. */
    x = 4*(hres/8 + d);
    y = 4*(vres/8 + d);
    w = hres - x - d;
    h = vres - y - d;
    set_fcolor(WHITE);
    fill_rect(w, h, x, y);
    set_fcolor(BLACK);
    draw_rect(w-3, h-3, x+1, y+1);
    x += w/16;
    y += d;
    w -= w/8;
    h -= 2*d;
    ts = 33;
    t = arc;
    patn = 15;
    for (i = 1; i <= 8; ++i) {
	if (i == 8)
	    x += w/8;
	set_colors(15-i, i);
	current_patn.data = (PTR)&patnbits[patn++];
	set_patn(&current_patn);
	patnfill_piearc(w-w/8, h, x, y, ts, ta = *t++);
	set_fcolor(BLACK);
	pen_piearc(w-w/8, h, x, y, ts, ta);
	ts += ta;
    }
}

