/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test the polygon fill function.  Draw a series of filled polygons
 *   to the screen using the fill_polygon function.  The polygons are
 *   defined by five moving points which move in a straight-line
 *   direction until they bounce off the sides of the screen.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/31/87...Original version written...................J.R. Van Aken
 *   06/02/87...Removed bounding polylines from polygons...J.R. Van Aken
 *   03/27/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define NVERTS	6	    /* number of polygon vertices	*/

typedef struct { short x, y; } POINT2D;

static CONFIG cfg;


main()
{
    static POINT2D xy[NVERTS], vxy[NVERTS];
    int hres, vres, i, x, y, k, color0, color1, patn;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(0);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Adjust shape and movement parameters to screen dimensions. */
    x = hres << 16;
    y = 0;
    for (i = 0; i < NVERTS; i++) {
	x -= y/4;
	y += x/4;
	xy[i].x = hres/2;
	xy[i].y = vres/2;
	vxy[i].x = 3*x >> 16+6;
	vxy[i].y = 3*y >> 16+6;
    }

    /* Infinite loop below draws polygons to screen. */
    k = 0;
    color0 = 0;
    color1 = -1;
    patn = 0;
    for (;;) {
	set_colors(color1, color0);
	current_patn.data = (PTR)&patnbits[patn];  /* see patterns.h */
	set_patn(&current_patn);

	/* Alternate solid- and pattern-filled polygons. */
	if (++patn == NUM_PATNS)
	    patn = 0;
	if (k++ & 1) {
	    fill_polygon(NVERTS, xy);
	    color0++;
	    color1--;
	} else
	    patnfill_polygon(NVERTS, xy);

	/* Check for collisions with edges of screen. */
	for (i = 0; i < NVERTS; i++) {
	    xy[i].x += vxy[i].x;
	    if (cpw(xy[i].x, vres/2)) {
		vxy[i].x = -vxy[i].x;
	    }
	    xy[i].y += vxy[i].y;
	    if (cpw(hres/2, xy[i].y)) {
		xy[i].y -= vxy[i].y;
		vxy[i].y = -vxy[i].y;
	    }
	}
    }
}

