/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test the rectangle fill and oval fill functions.  Draw a series of
 *   "bouncing" oval and rectangular shapes of varying sizes to the
 *   screen.  This program tests the following functions:  fill_rect,
 *   patnfill_rect, fill_oval, patnfill_oval, frame_rect,
 *   patnframe_rect, frame_oval and patnframe_oval.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   03/26/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static CONFIG cfg;


main()
{
    int hres, vres, wmin, wmax, hmin, hmax, vx, vy, vw, vh, x, y, w, h;
    int k, color0, color1, patn;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Adjust shape and movement parameters to screen dimensions. */
    vx = hres/12;	   /* rate at which x coordinate changes */
    vy = vres/20;	   /* rate at which y coordinate changes */
    vw = hres/28;	   /* rate at which width changes */
    vh = vres/32;	   /* rate at which height changes */
    wmin = 3*hres/20;	   /* minimum width */
    wmax = 2*hres/5;	   /* maximum width */
    hmin = vres/5;	   /* minimum height */
    hmax = 2*vres/5;	   /* maximum height */
    x = y = 0;		   /* initial x and y coordinates */
    w = (wmin + wmax)/2;   /* initial width */
    h = (hmin + hmax)/2;   /* initial height */

    /* Infinite loop below draws geometric primitives to screen. */
    k = 0;
    color0 = 0;
    color1 = -1;
    patn = 0;
    for (;;) {
	set_colors(color1--, color0++);
	current_patn.data = (PTR)&patnbits[patn];  /* see patterns.h */
	set_patn(&current_patn);
	if (++patn == NUM_PATNS)
	    patn = 0;

	/* Determine which of 8 types of object to draw. */
	switch (k++ >> 8 & 7) {
	case 0:  fill_rect(w, h, x, y);
		 break;
	case 1:  patnfill_rect(w, h, x, y);
		 break;
	case 2:  fill_oval(w, h, x, y);
		 break;
	case 3:  patnfill_oval(w, h, x, y);
		 break;
	case 4:  frame_rect(w, h, x, y, w>>3, h>>3);
		 break;
	case 5:  patnframe_rect(w, h, x, y, w>>2, h>>2);
		 break;
	case 6:  frame_oval(w, h, x, y, w>>3, h>>3);
		 break;
	case 7:  patnframe_oval(w, h, x, y, w>>2, h>>2);
		 break;
	}

	/* Vary width w and height h of enclosing rectangle. */
	w += vw;
	if (w < wmin) {
	    vw = -vw;
	    w = (wmin << 1) - w;
	}
	else if (w > wmax) {
	    vw = -vw;
	    w = (wmax << 1) - w;
	}
	h += vh;
	if (h < hmin) {
	    vh = -vh;
	    h = (hmin << 1) - h;
	}
	else if (h > hmax) {
	    vh = -vh;
	    h = (hmax << 1) - h;
	}

	/* If rectangle bumps into screen edge, reverse velocity. */
	x += vx;
	if (x < 0) {
	    vx = -vx;
	    x = -x;
	    if (x < 0)
		x = 0;
	}
	else if (x + w >= hres) {
	    vx = -vx;
	    x = (hres << 1) - x;
	    if (x + w >= hres)
		x = hres - w;
	}
	y += vy;
	if (y < 0) {
	    vy = -vy;
	    y = -y;
	    if (y < 0)
		y = 0;
	}
	else if (y + h >= vres) {
	    vy = -vy;
	    y = (vres << 1) - y;
	    if (y + h >= vres)
		y = vres - h;
	}
    }
}

